<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 6/29/2021
 * Time: 4:42 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Activate extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
        $this->load->model("Flutterwave_model", "fw");
    }

    public function index ($uid=NULL) {
        $uid = ($uid == NULL) ? userdata(UID) : $uid;
        if ($this->Util_model->row_count("user_getting_started", "WHERE uid=$uid") == 0) {
            redirect(base_url()."get-started");
        }

        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'activate">Activate</a></li>
        </ol>
        ';
        $data['uid'] = $uid;
        $data['tab'] = "activate";
        $data['main_content'] = 'users/activate';
        $this->load->view('layouts/main',$data);
    }

    public function checkout ($plan_id, $uid=NULL, $promo_code="") {
        $uid = ($uid == NULL) ? userdata(UID) : $uid;
        $plan = $this->Util_model->get_info("packages", "*", "WHERE id=$plan_id");
        $amount = $plan['amount'];
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'activate">Activate</a></li>
            <li>Checkout</li>
        </ol>
        ';
        $data['promo_code'] = "";
        $data['discount'] = 0;
        $data['promo_msg'] = "";
        if ($promo_code != "") {
            if ($this->Util_model->row_count("coupon", "WHERE code='$promo_code' AND package=$plan_id AND usable>0 AND status=1") == 1) {
                $coupon = $this->Util_model->get_info("coupon", "*", "WHERE code='$promo_code' AND package=$plan_id AND status=1");
                if ($this->Util_model->row_count("user_coupon", "WHERE uid=$uid AND coupon=$coupon[id] AND `table`='coupon'") == 0) {
                    $data['promo_code'] = $promo_code;
                    $discount = $coupon['discount'];
                    $data['discount'] = get_percentage($amount, $discount);
                } else {
                    $data['promo_msg'] = "<span class='text-red'><i class='fa fa-times-circle'></i> You have used promo code</span>";
                }
            } else {
                $data['promo_msg'] = "<span class='text-red'><i class='fa fa-times-circle'></i> Invalid promo code</span>";
            }
        }
        $data['uid'] = $uid;
        $data['plan_name'] = $plan['name'];
        $data['plan_amount'] = $amount;
        $data['package'] = $plan['id'];
        $data['tab'] = "activate";
        $data['main_content'] = 'users/activate';
        $this->load->view('layouts/main',$data);
        
    }

    public function make_payment ($uid, $plan_id, $promo_code="") {
        $plan = $this->Util_model->get_info("packages", "*", "WHERE id=$plan_id");
        $discount = 0;
        $used_coupon = false;
        if ($promo_code != "") {
            if ($this->Util_model->row_count("coupon", "WHERE code='$promo_code' AND package=$plan[id] AND usable>0 AND status=1") == 1) {
                $coupon = $this->Util_model->get_info("coupon", "*", "WHERE code='$promo_code' AND package=$plan[id] AND status=1");
                if ($this->Util_model->row_count("user_coupon", "WHERE uid=$uid AND coupon=$coupon[id] AND `table`='coupon'") == 0) {
                    $discount = $coupon["discount"];
                    $discount = get_percentage($plan["amount"], $discount);
                    $used_coupon = true;
                } 
            }
        }
        $amount_to_pay = $plan['amount'] - $discount;
        $name = $plan['name'];
        if ($this->Main_model->check_balance(userdata(UID), $amount_to_pay)) {
            $wallet = $this->Main_model->add_to_wallet($amount_to_pay, 0, userdata(UID), "Account upgrade to $name", "Account upgrade to $name", "upgrade", "packages:id=$plan_id", "", 1);
            if ($wallet['return']) {
                if ($this->Util_model->get_user_info($uid, "rank", "profile") == 1) {
                    $this->Db_model->update("user_profile", ["rank" => 2, "date" => date_time()], "WHERE uid=$uid");
                }
                $this->Db_model->update("user_profile", ["package" => $plan_id, "date" => date_time()], "WHERE uid=$uid");
                $this->Db_model->insert("user_upgrade", ["uid" => $uid, "package" => $plan_id, "amount" => $amount_to_pay, "ref" => $wallet['reference']]);
                $this->Main_model->add_comm($uid, $wallet['reference']); //Distribute commissions to uplines
                $this->Main_model->ranking_comm($uid, $amount_to_pay); //Distribute ranking commission
                
                if ($used_coupon) {
                    $coupon = $this->Util_model->get_info("coupon", "*", "WHERE code='$promo_code' AND package=$plan[id] AND status=1");
                    $this->Db_model->insert("user_coupon", ["uid"=>$uid, "coupon"=>$coupon['id'], "table"=>"coupon"]);
                    $this->Db_model->update("coupon", ["usable"=>($coupon["usable"] - 1)], "WHERE id=$coupon[id]");
                }
                set_flashdata("msg", alert_msg("<i class=''></i> Upgrade successful", "alert-success", 1));
                redirect(base_url()."home");
            } else {
                set_flashdata("msg", alert_msg("<i class=''></i> Upgrade unsuccessful: An error occured", "alert-danger", 1));
                redirect(base_url()."activate/checkout/$plan_id/$uid/$promo_code#summary");
            }
        } else {
            set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance. Deposit to proceed.", "alert-danger", 1));
            set_flashdata("redirect", base_url()."activate/make-payment/$plan_id/$uid/$promo_code");
            redirect(base_url()."deposit");
        }
    }

    public function approve_activation () {
        $ref = $_GET['tx_ref'];
        $status = $_GET['status'];
        $wallet = $this->Util_model->get_info("user_wallet", "amount, creditor, extra, status", "WHERE ref='$ref'");
        $uid = $wallet['creditor'];
        $plan_id = explode(":", $wallet['extra'])[1];
        if ($status == 'successful') {
            if ($wallet['status'] != 1) {
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                $plan = $this->Util_model->get_info("packages", "name, duration", "WHERE id=$plan_id");
                $amount = $wallet['amount'];
                $wallet = $this->Main_model->add_to_wallet($amount, 0, $uid, "Activation of the $plan[name] package.", "Activation of the $plan[name] package.", "activation", "packages:$plan_id", "", 1);
                if ($wallet['return']) {
                    $this->Db_model->update("user_getting_started", ["status"=>3], "WHERE uid=$uid");
                    $this->Db_model->update("user_profile", ["package" => $plan_id, "rank" => 1, "duration" => $plan['duration'], "date" => date_time()], "WHERE uid=$uid");
                    $this->Db_model->insert("user_upgrade", ["uid" => $uid, "package" => $plan_id, "ref" => $wallet['reference']]);
                    $this->Main_model->add_comm($uid, $wallet['reference']); //Distribute commissions to uplines
                    $this->Main_model->add_to_worth($amount, $this->Util_model->get_user_info($uid, "ref1", "referrer"), "Activation", 1); //Add to referrer net worth
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Your account have successfully been upgraded to <b>$plan[name] plan</b>", "alert-success", 1));
                }
            }
            
            redirect(base_url()."home");
        } else {
            $this->Db_model->update("user_wallet", ["status" => 2], "WHERE ref='$ref'");
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Transaction was cancelled. Please try again.", "alert-danger", 1));
            redirect(base_url()."activate/plan/$plan_id");
        }
    }

    public function activate_user ($uid, $plan_id) {
        $plan = $this->Util_model->get_info("packages", "*", "WHERE id=$plan_id");
        $amount = $plan['amount'];
        $name = $plan['name'];
        if ($this->Main_model->check_balance(userdata(UID), $amount)) {
            $wallet = $this->Main_model->add_to_wallet($amount, $uid, userdata(UID), "Fund transfer for activation", "Fund transfer for activation", "Transfer", "packages:$plan_id", "", 1);
            
            if ($wallet['return']) {
                $wallet = $this->Main_model->add_to_wallet($amount, 0, $uid, "Activation of the $name package.", "Activation of the $name package.", "activation", "packages:$plan_id", "", 1);
                if ($wallet['return']) {
                    if ($this->Util_model->get_user_info($uid, "rank", "profile") == 1) {
                        $this->Db_model->update("user_profile", ["rank" => 2, "date" => date_time()], "WHERE uid=$uid");
                    }
                    $this->Db_model->update("user_profile", ["package" => $plan_id, "duration" => set_expire_date(24 * $plan['duration']), "date" => date_time()], "WHERE uid=$uid");
                    $this->Db_model->insert("user_upgrade", ["uid" => $uid, "package" => $plan_id, "amount" => $amount, "ref" => $wallet['reference']]);
                    $this->Main_model->add_comm($uid, $wallet['reference']); //Distribute commissions to uplines
                    $this->Main_model->ranking_comm($uid, $amount); //Distribute ranking commission
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> ".$this->Util_model->get_user_info($uid)." have successfully been upgraded to <b>$name package</b>", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
            }
        } else {
            set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance. <a href='".base_url()."deposit'>Deposit</a> to proceed.", "alert-danger", 1));
        }
        redirect(base_url()."network");
    }

    public function get_discount_remain_time () {
        $this->output->set_output(remaining_time($this->Util_model->get_info("user_getting_started", "discount_expire", "WHERE uid=".userdata(UID)." AND status=2")));
    }

    public function get_free_access () {
        $discount_active = (remaining_time($this->Util_model->get_info("user_getting_started", "discount_expire", "WHERE uid=".userdata(UID)." AND status=2")) == "0:0:0") ? false : true;
        if ($discount_active) {
            if ($this->Util_model->row_count("user_profile", "WHERE uid=".userdata(UID)." AND free_access=0 AND package=0") == 1) {
                $this->Db_model->update("user_profile", ["free_access" => 1, "duration" => 3], "WHERE uid=".userdata(UID));
                redirect(base_url()."home");
            }
        }
        set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Ops! Your 3 days free access has expired", "alert-danger", 1));
        redirect(base_url()."activate");
    }

}

?>