<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin extends CI_Controller
{
    private $salt = "@#6$%^&*THIS$%^&IS(&^A%^&LARGE^&**%^&SALT-8,/7%^&*";

    public function __construct()
    {
        parent::__construct();
        function handler($exception)
        {
        }
        set_error_handler('handler');
    }

    public function __destruct()
    {
        restore_error_handler();
    }

    public function index()
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            redirect('admin/login');
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Dashboard</a></li>
        </ol>
        ';
        $data['tab'] = "dashboard";
        $data['main_content'] = 'admin/home';
        $this->load->view('admin/layouts/main', $data);
    }

    public function users()
    {
        redirect('admin/active_users');
    }

    public function books()
    {
        redirect('admin/approved_books');
    }

    public function courses()
    {
        redirect('admin/approved_courses');
    }

    public function transactions()
    {
        redirect('admin/deposits');
    }

    public function issues()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Issues</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "issues";
        $data['main_content'] = 'admin/issues';
        $this->load->view('admin/layouts/main', $data);
    }

    public function read($item_code)
    {
        $this->admin->check();
        try {
            $temp_item_code = ($item_code + 1) - 1;
            if ($temp_item_code <= 0) throw new Error('Arithmetic exception');
            redirect('book/read/' . $item_code);
        } catch (Error $e) {
            redirect('course/watch/' . $item_code);
        }
    }

    public function promote($item_code)
    {
        $this->admin->check();
        try {
            $temp_item_code = ($item_code + 1) - 1;
            if ($temp_item_code <= 0) throw new Error('Arithmetic exception');
            $result = $this->scansio_db_man->select('book_main', '', "WHERE book_id = $item_code");
            if ($result) {
                $is_default = $this->scansio_db_man->select('default_book', "", "WHERE bid = $result[id]");
                if ($is_default) {
                    $success =  $this->scansio_db_man->update('default_book', ['status' => ACTIVE], "WHERE bid = $result[id]");
                    flash_msg($success);
                } else {
                    $success = $this->scansio_db_man->insert('default_book', ['bid' => $result['id'], 'status' => ACTIVE]);
                    flash_msg($success);
                }
            } else {
                flash_msg(false);
            }
            redirect('admin/approved_books');
        } catch (Error $e) {
            $result = $this->scansio_db_man->select('academy_course', "", "WHERE course_code = '$item_code'");
            if ($result) {
                $is_default = $this->scansio_db_man->select('default_course', "", "WHERE cid = $result[id]");
                if ($is_default) {
                    $success = $this->scansio_db_man->update('default_course', ['status' => ACTIVE], "WHERE cid = $result[id]");
                    flash_msg($success);
                } else {
                    $success = $this->scansio_db_man->insert('default_course', ['cid' => $result['id'], 'status' => ACTIVE]);
                    flash_msg($success);
                }
            } else {
                flash_msg(false);
            }
            redirect('admin/approved_courses');
        }
    }

    public function depromote($item_code)
    {
        $this->admin->check();
        try {
            $temp_item_code = ($item_code + 1) - 1;
            if ($temp_item_code <= 0) throw new Error('Arithmetic exception');
            $result = $this->scansio_db_man->select('book_main', '', "WHERE book_id = $item_code");
            if ($result) {
                $is_default = $this->scansio_db_man->select('default_book', "", "WHERE bid = $result[id]");
                if ($is_default) {
                    $this->scansio_db_man->update('default_book', ['status' => INACTIVE], "WHERE bid = $result[id]");
                } else {
                    $this->scansio_db_man->insert('default_book', ['bid' => $result['id'], 'status' => INACTIVE]);
                }
                flash_msg(true);
            } else {
                flash_msg(false);
            }
            redirect('admin/approved_books');
        } catch (Error $e) {
            $result = $this->scansio_db_man->select('academy_course', '', "WHERE course_code = '$item_code'");
            if ($result) {
                $is_default = $this->scansio_db_man->select('default_course', "", "WHERE cid = '$result[id]'");
                if ($is_default) {
                    $this->scansio_db_man->update('default_course', ['status' => INACTIVE], "WHERE cid = '$result[id]'");
                } else {
                    $this->scansio_db_man->insert('default_course', ['cid' => $result[id], 'status' => INACTIVE]);
                }
                flash_msg(true);
            } else {
                flash_msg(false);
            }
            redirect('admin/approved_courses');
        }
    }

    public function command($item_code, $action)
    {
        $this->admin->check();
        $action = empty($action) ? 0 : $action;
        switch ($action) {
            case PENDING_PUBLISH:
            case APPROVED:
            case APPROVAL_DECLINE:
            case SUSPEND:
            case HOTLIST:
                try {
                    $temp_item_code = ($item_code + 1) - 1;
                    if ($temp_item_code <= 0) throw new Error('Arithmetic exception');
                    $result = $this->scansio_db_man->update('book_main', ['status' => $action], "WHERE book_id = $item_code");
                    flash_msg($result);
                    switch ($action) {
                        case APPROVED:
                        case PENDING_PUBLISH:
                        case SUSPEND:
                            redirect('admin/manage_books');
                            break;
                        case APPROVAL_DECLINE:
                            redirect('admin/pending_books');
                            break;
                        case HOTLIST:
                            redirect('admin/deleted_books');
                            break;

                        default:
                            redirect('admin/approved_books');
                            break;
                    }
                } catch (Error $e) {
                    $result = $this->scansio_db_man->update('academy_course', ['status' => $action], "WHERE course_code = '$item_code'");
                    flash_msg($result);

                    switch ($action) {
                        case APPROVED:
                        case APPROVAL_DECLINE:
                        case PENDING_PUBLISH:
                            redirect('admin/manage_courses');
                            break;
                        case SUSPEND:
                            redirect('admin/approved_courses');
                            break;
                        case HOTLIST:
                            redirect('admin/deleted_courses');
                            break;

                        default:
                            redirect('admin/approved_courses');
                            break;
                    }
                }
                break;

            default:
                flash_msg(false);
                redirect('admin');
                break;
        }
    }

    public function ucmd($action, $uid)
    {
        $this->admin->check();
        $action = empty($action) ? 0 : $action;
        switch ($action) {
            case ACTIVE:
            case HOTLIST:
                $developer = $this->scansio_db_man->select('user_profile', '', "WHERE uid = $uid && status != " . HOTLISTED . " && role = " . DEVELOPER);
                if (!$developer) {
                    $result = $this->scansio_db_man->update('user_main', ['status' => $action], "WHERE uid = $uid");
                    $result = $this->scansio_db_man->update('user_profile', ['status' => $action], "WHERE uid = $uid");
                    flash_msg($result);
                    switch ($action) {
                        case ACTIVE:
                            redirect('admin/blocked_users');
                            break;
                        case HOTLIST:
                            redirect('admin/active_users');
                            break;

                        default:
                            redirect('admin/active_users');
                            break;
                    }
                } else {
                    flash_msg(false, 'Operation to developer\'s account prohibited');
                    switch ($action) {
                        case ACTIVE:
                            redirect('admin/active_users');
                            break;
                        case HOTLIST:
                            redirect('admin/blocked_users');
                            break;

                        default:
                            redirect('admin/active_users');
                            break;
                    }
                }
                break;

            default:
                flash_msg(false);
                redirect('admin');
                break;
        }
    }

    public function delete($item_code)
    {
        $this->admin->check();
        try {
            $temp_item_code = ($item_code + 1) - 1;
            if ($temp_item_code <= 0) throw new Error('Arithmetic exception');
            if ($item_code <= 0) throw new Error('Arithmetic exception');
            $result = $this->scansio_db_man->delete('book_main', "WHERE book_id = $item_code");
            flash_msg($result);
            redirect('admin/approved_books');
        } catch (Error $e) {
            $result = $this->scansio_db_man->delete('academy_course', "WHERE course_code = '$item_code'");
            flash_msg($result);
            redirect('admin/approved_courses');
        }
    }

    public function withdrawals()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-money"></i> Withdrawals</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "withdrawals";
        $data['main_content'] = 'admin/withdrawals';
        $this->load->view('admin/layouts/main', $data);
    }

    public function deposits()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-money"></i> Deposits</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "deposits";
        $data['main_content'] = 'admin/deposits';
        $this->load->view('admin/layouts/main', $data);
    }

    public function manual_deposits()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-money"></i> Manual Deposits</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "manual_deposits";
        $data['main_content'] = 'admin/manual_deposits';
        $this->load->view('admin/layouts/main', $data);
    }

    public function upgraded_user()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-user"></i> Upgraded User</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "upgraded";
        $data['main_content'] = 'admin/upgraded';
        $this->load->view('admin/layouts/main', $data);
    }

    public function newsletter($use_template = 0, $just_reload = false)
    {
        $this->admin->check();
        if ($use_template == 0) {
            if ($this->input->post('subject') != NULL && !$just_reload) {
                $this->form_validation->set_rules("receiver", "Receiver", "required|trim");
                $this->form_validation->set_rules("subject", "Subject", "required|trim");
                $this->form_validation->set_rules("heading", "Heading", "required|trim");

                if ($this->form_validation->run() == FALSE) {
                    flash_msg(false, validation_errors(), false);
                } else {
                    $heading = ucwords($this->input->post("heading"));
                    $message = $this->input->post("message");
                    $button_link = (empty($this->input->post("button_href"))) ? base_url() : $this->input->post("button_href");
                    $button_label = (empty($this->input->post("button_label"))) ? "Visit Our Site" : $this->input->post("button_label");
                    $markups = array(
                        "[HEADING]" => $heading,
                        "[PLAIN-TEXT]" => $message,
                        "[BUTTON-HREF]" => $button_link,
                        "[BUTTON-TEXT]" => $button_label,
                        "[FIRST-NAME]" => ""
                    );

                    if ($this->Mail_model->send_mail($this->input->post("receiver"), $this->input->post("subject"), $markups)) {
                        flash_msg(true, 'Message sent successfully');
                        redirect('admin/newsletter');
                    } else {
                        $data = array(
                            "subject" => ucwords($this->input->post("subject")),
                            "heading" => $heading,
                            "receiver" => $this->input->post("receiver"),
                            "message" => $message,
                            "button_link" => $button_link,
                            "button_label" => $button_label,
                        );
                        flash_msg(false, 'Error sending message');
                    }
                }
            }
        } else if ($use_template != NULL) {
            $template = $this->scansio_db_man->select('newsletter_template', '', "WHERE id = " . $use_template);
            if ($template) {
                $data = array(
                    "subject" => $template['subject'],
                    "receiver" => $template['receiver'],
                    "heading" => $template['heading'],
                    "message" => $template['message'],
                    "button_link" => $template['button_link'],
                    "button_label" => $template['button_label'],
                );
            } else {
                if ($this->input->post('subject') != NULL) {
                    $receiver = $this->input->post("receiver");
                    $heading = ucwords($this->input->post("heading"));
                    $message = $this->input->post("message");
                    $button_link = (empty($this->input->post("button_href"))) ? base_url() : $this->input->post("button_href");
                    $button_label = (empty($this->input->post("button_label"))) ? "Visit Our Site" : $this->input->post("button_label");
                    $data = array(
                        "subject" => ucwords($this->input->post("subject")),
                        "receiver" => $receiver,
                        "heading" => $heading,
                        "message" => $message,
                        "button_link" => $button_link,
                        "button_label" => $button_label,
                    );
                } else {
                    flash_msg(false, 'Can\'t load this template right now try again shortly');
                }
            }
        }

        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-envelope"></i> Newsletter</a></li>
        </ol>
        ';
        $data['style'] = "<link href='https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote.min.css' rel='stylesheet'>";
        $data['tab'] = "newsletter";
        $data['main_content'] = 'admin/newsletter';
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_newsletter()
    {
        $this->admin->check();
        $this->form_validation->set_rules("subject", "Subject", "required|trim");
        $this->form_validation->set_rules("heading", "Heading", "required|trim");
        $this->form_validation->set_rules("message", "Message", "required|trim");

        $subject = ucwords($this->input->post("subject"));
        $heading = ucwords($this->input->post("heading"));
        $message = $this->input->post("message");
        $button_link = (empty($this->input->post("button_href"))) ? base_url() : $this->input->post("button_href");
        $button_label = (empty($this->input->post("button_label"))) ? "Visit Our Site" : $this->input->post("button_label");
        $receiver = $this->input->post("receiver");
        $data = array(
            "subject" => $subject,
            "heading" => $heading,
            "message" => $message,
            "button_link" => $button_link,
            "button_label" => $button_label,
            "receiver" => $receiver == NULL ? '' : $receiver,
        );
        if ($this->form_validation->run() == FALSE) {
            flash_msg(false, validation_errors(), false);
        } else {

            if ($this->scansio_db_man->insert('newsletter_template', $data)) {
                flash_msg(true, 'Template save');
                $template = $this->scansio_db_man->select('newsletter_template', '', "WHERE subject LIKE '%$subject%' && receiver = '$receiver' ORDER BY date DESC");
                redirect("admin/newsletter/$template[id]");
            } else {
                flash_msg(false, 'Can\'t save this template right now try again shortly');
                $this->newsletter(0, true);
                return;
            }
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-envelope"></i> Newsletter</a></li>
        </ol>
        ';
        $data['style'] = "
        <link href='https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote.min.css' rel='stylesheet'>";
        $data['tab'] = "newsletter";
        $data['main_content'] = 'admin/newsletter';
        $this->load->view('admin/layouts/main', $data);
    }

    public function login()
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
            redirect("admin");
        }
        $this->form_validation->set_rules('user', 'Email/Username', 'required|trim');
        $this->form_validation->set_rules('pass', 'Password', 'required|trim|min_length[6]|max_length[50]');

        $user = $this->input->post('user');
        $pass = $this->input->post('pass');
        if ($user == NULL || $pass == NULL) {
            $this->load->view('admin/login');
            return;
        }
        if ($this->form_validation->run() == FALSE) {
            flash_msg(false, 'Incorrect email/username or password');
            $this->load->view('admin/login');
        }
        $inputs = array(
            "user" => strtolower($user),
            "pass" => md5($this->salt . $pass . $this->salt)
        );

        $result = $this->admin->login($inputs);
        if ($result) {
            if (has_userdata('admin_redirect')) {
                redirect(userdata('admin_redirect'));
            }
            redirect("admin");
        }
        flash_msg(false, 'Incorrect email/username or password');
        redirect('admin/login');
    }

    public function approved_courses()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Approved Courses</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "approved_courses";
        $data['main_content'] = 'admin/approved_courses';
        $this->load->view('admin/layouts/main', $data);
    }

    public function course_comment($course_code)
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Course Comments</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['course_code'] = $course_code;
        $data['tab'] = "approved_courses";
        $data['main_content'] = 'admin/course_comments';
        $this->load->view('admin/layouts/main', $data);
    }

    public function delete_comment($course_code, $topic_code)
    {
        $this->admin->check();
        $where = " WHERE course_code = '$course_code' && topic_code = $topic_code";
        $deleted = $this->scansio_db_man->delete('academy_comment', $where);
        if ($deleted) {
            flash_msg(true);
        } else {
            flash_msg(false);
        }
        redirect("admin/course_comment/$course_code");
    }

    public function pending_courses()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Pending Courses</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "pending_courses";
        $data['main_content'] = 'admin/pending_courses';
        $this->load->view('admin/layouts/main', $data);
    }

    public function suspended_courses()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Suspended Courses</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "suspended_courses";
        $data['main_content'] = 'admin/suspended_courses';
        $this->load->view('admin/layouts/main', $data);
    }

    public function not_submitted_courses()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Not Submitted Courses</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "not_submitted_courses";
        $data['main_content'] = 'admin/not_submitted_courses';
        $this->load->view('admin/layouts/main', $data);
    }

    public function deleted_courses()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Deleted Courses</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "deleted_courses";
        $data['main_content'] = 'admin/deleted_courses';
        $this->load->view('admin/layouts/main', $data);
    }

    public function approved_books()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Approved Books</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "approved_books";
        $data['main_content'] = 'admin/approved_books';
        $this->load->view('admin/layouts/main', $data);
    }

    public function pending_books()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Pending books</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "pending_books";
        $data['main_content'] = 'admin/pending_books';
        $this->load->view('admin/layouts/main', $data);
    }

    public function suspended_books()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Suspended books</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "suspended_books";
        $data['main_content'] = 'admin/suspended_books';
        $this->load->view('admin/layouts/main', $data);
    }

    public function not_submitted_books()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Not Submitted books</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "not_submitted_books";
        $data['main_content'] = 'admin/not_submitted_books';
        $this->load->view('admin/layouts/main', $data);
    }

    public function deleted_books()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Deleted books</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "deleted_books";
        $data['main_content'] = 'admin/deleted_books';
        $this->load->view('admin/layouts/main', $data);
    }

    public function active_users()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Paid Users</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "active_users";
        $data['main_content'] = 'admin/active_users';
        $this->load->view('admin/layouts/main', $data);
    }

    public function admin()
    {
        $this->admin->check();
        $dev = $this->scansio_db_man->select('user_profile', '', 'WHERE uid = ' . userdata(A_UID) . ' && role = ' . DEVELOPER);
        if (!$dev) {
            redirect('admin/active_users');
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> admin</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "admin";
        $data['main_content'] = 'admin/admin';
        $this->load->view('admin/layouts/main', $data);
    }

    public function inactive_users()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Unpaid Users</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "inactive_users";
        $data['main_content'] = 'admin/inactive_users';
        $this->load->view('admin/layouts/main', $data);
    }

    public function blocked_users()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Blocked Users</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "blocked_users";
        $data['main_content'] = 'admin/blocked_users';
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_book_category()
    {
        $this->admin->check();
        $this->form_validation->set_rules("category", "Category", "required|trim");

        if ($this->form_validation->run() == FALSE) {
            flash_msg(false, validation_errors(), false);
            redirect("admin");
        }
        $title = $this->input->post('category');
        $result = $this->scansio_db_man->insert('book_category', ['title' => $title, 'status' => ACTIVE]);
        if (!$result) {
            flash_msg(false);
            redirect(base_url() . "admin");
        }
        flash_msg(true);
        redirect(base_url() . "admin");
    }

    public function add_course_category()
    {
        $this->admin->check();
        $this->form_validation->set_rules("category", "Category", "required|trim");

        if ($this->form_validation->run() == FALSE) {
            flash_msg(false, validation_errors(), false);
            redirect("admin");
        }
        $title = $this->input->post('category');
        $result = $this->scansio_db_man->insert('academy_category', ['title' => $title, 'status' => ACTIVE]);
        if (!$result) {
            flash_msg(false);
            redirect("admin");
        }
        flash_msg(true);
        redirect("admin");
    }

    public function make_admin($uid)
    {
        $this->admin->check();
        $dev = $this->scansio_db_man->select('user_profile', '', 'WHERE uid = ' . userdata(A_UID) . ' && role = ' . DEVELOPER);
        if (!$dev) {
            flash_msg(false, 'Unauthorised User');
            redirect(base_url() . "admin/users");
        }
        $result = $this->scansio_db_man->update('user_profile', ['role' => ADMIN], "WHERE uid = $uid && status != " . HOTLISTED . " && role != " . DEVELOPER);
        if (!$result) {
            flash_msg(false);
            redirect(base_url() . "admin/users");
        }
        flash_msg(true);
        redirect(base_url() . "admin/users");
    }

    public function remove_admin($uid)
    {
        $this->admin->check();
        $dev = $this->scansio_db_man->select('user_profile', '', 'WHERE uid = ' . userdata(A_UID) . ' && role = ' . DEVELOPER);
        if (!$dev) {
            flash_msg(false, 'Unauthorised User');
            redirect("admin/admin");
        }
        $result = $this->scansio_db_man->update('user_profile', ['role' => USER], "WHERE uid = $uid && status != " . HOTLISTED . ' && role = ' . ADMIN);
        if (!$result) {
            flash_msg(false);
            redirect("admin/admin");
        }
        flash_msg(true);
        redirect("admin/admin");
    }

    public function verification_check($verification_code)
    {
        if ($verification_code == '') {
            $this->form_validation->set_message("verification_check", "Error: you need a verification code to sign up as admin. Contact developer if you don't have any.");
            return false;
        }
        if (!is_numeric($verification_code)) {
            $this->form_validation->set_message("verification_check", "Error: you need a correct verification code to sign up as admin. Contact developer if you don't have any.");
            return false;
        }
        $where = 'WHERE verification_code = ' . $verification_code;
        $ver = $this->scansio_db_man->select('admin_verification', '', $where);
        if ($ver && (time() - $ver['expires']) < (1000 * 60 * 30)) {
            $this->form_validation->set_message("verification_check", "Error: you need a correct verification code to sign up as admin. Contact developer if you don't have any.");
            return false;
        }
        return true;
    }

    public function password_check($password)
    {
        if ($password == '') {
            $this->form_validation->set_message("password_check", "Password required");
            return false;
        }
        $where = 'WHERE uid = ' . userdata(A_UID) . " && password = '" . md5($this->salt . $password . $this->salt) . "' && status != " . HOTLISTED . " && (role = " . ADMIN . " || role = " . DEVELOPER . ")";
        $valid = $this->scansio_db_man->select('user_profile', '', $where);
        if ($valid && count($valid) > 0) {
            return true;
        }
        $this->form_validation->set_message("password_check", "Incorrect password");
        return false;
    }

    public function logout()
    {
        $this->admin->check();
        $this->admin->logout();
        redirect('admin/login');
    }

    public function generate_verification_code()
    {
        $code = rand(1111111111, 999999999);
        $time = time();
        $result = $this->scansio_db_man->insert('admin_verification', ['verification_code' => $code, 'expires' => $time]);
        return $result ? $code : 0;
    }

    public function get_users($group)
    {
        switch ($group) {
            case 'all':
                $item = $this->scansio_db_man->selectGroup('user_profile', '', "WHERE status = " . ACTIVE);
                $emails = '';
                foreach ($item as $row) {
                    $emails .= "$row[email];";
                }
                $emails .= rtrim($emails, ';');
                $this->output->set_output($emails);
                break;

            case 'paid':
                $item = $this->scansio_db_man->selectGroup('user_profile', '', "WHERE package != 0 && status = " . ACTIVE);
                $emails = '';
                foreach ($item as $row) {
                    $emails .= "$row[email];";
                }
                $emails .= rtrim($emails, ';');
                $this->output->set_output($emails);
                break;

            case 'unpaid':
                $item = $this->scansio_db_man->selectGroup('user_profile', '', "WHERE package = 0 && status = " . ACTIVE);
                $emails = '';
                foreach ($item as $row) {
                    $emails .= "$row[email];";
                }
                $emails .= rtrim($emails, ';');
                $this->output->set_output($emails);
                break;

            case 'vendors':
                $item = $this->scansio_db_man->selectGroup('user_profile', '', "WHERE package = 4 && status = " . ACTIVE);
                $emails = '';
                foreach ($item as $row) {
                    $emails .= "$row[email];";
                }
                $emails .= rtrim($emails, ';');
                $this->output->set_output($emails);
                break;

            case 'basic':
                $item = $this->scansio_db_man->selectGroup('user_profile', '', "WHERE package = 1 && status = " . ACTIVE);
                $emails = '';
                foreach ($item as $row) {
                    $emails .= "$row[email];";
                }
                $emails .= rtrim($emails, ';');
                $this->output->set_output($emails);
                break;
        }
    }

    public function remove_template($template_id)
    {
        $this->admin->check();
        $this->scansio_db_man->delete('newsletter_template', "WHERE id = $template_id");
        redirect('admin/newsletter');
    }

    public function user_login($uid)
    {
        $this->admin->check();
        $valid_user = $this->scansio_db_man->select("user_profile", '', "WHERE uid = $uid && role != " . DEVELOPER);
        if (!$valid_user) {
            flash_msg(false, 'Invalid User Login');
            redirect("admin/admin");
        }
        $_SESSION[UID] = $valid_user['uid'];
        redirect('home');
    }

    public function credit_debit_user()
    {
        $this->admin->check();
        if (isset($_POST['username']) & isset($_POST['password'])) {
            $type = $this->input->post('type');
            $username = $this->input->post('username');
            $amount = $this->input->post('amount');
            $description = $this->input->post('description');
            $data = [
                'type' => $type,
                'amount' => $amount,
                'description' => $description
            ];
            $this->form_validation->set_rules("type", "Type", "required|trim");
            $this->form_validation->set_rules("username", "Username", "required|trim");
            $this->form_validation->set_rules("amount", "Amount", "required|trim");
            $this->form_validation->set_rules("description", "Description", "required|trim");
            $this->form_validation->set_rules("password", "Password", "required|trim|min_length[6]|max_length[50]|callback_password_check");

            if ($this->form_validation->run() == FALSE) {
                $data['username'] = $username;
                flash_msg(false, validation_errors(), false);
            } else {
                $admin_uid = userdata(A_UID);
                $user_exist = $this->scansio_db_man->select('user_profile', "", "WHERE (role = " . DEVELOPER . " || uid != $admin_uid) && (username = '$username' || email = '$username') && status != " . HOTLISTED);
                if (!$user_exist) {
                    $data['username'] = $username;
                    flash_msg(false, "Invalid user OR Operation on user not allowed");
                } else {
                    $uid = $user_exist['uid'];
                    $ref = $this->Util_model->generate_id(11111111, 99999999, "credit_debit_user", "ref", "var", true, "fb");
                    $status = 1;
                    $data['uid'] = $uid;
                    $data['admin_uid'] = $admin_uid;
                    $data['ref'] = $ref;
                    $data['status'] = $status;
                    $result = $this->scansio_db_man->insert('credit_debit_user', $data);
                    if (!$result) {
                        $data['username'] = $username;
                        flash_msg(false);
                    } else {
                        if ($type == 'credit') {
                            $this->Main_model->add_to_wallet(
                                $amount,
                                $uid,
                                0,
                                $description,
                                $description,
                                "Topup",
                                "",
                                $ref,
                                1
                            );
                            flash_msg(true);
                            $data = [];
                            redirect('admin/credit_debit_user');
                        } else if ($type == 'debit') {
                            $this->Main_model->add_to_wallet(
                                $amount,
                                0,
                                $uid,
                                $description,
                                $description,
                                "Charge",
                                "",
                                $ref,
                                1
                            );
                            flash_msg(true);
                            $data = [];
                            redirect('admin/credit_debit_user');
                        } else {
                            $data['username'] = $username;
                            flash_msg('false', '', "Invalid type of transaction");
                            $this->scansio_db_man->delete('credit_debit_user', "WHERE ref = $ref");
                        }
                    }
                }
            }
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Credit/Debit User</a></li>
        </ol>
        ';
        $data['style'] = "
        <link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "credit_debit_user";
        $data['main_content'] = 'admin/credit_debit_user';
        $this->load->view('admin/layouts/main', $data);
    }

    public function activate_user($uid, $plan_id)
    {
        $this->admin->check();
        $plan = $this->Util_model->get_info("packages", "*", "WHERE id=$plan_id");
        if (!$plan) {
            flash_msg(false, 'Invalid package');
            redirect('admin/active_users');
        }
        $user_exists = $this->scansio_db_man->select('user_profile', '', "WHERE uid = $uid && status != " . HOTLISTED);
        if (!$user_exists) {
            flash_msg(false, 'User does not exist or blocked');
            redirect('admin/active_users');
        }
        if ($user_exists['package'] > $plan_id) {
            flash_msg(false, 'You can\'t downgrade user');
            redirect('admin/active_users');
        }
        $developer = $this->scansio_db_man->select('user_profile', '', "WHERE uid = $uid && status != " . HOTLISTED . " && role = " . DEVELOPER);
        if ($developer) {
            flash_msg(false, 'Operation on user not supported or protected user');
            redirect('admin/active_users');
        }
        $amount = $plan['amount'];
        $name = $plan['name'];
        $wallet = $this->Main_model->add_to_wallet($amount, $uid, 0, "Fund transfer for activation", "Fund transfer for activation", "Transfer", "packages:$plan_id", "", 1);
        if ($wallet['return']) {
            $wallet = $this->Main_model->add_to_wallet($amount, 0, $uid, "Activation of the $name package.", "Activation of the $name package.", "activation", "packages:$plan_id", "", 1);
            if ($wallet['return']) {
                $this->Db_model->update("user_profile", ["package" => $plan_id, "rank" => 1, "date" => date_time()], "WHERE uid=$uid");
                $this->Db_model->insert("user_upgrade", ["uid" => $uid, "package" => $plan_id, "ref" => $wallet['reference']]);
                $this->Db_model->insert("user_upgrade_by_admin", ["uid" => $uid, "package" => $plan_id, "admin_uid" => userdata(A_UID), "ref" => $wallet['reference']]);
                //$this->Main_model->add_comm($uid, $wallet['reference']); //Distribute commissions to uplines
                //$this->Main_model->add_point($uid); //Distribute points to uplines
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> " . $this->Util_model->get_user_info($uid) . " have successfully been upgraded to <b>$name package</b>", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
        }
        redirect('admin/active_users');
    }

    private function generate_course_code($min, $max, $category, $tbl = '', $field = '')
    {
        $course_code = '';
        do {
            $chunk = explode(' ', $category);
            $symbol = '';
            if (count($chunk) > 1) {
                $symbol .= (str_split($chunk[0])[0] . str_split($chunk[1])[0]);
            } else {
                $spl = str_split($category);
                $symbol .= ($spl[0] . $spl[strlen($category) - 1]);
            }
            $course_code = $symbol . rand($min, $max);
        } while ($this->Util_model->row_count($tbl, "WHERE $field = '$course_code'") > 0);
        return $course_code;
    }

    public function create_course()
    {
        $this->admin->check();

        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        //$this->form_validation->set_rules('intro_video', 'Introduction Video', 'required|trim');
        if ($this->form_validation->run()) {
            $title = ucwords($this->input->post('title'));
            $description = $this->input->post('description');
            //$intro_video = $this->input->post('intro_video');
            $course_code = $this->generate_course_code(100, 999, $title, 'academy_course', 'course_code');
            $uid = userdata(A_UID);
            $dir = './assets/courses/' . $course_code . '/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('thumbnail', $dir, rand(1000, 9999));
                if ($upload_pic['result']) {
                    $course_pic = ltrim($upload_pic['file_name'], './');
                    $fullpath = str_replace('\\', '/', FCPATH) . "$course_pic";
                    $this->Util_model->resize_pic($fullpath, false, 320, 240, true);
                    $data = [
                        'course_title' => $title,
                        'course_code' => $course_code,
                        'course_instructor' => $uid,
                        'course_pic' => $course_pic,
                        //'course_introduction_link' => $intro_video,
                        'course_desc' => $description,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('academy_course', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/create_topic/$course_code", 'info' => "$title created"]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => validation_errors()]));
        }
    }

    public function creating_course()
    {
        $this->admin->check();

        //$data['categories'] = $this->Util_model->list_from_table("academy_category", "id", "title", "WHERE status=1");
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin/approved_courses"><i class="fa fa-dashboard"></i> Manage Courses</a></li>
            <li><i class="fa fa-graduationcap"></i> Courses </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'admin/create_course';
        $this->load->view('admin/layouts/main', $data);
    }

    public function create_topic($course_code)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $course = $this->scansio_db_man->select("academy_course", '', "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you can\'t access $course_code. Please retry shortly...", "alert-danger", 1));
            redirect('admin/not-submitted-courses');
            return;
        }
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['course_code'] = $course_code;
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'admin/create_topic';
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_topic($course_code)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $course_where = "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course || count($course) < 1) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> You don't have access to this course", "alert-danger", 1)]));
            return;
        }
        $this->form_validation->set_rules('topic_title', 'Topic Title', 'required');
        $this->form_validation->set_rules('topic_link', 'Topic Link', 'required');
        $this->form_validation->set_rules('topic_time', 'Loading Video', 'required');
        $this->form_validation->set_message('required', 'Please check your video url then let the video player initialize');
        if ($this->form_validation->run()) {
            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course_code' && status != " . HOTLISTED . " ORDER BY position");
            $num_topics = 0;
            $last_position = 0;
            if ($topics && ($num_topics = count($topics)) > 0) {
                $last_position = ($topics[$num_topics - 1]['position'] + 1);
            }
            $topic_time = $this->input->post('topic_time');
            $data = [
                'course_code' => $course_code,
                'topic_title' => $this->input->post('topic_title'),
                'topic_link' => $this->input->post('topic_link'),
                'topic_time' => $topic_time,
                'description' => $this->input->post('description'),
                'position' => $last_position,
                'status' => 1
            ];
            if ($this->scansio_db_man->insert('academy_topic', $data)) {
                $this->scansio_db_man->update('academy_course', ['course_time' => ($course['course_time'] + $topic_time)], $course_where);
                $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/topics/" . $course_code, 'info' => alert_msg("<i class='fa fa-check-square'></i> $data[topic_title] Created", "alert-success", 1)]));
            } else {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    public function creating_book()
    {
        $this->admin->check();

        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url('admin/manage-books') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
            <li><i class="fa fa-graduationcap"></i> Create Book </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_books";
        $data['main_content'] = 'admin/create_new_book';
        $this->load->view('admin/layouts/main', $data);
    }

    public function create_book()
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('edition', 'Edition', 'trim|required|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('chapters', 'Chapters', 'trim|required|numeric|is_natural|max_length[2]|integer');
        if ($this->form_validation->run()) {
            $title = $this->input->post('title');
            $edition = $this->input->post('edition');
            $chapters = $this->input->post('chapters');
            $description = $this->input->post('description');
            $book_id = $this->Util_model->generate_id(10000000, 99999999, 'book_main', 'book_id');
            $dir = './assets/books/' . $book_id . '/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            $pdfdir = './ebooks/' . $book_id . '/';
            if (!file_exists($pdfdir)) {
                try {
                    mkdir($pdfdir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('cover', $dir, md5(rand(1000, 9999)));
                $upload_pdf = upload_pdf('file', $pdfdir, md5(rand(1000, 9999)));

                if ($upload_pic['result'] & $upload_pdf['result']) {
                    $pic_url = $upload_pic['file_name'];
                    $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                    $re = $this->Util_model->resize_pic($fullpath, false, 240, 320, true);
                    $file_url = $upload_pdf['file_name'];
                    $data = [
                        'book_id' => $book_id,
                        'title' => $title,
                        'author' => $uid,
                        'edition' => $edition,
                        'chapters' => $chapters,
                        'pic_url' => $pic_url,
                        'file' => $file_url,
                        'desc' => $description,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('book_main', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/manage-books", 'info' => alert_msg("<i class='fa fa-check-circle'></i> $title created", "alert-success", 1)]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    /*  public function create_script()
    {
        $this->admin->check();
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        if ($this->form_validation->run()) {
            $title = $this->input->post('title');
            $description = $this->input->post('description');
            $dir = './assets/scripts/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            $pdfdir = './scripts_pdf/';
            if (!file_exists($pdfdir)) {
                try {
                    mkdir($pdfdir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('thumbnail', $dir, rand(1000, 9999));
                $upload_pdf = upload_pdf('file', $pdfdir, rand(1000, 9999));

                if ($upload_pic['result'] & $upload_pdf['result']) {
                    $pic_url = $upload_pic['file_name'];
                    $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                    $re = $this->Util_model->resize_pic($fullpath, false, 100, 100, true);
                    $file_url = $upload_pdf['file_name'];
                    $data = [
                        'title' => $title,
                        'author' => userdata(A_UID),
                        'thumbnail' => $pic_url,
                        'file' => $file_url,
                        'desc' => $description,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('script', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/manage-scripts", 'info' => alert_msg("<i class='fa fa-check-circle'></i> $title created", "alert-success", 1)]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Thumbnail: $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }
 */
    public function manage_courses()
    {
        $this->admin->check();
        $where = "WHERE status != ".HOTLISTED." ORDER BY last_update DESC";
        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where);
        $view = '';
        if (!($courses && count($courses) > 0)) {
            $view = 'There is no course in the system yet.';
        } else {
        $view .= "
				    <table class='table table-hover table-striped'>
					    <thead>
					    	<tr>
					    		<th>
					    			Code
					    		</th>
					    		<th>
					    			Thumbnail
					    		</th>
					    		<th>
					    			Title
					    		</th>
					    		<th>
					    			Topics
					    		</th>
					    		<th>
					    			Time
					    		</th>
					    		<th>
					    			Updated
					    		</th>
					    		<th class='action d-print-none'>
					    			Action
					    		</th>
					    	</tr>
					    </thead>
				    <tbody>";

        foreach ($courses as $course) {
            $code = $course['course_code'];
            $title = $course['course_title'];
            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]'");
            $topics = ($topics ? count($topics) : 0);
            $time = $course['course_time'];
            $updated = $course['last_update'];
            $status = $course['status'];
            $topics_where = "WHERE course_code='$course[course_code]' ORDER BY position ASC";
            $topic_code = '0';
            $last_watched_topic = $this->scansio_db_man->select('academy_watched', '', "WHERE uid=" . userdata(A_UID) . " AND course_code='$course[course_code]' ORDER BY date DESC");
            if (!$last_watched_topic || count($last_watched_topic) < 1 || ($topic_code = $last_watched_topic['topic_code']) == 0) {
                $t_topics = $this->scansio_db_man->selectGroup('academy_topic', '', $topics_where);
                if ($t_topics && isset($topics[0])) {
                    $topic_code = $topics[0]['id'];
                }
            }
            $read_link = "window.location = \"" . base_url() . "academy/$course[course_code]/$topic_code\"";
            $statusLink = '';
            $statusText = '';
            if ($status == PUBLISHED) {
                $statusText = 'Unpublish';
                $statusLink = base_url() . "admin/command/$course[course_code]/" . UNPUBLISH;
            } else if ($status == PENDING_PUBLISH) {
                $statusText = 'Publish';
                $statusLink = base_url() . "admin/command/$course[course_code]/" . PUBLISH;
            } else if ($status == SUSPENDED) {
                $statusText = 'Suspended';
                $statusLink = 'javascript:';
            } else if ($status == PENDING_APPROVAL) {
                $statusText = 'Pending';
                $statusLink = 'javascript:';
            } else if ($status == APPROVAL_DECLINED) {
                $statusText = 'Re-publish';
                $statusLink = base_url() . "admin/command/$course[course_code]/" . PUBLISH;
            }

            $view .= "     
					<tr>
						<td>
							$code
						</td>
						<td>
							<img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor' onclick='$read_link'>
						</td>
						<td>
							$title
						</td>
						<td>
							$topics
						</td>
						<td>
							" . getFormattedDuration($time) . "
						</td>
						<td>
							$updated
						</td>
						<td>
							<a href='" . base_url() . "admin/command/$course[course_code]/" . HOTLIST . "' class='btn btn-danger btn-xs no-border' ><i class='fa fa-remove'></i> Delete</a>
							<a href='" . base_url() . "admin/course-edit/$course[course_code]" . "' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
							<a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='Publish' " . ($status == SUSPENDED ? 'disabled' : '') . "><i class='fa fa-check'></i> $statusText </a>
						</td>
					</tr>
					
				";
        }
        $view .= "
            </tbody>
        </table>
        ";}
        $data['breadcrumb'] = '
            <ol class="breadcrumb">
                <li><a href="' . base_url('admin/approved_courses') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
                <li><i class="fa fa-graduationcap"></i> Manage Courses </li>
            </ol>
            ';
        $data['tab'] = "manage_courses";
        $data['view'] = $view;
        $data['main_content'] = 'admin/manage_courses';
        $this->load->view('admin/layouts/main', $data);
    }

    public function manage_books()
    {
        $this->admin->check();
        $where = " WHERE status != " . HOTLISTED . " ORDER BY last_update DESC";
        $books = $this->scansio_db_man->selectGroup('book_main', '', $where);
        $view = '';
        if (!($books && count($books) > 0)) {
            $view = 'There are on courses available';
        }
        $view .= "
            <table class='table table-hover table-striped'>
                <thead>
                    <tr>
                        <th>
                            Cover Page
                        </th>
                        <th>
                            Title
                        </th>
                        <th>
                            Chapters
                        </th>
                        <th>
                            Edition
                        </th>
                        <th class='action d-print-none'>
                            Action
                        </th>
                    </tr>
                </thead>
            <tbody>
        ";

        foreach ($books as $row) {
            $author = $this->scansio_db_man->select('user_main', '', 'WHERE uid = ' . $row['author']);
            if (!$author) $author = 'Unknown';
            $author = $row['author'] == userdata(A_UID) ? 'You' : $author;
            $chapters = $row['chapters'];
            $edition = $row['edition'];
            $status = $row['status'];
            $read_link = "window.location = \"" . base_url() . "academy/ebook/" . urlencode($row['title']) . "/$row[book_id]\"";
            $statusLink = '';
            $statusText = '';
            if ($status == PUBLISHED) {
                $statusText = 'Unpublish';
                $statusLink = base_url() . "admin/command/$row[book_id]/" . UNPUBLISH;
            } else if ($status == PENDING_PUBLISH) {
                $statusText = 'Publish';
                $statusLink = base_url() . "admin/command/$row[book_id]/" . PUBLISH;
            } else if ($status == SUSPENDED) {
                $statusText = 'Suspended';
                $statusLink = 'javascript:';
            } else if ($status == PENDING_APPROVAL) {
                $statusText = 'Pending';
                $statusLink = 'javascript:';
            } else if ($status == APPROVAL_DECLINED) {
                $statusText = 'Re-publish';
                $statusLink = base_url() . "admin/command/$row[book_id]" . PUBLISH;
            }

            $view .= "     
				<tr>
					<td>
						<img src='" . base_url($row['pic_url']) . "' style='height: 100px; width: 80px;'  class='pointer-cursor' onclick='$read_link'>
					</td>
					<td>
						$row[title]
					</td>
					<td>
						$chapters
					</td>
					<td>
						$edition
					</td>
					<td>
						<a href='" . base_url() . "admin/command/$row[book_id]/" . HOTLIST . "' class='btn btn-danger btn-xs no-border' title='Caution are you sure of this please to retrieve it you have to contact admin.'><i class='fa fa-remove'></i> Delete</a>
						<a href='" . base_url() . "admin/book-edit/$row[book_id]' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
						<a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='Publish'><i class='fa fa-check'></i> $statusText </a>
					</td>
				</tr>
				
			";
        }

        $view .= "
                </tbody>
            </table>
        ";
        $data['breadcrumb'] = '
            <ol class="breadcrumb">
                <li><a href="' . base_url('admin/manage-books') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
                <li><i class="fa fa-graduationcap"></i> Create Book </li>
            </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_books";
        $data['view'] = $view;
        $data['main_content'] = 'admin/manage_books';
        $this->load->view('admin/layouts/main', $data);
    }

    /* public function manage_scripts()
    {
        $this->admin->check();
        $where = " ORDER BY date DESC";
        $scripts = $this->scansio_db_man->selectGroup('script', '', $where);
        $view = '';
        $view .= "
            <table class='table table-hover table-striped'>
                <thead>
                    <tr>
                        <th>
                            Thumbnail
                        </th>
                        <th>
                            Title
                        </th>
                        <th>
                            Created
                        </th>
                        <th class='action d-print-none'>
                            Action
                        </th>
                    </tr>
                </thead>
            <tbody>
        ";

        foreach ($scripts as $row) {
            $author = $this->scansio_db_man->select('user_main', '', 'WHERE uid = ' . $row['author'])['name'];
            if (!$author) $author = 'Unknown';
            $author = $row['author'] == userdata(A_UID) ? 'You' : $author;
            $status = $row['status'];
            $read_link = "window.location = \"" . base_url() . "academy/escript/$row[id]\"";
            $statusLink = '';
            $statusText = '';
            if ($status == PUBLISHED) {
                $statusText = 'Unpublish';
                $statusLink = base_url() . "admin/script-action/$row[id]/" . UNPUBLISH;
            } else if ($status == PENDING_PUBLISH) {
                $statusText = 'Publish';
                $statusLink = base_url() . "admin/script-action/$row[id]/" . PUBLISH;
            } else if ($status == SUSPENDED) {
                $statusText = 'Suspended';
                $statusLink = 'javascript:';
            } else if ($status == PENDING_APPROVAL) {
                $statusText = 'Pending';
                $statusLink = 'javascript:';
            } else if ($status == APPROVAL_DECLINED) {
                $statusText = 'Re-publish';
                $statusLink = base_url() . "admin/script-action/$row[id]/" . PUBLISH;
            } else if ($status == HOTLISTED) {
                $statusText = 'Recover';
                $statusLink = base_url() . "admin/script-action/$row[id]/" . PENDING_PUBLISH;
            }
            $delete = ($status == HOTLISTED ? base_url() . "admin/delete-script/$row[id]" : base_url() . "admin/script-action/$row[id]/" . HOTLIST);

            $view .= "     
				<tr>
					<td>
						<img src='" . base_url($row['thumbnail']) . "' style='height: 100px; width: 100px;'  class='pointer-cursor' onclick='$read_link'>
					</td>
					<td>
						$row[title]
					</td>
					<td>
						$row[date]
					</td>
					<td>
						<a href='" . $delete . "' class='btn btn-danger btn-xs no-border' title='Caution are you sure of this please to retrieve it you have to contact admin.'><i class='fa fa-remove'></i> Delete</a>
						<a href='" . base_url() . "admin/script-edit/$row[id]' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
						<a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='Publish'><i class='fa fa-check'></i> $statusText </a>
					</td>
				</tr>
				
			";
        }

        $view .= "
                </tbody>
            </table>
        ";
        $data['breadcrumb'] = '
            <ol class="breadcrumb">
                <li><a href="' . base_url('admin') . '"><i class="fa fa-dashboard"></i> Manage scripts</a></li>
                <li><i class="fa fa-graduationcap"></i> Create script </li>
            </ol>
        ';
        $data['tab'] = "manage_scripts";
        $data['view'] = $view;
        $data['main_content'] = 'admin/manage_scripts';
        $this->load->view('admin/layouts/main', $data);
    } */

    public function course_update($course_code)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $course_where = "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the Course didn\'t exist or you didn\'t have access to the Course.']));
            return;
        }
        $dir = './assets/courses/' . ($course['course_code']) . '/';
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        try {
            $upload_pic = '';
            if (isset($_FILES['thumbnail']['name']) && $_FILES['thumbnail']['name'] != '') {
                $upload_pic = upload_pic('thumbnail', $dir, md5(rand(1000, 9999)));
                if (!$upload_pic['result']) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1));
                }
            }
            $pic_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($course['course_pic']);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false, 300, 220, true);
            }
            $props = [
                'course_title' => ucwords($this->input->post('title')),
                'course_instructor' => userdata(A_UID),
                'course_pic' => $pic_url,
                //'course_introduction_link' => $this->input->post('intro_video'),
                'course_desc' => $this->input->post('description'),
            ];
            $data = [];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            $this->scansio_db_man->update('academy_course', $data, $course_where);
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.', 'Error']));
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . 'admin/manage_courses', 'info' => 'Course updated successfully']));
    }

    public function course_edit($course_code)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $course = $this->scansio_db_man->select('academy_course', '', "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You don't have access to $course_code", "alert-danger", 1));
            redirect("admin/manage-courses");
            return;
        }
        $data['course_code'] = $course['course_code'];
        $data['title'] = $course['course_title'];
        $data['description'] = $this->scansio_db_man->parseHtmlEntity($course['course_desc']);
        $data['thumbnail'] = base_url() . $course['course_pic'];
        $data['intro_video'] = $course['course_introduction_link'];
        $data['last_update'] = $course["last_update"] == '' ? $course['date'] : $course['last_update'];
        $data['style'] = '<link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['action'] = UPDATE;
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'admin/course_editing';
        $data['breadcrumb'] = '
	        <ol class="breadcrumb">
	            <li><a href="' . base_url() . 'admin/manage_courses"><i class="fa fa-book"></i> Manage Courses </a></li>
	            <li><a ><i class="fa fa-book-reader"></i> Edit Course </li> </a3>
	        </ol>
        ';
        $this->load->view('admin/layouts/main', $data);
    }

    public function book_update($book_id)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $book_where = "WHERE author = $uid AND book_id = $book_id";
        $book = $this->scansio_db_man->select('book_main', '', $book_where);
        $this->output->set_content_type('json');
        if (!$book) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the book didn\'t exist or you didn\'t have access to the book.']));
            return;
        }
        $dir = "./assets/books/$book_id/";
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        $pdfdir = './ebooks/' . $book_id . '/';
        if (!file_exists($pdfdir)) {
            try {
                mkdir($pdfdir);
            } catch (Exception $e) {
            }
        }
        try {
            $upload_pic = '';
            $upload_pdf = '';
            if (isset($_FILES['cover']['name']) && $_FILES['cover']['name'] != '') {
                $old_pic_url = $book['pic_url'];
                $upload_pic = upload_pic('cover', $dir, md5(rand(1000, 9999)));
            }
            if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
                $old_file = $book['file'];
                $upload_pdf = upload_pdf('file', $pdfdir, md5(rand(1000, 9999)));
            }
            $pic_url = '';
            $file_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($old_pic_url);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false,  240, 320, true);
            }
            if ($upload_pdf != '' &&  $upload_pdf['result']) {
                $file_url = $upload_pdf['file_name'];
                deleteFile($old_file);
            }
            $props = [
                'title' => ucwords($this->input->post('title')),
                'edition' => $this->input->post('edition'),
                'chapters' => $this->input->post('chapters'),
                'pic_url' => $pic_url,
                'file' => $file_url,
                'desc' => $this->input->post('description')
            ];
            $data = [];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            $this->scansio_db_man->update('book_main', $data, $book_where);
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.']));
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/manage-books", 'info' => 'Book updated successfully']));
    }

    public function book_edit($book_id)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $book = $this->scansio_db_man->select('book_main', '', "WHERE author = $uid AND book_id = $book_id");
        if (!$book) {
            flash_msg(false, 'Book not found or you don\'t have permission');
            redirect("admin/manage-books");
            return;
        }
        $chapters = $book['chapters'];
        $edition = $book['edition'];
        $data['book_id'] = $book_id;
        $data['title'] = $book['title'];
        $data['edition'] = $edition;
        $data['chapters'] = $chapters;
        $data['style'] = '<link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['description'] = $book['desc'];
        $data['last_update'] = $book["last_update"] == '' ? $book['date'] : $book['last_update'];
        $data['tab'] = "manage_books";
        $data['main_content'] = 'admin/book_editing';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin/manage_books"><i class="fa fa-book"></i> Manage Book </a></li>
            <li><a ><i class="fa fa-book-reader"></i> Edit Book </li> </a>
        </ol>
        ';
        $this->load->view('admin/layouts/main', $data);
    }

    /* public function creating_script()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url('admin/manage-scripts') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
            <li><i class="fa fa-graduationcap"></i> Create Script </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_books";
        $data['main_content'] = 'admin/create_script';
        $this->load->view('admin/layouts/main', $data);
    } */

    /* public function script_update($script_id)
    {
        $this->admin->check();
        $script_where = "WHERE id = $script_id";
        $script = $this->scansio_db_man->select('script', '', $script_where);
        $this->output->set_content_type('json');
        if (!$script) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the script didn\'t exist or you didn\'t have access to the script.']));
            return;
        }
        $dir = "./assets/scripts";
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        $pdfdir = './scripts_pdf';
        if (!file_exists($pdfdir)) {
            try {
                mkdir($pdfdir);
            } catch (Exception $e) {
            }
        }
        try {
            $upload_pic = '';
            $upload_pdf = '';
            if (isset($_FILES['thumbnail']['name']) && $_FILES['cover']['name'] != '') {
                $old_pic_url = $script['thumbnail'];
                $upload_pic = upload_pic('thumbnail', $dir, $script_id . rand(1000, 9999));
            }
            if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
                $old_file = $script['file'];
                $upload_pdf = upload_pdf('file', $pdfdir, $script_id . rand(1000, 9999));
            }
            $pic_url = '';
            $file_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($old_pic_url);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false,  240, 320, true);
            }
            if ($upload_pdf != '' &&  $upload_pdf['result']) {
                $file_url = $upload_pdf['file_name'];
                deleteFile($old_file);
            }
            $props = [
                'title' => ucwords($this->input->post('title')),
                'thumbnail' => $pic_url,
                'file' => $file_url,
                'desc' => $this->input->post('description')
            ];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            $this->scansio_db_man->update('script', $data, $script_where);
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.']));
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/manage-scripts", 'info' => 'Script updated successfully']));
    }
 */
    /* public function script_edit($script_id)
    {
        $this->admin->check();
        $script = $this->scansio_db_man->select('script', '', "WHERE id = $script_id");
        if (!$script) {
            flash_msg(false, '', 'Script not found or you don\'t have permission');
            redirect("admin/manage-scripts");
            return;
        }
        $data['script_id'] = $script_id;
        $data['title'] = $script['title'];
        $data['description'] = $script['desc'];
        $data['created'] = $script['date'];
        $data['tab'] = "manage_scripts";
        $data['main_content'] = 'admin/script_editing';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin/manage_scripts"><i class="fa fa-scroll"></i> Manage Scripts </a></li>
            <li><a ><i class="fa fa-script"></i> Edit Script </li> </a>
        </ol>
        ';
        $this->load->view('admin/layouts/main', $data);
    } */

    /* public function script_action($script_id, $action)
    {
        $this->admin->check();
        $action = empty($action) ? 0 : $action;
        switch ($action) {
            case PENDING_PUBLISH:
            case APPROVED:
            case APPROVAL_DECLINE:
            case SUSPEND:
            case HOTLIST:
                $result = $this->scansio_db_man->update('script', ['status' => $action], "WHERE id = $script_id");
                flash_msg($result);
                redirect('admin/manage_scripts');

            default:
                flash_msg(false);
                redirect('admin/manage_scripts');
                break;
        }
    } */

    /* public function delete_script($script_id)
    {
        $result = $this->scansio_db_man->delete("script", "WHERE id = $script_id");
        flash_msg($result);
        redirect("admin/manage-scripts");
    } */

    public function creating_opportunity()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url('admin/opportunities') . '"><i class="fa fa-dashboard"></i> Manage Opportunities</a></li>
            <li><i class="fa fa-graduationcap"></i> Post opportunity </li>
        </ol>
        ';
        $data['categories'] = $this->Util_model->list_from_table("opportunity_category", "id", "title", "WHERE status = " . ACTIVE);
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "opportunities";
        $data['main_content'] = 'admin/create_opportunity';
        $this->load->view('admin/layouts/main', $data);
    }

    public function create_opportunity()
    {
        $this->admin->check();
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('short_desc', 'Short Description', 'trim|required');
        $this->form_validation->set_rules('full_desc', 'Full Detali', 'trim|required');
        $this->form_validation->set_rules('category', 'Category', 'numeric');
        $this->form_validation->set_rules('end', 'Duration', 'trim|required');
        if ($this->form_validation->run()) {
            $title = $this->input->post('title');
            $short_desc = $this->input->post('short_desc');
            $full_desc = $this->input->post('full_desc');
            $price = $this->input->post('price');
            $old_price = $this->input->post('old_price');
            $category = $this->input->post('category');
            $end = $this->input->post('end');
            $dir = './assets/opportunity/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('thumbnail', $dir, rand(1000, 9999));
                if ($upload_pic['result']) {
                    $thumbnail = ltrim($upload_pic['file_name'], './');
                    $fullpath = str_replace('\\', '/', FCPATH) . "$thumbnail";
                    $this->Util_model->resize_pic($fullpath, false, 320, 240, true);
                    $data = [
                        'uid' => userdata(A_UID),
                        'title' => $title,
                        'short_desc' => $short_desc,
                        'full_desc' => $full_desc,
                        'thumbnail' => $thumbnail,
                        'price' => $price,
                        'old_price' => $old_price,
                        'category' => $category,
                        'end' => $end,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('opportunity', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/opportunities", 'info' => alert_msg("<i class='fa fa-check-circle'></i> $title created", "alert-success", 1)]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    public function opportunity_update($opportunity_id)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity_where = "WHERE uid = $uid AND id = $opportunity_id";
        $opportunity = $this->scansio_db_man->select('opportunity', '', $opportunity_where);
        $this->output->set_content_type('json');
        if (!$opportunity) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the opportunity didn\'t exist or you didn\'t have access to the opportunity.']));
            return;
        }
        $dir = './assets/opportunity/' . $opportunity['id'] . '/';
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        try {
            $upload_pic = '';
            if (isset($_FILES['thumbnail']['name']) && $_FILES['thumbnail']['name'] != '') {
                $upload_pic = upload_pic('thumbnail', $dir, md5(rand(1000, 9999)));
                if (!$upload_pic['result']) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1));
                }
            }
            $pic_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($opportunity['thumbnail']);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false, 300, 220, true);
            }
            $props = [
                'title' => ucwords($this->input->post('title')),
                'short_desc' => $this->input->post('short_desc'),
                'full_desc' => $this->input->post('full_desc'),
                'price' => $this->input->post('price'),
                'old_price' => $this->input->post('old_price'),
                'category' => $this->input->post('category'),
                'end' => $this->input->post('end'),
                'thumbnail' => $pic_url,
            ];
            $data = [];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            $result = $this->scansio_db_man->update('opportunity', $data, $opportunity_where);
            if ($result) {
                $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/opportunities", 'info' => 'Opportunity updated successfully']));
            } else {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'An error occured please retry']));
            }
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.', 'Error']));
        }
    }

    public function opportunity_edit($opportunity_id)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity = $this->scansio_db_man->select('opportunity', '', "WHERE uid = $uid AND id = $opportunity_id");
        if (!$opportunity) {
            flash_msg(false, '', 'Opportunity not found or you don\'t have permission');
            redirect("admin/opportunities");
            return;
        }
        $data['opportunity_id'] = $opportunity_id;
        $data['title'] = $opportunity['title'];
        $data['short_desc'] = $opportunity['short_desc'];
        $data['full_desc'] = $opportunity['full_desc'];
        $data['thumbnail'] = base_url() . $opportunity['thumbnail'];
        $data['price'] = $opportunity['price'];
        $data['old_price'] = $opportunity['old_price'];
        $data['categories'] = $this->Util_model->list_from_table("opportunity_category", "id", "title", "WHERE status = " . ACTIVE, $opportunity['category']);
        $data['created'] = $opportunity['created'];
        $data['updated'] = $opportunity['updated'];
        $data['end'] = $opportunity['end'];
        $data['tab'] = "opportunites";
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['main_content'] = 'admin/opportunity_editing';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin/opportunites"><i class="fa fa-scroll"></i> Manage opportunitys </a></li>
            <li><a ><i class="fa fa-opportunity"></i> Edit opportunity </li> </a>
        </ol>
        ';
        $this->load->view('admin/layouts/main', $data);
    }

    public function opportunity_action($opportunity_id, $action)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $action = empty($action) ? 0 : $action;
        switch ($action) {
            case PENDING_PUBLISH:
            case APPROVED:
            case APPROVAL_DECLINE:
            case SUSPEND:
            case HOTLIST:
                $result = $this->scansio_db_man->update('opportunity', ['status' => $action], "WHERE uid = $uid AND id = $opportunity_id");
                flash_msg($result);
                redirect('admin/opportunities');

            default:
                flash_msg(false);
                redirect('admin/opportunities');
                break;
        }
    }

    public function delete_opportunity($opportunity_id)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $result = $this->scansio_db_man->delete("opportunity", "WHERE uid = $uid AND id = $opportunity_id");
        flash_msg($result);
        redirect("admin/opportunities");
    }

    public function opportunities()
    {
        $this->admin->check();
        $where = " ORDER BY date DESC";
        $uid = userdata(A_UID);
        $opportunities = $this->scansio_db_man->rawQuery("SELECT u.name AS creator, u.uid AS creator_id, o.* FROM user_main u, opportunity o WHERE u.uid = o.uid ORDER BY date DESC");
        $view = "
            <table class='table table-hover table-striped'>
                <thead>
                    <tr>
                        <th>
                            #
                        </th>
                        <th>
                            Thumbnail
                        </th>
                        <th>
                            Status
                        </th>
                        <th>
                            Title
                        </th>
                        <th>
                            Short Description
                        </th>
                        <th>
                            Price
                        </th>
                        <th>
                            Old Price
                        </th>
                        <th>
                            Creator
                        </th>
                        <th>
                            Creator Id
                        </th>
                        <th>
                            Video Resources
                        </th>
                        <th>
                            eBook Resources
                        </th>
                        <th>
                            Created
                        </th>
                        <th>
                            Updated
                        </th>
                        </th>
                        <th>
                            Ends in
                        </th>

                        <th class='action d-print-none'>
                            Action
                        </th>
                    </tr>
                </thead>
            <tbody>
        ";
        $count = 0;
        foreach ($opportunities as $o) {
            ++$count;
            $video_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $o[id] AND type = 'video'");
            $ebook_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $o[id] AND type = 'ebook'");
            $ends_in = get_formatted_date($o['end']);
            $status = $o['status'];
            $read_link = base_url() . "home/opp-full-detail/$o[id]";
            $statusLink = '';
            $statusText = '';
            if ($status == PUBLISHED) {
                $stat = '<span class="text-success">Approved</span>';
                $statusText = 'Unpublish';
                $statusLink = base_url() . "admin/opportunity-action/$o[id]/" . UNPUBLISH;
            } else if ($status == PENDING_PUBLISH) {
                $stat = '<span class="text-default">Not submitted</span>';
                $statusText = 'Publish';
                $statusLink = base_url() . "admin/opportunity-action/$o[id]/" . PUBLISH;
            } else if ($status == SUSPENDED) {
                $stat = '<span class="text-danger">Suspended</span>';
                $statusText = 'Suspended';
                $statusLink = 'javascript:';
            } else if ($status == PENDING_APPROVAL) {
                $stat = '<span class="text-warning">Pending</span>';
                $statusText = 'Pending';
                $statusLink = 'javascript:';
            } else if ($status == APPROVAL_DECLINED) {
                $stat = '<span class="text-danger">Declined</span>';
                $statusText = 'Re-publish';
                $statusLink = base_url() . "admin/opportunity-action/$o[id]/" . PUBLISH;
            } else if ($status == HOTLISTED) {
                $stat = '<span class="text-danger">Deleted</span>';
                $statusText = 'Recover';
                $statusLink = base_url() . "admin/opportunity-action/$o[id]/" . PENDING_PUBLISH;
            }
            $delete = ($status == HOTLISTED ? base_url() . "admin/delete-opportunity/$o[id]" : base_url() . "admin/opportunity-action/$o[id]/" . HOTLIST);

            $view .= "     
				<tr>
					<td>
						$count
					</td>
					<td>
                        <a href='$read_link'>
                            <img src='" . base_url($o['thumbnail']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor' >
                        </a>
                    </td>
					<td >
						$stat
					</td>
					<td>
						$o[title]
					</td>					
                    <td>
						$o[short_desc]
					</td>
					<td>
						$o[price]
					</td>					
                    <td>
						$o[old_price]
					</td>
					<td>
						$o[creator]
					</td>					
                    <td>
						$o[creator_id]
					</td>
					<td>
						$video_resources
					</td>
					<td>
						$ebook_resources
					</td>
					<td>
						$o[created]
					</td>
                    <td>
						$o[updateed]
					</td>
                    <td>
						$ends_in
					</td>
					<td>
						<a href='$read_link' class='btn btn-info btn-xs no-border' title='View in user dashboard.'><i class='fa fa-eye'></i> View</a>
						<a href='" . base_url() . "/admin/opportunity-resources/$o[id]' class='btn btn-info btn-xs no-border' title='View all the resources in this oppportunity'><i class='fa fa-eye'></i> View Resource</a>
						<a href='$delete' class='btn btn-danger btn-xs no-border' title='Caution are you sure of this please to retrieve it you have to contact admin.'><i class='fa fa-remove'></i> Delete</a>
						<a href='" . base_url() . "admin/opportunity-edit/$o[id]' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
						<a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='$statusText'><i class='fa fa-check'></i> $statusText </a>
					</td>
				</tr>
			";
        }

        $view .= "
                </tbody>
            </table>
        ";
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Manage Opportunities</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['view'] = $view;
        $data['tab'] = "opportunities";
        $data['main_content'] = 'admin/opportunities';
        $this->load->view('admin/layouts/main', $data);
    }

    public function opportunity_resources($opportunity_id, $type = 'video')
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity = $this->scansio_db_man->select("opportunity", "", "WHERE uid = $uid AND id = $opportunity_id");
        if (!$opportunity) {
            flash_msg(false, "Access Denied");
            redirect('admin/opportunities');
        }
        $opportunity_resources = $this->scansio_db_man->selectGroup("opportunity_resources", "", "WHERE oid = $opportunity_id AND type = '$type'");
        $view = "<ul class='products-list product-list-in-box'>";
        if ($opportunity_resources) {
            if ($type == 'video') {
                $count = 0;
                foreach ($opportunity_resources as $resource) {
                    ++$count;
                    $course = $this->scansio_db_man->select("academy_course", "", "WHERE id = $resource[rid]");
                    $topic = $this->scansio_db_man->select("academy_topic", "", "WHERE course_code = '$course[course_code]' AND status = " . ACTIVE . " ORDER BY position ASC");
                    $view .= "
                        <li class='item cursor-pointer' style='padding-left:5px; padding-right:10px;' onclick='window.location = \"" . base_url() . "academy/$course[course_code]/$topic[id]\"'>
                            <div class='product-img'>
                                <div class='img-circle text-center pull-left' style='width:40px; height:40px; vertical-align: middle'>$count</div>
                            </div>
                            <div class='product-info'>
                                <a href='javascript:void(0)' class='product-title'>
                                    $course[course_title]
                                </a>
                                <span class='product-description'>
                                    <i class='fa fa-clock-o'></i> " . getFormattedDuration($course['course_time']) . "
                                    <a href='" . base_url() . "admin/remove_resource/$resource[oid]/$resource[rid]/$type' class='btn btn-xs pull-right' title='Remove resource'><i class='fa fa-remove text-danger '></i></a>
                                </span>
                            </div>
                        </li>
                    ";
                }
            } else {
                $count = 0;
                foreach ($opportunity_resources as $resource) {
                    ++$count;
                    $book = $this->scansio_db_man->select("book_main", "", "WHERE id = $resource[rid]");
                    $view .= "
                        <li class='item cursor-pointer' style='padding-left:5px; padding-right:10px;' onclick='window.location = \"" . base_url() . "academy/ebook/" . urlencode($book['title']) . "/$book[book_id]\"'>
                            <div class='product-img'>
                                <div class='img-circle text-center pull-left' style='width:40px; height:40px; vertical-align: middle'>$count</div>
                            </div>
                            <div class='product-info'>
                                <a href='javascript:void(0)' class='product-title'>
                                    $book[title]
                                </a>
                                <span class='product-description'>
                                    <a href='" . base_url() . "admin/remove_resource/$resource[oid]/$resource[rid]/$type' class='btn btn-xs pull-right' title='Remove resource'><i class='fa fa-remove text-danger '></i></a>
                                </span>
                            </div>
                        </li>
                    ";
                }
            }
        } else {
            $view .= "<li>No resource added yet</li>";
        }
        $view .= "
            </ul>
        ";
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Opportunity Resources</a></li>
        </ol>
        ';
        $data['pane'] = $type;
        $data['opportunity_id'] = $opportunity_id;
        $data['type'] = $type;
        $data['view'] = $view;
        $data['tab'] = "opportunities";
        $data['main_content'] = 'admin/opportunity_resources';
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_resource($oid, $rid, $type)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity = $this->scansio_db_man->select("opportunity", "", "WHERE uid = $uid AND id = $oid");
        if (!$opportunity) {
            return false;
        }
        if ($type == 'video') {
            $valid_resource = $this->scansio_db_man->select('academy_course', '', "WHERE id = $rid AND status = " . ACTIVE);
        } else if ($type == 'ebook') {
            $valid_resource = $this->scansio_db_man->select('book_main', '', "WHERE id = $rid AND status = " . ACTIVE);
        } else {
            return false;
        }
        if (!$valid_resource) {
            return false;
        }
        $result = $this->scansio_db_man->insert('opportunity_resources', ['oid' => $oid, 'rid' => $rid, 'type' => $type]);
        return $result;
    }

    public function resource_selection($oid, $type)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity = $this->scansio_db_man->select("opportunity", "", "WHERE uid = $uid AND id = $oid");
        if (!$opportunity) {
            flash_msg(false, "Access Denied");
            redirect('admin/opportunities');
        }
        $data['oid'] = $oid;
        $data['type'] = $type;
        $data['tab'] = "opportunities";
        $data['main_content'] = 'admin/resource_selection';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin/opportunites"><i class="fa fa-scroll"></i> Manage opportunitys </a></li>
            <li><a ><i class="fa fa-opportunity"></i> Resource selection </li> </a>
        </ol>
        ';
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_selected_resources($oid, $type)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity = $this->scansio_db_man->select("opportunity", "", "WHERE uid = $uid AND id = $oid");
        if (!$opportunity) {
            flash_msg(false, "Access Denied");
            redirect('admin/opportunities');
        }
        $selected = $this->input->post('rid');
        foreach ($selected as $rid) {
            if (($rid != '0')) {
                $this->add_resource($oid, $rid, $type);
            }
        }
        flash_msg(true, 'Added');
        redirect("admin/opportunity-resources/$oid/$type");
    }

    public function remove_resource($oid, $rid, $type)
    {
        $this->admin->check();
        $uid = userdata(A_UID);
        $opportunity = $this->scansio_db_man->select("opportunity", "", "WHERE uid = $uid AND id = $oid");
        if (!$opportunity) {
            flash_msg(false, "Access Denied");
            redirect('admin/opportunities');
        }
        $result = $this->scansio_db_man->delete("opportunity_resources", "WHERE rid = $rid AND type = '$type'");
        flash_msg($result);
        redirect("admin/opportunity_resources/$oid/$type");
    }

    public function topics($course_code)
    {
        $this->admin->check();
        $course = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you don't have access to course $course_code", "alert-danger", 1));
            redirect("admin/deleted-courses");
            return;
        }
        $view = "";
        $topics = $this->scansio_db_man->selectGroup("academy_topic", '', "WHERE course_code='$course_code' AND status=1 ORDER BY position");
        if ($topics) {
            foreach ($topics as $topic) {
                $view .= "
                    <li class='item cursor-pointer' style='padding-left:5px; padding-right:10px;'>
                        <div class='product-img'>
                            <div class='img-circle text-center pull-left' style='width:40px; height:40px; vertical-align: middle'>" . ($topic['position'] + 1) . "</div>
                        </div>
                        <div class='product-info'>
                            <a href='javascript:void(0)' class='product-title'>
                                $topic[topic_title]
                            </a>
                            <span class='product-description'>
                                <i class='fa fa-clock-o'></i> " . getFormattedDuration($topic['topic_time']) . "
								<div class='pull-right'>
									<a href='" . base_url() . "admin/topic_action/" . HOTLIST . "/$course_code/$topic[id]' class='btn btn-danger btn-xs no-border delete-permanent' data-toggle='tooltip' data-title='Are your sure you want to delete this topic'><i class='fa fa-remove'></i> Delete </a>
									<a href='" . base_url() . "admin/topic_action/" . EDIT . "/$course_code/$topic[id]' class='btn btn-success btn-xs no-border' title='Create topic'><i class='fa fa-plus-square'></i> Edit</a>
								</div>
                            </span>
                            
                        </div>
                    </li>
                ";
            }
        }
        $data['breadcrumb'] = "
		        <ol class='breadcrumb'>
		            <li><a href='" . base_url() . "admin/manage-courses'><i class='fa fa-dashboard'></i> Manage Courses</a></li>
		            <li><a href='" . base_url() . "admin/course-edit/$course_code'><i class='fa fa-graduationcap'></i> Course Details</a></li>
		            <li><i class='fa fa-graduationcap'></i> Topics </li>
		        </ol>
		    ";
        $data['course_code'] = $course_code;
        $data['view'] = $view;
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'admin/topics';
        $this->load->view('admin/layouts/main', $data);
    }

    public function topic_action($action, $course_code, $topic_code)
    {
        $this->admin->check();

        switch ($action) {
            case EDIT:
                $this->topic_edit($course_code, $topic_code);
                break;

            case HOTLIST:
                $this->topic_delete($course_code, $topic_code);
                break;

            case UPDATE:
                $this->topic_update($course_code, $topic_code);
                break;
        }
    }

    public function topic_edit($course_code, $topic_code)
    {
        $this->admin->check();

        $course = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Sorry you can\'t access this course topic. Please retry shortly...", "alert-danger", 1));
            redirect('admin/manage-courses');
            return;
        }
        $topics = $this->scansio_db_man->selectGroup("academy_topic", '', "WHERE course_code = '$course_code' AND status != " . HOTLISTED . " ORDER BY position ASC");
        $topic = $this->scansio_db_man->select("academy_topic", '', "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED);
        if (!$topic) {
            set_flashdata(alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred. Please retry shortly...", "alert-danger", 1));
            redirect('admin/topics/' . $course_code);
            return;
        }
        $topic_title = $topic['topic_title'];
        $topic_link = $topic['topic_link'];
        $topic_time = $topic['topic_time'];
        $last_topic = $topics[count($topics) - 1];
        $positions = '';
        if ($last_topic) {
            foreach ($topics as $t) {
                $positions .= "<option value='$t[position]' " . ($topic['position'] == $t['position'] ? 'selected' : '') . "> " . ($topic['position'] == $t['position'] ? '' : 'Before | ') . "$t[topic_title]</option>";
            }
            $positions .= $last_topic['position'] == $topic['position'] ? '' : "<option value='" . count($topics) . "' >Last</option>";
        }
        $data['course_code'] = $course_code;
        $data['topic_code'] = $topic_code;
        $data['topic_title'] = $topic_title;
        $data['topic_time'] = $topic_time;
        $data['topic_link'] = $topic_link;
        $data['description'] = $topic['description'];
        $data['positions'] = $positions;
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['breadcrumb'] = '
		        <ol class="breadcrumb">
		            <li><a href="' . base_url() . 'admin/topics/' . $course_code . '"><i class="fa fa-dashboard"></i>Manage Topics</a></li>
		            <li><i class="fa fa-graduationcap"></i> ' . $topic_title . ' </li>
		        </ol>
		    ';
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'admin/topic_editing';
        $this->load->view('admin/layouts/main', $data);
    }

    public function topic_delete($course_code, $topic_code)
    {
        $this->admin->check();

        $course_where = "WHERE course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course || count($course) < 1) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Course not exists or you don't have access to it", "alert-danger", 1)]));
            return;
        }
        $topic_where = "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED;
        $topic = $this->scansio_db_man->select("academy_topic", '', $topic_where);
        if (!$topic) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred. Please retry shortly...", "alert-danger", 1)]));
            return;
        }
        $this->changePosition($course_code, $topic_code, $topic['position']);
        $delete = $this->scansio_db_man->delete('academy_topic', $topic_where);
        if ($delete) {
            $this->scansio_db_man->update('academy_course', ['course_time' => ($course['course_time'] - $topic['topic_time'])], $course_where);
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Error topic not deleted", "alert-danger", 1)]));
            return;
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . 'admin/topics/' . $course_code, 'info' => alert_msg("<i class='fa fa-check-square'></i> Topic Deleted", "alert-success", 1)]));
    }

    public function topic_update($course_code, $topic_code)
    {
        $this->admin->check();

        $course_where = "WHERE course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course || count($course) < 1) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred please try again", "alert-danger", 1)]));
            return;
        }
        $topic_where = "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED;
        $topic = $this->scansio_db_man->select("academy_topic", '', $topic_where);
        if (!$topic) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred. Please retry shortly...", "alert-danger", 1)]));
            return;
        }
        $topic_time = $this->input->post('topic_time');
        $position = $this->input->post('position');
        $position = ($position == '' ? 0 : $position);
        $description = $this->input->post('description');
        $tempVals = [
            'course_code' => $course_code,
            'topic_title' => $this->input->post('topic_title'),
            'topic_link' => $this->input->post('topic_link'),
            'topic_time' => $topic_time,
            'description' => $description,
        ];
        $data = [];
        foreach ($tempVals as $columns => $value) {
            if ($value != '')
                $data[$columns] = $value;
        }
        $previous_time = $topic['topic_time'];

        if ($this->scansio_db_man->update('academy_topic', $data, $topic_where)) {
            if (($topic_time - $previous_time) != 0) {
                $this->scansio_db_man->update('academy_course', ['course_time' => (($course['course_time'] - $previous_time) + $topic_time)], $course_where);
            }
            if ($position != $topic['position']) {
                $previous_position = $topic['position'];
                $target_position = $position;
                $this->changePosition($course_code, $topic_code, $previous_position, $target_position);
            }
            $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "admin/topics/" . $course_code, 'info' => alert_msg("<i class='fa fa-check-square'></i> $data[topic_title] updated", "alert-success", 1)]));
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
        }
    }

    private function changePosition($course_code, $topic_code, $from, $to = 'last')
    {
        $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course_code' && status != " . HOTLISTED . " ORDER BY position");
        $previous_position = $from;
        $target_position = ($to == 'last' ? count($topics) : $to);
        //Implemeting move operation
        if ($previous_position > $target_position) {
            //Moving up
            for ($i = $target_position; $i < $previous_position; $i++) { /* AND position = $i*/
                $t_where = "WHERE course_code = '$course_code' AND id = " . $topics[$i]['id'] . " AND status != " . HOTLISTED;
                $this->scansio_db_man->update('academy_topic', ['position' => ($i + 1)], $t_where);
            }
        } else {
            //Moving down
            for ($i = $target_position; $i > $previous_position; $i--) {
                $t_where = "WHERE course_code = '$course_code' AND id = " . $topics[$i]['id'] . " AND status != " . HOTLISTED;
                $this->scansio_db_man->update('academy_topic', ['position' => ($i - 1)], $t_where);
            }
        }
        $topic_where = "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED;
        $this->scansio_db_man->update('academy_topic', ['position' => $target_position], $topic_where);
    }

    public function trading()
    {
        $this->admin->check();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-line-chart"></i> Trading</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['tab'] = "trading";
        $data['main_content'] = 'admin/trading';
        $this->load->view('admin/layouts/main', $data);
    }

    public function add_trade($process = 0)
    {
        if ($process == 1) {
            $this->form_validation->set_rules("pair", "Trading pair", "trim|required");
            $this->form_validation->set_rules("buy", "Buy price", "trim|required|integer");
            $this->form_validation->set_rules("sell", "Sell price", "trim|required|integer");

            if ($this->form_validation->run() == true) {
                $buy = $this->input->post("buy");
                $sell = $this->input->post("sell");
                $pair = $this->input->post("pair");
                $price = $this->Main_model->get_pair_price(str_replace("/", "", $pair));
                $profit = (($price - $buy) * 100) / $buy;
                $date = ($this->input->post("date") == "") ? date_time() : $this->input->post("date");
                $data = array(
                    "pairs" => $this->input->post("pair"),
                    "buy" => $buy,
                    "sell" => $sell,
                    "price" => $price,
                    "profit" => round($profit, 2),
                    "status" => 1,
                    "date" => $date
                );
                if ($this->Db_model->insert("trading_main", $data)) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Trade added successfully", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error adding trade", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", validation_errors());
            }
            redirect(base_url() . "admin/trading");
        } else {
            $view = "
            <div class='modal-header'>
                <h4>Add Trade</h4>
            </div>
            <div class='modal-body'>
                " . validation_errors() . "
                " . form_open(base_url() . "admin/add-trade/1") . "
                <div class='form-group'>
                    <label>Trading pair</lable>
                    <input class='form-control' type='text' name='pair' placeholder='RLC/USDT' value='" . set_value('pair') . "'>
                </div>
                <div class='form-group'>
                    <label>Buy price</lable>
                    <input class='form-control' type='number' step='0.00000001' name='buy' placeholder='1.284' value='" . set_value('buy') . "'>
                </div>
                <div class='form-group'>
                    <label>Sell price</lable>
                    <div class='input-group'>
                        <input class='form-control' type='number' step='0.00000001' name='sell' placeholder='1.30968' value='" . set_value('sell') . "'>
                        <span class='input-group-addon'>0</span>
                    </div>
                </div>
                <div class='form-group'>
                    <label>Buy price</lable>
                    <input class='form-control' type='datetime-local' name='date' value='" . set_value('date') . "'>
                </div>
                <button class='btn btn-primary' type='submit'>Add Trade</button>
                <button class='btn btn-danger' data-dismiss='modal'>Close</button>
                " . form_close() . "
            </div>
            ";
            $this->output->set_output($view);
        }
    }
}
