<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/27/2018
 * Time: 5:11 PM
 */
class Airtime extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function index($msg="Working") {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-phone-square"></i> Buy Airtime</li>
        </ol>
        ';
        $data['tab'] = "airtime";
        $data['main_content'] = "users/airtime";
        $this->load->view('layouts/main', $data);
    }
    
    public function process_airtime() {
        $this->form_validation->set_rules("amount", "Amount", "trim|required|numeric|less_than_equal_to[50000]|greater_than_equal_to[50]");
        $this->form_validation->set_rules("recipient", "Recipient", "trim|required|numeric");
        $this->form_validation->set_rules("network", "Network", "trim|required");
        $this->form_validation->set_rules("password", "Password", "trim|required");

        if ($this->form_validation->run() === TRUE) {
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you can't purchase airtime on free mode", "alert-danger", 1));
                redirect(base_url()."withdraw");
            }
            $this->load->model("users/Users_model", "user");
            if ($this->user->confirm_pass($this->input->post("password"))) {
                $recipient = $this->input->post('recipient');
                if (substr($recipient, 0, 3) == 234) {
                    $recipient = "0".ltrim($recipient, 234);
                }
                $network = $this->Util_model->get_info("networks", "network, country", "WHERE id=$net_id");
                $country = $this->Util_model->get_info("countries", "*", "WHERE id=$network[country]");
                $network = $network['network'];

                $amount = $this->input->post('amount');
                $network = $this->Main_model->get_network($recipient);
                $net_id = $this->input->post("network");

                $discount = $this->Util_model->get_info("airtime_discount", "discount", "WHERE network_id=$net_id");
                $discount = ($discount == 0) ? 0 : get_percentage($amount, $discount);

                $amount_to_pay = $amount - get_percentage($amount, $network['discount']);
                $network_error = true;
                if (!isset($_POST['ported'])) {
                    if ($network['net_id'] != $_POST['network']) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Recipient phone number and network doesn't match", "alert-danger", 1));
                        $network_error = false;
                    }
                }

                if ($network_error) {
                    $usd_amt = $this->Util_model->currency_converter($amount_to_pay, $country['currency'], 'USDT');
                    if ($this->Main_model->check_balance(userdata(UID), $usd_amt)) {
                        $ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb");
                        $debit = $this->Main_model->add_to_wallet($usd_amt, 0, userdata(UID), "Sold $network($country[name]) $amount airtime", "Purchased $network($country[name]) $amount airtime", "Airtime purchase", "$amount ($country[currency]):$network:$recipient:$amount_to_pay ($country[currency])", $ref);
                        if ($debit['return']) {
                            /* if ($net_id  > 1) {
                                $airtime_request = $this->Main_model->initialize_airtime_request(userdata(UID), $net_id, $amount, $recipient, $amount_to_pay, $network['discount'], $ref);
                            } else {
                                $airtime_request = $this->Main_model->initialize_airtime_request_smeplug(userdata(UID), $net_id, $amount, $recipient, $amount_to_pay, $network['discount'], $ref);
                            } */
                            $airtime_request = $this->Main_model->initialize_clubkonnect_airtime_request(userdata(UID), $net_id, $amount, $recipient, $amount_to_pay, $discount, $ref, "");
                            if ($airtime_request['status']) {
                                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> $airtime_request[message]", "alert-success", 1));
                            } else {
                                $this->Db_model->delete("user_wallet", "WHERE debitor=" . userdata(UID) . " AND ref='$ref'");
                                //$this->Db_model->update("user_coupon", ["used" => 0], "WHERE uid=" . userdata(UID) . " AND coupon='$coup' AND relate='airtime_coupon'");
                                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $airtime_request[message]", "alert-danger", 1));
                            }
                        } else {
                            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to complete process at the moment. Try again later", "alert-danger", 1));
                        }
                    } else {
                        redirect(base_url()."deposit");
                    }
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."airtime");
    }

    public function password_check($password) {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($password)) {
            return true;
        } else {
            $this->form_validation->set_message("password_check","Incorrect password. Try again");
            return false;
        }
    }

    public function cancel_transaction ($order_id) {
        $this->Main_model->cancel_airtime_transaction($order_id);
        redirect(base_url()."airtime");
    }

    public function get_discount ($net_id) {
        echo $this->Util_model->get_info("airtime_discount", "discount", "WHERE network_id=$net_id");
    }

}

?>