<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/27/2018
 * Time: 5:11 PM
 */
class Airtime_to_cash extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function index() {
        $this->form_validation->set_rules("amount", "Amount", "trim|required|numeric");
        $this->form_validation->set_rules("method", "Payment method", "trim|required");
        $this->form_validation->set_rules("network", "Network", "trim|required");
        $this->form_validation->set_rules("from", "Phone number", "trim|required|numeric");

        if ($this->form_validation->run() === TRUE) {
            $method = $this->input->post('method');
            $amount = $this->input->post('amount');
            $from_pin = 0;
            $network = $this->input->post('network');
            $amount_to_receive = $amount - get_percentage($amount, $this->Util_model->get_info("airtime_to_cash_fee", "charge", "WHERE net_id=$network"));
            $field_filled_up = false;
            $from_pin = $this->input->post('from');
            if ($method == 1) {
                    $method = "Wallet";
                    $field_filled_up = true;
            } else {
                if (!empty($this->input->post('bank')) && !empty($this->input->post('acct_num')) && !empty($this->input->post('acct_name'))) {
                    $method = strtoupper($_POST['acct_name'])." $_POST[acct_num] ($_POST[bank])";
                    $field_filled_up = true;
                }
            }

            if ($field_filled_up) {
                $data = array(
                    "uid" => userdata(UID),
                    "reference" => $this->Util_model->generate_id(11111111, 99999999, "airtime_to_cash", "reference", "varchar", true, 'fb'),
                    "network" => $network,
                    "method" => $method,
                    "phone_pin" => $from_pin,
                    "amount" => $amount,
                    "amount_received" => $amount_to_receive,
                    "status" => 0,
                    "date" => date_time()
                );
                if ($this->Db_model->insert("airtime_to_cash", $data)) {
                    $additional = "
                    <p><b>Username: </b>".$this->Util_model->get_user_info(userdata(UID), "username", "profile")."</p>
                    <p><b>Amount: </b>$amount</p>
                    ";
                    $this->Mail_model->send_notification("Airtime To Cash", "An airtime to cash request has been made and it requires manual confirmation from you.", "<a href='".base_url()."admin/airtime-cash-orders'>Complete Order</a>", $additional, "Admin");
                    //Notification
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Transaction booked successfully. Awaiting payment from you.", "alert-success", 1));
                    redirect(base_url()."airtime-to-cash?reference=".$this->Util_model->get_info("airtime_to_cash", "reference","WHERE status=0 ORDER BY id DESC LIMIT 1"));
                } else {
                    set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured while booking transaction. Try again later.", "alert-danger", 1));
                }
            } else {
                set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Required field empty. Please fill all the field with red asterisks.", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }

        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><i class="fa fa-refresh"></i> Airtime To Cash</li>
        </ol>
        ';
        $data['tab'] = "airtime2cash";
        $data['main_content'] = "users/airtime2cash";
        $this->load->view('layouts/main', $data);
    }

    public function airtime_sent ($ref) {
        if ($this->Db_model->update("airtime_to_cash", ["status"=>1], "WHERE reference='$ref' AND status=0")) {
            $this->Mail_model->send_notification("Airtime to cash Purchase", "A airtime to cash request has been made and it requires manual confirmation from you. The user has signified that he has sent the airtime, so kindly check and confirm this transaction.", base_url()."admin/airtime-cash-orders", "View Request");
            //Notification
            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Awaiting confirmation by system", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to perform action at the moment. Try again later.", "alert-danger", 1));
        }
        redirect(base_url()."airtime-to-cash?reference=$ref");
    }

    public function password_check($password) {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($password)) {
            return true;
        } else {
            $this->form_validation->set_message("password_check","Incorrect password. Try again");
            return false;
        }
    }

    public function cancel_transaction ($order_id) {
        if ($this->Db_model->update("airtime_to_cash", ['status'=>3], "WHERE reference='$order_id' AND status=0")) {
            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Airtime conversion cancelled successfully", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error: unable to cancel airtime conversion", "alert-danger", 1));
        }
        redirect(base_url()."airtime-to-cash");
    }

}

?>