<?php

/**
 *  
 */
class Book extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
        }

    }

    public function preview_book($book_id)
    {
        $book = $this->Db_model->select('*', 'book_main', "WHERE book_id = '$book_id' AND status = 1");
        if (!$book) {
            set_flashdata("msg", alert_msg("<i class='fa fa-remove'></i> The requested book not found", "alert-danger", 1));
            redirect("academy/ebook");
        }
        $category = $this->scansio_db_man->select('book_category', '*', 'WHERE id = ' . $book['cat_id'])['title'];
        $author = $this->scansio_db_man->select('user_main', '*', 'WHERE uid = ' . $book['author'])['name'];
        $author = $book['author'] == userdata(UID) ? 'You' : $author;
        $img_url = base_url() . $book['pic_url'];
        $type = $this->scansio_db_man->select('book_type', '*', 'WHERE id = ' . $book['type'])['title'];
        $read_link = base_url() . "misc/validate_balance/$book_id/$book[price]/books";
        $purchased = false;
        $last_update = $book['last_update'];
        if ($this->Book_model->has_access($book_id, 'book')) {
            $read_link = base_url() . "academy/ebook/" . urlencode($book["title"]) . "/$book_id";
            $purchased = true;
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-graduationcap"></i> Academy</li>
        </ol>
        ';
        $data['tab'] = "academy";
        $data['book'] = $book;
        $data['title'] = $book['title'];
        $data['edition'] = $book['edition'];
        $data['price'] = $book['price'];
        $data['old_price'] = $book['old_price'];
        $data['category'] = $category;
        $data['author'] = $author;
        $data['img_url'] = $img_url;
        $data['type'] = $type;
        $data['read_link'] = $read_link;
        $data['purchased'] = $purchased;
        $data['last_update'] = $last_update;
        $data['main_content'] = 'users/preview_book';
        $this->load->view('layouts/main', $data);
    }

    public function read($book_id)
    {
        $title = $this->Util_model->get_info("book_main", "title", "WHERE book_id = $book_id");
        $this->read_book(urlencode($title), $book_id);
    }

    public function read_book($title, $book_id)
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            /* if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
                redirect(base_url() . "activate");
            } */
            if (!$this->Book_model->has_access($book_id, 'book')) {
                redirect("academy/ebook/preview/$book_id");
                return;
            }
            ;
        }
        if (has_userdata(A_UID)) {
            $book = $this->scansio_db_man->select('book_main', '*', "WHERE book_id = $book_id");
        } else {
            $book = $this->scansio_db_man->select('book_main', '*', "WHERE book_id = $book_id AND status = " . ACTIVE);
        }
        if ($book && urldecode($title) == $book['title']) {
            if (!has_userdata(A_UID)) {
                $uid = userdata(UID);
                $has_view = $this->scansio_db_man->select('book_views', '', "WHERE `uid` = $uid && `booK_id` = $book_id");
                if (!$has_view) {
                    $this->scansio_db_man->insert('book_views', ['uid' => $uid, 'book_id' => $book_id]);
                }
            }

            $data['title'] = $book['title'];
            $data['file'] = base_url() . 'book/viewer?file=' . base_url() . 'book/get-book-file/' . $book_id;
            $data['tab'] = "academy";
            $data['main_content'] = 'users/read_book';
            $data['breadcrumb'] = '
				<ol class="breadcrumb">
					<li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home </a></li>
					<li><a href="' . base_url() . 'academy/ebook"><i class="fa fa-book"></i> eBooks </a></li> 
					<li> ' . $data['title'] . ' </li>
				</ol>
				';
            if (has_userdata(A_UID)) {
                $this->load->view('admin/layouts/main', $data);
            } else {
                $this->load->view('layouts/main', $data);
            }
        } else {
            if (has_userdata(A_UID))
                redirect('admin/books');
            else
                redirect('academy/ebooks');
        }
    }


    public function viewer()
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            /* if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
                redirect(base_url() . "activate");
            } */
        }
        $this->load->view('pdf/viewer');
    }

    public function get_book_file($book_id)
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            /* if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
                redirect(base_url() . "activate");
            } */
        }
        //log_message('debug', "Getting pdf file .....");
        $referred_by = str_replace('\\', '/', base_url()) . 'book/viewer?file=' . base_url() . 'book/get-book-file/' . $book_id;
        //log_message('debug', "Referred by: $referred_by");
        $http_referer = $_SERVER['HTTP_REFERER'];
        //log_message('debug', "HTTP referer: $http_referer");
        $referer_matched = ($http_referer == $referred_by);
        //log_message('debug', ("HTTP referer matched: " . (($referer_matched) ? 'true' : 'false')));
        if (!$referer_matched) {
            redirect('academy/ebook');
            return;
        }
        if (!has_userdata(A_UID)) {
            $where = "WHERE book_id = $book_id && status = " . PUBLISHED;
            $book = $this->scansio_db_man->select('book_main', '', $where);
            if (!$book || !$this->Book_model->has_access($book_id, 'book')) {
                //log_message('debug', "Book doesn't exist or user didn't have access to it.");
                redirect('academy/ebook/all');
                return;
            }
        } else {
            $book = $this->scansio_db_man->select('book_main', '', "WHERE book_id = $book_id");
        }
        $parent = str_replace('\\', '/', FCPATH);
        //log_message('debug', "FCPATH: " . FCPATH);
        //log_message('debug', "Parent path: $parent");
        //log_message('debug', "Book path from database: $book[file]");
        $path = ltrim($book['file'], './');
        //log_message('debug', "Book full path: $parent$path");
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $book_id . '.pdf' . '"');
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($parent . $path));
        //log_message('debug', "PDF size: " . filesize($parent . $path));
        ob_clean();
        flush();
        $file = $parent . $path;
        readfile($file);
        exit;
    }


}