<?php

/**
 *  
 */
class Course extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
        }

    }

    public function preview_course($course_code)
    {
        $course = $this->Db_model->select('*', 'academy_course', "WHERE course_code = '$course_code' AND status = 1");
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-remove'></i> The requested course not found or not yet published", "alert-danger", 1));
            redirect("academy");
        }
        $category = $this->scansio_db_man->select('academy_category', '*', "WHERE id = $course[category]");
        $category = ($category ? $category['title'] : "Misc");
        $instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor]")['name'];
        $instructor = $course['course_instructor'] == userdata(UID) ? 'You' : $instructor;
        $intro_video = $course['course_introduction_link'];
        $duration = getFormattedDuration($course['course_time']);
        $level = $course['course_level'];
        $level = ($level == EXPERT) ? 'Expert' : (($level == ADVANCE) ? 'Advance' : 'Beginner');
        $price = $course['course_price'];
        $old_price = $course['course_old_price'];
        $description = $this->scansio_db_man->parseHtmlEntity($course['course_desc']);
        $uid = userdata(UID);
        $thumbnail = $course['course_pic'];
        $last_update = $course['last_update'];
        $read_link = base_url() . "misc/validate_balance/$course_code/$course[course_price]/courses";
        $purchased = false;
        if ($this->Course_model->has_access($course_code)) {
            $topics_where = "WHERE course_code='$course[course_code]' ORDER BY position ASC";
            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', $topics_where);
            $topic = $this->scansio_db_man->select('academy_topic', '', "WHERE course_code='$course[course_code]' AND status = 1");
            $topic_code = '0';
            if ($topics && isset($topics[0])) {
                $topic_code = (is_string($topic) ? $topic : (is_array($topic) ? $topic['id'] : 0));
            } else {
                $topic_code = (is_string($topic) ? $topic : (is_array($topic) ? $topic['id'] : 0));
            }
            $read_link = base_url() . "academy/$course[course_code]/$topic_code";
            $purchased = true;
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-graduationcap"></i> Academy</li>
        </ol>
        ';
        $data['thumbnail'] = base_url($thumbnail);
        $data['last_update'] = $last_update;
        $data['course'] = $course;
        $data['category'] = $category;
        $data['instructor'] = $instructor;
        $data['intro_video'] = $intro_video;
        $data['duration'] = $duration;
        $data['level'] = $level;
        $data['price'] = $price;
        $data['old_price'] = $old_price;
        $data['description'] = $description;
        $data['read_link'] = $read_link;
        $data['purchased'] = $purchased;
        $data['tab'] = "academy";
        $data['main_content'] = 'users/preview_course';
        $this->load->view('layouts/main', $data);
    }


    public function academy_topic($course_code, $topic_code = '1')
    {
        $uid = userdata(UID);
        if (has_userdata(A_UID)) {
            $uid = userdata(A_UID);
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
                redirect(base_url() . "activate");
            }
            $course_availability = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$course_code' && status = " . PUBLISHED);
            if (!$course_availability) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry the course you want is unavailable. Try again later...", "alert-danger", 1));
                redirect('academy');
                return;
            }
            if (!$this->Course_model->has_access($course_code)) {
                redirect("academy/ecourse/preview/$course_code");
                return;
            }
        }
        $topic = $this->Db_model->selectGroup("*", "academy_topic", "WHERE course_code='$course_code' AND id='$topic_code' AND status=1");
        if ($topic->num_rows() == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Topics not found in <b>" . $this->Util_model->get_info("academy_course", "course_title", "WHERE course_code='$course_code'") . "</b>. Try again later", "alert-danger", 1));
            if (has_userdata(A_UID))
                redirect('admin/manage_courses');
            else
                redirect(base_url() . "academy");
            return;
        }
        if ($this->Util_model->row_count("academy_watched", "WHERE uid=" . $uid . " AND course_code='$course_code' AND topic_code='$topic_code'") == 0) {
            $this->Db_model->insert("academy_watched", ["uid" => $uid, "course_code" => $course_code, "topic_code" => $topic_code]);
        } else {
            $this->Db_model->update("academy_watched", ["date" => date_time()], "WHERE uid=" . $uid . " AND course_code='$course_code' AND topic_code='$topic_code'");
        }
        $course = $this->Util_model->get_info("academy_course", "*", "WHERE course_code='$course_code'");
        $topic = $topic->row_array();
        $topic_list = '<ul class="products-list product-list-in-box">';
        $topics = $this->Db_model->selectGroup("*", "academy_topic", "WHERE course_code='$course[course_code]' AND status=1 ORDER BY position");
        foreach ($topics->result_array() as $row) {
            $num_color = ($this->Util_model->row_count("academy_watched", "WHERE uid=" . $uid . " AND course_code='$row[course_code]' AND topic_code='$row[id]'") == 0) ? "bg-gray" : "bg-blue";
            $active = ($row['id'] == $topic['id']) ? "style='background-color:#f7f8ff'" : "";
            $play = ($row['id'] == $topic['id']) ? "<i class='fa fa-play-circle pull-right'></i>" : "";
            $topic_list .= "
			<li class='item cursor-pointer' style='padding-left:5px; padding-right:10px; $active' onclick='window.location = \"" . base_url() . "academy/$row[course_code]/$row[id]\"'>
				<div class='product-img'>
					<div class='img-circle $num_color text-center pull-left' style='width:40px; height:40px; vertical-align: middle'>" . ($row['position'] + 1) . "</div>
				</div>
				<div class='product-info'>
					<a href='javascript:void(0)' class='product-title'>
						$row[topic_title] $play
					</a>
					<span class='product-description'>
						<i class='fa fa-clock-o'></i> " . getFormattedDuration($row['topic_time']) . "
					</span>
				</div>
			</li>
			";
        }
        $topic_list .= "</ul>";
        $data['topic_list'] = $topic_list;
        $data['comments'] = $this->Course_model->topic_comments($topic['course_code'], $topic['id']);
        $data['description'] = $this->scansio_db_man->parseHtmlEntity($topic['description']);
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li><a href="' . base_url() . 'academy"><i class="fa fa-graduation-cap"></i> Academy</a></li>
            <li> ' . $course_availability['course_title'] . '</li>
        </ol>
        ';
        $data['style'] = '
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css">
        <link rel="stylesheet" href="' . base_url() . 'assets/plugins/mediaelement/build/mediaelementplayer.css">
        ';
        $data['topic'] = $topic;
        $data['course'] = $course;
        $data['tab'] = "academy";
        $data['main_content'] = 'users/academy_topic';
        if (has_userdata(A_UID)) {
            $this->load->view('admin/layouts/main', $data);
        } else {
            $this->load->view('layouts/main', $data);
        }
    }


    public function watch($course_code)
    {
        $uid = userdata(UID);
        if (has_userdata(A_UID)) {
            $uid = userdata(A_UID);
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
                redirect(base_url() . "activate");
            }
            if (!$this->Course_model->has_user_purchase($course_code)) {
                redirect('my_courses');
                return;
            }
        }
        $watched = $this->Util_model->row_count("academy_watched", "WHERE uid=" . $uid . " AND course_code='$course_code'");
        $topic = ($watched == 0) ? $this->Util_model->get_info("academy_topic", "id", "WHERE course_code='$course_code' AND status=1 ORDER BY position LIMIT 1") : $this->Util_model->get_info("academy_watched", "topic_code", "WHERE uid=" . $uid . " AND course_code='$course_code' ORDER BY date DESC");
        $topics_where = "WHERE course_code = '$course_code' ORDER BY position ASC";
        $topics = $this->scansio_db_man->selectGroup('academy_topic', '', $topics_where);
        $topic_code = '0';
        if ($topics && isset($topics[0])) {
            $topic_code = (is_array($topic) ? $topic['id'] : $topics[0]['id']);
        }
        $this->academy_topic($course_code, $topic_code);
    }
}