<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/27/2018
 * Time: 5:11 PM
 */
class Data extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function index() {
        
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-globe"></i> Buy Data</li>
        </ol>
        ';
        $data['tab'] = "data";
        $data['main_content'] = "users/data";
        $this->load->view('layouts/main', $data);
    }
    
    public function process_data() {
        $this->form_validation->set_rules("network", "Network", "required|trim");
        $this->form_validation->set_rules("bundle", "Bundle", "required|trim");
        $this->form_validation->set_rules("recipient", "Recipient", "required|trim|numeric");
        $this->form_validation->set_rules("password", "Password", "trim|required");

        if ($this->form_validation->run() === TRUE) {
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you can't purchase data on free mode", "alert-danger", 1));
                redirect(base_url()."data");
            }
            $this->load->model("users/Users_model", "user");
            if ($this->user->confirm_pass($this->input->post("password"))) {
                $recipient = $this->input->post('recipient');
                if (substr($recipient, 0, 3) == 234) {
                    $recipient = "0".ltrim($recipient, 234);
                }
                $net_id = $this->input->post('network');
                $bundle = $this->Util_model->get_info("data_bundle", "*", "WHERE id='$_POST[bundle]'");
                $amount_to_pay = $bundle['amount'];
                $network = $this->Util_model->get_info("networks", "*", "WHERE id=$net_id");
                $country = $this->Util_model->get_info("countries", "*", "WHERE id=$network[country]");
                $network_error = true;

                if (!isset($_POST['ported'])) {
                    if ($network['net_id'] != $_POST['network']) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Recipient phone number and network doesn't match", "alert-danger", 1));
                        $network_error = false;
                    }
                }
                
                if ($network_error) {
                    $usd_amt = $this->Util_model->currency_converter($amount_to_pay, $country['currency'], 'USDT');
                    if ($this->Main_model->check_balance(userdata(UID), $usd_amt)) {
                        $ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb");
                        $debit = $this->Main_model->add_to_wallet(
                            $usd_amt,
                            0,
                            userdata(UID),
                            "$network[network] $bundle[bundle]",
                            "$network[network] $bundle[bundle]",
                            "Data purchase",
                            "$network[network]:$bundle[bundle]:$country[currency] $bundle[amount]:$recipient",
                            $ref
                        );
                        if ($debit['return']) {
                            /* if ($this->Util_model->get_info("networks", "auto", "WHERE id=$net_id") == 0) {
                                $data_request = $this->Main_model->initialize_data_request_mannual(userdata(UID), $recipient, $bundle['id'], $amount_to_pay, 0, $ref);
                            } else {
                                $data_request = $this->Main_model->initialize_data_request(userdata(UID), $recipient, $bundle['id'], $amount_to_pay, 0, $ref);
                            } */
                            $data_request = $this->Main_model->clubkonnect_data_request(userdata(UID), $recipient, $bundle['id'], $amount_to_pay, 0, $ref, "");
                            if ($data_request['status']) {
                                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> $data_request[message]", "alert-success", 1));
                            } else {
                                $this->Db_model->delete("user_wallet", "WHERE debitor=" . userdata(UID) . " AND ref='$ref'");
                                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $data_request[message]", "alert-danger", 1));
                            }
                        } else {
                            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to complete process at the moment. Try again later", "alert-danger", 1));
                        }
                    } else {
                        redirect(base_url() . "deposit");
                    }
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."data");
    }

    public function password_check($password) {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($password)) {
            return true;
        } else {
            $this->form_validation->set_message("password_check","Incorrect password. Try again");
            return false;
        }
    }

    public function cancel_transaction ($order_id) {
        $this->Main_model->cancel_data_transaction($order_id);
        redirect(base_url()."data-bundle");
    }

    public function list_bundles ($net_id="") {
        $opt = "";
        if ($net_id == "") {
            $opt = "<option value=''>Select network first</option>";
        } else {
            $s = $this->Db_model->selectGroup("*", "data_bundle", "WHERE network_id=$net_id AND status=1");
            if ($s->num_rows() == 0) {
                $opt = "<option value=''>No bundle found</option>";
            } else {
                $opt = "<option value=''>--Select bundle--</option>";
                $network = $this->Util_model->get_info("networks", "network", "WHERE id=$net_id");
                foreach ($s->result_array() as $row) {
                    $opt .= "<option value='$row[id]'>$network $row[bundle] - $row[validity] days</option>";
                }
            }
        }
        echo $opt;
    }

    public function get_amount ($bundle="") {
        $return = json_encode([
            "amount"      =>  0,
            "eqv"      =>  0
        ]);
        if ($bundle != "")  {
            $amount = $this->Util_model->get_info("data_bundle", "amount", "WHERE id=$bundle");
            $charge = $this->Util_model->get_option("utility_charge");
            $amt = $amount + get_percentage($amount, $charge);
            $rate = $this->Util_model->get_info("payment_rates", "rate", "WHERE base='USDT' AND currency='".$this->Util_model->get_country_info('currency')."' AND status=1");
            $eqv = $amt / $rate;
            $return = json_encode([
                "amount"      =>  $amount,
                "eqv"      =>  $eqv
            ]);
        }
        $this->output->set_output($return);
    }

    public function refresh_data_bundles () {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "smeplug.ng/api/v1/data/plans",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer ".$this->Util_model->get_option("sme_plug_sk")
            ),
        ));

        $response = json_decode(curl_exec($curl));

        curl_close($curl);

        $values = "";
        $this->Db_model->query("TRUNCATE data_bundle");
        foreach ($response->data as $net_id => $net) {
            foreach ($net as $bundle) {
                $b_id = $bundle->id;
                $name = $bundle->name;
                $price = $bundle->price;
                $values .= "('$b_id', $net_id, '$name', $price, 1), ";
            }
        }
        $values = rtrim($values, ", ");
        if ($this->Db_model->query("INSERT INTO `data_bundle` (id, network_id, bundle, amount, status) VALUES $values")) {
            $return = [
                "status"    =>  true,
                "msg"       =>  "Data bundle refreshed successfully"
            ];
        } else {
            $return = [
                "status"    =>  true,
                "msg"       =>  "Error refreshing data bundle"
            ];
        }

    }

}

?>