<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 6/29/2021
 * Time: 4:42 PM
 */

defined('BASEPATH') or exit('No direct script access allowed');

class Get_started extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
        if ($this->Util_model->get_user_info(userdata(UID), "free_access", "profile") == 0) {
            if ($this->Util_model->row_count("user_getting_started", "WHERE uid=" . userdata(UID) . " AND status=2") == 1) {
                redirect(base_url() . "activate");
            }
        }
    }

    public function index()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'activate">Get Started</a></li>
        </ol>
        ';
        $data['tab'] = "get_started";
        $data['main_content'] = 'users/getting-started';
        $this->load->view('layouts/main', $data);
    }

    public function update_fin_status()
    {
        if ($this->Util_model->row_count("user_getting_started", "WHERE uid=" . userdata(UID)) == 0) {
            if (!$this->Db_model->insert("user_getting_started", ["uid" => userdata(UID), "fin_test" => $_POST['score'], "date" => date_time()])) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
            }
        } else {
            if (!$this->Db_model->update("user_getting_started", ["fin_test" => $_POST['score'], "date" => date_time()], "WHERE uid=" . userdata(UID))) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
            }
        }
        redirect(base_url() . "get-started");
    }

    public function closing()
    {
        
        if ($this->Util_model->row_count("user_getting_started", "WHERE uid=" . userdata(UID) . " AND status<=1") == 1) {
            if (!$this->Db_model->update("user_getting_started", ["question1" => $_POST['question1'], "question2" => $_POST['question2'], "question3" => $_POST['question3'], "status" => 1, "date" => date_time()], "WHERE uid=" . userdata(UID))) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
            }
        }
        redirect(base_url() . "get-started");
    }

    public function start_immidiately()
    {
        if ($this->Util_model->row_count("user_getting_started", "WHERE uid=" . userdata(UID) . " AND status=1") == 1) {
            $this->Db_model->update("user_getting_started", ["status" => 2, "discount_expire" => set_expire_date(24 * 3)], "WHERE uid=" . userdata(UID));
        }
        redirect(base_url() . "activate");
    }

    public function show_welcome_message()
    {
        $view = "
        <div class='modal-header'>
            <h3 class='modal-title'>Welcome HOME!</h3>
        </div>
        <div class='modal-body text-center' style='font-size:18px'>
            Hi " . $this->Util_model->get_user_info(userdata(UID)) . ",<br>
            Make sure to watch the video till the end, your success in this HOUSE depends on it.
            <iframe style='width:100%; height:350px;' src='https://www.youtube.com/embed/I7KI-btINpM?rel=0'></iframe>
            <div class='text-center top-2x'>
                <a href='" . base_url() . "get-started/watched-welcome-video' class='btn btn-warning'>I Understand What To Do</a>
            </div>
        </div>
        ";
        $this->output->set_output($view);
    }

    public function watched_welcome_video()
    {
        $this->Db_model->update("user_profile", ["status" => 1], "WHERE uid=" . userdata(UID));
        redirect(base_url() . "home");
    }

    public function other_info($update = 0)
    {
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('dob', 'Date of Birth', 'required|trim');
        $this->form_validation->set_rules('state', 'State', 'required|trim');
        $this->form_validation->set_rules('city', 'City', 'required|trim');

        if ($this->form_validation->run() == TRUE) {
            $data = [
                'dob' => $this->input->post('dob'),
                'state_id' => $this->input->post('state'),
                'city' => $this->input->post('city')
            ];
            if ($update > 0) {
                if ($this->scansio_db_man->update('user_other', $data, "WHERE id = $update")) {
                    $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "get-started", 'info' => "Other information saved"]));
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                }
            } else {
                $data['uid'] = userdata(UID);
                if ($this->scansio_db_man->insert('user_other', $data)) {
                    $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "get-started", 'info' => "Other information saved"]));
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                }
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => validation_errors()]));
        }
    }
}
