<?php

/**
 *  
 */
class Home extends CI_Controller
{
    private $page_limit = 50, $featured, $style;

    public function __construct()
    {
        parent::__construct();
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                redirect(base_url() . "activate");
            }
        }
    }

    public function index()
    {
        //$this->load->model("Store_model", "store");

        // if ($this->Util_model->row_count("user_account", "WHERE uid=".userdata(UID)) == 0) {
        //     $this->load->model("Monnify_model", "monnify");
        //     $this->monnify->reserveAccount(userdata(UID));
        // }

        // $acct = $this->Util_model->get_info("user_account", "*", "WHERE uid=".userdata(UID));
        // $data['account'] = [
        //     "bank"  =>  ($acct == NULL)?"":$this->Util_model->get_info("banks", "name", "WHERE code='$acct[bank]'"),
        //     "acct_number" => ($acct == NULL)?"":$acct['acct_num'],
        //     "acct_name" => ($acct == NULL)?"":$acct['acct_name'],
        // ];
        /* if ($this->Util_model->get_user_info(userdata(UID), "status") == 0) {
            redirect(base_url()."activate");
        } */
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-home"></i> Home</a></li>
        </ol>
        ';
        $this->load->model("products/Opportunity_model", "opp");
        $data['cid'] = $this->Util_model->get_user_info((has_userdata(A_UID) ? userdata(A_UID) : userdata(UID)), "cid", "profile");
        $data['profile'] = $this->Util_model->get_info("user_profile", "*", "WHERE uid=" . (has_userdata(A_UID) ? userdata(A_UID) : userdata(UID)));
        $data['tab'] = "dashboard";
        $data['main_content'] = 'users/home';
        $this->load->view('layouts/main', $data);
    }

    public function plan()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li>Investment Plan</li>
        </ol>
        ';
        $data['tab'] = "plan";
        $data['main_content'] = 'users/plan';
        $this->load->view('layouts/main', $data);
    }

    public function cbd()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-leaf"></i> CBD Plan</li>
        </ol>
        ';
        $data['tab'] = "cbd";
        $data['main_content'] = 'users/cbd';
        $this->load->view('layouts/main', $data);
    }

    public function invest()
    {
        if ($this->General_model->get_balance(userdata(UID), false) >= $_POST['amount']) {
            $return = array(
                "return"    =>  1,
                "msg"       =>  "<i class='fa fa-check-circle'></i> Investment was successful. Thank you"
            );
            $plan = $this->Util_model->get_info("plans", "name, type", "WHERE id=$_POST[plan]");
            $wallet = $this->Main_model->add_to_wallet($_POST['amount'], 0, userdata(UID), "Forex investment", "Forex investment", "Investment", "$plan[type] ($plan[name])", "", 1);
            if ($wallet['return']) {
                $data = array(
                    "uid"           =>  userdata(UID),
                    "plan"          =>  $_POST['plan'],
                    "type"          =>  $plan['type'],
                    "amount"        =>  $_POST['amount'],
                    "profit"        =>  0,
                    "status"        =>  1
                );
                $this->Db_model->insert("investment", $data);
                $return = array(
                    "return"    =>  1,
                    "msg"       =>  "<i class='fa fa-check-circle'></i> Investment was successful. Thank you"
                );
            } else {
                $return = array(
                    "return"    =>  0,
                    "msg"       =>  "<i class='fa fa-times-circle'></i> An error occurred. Try again shortly"
                );
            }
        } else {
            $return = array(
                "return"    =>  0,
                "msg"       =>  "<i class='fa fa-times-circle'></i> Insufficient balance. <a href='" . base_url() . "fund'>Fund account</a>"
            );
        }

        echo json_encode($return);
    }

    public function crypto_payment($amount, $method)
    {
        $method = str_replace("%20", " ", $method);
        $this->load->model("Crypto_payment_model", "crypto");
        $order = $this->crypto->create_order($amount, $method);
        if ($order['status']) {
            $content = $order['content'];
            $data = [
                "amount"    =>  $amount,
                "creditor"  =>  userdata(UID),
                "debitor"   =>  0,
                "creditor_desc" =>  "Account funding",
                "debitor_desc"  =>  "Account funding",
                "type"      =>  "Funding #$order[order_id]",
                "extra"     =>  ucwords($method) . " " . $content['coin_amount'] . " (#" . $order['order_id'] . ")",
                "ref"       =>  $content['id']
            ];
            $this->Db_model->insert("user_wallet", $data);
            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Fund booked successfully. Check back in the next 5 minutes", "alert-success", 1));
            redirect($content['url']);
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $order[content]", "alert-danger", 1));
            redirect(base_url() . "fund");
        }
    }

    public function crypto_payment_status($status)
    {
    }

    public function confirm_order($order_id)
    {
        $s = $this->Db_model->selectGroup("ref", "user_wallet", "WHERE type LIKE '%$order_id'");
        if ($s->num_rows() > 0) {
            $row = $s->row_array();
            $this->load->model("Crypto_payment_model", "crypto");
            $order = $this->crypto->confirm_order($row['ref']);
            if ($order['status']) {
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$row[ref]'");
            } else {
                $this->Db_model->update("user_wallet", ["status" => 2], "WHERE ref='$row[ref]'");
            }
        }
        redirect(base_url() . "fund-list");
    }

    public function cashout_investment($id)
    {
        $invest = $this->Util_model->get_info("investment", "*", "WHERE id=$id");
        if ($invest['status'] == 1) {
            $amt = $invest['amount'] - get_percentage($invest['amount'], 5);
            $this->Main_model->add_to_wallet($amt, userdata(UID), 0, "Investment cashout", "Investment cashout", "Cashout", $id, "", 1);
            $this->Main_model->add_to_wallet(get_percentage($invest['amount'], 5), $this->Util_model->get_info("user_profile", "uid", "WHERE role=3 LIMIT 1"), 0, "Investment cashout commission", "Investment cashout commission", "Cashout commission", $id, "", 1);
            $this->Db_model->update("investment", ["status" => 2], "WHERE id=$id");
            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Investment has been cashed out successfully", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to cashout investment. Try later", "alert-danger", 1));
        }
        redirect(base_url() . "investment");
    }

    public function send_receive()
    {
        $this->form_validation->set_rules("wallet_address", "Wallet Address", "trim|required|callback_wallet_address_check");
        $this->form_validation->set_rules("amount", "Amount", "trim|required");
        $this->form_validation->set_rules("description", "Description", "trim");
        $this->form_validation->set_rules("password", "Password", "trim|required|callback_password_check");

        if ($this->form_validation->run() === TRUE) {
            $comm = get_percentage($this->input->post("amount"), 2.5);
            $amount_to_pay = $this->input->post("amount") + $comm;
            if ($this->Main_model->check_balance(userdata(UID), $amount_to_pay)) {
                $wallet = $this->Main_model->add_to_wallet($this->input->post('amount'), $this->Util_model->get_info("user_profile", "uid", "WHERE address='$_POST[wallet_address]' LIMIT 1"), userdata(UID), "Send/Receive MEXcoin", "Send/Receive MEXcoin", "Send/Receive", "", "", 1);
                $this->Main_model->add_to_wallet($comm, $this->Util_model->get_info("user_profile", "uid", "WHERE role=3 LIMIT 1"), userdata(UID), "Sending MEXcoin commission", "Sending MEXcoin commission", "Send commission", $wallet['reference'], "", 1);
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> You have successfully sent $_POST[amount] MEX", "alert-success", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . '"><i class="fa fa-home"></i> Home</a></li>
            <li>Send/Receive MEXcoin</li>
        </ol>
        ';
        $data['tab'] = "send-receive";
        $data['main_content'] = 'users/send_receive';
        $this->load->view('layouts/main', $data);
    }

    public function password_check($password)
    {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($password)) {
            return true;
        } else {
            $this->form_validation->set_message("password_check", "Incorrect password. Try again");
            return false;
        }
    }

    public function wallet_address_check($address)
    {
        if ($this->Util_model->row_count("user_profile", "WHERE address='$address'") > 0) {
            if ($this->Util_model->get_info("user_profile", "uid", "WHERE address='$address' LIMIT 1") == userdata(UID)) {
                $this->form_validation->set_message("wallet_address_check", "You can't send MEX to yourself");
                return false;
            } else {
                return true;
            }
        } else {
            $this->form_validation->set_message("wallet_address_check", "Invalid wallet address. Try again");
            return false;
        }
    }

    public function network($generation = 1)
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-sitmap"></i> My Network</li>
        </ol>
        ';
        $data['tab'] = "network";
        $data['generation'] = $generation;
        $data['main_content'] = 'users/network';
        $this->load->view('layouts/main', $data);
    }

    public function channels()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li>Channels</li>
        </ol>
        ';
        $data['tab'] = "channels";
        $data['main_content'] = 'users/channels';
        $this->load->view('layouts/main', $data);
    }

    public function join_channel($id)
    {
        $this->form_validation->set_rules("tele_username", "Telegram username", "required|trim");
        if ($this->form_validation->run() == true) {
            $data = array(
                "uid"           =>  userdata(UID),
                "channel"       =>  $id,
                "username"      =>  $this->input->post('tele_username'),
                "status"        =>  0
            );

            if ($this->Db_model->insert("user_join_channel", $data)) {
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> You request have been submitted successfully", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured try again later.", "alert-danger", 1));
            }
        }
        redirect(base_url() . "channels");
    }

    public function academy($pane = "ecourse")
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home</a></li>
            <li><i class="fa fa-graduationcap"></i> Academy</li>
        </ol>
        ';
        $data['tab'] = "academy";
        $data['pane'] = $pane;
        $data['main_content'] = 'users/academy';
        $this->load->view('layouts/main', $data);
    }

    public function get_remaining_duration () {
        $this->output->set_output(remaining_time($this->Util_model->get_info("user_profile", "duration", "WHERE uid=".userdata(UID)), "month"));
    }
}
