<?php

class Misc extends CI_Controller
{
	public function __construct()
    {
        parent::__construct();
        $this->load->model("users/Users_model","Users_model");
        $this->load->model("products/Course_model","Course_model");
        $this->load->model("products/Book_model","Book_model");
    }

	public function user($username)
	{
		$username = urldecode($username);
		$this->output->set_content_type('json');
		$result = $this->scansio_db_man->select('user_profile', '', "WHERE (username = '$username' || email = '$username') AND status != " . HOTLISTED);
		if (!$result) {
			$this->output->set_output(json_encode(['status' => false, 'info' => "Invalid username"]));
			return;
		}
		$name = $this->scansio_db_man->select('user_main', '', "WHERE uid = $result[uid] AND status != " . HOTLISTED)['name'];
		$this->output->set_output(json_encode(['status' => true, 'info' => $name]));
	}

	public function publishing_payment($item_code, $amount, $what)
	{
		$this->Util_model->log_redirect();
		$uid = userdata(UID);
		$balance = $this->Main_model->get_balance($uid, false);
		$insufficient_balance = ($balance < $amount);
		if ($insufficient_balance) {
			$remaining = $amount - $balance;
			flash_msg(false, "You don't have sufficient balance to process this transaction. Deposit and continue");
			set_flashdata("amount", $remaining);
			set_flashdata("redirect", "misc/publishing-payment/$item_code/$amount/$what");
			redirect('deposit');
			return;
		}
		$ref = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "ref", "var", true, "fb");
		if ($what == 'courses') {
			$course_availability = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$item_code' && status != " . HOTLISTED);
			if (!$course_availability) {
				flash_msg(false, "Course not found");
			} else {
				$debited = $this->Main_model->add_to_wallet(
					$amount,
					0,
					$uid,
					"Publishing fee for $course_availability[title] : Course",
					"Publishing fee for $course_availability[title] : Course",
					"Charge",
					"",
					$ref,
					1
				);
				if ($debited['return']) {
					$this->scansio_db_man->insert("course_publishing_fee", [
						'uid' => $uid,
						'course_code' => $item_code,
						'amount' => $amount,
						'status' => 1,
						'ref' => $ref
					]);
					flash_msg(true);
					redirect("studio/command/$item_code/" . PUBLISH);
					return;
				} else {
					flash_msg(false);
				}
			}
			redirect('studio/ecourses');
			return;
		} else {
			$book_availability = $this->scansio_db_man->select("book_main", '', "WHERE book_id = '$item_code' && status != " . HOTLISTED);
			if (!$book_availability) {
				flash_msg(false, "Book not found");
			} else {
				$debited = $this->Main_model->add_to_wallet(
					$amount,
					0,
					$uid,
					"Publishing fee for $book_availability[title] : Book",
					"Publishing fee for $book_availability[title] : Book",
					"Charge",
					"",
					$ref,
					1
				);
				if ($debited['return']) {
					$this->scansio_db_man->insert("book_publishing_fee", [
						'uid' => $uid,
						'book_id' => $item_code,
						'amount' => $amount,
						'status' => 1,
						'ref' => $ref
					]);
					flash_msg(true);
					redirect("studio/command/$item_code/" . PUBLISH);
					return;
				} else {
					flash_msg(false);
				}
			}
			redirect('studio/ebooks');
			return;
		}
	}

	public function buy_by_sales_link($item, $code)
	{
		switch ($item) {
			case 'c':
				$valid_link = $this->scansio_db_man->select("user_course_sales_link", '', "WHERE link_code = '$code'");
				if (!$valid_link) {
					flash_msg(false, '', 'Invalid sales link');
					redirect('list_courses');
					return;
				}
				$course = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$valid_link[course_code]'");
				$saler = $this->scansio_db_man->select("user_profile", '', "WHERE uid = $valid_link[saler_id]");
				set_userdata('ref', $saler['username']);
				set_userdata('item_code', $course['course_code']);
				set_userdata('saler', $valid_link['saler_id']);
				redirect('courses/preview_course/' . $course['course_code']);
				break;

			case 'b':
				$valid_link = $this->scansio_db_man->select("user_book_sales_link", '', "WHERE link_code = '$code'");
				if (!$valid_link) {
					flash_msg(false, '', 'Invalid sales link');
					redirect('list_courses');
					return;
				}
				$book = $this->scansio_db_man->select("book_main", '', "WHERE book_id = $valid_link[book_id]");
				$saler = $this->scansio_db_man->select("user_profile", '', "WHERE uid = $valid_link[saler_id]");
				set_userdata('ref', $saler['username']);
				set_userdata('item_code', $book['book_id']);
				set_userdata('saler', $valid_link['saler_id']);
				redirect('book/preview_book/' . $book['book_id']);
				break;

			default:
				flash_msg(false, '', 'Invalid sales link');
				redirect('list_courses');
		}
	}

	public function sales()
	{
		$this->Util_model->log_redirect();
		$data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home">Dashboard</a></li>
        </ol>
        ';
		$data['tab'] = "sales";
		$data['main_content'] = 'users/sales';
		$this->load->view('layouts/main', $data);
	}

	public function validate_balance($item_code, $amount, $what, $username = NULL) {
		$this->Util_model->log_redirect();
		$uid = userdata(UID);
		$user = '';
		if ($username != NULL) {
			$user = $this->scansio_db_man->select("user_profile", '', "WHERE username = '$username'", $this->db->database);
			if (!$user || !isset($user['username'])) {
				set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Invalid username", "alert-danger", 1));
				$what == 'courses' ? redirect('courses/preview_course/' . $item_code) : redirect('book/preview_book/' . $item_code);
				return;
			}
		} else {
			$user = $this->scansio_db_man->select("user_profile", '', "WHERE uid = '$uid' && status != " . HOTLISTED, $this->db->database);
			if (!$user || !isset($user['username'])) {
				set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Error retrieving your information. Please try again.", "alert-danger", 1));
				redirect('courses/preview_course/' . $item_code);
				return;
			}
		}
		$balance = $this->Main_model->get_balance($uid, false);
		$insufficient_balance = ($balance < $amount);
		if ($insufficient_balance) {
			$remaining = $amount - $balance;
			set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> You don't have sufficient balance to process this transaction. Deposit and continue", "alert-danger", 1));
			set_flashdata("amount", $remaining);
			set_flashdata("redirect", "misc/validate_balance/$item_code/$amount/$what/$username");
			redirect('deposit');
			return;
		}
		if ($what == 'courses') {
			$course_availability = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$item_code' && status = " . PUBLISHED, $this->db->database);
			if (!$course_availability || !isset($course_availability['course_instructor'])) {
				set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Course not found", "alert-danger", 1));
				redirect('courses/list_courses');
				return;
			}
			$data['tab'] = "list_courses";
			$data['course'] = $course_availability;
		} else {
			$book_availability = $this->scansio_db_man->select("book_main", '', "WHERE book_id = '$item_code' && status = " . PUBLISHED, $this->db->database);
			if (!$book_availability || !isset($book_availability['author'])) {
				set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Book not found", "alert-danger", 1));
				redirect('courses/list_books');
				return;
			}
			$data['tab'] = "list_books";
			$data['book'] = $book_availability;
		}
		$user_main = $this->scansio_db_man->select("user_main", '', "WHERE uid = '$user[uid]' && status = " . ACTIVE, $this->db->database);
		$data['item_code'] = $item_code;
		$data['user'] = $user;
		$data['name'] = $user_main['name'];
		$data['user_image'] = base_url() . $this->Util_model->picture($user['uid']);
		$data['main_content'] = 'users/purchase';
		$this->load->view('layouts/main', $data);
	}

	public function item_purchase($item_code, $item) {
		$this->Util_model->log_redirect();
		$this->output->set_content_type('json');
		$this->form_validation->set_rules('password', 'Password', 'required|trim|min_length[6]');
		$this->form_validation->set_rules('username', 'Username', 'required|trim|min_length[6]');
		$this->form_validation->set_rules('amount', 'Amount', 'required|trim|numeric|is_natural|max_length[9]|integer');
		if (!$this->form_validation->run()) {
			$this->output->set_output(json_encode(['status' => false, 'info' => validation_errors()]));
			return;
		}
		$uid = userdata(UID);
		$amount = $this->input->post('amount');
		$password = $this->input->post('password');
		$username = $this->input->post('username');
		$user_availability = $this->scansio_db_man->select("user_profile", '', "WHERE username = '$username'", $this->db->database);
		if (!$user_availability || !isset($user_availability['username'])) {
			$this->output->set_output(json_encode(['status' => false, 'info' => "Unable to locate user. Try again later."]));
			return;
		}
		$uid = $user_availability['uid'];
		$confirm_pass = $this->Users_model->confirm_pass($password);
		if (!$confirm_pass) {
			$this->output->set_output(json_encode(['status' => false, 'info' => "Invalid password"]));
			return;
		}
		$item_availability = '';
		$item_owner_availability = '';
		$positive_amount = '';
		if ($item == 'courses') {
			$item_availability = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$item_code' && status = " . PUBLISHED, $this->db->database);
			if (!$item_availability || !isset($item_availability['course_instructor'])) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "Sorry the course you want is unavailable. Try again later..."]));
				return;
			}
			$item_owner_availability = $this->scansio_db_man->select("user_profile", '', "WHERE uid = '$item_availability[course_instructor]' && status != " . HOTLISTED, $this->db->database);
			if (!$item_owner_availability || !isset($item_owner_availability['username'])) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "Unable to locate course instructor at this moment. Please try again later."]));
				return;
			}
			$has_access = $this->Course_model->has_user_purchase($item_availability['course_code'], $user_availability['uid']);
			if ($has_access) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "The user have access to the course"]));
				return;
			}
			$positive_amount = ($item_availability['course_price'] == $amount);
		} else {
			$item_availability = $this->scansio_db_man->select("book_main", '', "WHERE book_id = '$item_code' && status = " . PUBLISHED, $this->db->database);
			if (!$item_availability || !isset($item_availability['author'])) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "Sorry the book you want is unavailable. Try again later..."]));
				return;
			}
			$item_owner_availability = $this->scansio_db_man->select("user_profile", '', "WHERE uid = '$item_availability[author]'", $this->db->database);
			if (!$item_owner_availability || !isset($item_owner_availability['username'])) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "Unable to locate book author at this moment. Please try again later."]));
				return;
			}
			$has_access = $this->Course_model->has_user_purchase($item_availability['book_id'], $user_availability['uid']);
			if ($has_access) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "The user have access to the course"]));
				return;
			}
			$positive_amount = ($item_availability['price'] == $amount);
		}
		if (!$positive_amount) {
			$this->output->set_output(json_encode(['status' => false, 'info' => "Invalid amount"]));
			return;
		}
		$balance = $this->Main_model->get_balance(userdata(UID), false);
		$insufficient_balance = ($balance < $amount);
		if ($insufficient_balance) {
			$remaining = $amount - $balance;
			$info = "Insufficient balance. You need N$remaining to complete this transaction";
			$this->output->set_output(json_encode(['status' => true,
				'redirect' => base_url() . "misc/validate_balance/$item_code/$amount/$item/$username", 'info' => $info]));
			return;
		}
		$user = $this->scansio_db_man->select('user_main', '', "WHERE uid = $user_availability[uid] AND status != " . HOTLISTED, $this->db->database);
		$owner = $this->scansio_db_man->select('user_main', '', "WHERE uid = $item_owner_availability[uid] AND status != " . HOTLISTED, $this->db->database);
		$buyer_uid = userdata(UID);
		if ($item == 'courses') {
			//Debiting course buyer
			$course_payment = $this->Main_model->add_to_wallet(
				$amount,
				$item_owner_availability['uid'],
				$buyer_uid,
				"Payment of the course $item_availability[course_title] from $user[name]",
				"Transfer to $owner[name] for the payment of the course $item_availability[course_title]",
				"Course Payment",
				"",
				"",
				1
			);
			if (!$course_payment['return']) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "Error while performing transaction. Try again later..."]));
				return;
			}
			$this->scansio_db_man->insert('course_purchase', ['course_id' => $item_availability['id'], 'uid' => $user_availability['uid'], 'paid' => $amount], $this->db->database);
			set_flashdata('msg', alert_msg("<i class='fa fa-check'></i> Your have successfully purchased $item_availability[course_title]", "alert-success", 1));
			if (userdata(UID) == $user_availability['uid']) {
				$this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "academy/$item_code/", 'info' => "Bravo!! you have successfully purchased $item_availability[course_title]"]));
			} else {
				$this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "list_courses", 'info' => "Bravo!! you have successfully purchased $item_availability[course_title] for $user[name]"]));
			}
		} else {
			//Debiting book buyer
			$book_payment = $this->Main_model->add_to_wallet(
				$amount,
				$item_owner_availability['uid'],
				$buyer_uid,
				"Payment of the book $item_availability[title] from $user[name]",
				"Transfer to $owner[name] for the payment of the book $item_availability[title]",
				"Book payment",
				"",
				"",
				1
			);
			if (!$book_payment['return']) {
				$this->output->set_output(json_encode(['status' => false, 'info' => "Error while performing transaction. Try again."]));
				return;
			}
			$this->scansio_db_man->insert('book_purchase', ['book_id' => $item_availability['id'], 'uid' => $user_availability['uid'], 'paid' => $amount], $this->db->database);
			set_flashdata('msg', alert_msg("<i class='fa fa-check'></i> Your have successfully purchased $item_availability[title]", "alert-success", 1));
			if (userdata(UID) == $user_availability['uid']) {
				$this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "books/read_book/$item_availability[title]/$item_code", 'info' => "Bravo!! you have successfully purchased $item_availability[title]"]));
			} else {
				$this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "list_books", 'info' => "Bravo!! you have successfully purchased $item_availability[title] for $user[name]"]));
			}
		}
	}

}
