<?php

/**
 *  
 */
class Opportunity extends CI_Controller
{
    private $page_limit = 50, $featured, $style;

    public function __construct()
    {
        parent::__construct();
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                redirect(base_url() . "activate");
            }
        }
        $this->load->model("products/Opportunity_model", "opp");
    }

    public function index($pane = "all")
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li>Opportunity</li>
        </ol>
        ';
        $data['pane'] = $pane;
        $data['tab'] = "opportunity";
        $data['main_content'] = 'users/opportunity';
        $this->load->view('layouts/main', $data);
    }

    public function home_opportunity($sm = 0)
    {
        $this->output->set_output($this->opp->home_opportunity($sm));
    }

    public function view($id, $participating = '')
    {
        $uid = userdata(UID);
        if ($participating) {
            $opportunity_participant = $this->scansio_db_man->select('opportunity_participant', '', "WHERE uid = $uid AND oid = $id AND status = " . ACTIVE);
            if (!$opportunity_participant) {
                flash_msg(true, "You are not participating in the opportunity please participate");
            }
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="' . base_url() . 'opportunity"><i class="fa fa-briefcase"></i> Opportunity</a></li>
            <li>View</li>
        </ol>
        ';
        $data['opp'] = $this->Util_model->get_info("opportunity", "*", "WHERE id=$id");
        $data['id'] = $id;
        $data['tab'] = "opportunity";
        $data['main_content'] = 'users/' . ($participating ? 'participating-opportunity-view' : 'opportunity-view');
        $this->load->view('layouts/main', $data);
    }

    public function resources($id)
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="' . base_url() . 'opportunity"><i class="fa fa-briefcase"></i> Opportunity</a></li>
            <li>View</li>
        </ol>
        ';
        $data['opp'] = $this->Util_model->get_info("opportunity", "*", "WHERE id=$id");
        $data['id'] = $id;
        $data['tab'] = "opportunity";
        $data['main_content'] = 'users/opportunity-resource';
        $this->load->view('layouts/main', $data);
    }

    public function participate($oid)
    {
        $this->Util_model->log_redirect();
        $uid = userdata(UID);
        $opportunity = $this->scansio_db_man->select("opportunity", '', "WHERE id = $oid && status = " . ACTIVE);
        if (!$opportunity) {
            flash_msg(false, "Opportunity not found");
            redirect(userdata('previous_url'));
        }
        $opportunity_participant = $this->scansio_db_man->select('opportunity_participant', '', "WHERE uid = $uid AND oid = $oid AND status = " . ACTIVE);
        if ($opportunity_participant) {
            flash_msg(true, "You are already participating in the opportunity");
            redirect("opportunity/resources/$opportunity[id]");
        }
        $amount = $opportunity['price'];
        $balance = $this->Main_model->get_balance($uid, false);
        $insufficient_balance = ($balance < $amount);
        if ($insufficient_balance) {
            $remaining = $amount - $balance;
            set_flashdata("amount", $remaining);
            set_flashdata("redirect", "participate/$oid");
            flash_msg(false, "Insufficient balance. You need N$remaining to complete this transaction");
            redirect('deposit');
        }
        $user = $this->scansio_db_man->select('user_main', '', "WHERE uid = $uid AND status != " . HOTLISTED);
        $result = $this->Main_model->add_to_wallet(
            $amount,
            0,
            $uid,
            "Participation fee of $opportunity[title] from $user[name]",
            "Participation fee of $opportunity[title]",
            "Opportunity payment",
            "",
            "",
            1
        );
        if ($result["return"]) {
            $data = [
                'uid' => $uid,
                'oid' => $oid,
                'status' => ACTIVE,
            ];
            $this->scansio_db_man->insert("opportunity_participant", $data);
            $participating_id = $this->scansio_db_man->select('opportunity_participant', 'id', "WHERE uid = $uid AND oid = $oid AND status = " . ACTIVE);
            $this->scansio_db_man->update("user_wallet", ['extra' => "opportunity_participant:id=$participating_id"], "WHERE ref = '$result[reference]'");
            redirect("opportunity/resources/$opportunity[id]");
        } else {
            flash_msg(false);
            redirect(userdata('previous_url'));
        }

        /* Distribution of commission */
        /* if (
                $has_saler &&
                $has_item_code &&
                $saler_item_code == $item_code &&
                $saler &&
                $saler_id != $uid &&
                $is_saler_not_owner
            ) {
                $this->Main_model->add_to_wallet(
                    get_percentage($amount, ITEM_SELLER_PERCENTAGE),
                    userdata('saler'),
                    0,
                    "Commission of the course $item_availability[course_title] purchased by $user[name] using your sales link",
                    "Commission of the course $item_availability[course_title] purchased by $user[name]",
                    "Course payment",
                    "",
                    $course_payment['reference'],
                    1
                );
                $this->Main_model->add_comm(userdata('saler'), $course_payment['reference'], "course");
                unset_userdata('ref');
                unset_userdata('item_code');
                unset_userdata('saler');
                $saler_id = $saler['uid'];
            } else {
                $buyer_referral = $this->scansio_db_man->select('user_referrer', "", "WHERE uid = $buyer_uid")['ref1'];
                $this->Main_model->add_to_wallet(
                    get_percentage($amount, ITEM_SELLER_PERCENTAGE),
                    $buyer_referral,
                    0,
                    "Commission of the course $item_availability[course_title] purchased by $user[name] as your referee",
                    "Commission of the course $item_availability[course_title] purchased by $user[name]",
                    "Course payment",
                    "",
                    $course_payment['reference'],
                    1
                );
                $this->Main_model->add_comm($buyer_referral, $course_payment['reference'], "course");
                $saler_id = $buyer_referral;
            } */
    }

    public function opp_full_detail($opp_id)
    {
        if (has_userdata(A_UID)) {
            $uid = userdata(A_UID);
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
        }
        $data['opportunity_id'] = $opp_id;
        $data['tab'] = "opportunity";
        $data['main_content'] = 'users/read_opportunity';
        if (has_userdata(A_UID)) {
            $this->load->view('admin/layouts/main', $data);
        } else {
            $this->load->view('layouts/main', $data);
        }
    }

}