<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 6/11/2018
 * Time: 11:35 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class P2p extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("users/P2p_model", "p2p");
        $this->Util_model->log_redirect();
    }

    public function list_merchants () {
        $view = $this->p2p->list_merchants($_POST['amount'], $_POST['method'], $_POST['type']);
        $this->output->set_output($view);
    }

    public function check_orders($type) {
        $field = strtolower($type)."er_uid";
        $orders = $this->Util_model->row_count("p2p_orders", "WHERE $field=".userdata(UID)." AND type='$type' AND status<=2");
        if ($orders <= 3) {
            $this->output->set_output(true);
        } else {
            $this->output->set_output(false);
        }
    }

    public function create_buy_order () {
        $this->form_validation->set_rules("amount", "Amount", "trim|required|numeric|greater_than_equal_to[1]|less_than_equal_to[10000]");
        $this->form_validation->set_rules("method", "Method", "trim|required");

        if ($this->form_validation->run() == true) {
            $p2p_mer = $this->p2p->get_merchant($_POST["amount"], $_POST["method"]);
            if ($p2p_mer != 0) {
                $method = $this->Util_model->get_info("payment_methods", "*", "WHERE id=$p2p_mer[method]");
                if ($method['category'] == 'coin') {
                    $rate = $this->Util_model->conversion_rate($method["currency"], 'USDT');
                    $rate += get_percentage($rate, 3);
                    if ($method["currency"] != 'USDT') {
                        $rate = round((1 / $rate), 8);
                    }
                    $convert_amount = round(($_POST["amount"] * $rate), 8);
                } else {
                    $rate = $this->Util_model->conversion_rate('USDT', $method["currency"]);
                    $rate += get_percentage($rate, 3);
                    $convert_amount = round(($_POST["amount"] * $rate), 2);
                }
                $data = array (
                    "buyer_uid"     => userdata(UID),
                    "seller_uid"    => $p2p_mer['uid'],
                    "type"          => "Buy",
                    "reference"     => $this->Util_model->generate_id(1000000000, 9999999999, "p2p_orders", "reference", "var", true, "fb"),
                    "method"        => $p2p_mer['method'],
                    "amount"        => $_POST['amount'],
                    "converted_amount" => number_format($convert_amount, 2),
                    "rate"          => $rate,
                    "interest"      => 2,
                    "currency"      => $method['currency'],
                    "details"       => $this->Util_model->get_info("p2p_user_payment_details", "details", "WHERE uid=$p2p_mer[uid] AND method=$p2p_mer[method]"),
                    "time"          => $this->p2p->get_response_time('Buy'),
                    "status"        => 1,
                    "created_date" => date_time(),
                    "expiry_date" => set_expire_date((1/4))
                );
                if ($this->Db_model->insert("p2p_orders", $data)) {
                    $msg = "A deposit order of $_POST[amount] has been created by ".$this->Util_model->get_user_info(userdata(UID), 'username', 'profile')." and needs urgent attention from you. Check order https://bit.ly/3tTKJG5";
                    //$this->Main_model->send_sms('0'.$this->Util_model->get_user_info($p2p_mer['uid'], 'phone', 'profile'), $msg);
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Deposit order created successfully", "alert-success", 1));
                    redirect(base_url()."p2p/view-order/$data[reference]");
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error creating deposit order", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> No merchant met your criteria", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."deposit");
    }

    public function orders () {
        $data['breadcrumb'] = '<li>My Orders</li>';
        $data['styles'] = array (
            "datatable"     =>  base_url()."assets/plugins/datatables/datatables.min.css"
        );
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#">P2P</a></li>
            <li><a href="' . base_url() . 'p2p/orders"><i class="fa fa-exchange"></i> My Orders</a></li>
        </ol>
        ';
        $data['tab'] = "orders";
        $data['main_content'] = "users/orders";
        $this->load->view("layouts/main", $data);
    }

    public function create_sell_order () {
        $this->form_validation->set_rules("amount", "Amount", "trim|required|numeric|greater_than_equal_to[1]|less_than_equal_to[10000]");
        $this->form_validation->set_rules("method", "Method", "trim|required");

        if ($this->form_validation->run() == true) {
            if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you can't make withdrawal on free mode", "alert-danger", 1));
                redirect(base_url()."withdraw");
            }
            $p2p_mer = $this->p2p->get_merchant($_POST["amount"], $_POST["method"], "Sell");
            $settlement = $this->Util_model->get_info("p2p_user_payment_details", "details", "WHERE uid=".userdata(UID)." AND method=".$p2p_mer['method']);
            if ($settlement) {
                if ($p2p_mer != 0) {
                    $method = $this->Util_model->get_info("payment_methods", "*", "WHERE id=$p2p_mer[method]");
                    if ($method['category'] == 'coin') {
                        $rate = $this->Util_model->conversion_rate($method["currency"], 'USDT');
                        $rate -= get_percentage($rate, 3);
                        if ($method["currency"] != 'USDT') {
                            $rate = round((1 / $rate), 8);
                        }
                        $convert_amount = round(($_POST["amount"] * $rate), 8);
                    } else {
                        $rate = $this->Util_model->conversion_rate('USDT', $method["currency"]);
                        $rate -= get_percentage($rate, 3);
                        $convert_amount = round(($_POST["amount"] * $rate), 2);
                    }
                    $data = array (
                        "buyer_uid"     => $p2p_mer['uid'],
                        "seller_uid"    => userdata(UID),
                        "type"          => "Sell",
                        "reference"     => $this->Util_model->generate_id(1000000000, 9999999999, "p2p_orders", "reference", "var", true, "fb"),
                        "method"        => $p2p_mer['method'],
                        "amount"        => $_POST['amount'],
                        "converted_amount" => number_format($convert_amount, 2),
                        "rate"          => $rate,
                        "interest"      => 2,
                        "currency"      => $method['currency'],
                        "details"       => $settlement,
                        "time"          => $this->p2p->get_response_time('Sell'),
                        "status"        => 1,
                        "created_date" => date_time(),
                        "expiry_date" => set_expire_date((1/4))
                    );
                    if ($this->Main_model->check_balance(userdata(UID), $_POST['amount'])) {
                        if ($this->Db_model->insert("p2p_orders", $data)) {
                            $msg = "A withdrawal order of ".number_format($_POST['amount'])."USD has been created by ".$this->Util_model->get_user_info(userdata(UID), 'username', 'profile')." and needs urgent attention from you. Check order https://bit.ly/3tTKJG5";
                            //$this->Main_model->send_sms('0'.$this->Util_model->get_user_info($p2p_mer['uid'], 'phone', 'profile'), $msg);
                            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Withdrawal order created successfully", "alert-success", 1));
                            redirect(base_url()."p2p/view-order/".$data["reference"]);
                        } else {
                            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try again", "alert-danger", 1));
                        }
                    } else {
                        set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance. Top up funding balance to continue.", "alert-danger", 1));
                    }
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> No merchant met your criteria", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You have not created a settlement account for this payment method. <a href='".base_url()."profile'>Click here to set a settlement account details</a>", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."withdraw");
    }

    public function view_order ($ref) {
        $order = $this->Db_model->selectGroup("*", "p2p_orders", "WHERE reference='$ref' AND (buyer_uid=".userdata(UID)." OR seller_uid=".userdata(UID).") LIMIT 1");
        if ($order->num_rows() == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Invalid order", "alert-danger", 1));
            redirect(base_url()."p2p/orders");
        }
        
        $data['trans'] = $order->row_array();
        $data['style'] = '<link rel="stylesheet" href="'.base_url().'assets/plugins/lightbox/dist/css/lightbox.min.css">';
        $data['order_id'] = $data['trans']['id'];
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'p2p/orders">Orders</a></li>
            <li><a href="#">View Order</a></li>
        </ol>
        ';
        $data['tab'] = "orders";
        $data['main_content'] = "users/order_view";
        $this->load->view("layouts/main", $data);
    }

    public function post_chat () {
        if ($this->p2p->post_chat($_POST['sender'], $_POST['receiver'], $_POST['trans_id'], $_POST['content'], $_POST['type'])) {
            $this->output->set_output($this->p2p->list_chat($_POST['trans_id']));
        } else {
            $this->output->set_output(0);
        }
    }

    public function list_chat () {
        $this->output->set_output($this->p2p->list_chat($_POST['trans_id']));
    }

    public function trade_time () {
        if (!$this->p2p->trade_time_up($_POST['trans_id'])) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Trade cancelled. Try making payment faster next time.", "alert-danger"));
            $status = false;
            $json = json_encode(["status"=>$status]);
        } else {
            $status = true;
            $time = $this->p2p->remaining_time($this->Util_model->get_info("p2p_orders", "expiry_date", "WHERE id=$_POST[trans_id]"));
            $json = json_encode(["status"=>$status, "time"=>$time]);
        }
        $this->output->set_output($json);
    }

    public function made_payment ($trans_id) {
        $order = $this->Util_model->get_info("p2p_orders", "buyer_uid, reference", "WHERE id=$trans_id");
        if ($order['buyer_uid'] == userdata(UID)) {
            $this->p2p->made_payment($trans_id);
        }
        redirect(base_url()."p2p/view-order/$order[reference]");
    }

    public function release ($trans_id, $password) {
        $this->load->model("users/Users_model", "user");
        if ($this->user->verify_password($password)) {
            $trans = $this->Db_model->select("*", "p2p_orders", "WHERE id=$trans_id");
            if ($trans['seller_uid'] == userdata(UID)) {
                if ($this->p2p->release_trade($trans_id)) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Funds successfully released to the buyer", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
                }
            }
            redirect(base_url()."p2p/orders");
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again.", "alert-danger", 1));
            redirect(base_url()."p2p/view-order/".$this->Util_model->get_info("p2p_orders", "reference", "WHERE id=$trans_id"));
        }
    }

    public function cancel_trade ($trans_id) {
        $info = $this->Util_model->get_info("p2p_orders", "buyer_uid, reference", "WHERE id=$trans_id");
        if ($info['buyer_uid'] == userdata(UID)) {
            if ($this->p2p->cancel_trade($trans_id)) {
                set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Order cancelled successfully", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
            }
        }
        redirect(base_url()."p2p/view-order/$info[reference]");
    }

    public function trade_time_up () {
        $this->p2p->trade_time_up($_POST['trans_id']);
    }

    public function dispute_trade ($trans_id) {
        if ($this->trade->dispute_trade($trans_id)) {
            set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Trade sent for dispute. Send your complain to dispute@mexonaire.com", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
        }
        redirect(base_url()."trade");
    }

    public function upload_picture($sender, $receiver, $order_id) {
        if (!empty($_FILES['image']['name'][0])) {
            $file_path = str_replace("\\", "/", FCPATH);
            $month = date("Ym");
            if (!file_exists($file_path."assets/img/uploads/$month/")) {
                mkdir($file_path."assets/img/uploads/$month/", 0777, true);
            }

            $config = array(
                'upload_path' => $file_path."assets/img/uploads/$month/",
                'allowed_types' => 'jpg|gif|png',
                'max_size' => 1024,
                'file_name' => date("U"),
                'file_ext_tolower' => TRUE,
                'overwrite' => TRUE
            );

            $this->load->library('upload', $config);

            if ($this->upload->do_upload("image")) {
                $img_data = $this->upload->data();
                $upload_path = "assets/img/uploads/$month/" . $img_data['file_name'];
                $this->Db_model->insert("p2p_chat", ["mid"=>MID, "sender"=>$sender, "receiver"=>$receiver, "content"=>$upload_path, "type"=>"image", "order_id"=>$order_id]);
            } else {
                set_flashdata("msg", alert_msg($this->upload->display_errors(), "alert-danger", 1));
            }
        }
        redirect(base_url()."p2p-orders/view/".$this->Util_model->get_info("p2p_orders", "reference", "WHERE id=$order_id"));
    }

    public function list_seller_details () {
        $view = $this->p2p->list_seller_details(userdata(UID), $_POST['method']);
        $this->output->set_output($view);
    }

    public function add_payment_detail ($method) {
        $empty = 0;
        $detail = "";
        for ($i=0; $i<count($_POST['label']); $i++) {
            $empty += (empty($_POST['detail'][$i])) ? 1 : 0;
            $detail .= $_POST['label'][$i]."=".$_POST['detail'][$i].",";
        }
        $detail = rtrim($detail, ",");
        if (empty($_POST['password'])) {
            $empty += 1;
        }
        if ($empty > 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Required field(s) empty.", "alert-danger", 1));
        } else {
            $this->load->model("users/Users_model", "user");
            if ($this->user->verify_password($_POST['password'])) {
                $data = array(
                    "uid"       =>  userdata(UID),
                    "method"    =>  $method,
                    "details"   =>  $detail
                );
                if ($this->Db_model->insert("p2p_user_payment_details", $data)) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Payment detail added successfully.", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again.", "alert-danger", 1));
            }
        }
        redirect(base_url()."manage-payment-details/$method");
    }

    public function edit_payment_detail ($id, $method) {
        $empty = 0;
        $detail = "";
        for ($i=0; $i<count($_POST['label']); $i++) {
            $empty += (empty($_POST['detail'][$i])) ? 1 : 0;
            $detail .= $_POST['label'][$i]."=".$_POST['detail'][$i].",";
        }
        $detail = rtrim($detail, ",");
        if (empty($_POST['password'])) {
            $empty += 1;
        }
        if ($empty > 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Required field(s) empty.", "alert-danger", 1));
        } else {
            $this->load->model("users/Users_model", "user");
            if ($this->user->verify_password($_POST['password'])) {
                $data = array(
                    "details"   =>  $detail
                );
                if ($this->Db_model->update("p2p_user_payment_details", $data, "WHERE id=$id")) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Payment detail edited successfully.", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again.", "alert-danger", 1));
            }
        }
        redirect(base_url()."manage-payment-details/$method/$id");
    }

    public function save_payment_detail ($method) {
        $this->load->model("users/Users_model", "user");
        if ($this->user->verify_password($_POST['password'])) {
            $empty = 0;
            $detail = "";
            for ($i=0; $i<count($_POST["label"]); $i++) {
                $empty += (empty($_POST["detail"][$i])) ? 1 : 0;
                $detail .= $_POST["label"][$i]."=".$_POST["detail"][$i].",";
            }
            $detail = rtrim($detail, ",");
            if ($this->Util_model->row_count("p2p_user_payment_details", "WHERE uid=".userdata(UID)." AND method=$method") == 0) {
                $data = array(
                    "uid" => userdata(UID),
                    "method" => $method,
                    "details"   =>  $detail
                );
                $save = $this->Db_model->insert("p2p_user_payment_details", $data);
            } else {
                $data = array(
                    "details"   =>  $detail
                );
                $save = $this->Db_model->update("p2p_user_payment_details", $data, "WHERE uid=".userdata(UID)." AND method=$method");
            }
            if ($save) {
                set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Settlement account details saved successfully.", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again.", "alert-danger", 1));
        }
        redirect(base_url()."profile");
    }

    public function delete_payment_detail () {
        $this->load->model("users/Users_model", "user");
        if ($this->user->verify_password($_GET['password'])) {
            if ($this->Db_model->delete("p2p_user_payment_details", "WHERE id=$_GET[id]")) {
                set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Payment detail deleted successfully.", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect password. Try again.", "alert-danger", 1));
        }
        redirect(base_url()."manage-payment-details/$_GET[method]");
    }

    public function check_status () {
        $trans_id = $this->input->post("trans_id");
        $status = $this->Util_model->get_info("p2p_orders", "status", "WHERE id=$trans_id");
        $this->output->set_output($status);
    }

    public function book_funding () {
        $amount = $this->input->post('amount');
        $rate = COIN_PRICE;
        $pay = $this->input->post('pay');
        $transRef = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "ref", "var", true, "fb");
        
        $data = array(
            "uid"               =>  userdata(UID),
            "ref"               =>  $transRef,
            "amount"            =>  $amount,
            "rate"              =>  $rate,
            "amount_to_pay"     =>  $pay
        );
        if ($this->Db_model->insert("p2p_merchant_funding", $data)) {
            $funding_id = $this->Util_model->get_info("p2p_merchant_funding", "id", "ORDER BY id DESC LIMIT 1");
            $this->Main_model->add_to_wallet($amount, userdata(UID), 0, "Purchase of RNFTK directly from the system", "Sales of RNFTK directly to a p2p merchant", "Merchant Topup", "p2p_merchant_funding:id=$funding_id", $transRef, 0);
            $additional = "
            <p><b>Username: </b>".$this->Util_model->get_user_info(userdata(UID), "username", "profile")."</p>
            <p><b>Reference: </b>$transRef</p>
            <p><b>Amount: </b>$amount USD (".($amount * $rate)." USD)</p>
            ";
            $this->Mail_model->send_notification("Merchant Topup", "A p2p merchant has requested funding. Please attend to it as soon as possible", "<a href='".base_url()."admin/funding'>Complete Order</a>", $additional, "Admin");
            //Notification
            $this->output->set_output(true);
        } else {
            $this->output->set_output(false);
        }
        
    }

    #################MERCHANT SESSION##########################3

    public function manage_trade () {
        $pro = $this->Util_model->get_user_info(userdata(UID), "package, duration, phone_verified, email_verified", "profile");
        if ($pro['duration'] == 0) {
            redirect(base_url()."activate");
        } else if ($pro['package'] < 3) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry your plan can't access this page. Kindly upgrade your account plan.", "alert-danger", 1));
            redirect(base_url()."activate");
        } else if ($pro['phone_verified'] == 0 || $pro['email_verified'] == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry your account is yet to be verified. Verify Now!", "alert-danger", 1));
            redirect(base_url()."profile");
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#">Manage P2P</a></li>
        </ol>
        ';
        $data['pane'] = "manage-trade";
        $data['tab'] = "manage-trade";
        $data['main_content'] = "users/manage-trade";
        $this->load->view("layouts/main", $data);
    }

    public function create_trade ($pane="buy") {
        $pro = $this->Util_model->get_user_info(userdata(UID), "package, duration, phone_verified, email_verified", "profile");
        if ($pro['duration'] == 0) {
            redirect(base_url()."activate");
        } else if ($pro['package'] < 3) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry your plan can't access this page. Kindly upgrade your account plan.", "alert-danger", 1));
            redirect(base_url()."activate");
        } else if ($pro['phone_verified'] == 0 || $pro['email_verified'] == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry your account is yet to be verified. Verify Now!", "alert-danger", 1));
            redirect(base_url()."info");
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'p2p/manage-trade">Manage P2P</a></li>
            <li><a href="#">Create New Trade</a></li>
        </ol>
        ';
        $data['pane'] = $pane;
        $data['tab'] = "manage-trade";
        $data['main_content'] = "users/create-trade";
        $this->load->view("layouts/main", $data);
    }

    public function list_currency () {
        $method = trim($_POST["method"]);
        $s = $this->Db_model->query("SELECT DISTINCT currency FROM `payment_methods` WHERE title='$method' AND status=1 ORDER BY currency");
        if ($s->num_rows() > 0) {
            $view = "<option value=''>Select currency</option>";
            foreach ($s->result_array() as $row) {
                $view .= "<option value='$row[currency]'>$row[currency]</option>\n";
            }
        } else {
            $view = "<option value=''>Select method first</option>";
        }
        $this->output->set_output($view);
    }

    public function list_more_info () {
        $type = $_POST['type'];
        $method = $_POST['method'];
        $currency = $_POST['currency'];
        $method = $this->Util_model->get_info("payment_methods", "id", "WHERE title='$method' AND currency='$currency' AND status=1");
        $view = "";
        if ($type == 'buy') {
            $field = $this->Util_model->get_info("payment_methods", "fields", "WHERE id=$method");
            if (strstr($field, "|")) {
                foreach (explode("|", $field) as $field) {
                    $row = explode(":", $field);
                    $attr = explode("=", $row[1]);
                    $view .= "
                    <div class='form-group'>
                        <label class='col-sm-4 control-label'>$row[0] <span class='required'>*</span></label>
                        <div class='col-sm-8'>
                            <input type='hidden' name='label[]' value='$row[0]'>
                            <input class='form-control' type='$attr[1]' required placeholder='Enter ".strtolower($row[0])."' name='detail[]'>
                        </div>
                    </div>
                    ";
                }
            } else {
                $row = explode(":", $field);
                $attr = explode("=", $row[1]);
                $view .= "
                <div class='form-group'>
                    <label class='col-sm-4 control-label'>$row[0] <span class='required'>*</span></label>
                    <div class='col-sm-8'>
                        <input type='hidden' name='label[]' value='$row[0]'>
                        <input class='form-control' type='$attr[1]' required placeholder='Enter ".strtolower($row[0])."' name='detail[]'>
                    </div>
                </div>
                ";
            }
        }
        $view .= "
        <div class='form-group'>
            <label class='col-sm-4 control-label'>Interest <span class='required'>*</span></label>
            <div class='col-sm-8'>
                <div class='input-group'>
                    <input class='form-control' type='number' required name='margin' value='2' id='margin' readonly>
                    <span class='input-group-addon'>%</span>
                </div>
                <small class='text-italic'>Interest on every trade</small>
            </div>
        </div>
        <div class='form-group'>
            <label class='col-sm-4 control-label'>Min. Transaction Limit <span class='required'>*</span></label>
            <div class='col-sm-8'>
                <div class='input-group'>
                    <input class='form-control' type='number' required min='10' max='3000' name='min' value='10' id='min'>
                    <span class='input-group-addon'>USD</span>
                </div>
                <small class='text-italic'>Minimum transaction limit is at least 10 USD but you can choose to set it higher.</small>
            </div>
        </div>
        <div class='form-group'>
            <label class='col-sm-4 control-label'>Max. Transaction Limit <span class='required'>*</span></label>
            <div class='col-sm-8'>
                <div class='input-group'>
                    <input class='form-control' type='number' min='100' max='5000' name='max' value='100' id='max'>
                    <span class='input-group-addon'>USD</span>
                </div>
                <small class='text-italic'>Maximum transaction limit is at most 5000 USD but you can choose to set it lower.</small>
            </div>
        </div>
        <div class='form-group'>
            <label class='col-sm-4 control-label'>Terms of Trade</label>
            <div class='col-sm-8'>
                <textarea name='terms' class='form-control' id='terms'></textarea>
                <small class='text-italic'>Other information you wish to tell about your trade. Example 1: <b>Please use the reference as the description of the payment for bank transfer.</b> Example 2: <b>Please send request only if you can complete the payment within 15 mins.</b></small>
            </div>
        </div>
        ";
        $this->output->set_output($view);
    }

    public function new_trade ($type) {
        $this->form_validation->set_rules("method", "Payment Method", "required");
        $this->form_validation->set_rules("currency", "Currency", "required");
        $this->form_validation->set_rules("margin", "Margin", "trim|required|numeric|less_than_equal_to[5]|greater_than_equal_to[-5]");
        $this->form_validation->set_rules("min", "Minimum", "trim|required|numeric|greater_than_equal_to[10]");
        $this->form_validation->set_rules("max", "Maximum", "trim|required|numeric|less_than_equal_to[5000]");

        if ($this->form_validation->run() == TRUE) {
            $method = $this->Util_model->get_info("payment_methods", "id", "WHERE title='$_POST[method]' AND currency='$_POST[currency]' AND status=1");
            if ($this->Util_model->row_count("p2p_merchant", "WHERE uid=".userdata(UID)." AND method=$method AND type='$type'") == 0) {
                $details = "";
                if ($type == 'buy') {
                    for ($i=0; $i<count($_POST['label']); $i++) {
                        $details .= $_POST['label'][$i]."=".$_POST['detail'][$i].",";
                    }
                    $details = rtrim($details, ",");
                }
                $data = array(
                    "mid" => MID,
                    "uid" => userdata(UID),
                    "method" => $method,
                    "details" => $details,
                    "interest" => $_POST['margin'],
                    "min" => $_POST['min'],
                    "max" => $_POST['max'],
                    "type" => ucfirst($type),
                    "terms" => $_POST['terms'],
                    "status" => 1
                );
                if ($this->Db_model->insert("p2p_merchant", $data)) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> P2P trade created successfully", "alert-success", 1));
                    redirect(base_url()."p2p/manage-trade");
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error was encountered while creating p2p trade. Try again later", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> A trade has already been created on this payment method. Create a new trade on a different payment method.", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."p2p/create-trade/$type");
    } 

    public function edit_trade ($id, $task="blank") {
        $s = $this->Db_model->selectGroup("*", "p2p_merchant", "WHERE id=$id");
        if ($s->num_rows() > 0) {
            $trade = $s->row_array();
            if ($task == "blank") {
                $data['breadcrumb'] = '
                <ol class="breadcrumb">
                    <li><a href="'.base_url().'p2p/manage-trade">Manage P2P</a></li>
                    <li><a href="#">Edit Trade</a></li>
                </ol>
                ';
                $data['pane'] = "edit-trade";
                $data['tab'] = "manage-trade";
                $data['trade'] = $trade;
                $data['main_content'] = "users/edit-trade";
                $this->load->view("layouts/main", $data);
            } else {
                $this->form_validation->set_rules("method", "Payment Method", "required");
                $this->form_validation->set_rules("currency", "Currency", "required");
                $this->form_validation->set_rules("margin", "Margin", "trim|required|numeric|less_than_equal_to[5]|greater_than_equal_to[-5]");
                $this->form_validation->set_rules("min", "Minimum", "trim|required|numeric|greater_than_equal_to[10]");
                $this->form_validation->set_rules("max", "Maximum", "trim|required|numeric|less_than_equal_to[5000]");

                if ($this->form_validation->run() == TRUE) {
                    $details = "";
                    if ($trade['type'] == 'Buy') {
                        for ($i=0; $i<count($_POST['label']); $i++) {
                            $details .= $_POST['label'][$i]."=".$_POST['detail'][$i].",";
                        }
                        $details = rtrim($details, ",");
                    }
                    $data = array(
                        "details" => $details,
                        "interest" => $_POST['margin'],
                        "min" => $_POST['min'],
                        "max" => $_POST['max'],
                        "terms" => $_POST['terms']
                    );
                    if ($this->Db_model->update("p2p_merchant", $data, "WHERE id=$id")) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> P2P trade edited successfully", "alert-success", 1));
                        redirect(base_url()."p2p/manage-trade");
                    } else {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error was encountered while editing p2p trade. Try again later", "alert-danger", 1));
                    }
                } else {
                    set_flashdata("msg", validation_errors());
                }
                redirect(base_url()."p2p/edit-trade/$id");
            }
        }
    }

    public function trade_status ($id, $stat=1) {
        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error was encountered. Try again later", "alert-danger", 1));
        redirect(base_url()."p2p/manage-trade");
    }
    
    public function delete_trade ($id) {
        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error was encountered. Try again later", "alert-danger", 1));
        redirect(base_url()."p2p/manage-trade");
    }

    public function merchant_topup () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'p2p/manage-trade">Manage P2P</a></li>
            <li><a href="#">Merchant Topup</a></li>
        </ol>
        ';
        $data['pane'] = "merchant_topup";
        $data['tab'] = "merchant-trade";
        $data['main_content'] = "users/merchant_topup";
        $this->load->view("layouts/main", $data);
    }

}