<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 9/20/2019
 * Time: 11:54 PM
 */
class Profile extends CI_Controller
{

    private $salt = "@#6$%^&*THIS$%^&IS(&^A%^&LARGE^&**%^&SALT-8,/7%^&*";

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function index () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li>Settings</li>
        </ol>
        ';
        $data['tab'] = "profile";
        $data['main_content'] = 'users/profile';
        $this->load->view('layouts/main',$data);
    }

    public function upload_profile_picture(){
        if (!empty($_FILES['user_image']['name'][0])) {
            $config = array(
                'upload_path' => "./assets/img/uploads/",
                'allowed_types' => 'jpg|gif|png',
                'max_size' => 1024,
                'file_name' => $this->Util_model->get_user_info(userdata(UID), "username", "profile"),
                'file_ext_tolower' => TRUE,
                'overwrite' => TRUE
            );

            $this->load->library('upload', $config);

            if ($this->upload->do_upload("user_image")) {
                $img_data = $this->upload->data();
                $upload_path = "assets/img/uploads/" . $img_data['file_name'];
                if ($this->Db_model->update("user_main", ["pic_url"=>$upload_path], "WHERE uid=".userdata(UID))) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Profile picture updated successfully", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to update profile picture. Try again", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> ".$this->upload->display_errors(), "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upload cancelled", "alert-danger", 1));
        }
        redirect(base_url()."profile");
    }

    public function send_email_verification () {
        $this->load->model('users/Users_model', 'user');
        $this->user->send_email_verification_link(userdata(UID), $this->Util_model->get_user_info(userdata(UID), 'email', 'profile'));
        redirect(base_url()."info");
    }

    public function update_info() {
        $this->form_validation->set_rules('name','Name','trim|required');
        /*$this->form_validation->set_rules('state','State','trim|required');
        $this->form_validation->set_rules('region','Region','trim|required');
        $this->form_validation->set_rules('facebook','Facebook Username','trim');
        $this->form_validation->set_rules('twitter','Twitter Username','trim');
        $this->form_validation->set_rules('instagram','Instagram Username','trim');
        $this->form_validation->set_rules('linkedin','Linkedin Username','trim');*/

        if ($this->form_validation->run() === TRUE) {
            /*$data = array(
                "facebook"      =>  $this->input->post('facebook'),
                "twitter"       =>  $this->input->post('twitter'),
                "instagram"     =>  $this->input->post('instagram'),
                "linkedin"      =>  $this->input->post('linkedin')
            );*/
            /*if (!empty($_POST['facebook']) || !empty($_POST['twitter']) || !empty($_POST['instagram']) || !empty($_POST['linkedin'])) {
                if ($this->Util_model->row_count("user_social", "WHERE uid=".userdata(UID)) == 0) {
                    $data['uid'] = userdata(UID);
                    $this->Db_model->insert("user_social", $data);
                } else {
                    $this->Db_model->update("user_social", $data, "WHERE uid=".userdata(UID));
                }
            }*/
            if ($this->Db_model->update("user_main", ["name"=>ucwords($this->input->post('name'))], "WHERE uid=".userdata(UID))) {
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Profile saved successfully", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to update profile. Try again", "alert-danger", 1));
            }
        }
        redirect(base_url()."profile");
    }

    public function change_password () {
        $this->form_validation->set_rules('old_pass','Old Password','trim|required|min_length[6]|max_length[50]');
        $this->form_validation->set_rules('new_pass','Password','trim|required|min_length[6]|max_length[50]');

        if ($this->form_validation->run() === TRUE) {
            if (md5($this->salt.$this->input->post('old_pass').$this->salt) != $this->Util_model->get_user_info(userdata(UID), "password", "profile")) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The password is incorrect", "alert-danger", 1));
            } else {
                if ($this->Db_model->update("user_profile", ["password"=>md5($this->salt.$this->input->post('new_pass').$this->salt)], "WHERE uid=".userdata(UID))) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Password changed successfully", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to change password. Try again later", "alert-danger", 1));
                }
            }
        }
        redirect(base_url()."profile");
    }

    public function save_preference () {
        $this->form_validation->set_rules('savings','Savings share','trim|numeric|required|greater_than_equal_to[10]|less_than_equal_to[50]');
        $this->form_validation->set_rules('investment','Investment share','trim|numeric|required|greater_than_equal_to[10]|less_than_equal_to[50]');
        $this->form_validation->set_rules('project','Project share','trim|numeric|required|greater_than_equal_to[10]|less_than_equal_to[50]');

        if ($this->form_validation->run() == true) {
            $error_msg = "";
            if (($_POST["savings"] + $_POST["investment"] + $_POST["project"]) > 100) {
                $error_msg .= "<div>The summation of saving, investment and project share must not be more than 100</div>";
            } else {
                $share = array("savings"=>$_POST["savings"], "investment"=>$_POST["investment"], "project"=>$_POST["project"]);
                foreach ($share as $name => $val) {
                    if ($this->Util_model->row_count("user_options", "WHERE uid=".userdata(UID). " AND name='$name'") == 0) {
                        $this->Db_model->insert("user_options", ["uid"=>userdata(UID), "name"=>$name, "value"=>$val]);
                    } else {
                        $this->Db_model->insert("user_options", ["value"=>$val], "WHERE uid=".userdata(UID)." AND name='$name'");
                    }
                }
            }
            if ($error_msg == "") {
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Preference saved successfully", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $error_msg", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        
        redirect(base_url()."profile");
    }

    public function save_settlement_account () {
        $this->form_validation->set_rules('acct_bank','Bank','trim|required');
        $this->form_validation->set_rules('acct_num','Account number','trim|numeric|required|exact_length[10]');
        $this->form_validation->set_rules('acct_name','Account name','trim|required');
        $this->form_validation->set_rules('password','Account password','trim|required');

        $return = false;

        if ($this->form_validation->run() == true) {
            $this->load->model("users/Users_model");
            if ($this->Users_model->confirm_pass($_POST['password'])) {
                $data = array(
                    "uid" => userdata(UID),
                    "reference" => "",
                    "bank" => $this->input->post('acct_bank'),
                    "acct_name" => $this->input->post('acct_name'),
                    "acct_num" => $this->input->post('acct_num'),
                    "status" => 1
                );
                if ($this->Util_model->row_count("user_account", "WHERE uid=".userdata(UID)." AND status=1") == 0) {
                    $return = $this->Db_model->insert("user_account", $data);
                } else {
                    $return = $this->Db_model->update("user_account", $data, "WHERE uid=".userdata(UID));
                }
                if ($return) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Settlement account saved successfully", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error saving settlement account", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Incorrect account password", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        
        redirect(base_url()."profile");
    }

}