<?php

/**
 *  
 */
class Script extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
        }
    }
    
    public function read_script($script_id)
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            /* if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
				set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
				redirect(base_url() . "activate");
			} 
            if (!$this->Misc_model->has_access($script_id, 'script')) {
                redirect("academy/escript/preview/$script_id");
                return;
            };*/
        }
        if (has_userdata(A_UID)) {
            $script = $this->scansio_db_man->select('script', '*', "WHERE id = $script_id");
        } else {
            $script = $this->scansio_db_man->select('script', '*', "WHERE id = $script_id AND status = " . ACTIVE);
        }
        $data['title'] = $script['title'];
        $data['file'] = base_url() . 'book/viewer?file=' . base_url() . 'home/get-script/' . $script_id;
        $data['tab'] = "my_scripts";
        $data['main_content'] = 'users/read_book';
        $data['breadcrumb'] = '
				<ol class="breadcrumb">
					<li><a href="' . base_url() . 'home"><i class="fa fa-home"></i> Home </a></li>
					<li><i class="fa fa-script"></i> ' . $data['title'] . ' </li>
				</ol>
				';
        if (has_userdata(A_UID)) {
            $this->load->view('admin/layouts/main', $data);
        } else {
            $this->load->view('layouts/main', $data);
        }
    }

    public function get_script($script_id)
    {
        if (has_userdata(A_UID)) {
            $this->admin->check();
        } else {
            $this->Util_model->log_redirect();
            /* if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Upgrade your package.", "alert-danger", 1));
                redirect(base_url() . "activate");
            } */
        }
        //log_message('debug', "Getting pdf file .....");
        $referred_by = str_replace('\\', '/', base_url()) . 'book/viewer?file=' . base_url() . 'home/get-script/' . $script_id;
        //log_message('debug', "Referred by: $referred_by");
        $http_referer = $_SERVER['HTTP_REFERER'];
        //log_message('debug', "HTTP referer: $http_referer");
        $referer_matched = ($http_referer == $referred_by);
        //log_message('debug', ("HTTP referer matched: " . (($referer_matched) ? 'true' : 'false')));
        if (!$referer_matched) {
            redirect('/');
            return;
        }
        $script = $this->scansio_db_man->select('script', '', "WHERE id = $script_id");
        $parent = str_replace('\\', '/', FCPATH);
        //log_message('debug', "FCPATH: " . FCPATH);
        //log_message('debug', "Parent path: $parent");
        //log_message('debug', "script path from database: $script[file]");
        $path = ltrim($script['file'], './');
        //log_message('debug', "script full path: $parent$path");
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $script_id . '.pdf' . '"');
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($parent . $path));
        //log_message('debug', "PDF size: " . filesize($parent . $path));
        ob_clean();
        flush();
        $file = $parent . $path;
        readfile($file);
        exit;
    }
    
}
