<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 9/6/2018
 * Time: 10:05 AM
 */
class Store extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Store_model", "store");
    }

    public function index () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li>Store</li>
        </ol>
        ';
        $data['tab'] = "store";
        $data['main_content'] = "users/store";
        $this->load->view('layouts/main', $data);
    }

    public function item ($item_id) {
        $data['style'] = '<link rel="stylesheet" href="'.base_url().'assets/plugins/lightbox/dist/css/lightbox.min.css">';
        $data['item_id'] = $item_id;
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="'.base_url().'store">Store</a> </li>
            <li>Single item</li>
        </ol>
        ';
        $data['tab'] = "store_item";
        $data['main'] = $this->Db_model->select("*", "store_main", "WHERE sid=".$this->Util_model->get_info("store_products", "sid", "WHERE id=$item_id"));
        $data['pro'] = $this->Db_model->select("*", "store_profile", "WHERE sid=".$data['main']['sid']);
        $data['my_store'] = ($data['main']['uid'] == userdata(UID))?true:false;
        $data['style'] = '<link rel="stylesheet" href="'.base_url().'assets/plugins/lightbox/dist/css/lightbox.min.css">
                          <link href="'.base_url().'assets/plugins/starrr/dist/starrr.css" rel="stylesheet">';
        $data['main_content'] = "users/store_item";
        $this->load->view('layouts/main', $data);
    }

    public function add_to_cart () {
        $this->Util_model->log_redirect();
        $item_id = $this->input->post('item_id');
        if ($this->Util_model->row_count("store_cart", "WHERE uid=".userdata(UID)." AND item_id=$item_id") == 0) {
            $data = array (
                "uid"           =>  userdata(UID),
                "item_id"       =>  $item_id,
                "item_options"  =>  $this->input->post('options'),
                "item_count"    =>  1
            );
            if ($this->Db_model->insert("store_cart", $data)) {
                $return = [
                    "status"        =>  true,
                    "items"         =>  $this->Util_model->row_count("store_cart", "WHERE uid=".userdata(UID)),
                    "message"       =>  "Item successfully added to cart. <a href='".base_url()."store/cart' class='alert-link'>View cart</a>"
                ];
            } else {
                $return = [
                    "status"        =>  false,
                    "message"       =>  "An error occurred. Item not added"
                ];
            }
        } else {
            $item_count = $this->Util_model->get_info("store_cart", "item_count", "WHERE uid=".userdata(UID)." AND item_id=$item_id");
            $item_count++;
            if ($this->Db_model->update("store_cart", ["item_count"=>$item_count], "WHERE uid=".userdata(UID)." AND item_id=$item_id")) {
                $return = [
                    "status"        =>  true,
                    "items"         =>  $this->Util_model->row_count("store_cart", "WHERE uid=".userdata(UID)),
                    "message"       =>  "Item already added to cart. <a href='".base_url()."store/cart'>View cart</a>"
                ];
            } else {
                $return = [
                    "status"        =>  false,
                    "message"       =>  "An error occurred. Item not added"
                ];
            }
        }
        echo json_encode($return);
    }

    public function cart () {
        $this->Util_model->log_redirect();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="'.base_url().'list-store"><i class="fa fa-cart"></i> Store</li>
            <li>Cart</li>
        </ol>
        ';
        $data['tab'] = "cart";
        $data['main_content'] = "users/cart";
        $this->load->view('layouts/main', $data);
    }

    public function checkout () {
        $this->Util_model->log_redirect();
        $s = $this->Db_model->selectGroup("*", "store_address", "WHERE uid=".userdata(UID)." ORDER BY id DESC LIMIT 1");
        if ($s->num_rows() == 0) {
            $data['addr_fname'] = "";
            $data['addr_lname'] = "";
            $data['addr_phone1'] = "";
            $data['addr_phone2'] = "";
            $data['addr_address'] = "";
            $data['addr_landmark'] = "";
            $data['addr_state'] = "";
            $data['addr_lga'] = "";
        } else {
            $row = $s->row_array();
            $data['addr_fname'] = $row['first_name'];
            $data['addr_lname'] = $row['last_name'];
            $data['addr_phone1'] = $row['phone1'];
            $data['addr_phone2'] = $row['phone2'];
            $data['addr_address'] = $row['address'];
            $data['addr_landmark'] = $row['landmark'];
            $data['addr_state'] = $row['state'];
            $data['addr_lga'] = $row['region'];
        }
        $data['tab'] = "checkout";
        $data['main_content'] = "users/checkout";
        $this->load->view('layouts/main', $data);
    }

    public function add_item_count ($item_id) {
        if ($this->Util_model->row_count("store_cart", "WHERE uid=".userdata(UID)." AND item_id=$item_id") > 0) {
            $item_count = $_POST['item_count'];
            if ($this->Db_model->update("store_cart", ["item_count"=>$item_count], "WHERE uid=".userdata(UID)." AND item_id=$item_id")) {
                $return = [
                    "status"    =>  true,
                    "pane"      =>  $this->store->list_cart(userdata(UID))
                ];
            } else {
                $return = [
                    "status"    =>  false,
                    "message"   =>  "Item count not added. An error occurred",
                    "pane"      =>  $this->store->list_cart(userdata(UID))
                ];
            }
        } else {
            $return = [
                "status"    =>  false,
                "message"   =>  "Item does not exist",
                "pane"      =>  $this->store->list_cart(userdata(UID))
            ];
        }
        echo json_encode($return);
    }

    public function remove_from_cart ($item_id) {
        $this->Db_model->delete("store_cart", "WHERE item_id=$item_id");
        redirect(base_url()."store/cart");
    }

    public function wallet_pay () {
        $selling = (double)str_replace(",", "", $_POST['selling_price']);
        $selling_p = $selling - $_POST['wallet_pay'];
        if ($selling_p < 0) {
            $price = $this->store->get_selling_exp($selling);
            echo json_encode([
                "status" => false,
                "selling_price" => $price['selling_price'],
                "exp_earnings" => $price['exp_earnings'],
                "message" => "Amount must not be greater than the total price"
            ]);
        } else if ($_POST['wallet_pay'] > $this->General_model->get_balance(userdata(UID), false)) {
            $price = $this->store->get_selling_exp($selling);
            echo json_encode([
                "status" => false,
                "selling_price" => $price['selling_price'],
                "exp_earnings" => $price['exp_earnings'],
                "message" => "Insufficient balance. <a href='".base_url()."deposit'>Deposit NOW!</a>"
            ]);
        } else {
            $price = $this->store->get_selling_exp($selling_p);
            echo json_encode([
                "status"            =>  true,
                "selling_price"     =>  $price['selling_price'],
                "exp_earnings"      =>  $price['exp_earnings']
            ]);
        }
    }

    public function confirm_order () {
        $data = [
            "fname"         =>  $_POST['fname'],
            "lname"         =>  $_POST['lname'],
            "phone_code1"   =>  $_POST['phone_code1'],
            "phone1"        =>  $_POST['phone1'],
            "phone_code2"   =>  $_POST['phone_code2'],
            "phone2"        =>  $_POST['phone2'],
            "address"       =>  $_POST['address'],
            "landmark"      =>  $_POST['landmark'],
            "state"         =>  $_POST['state'],
            "lga"           =>  $_POST['lga'],
            "total"         =>  $_POST['total']
        ];
        if ($this->General_model->get_balance(userdata(UID), false) >= $data['total']) {
            $order = $this->store->confirm_order(userdata(UID), $data);
        } else {
            $order = [
                "status"        =>  false,
                "message"      =>  "Insufficient balance. <a href='".base_url()."fund'>Buy MEX now</a>"
            ];
        }

        echo json_encode($order);
    }

    public function store_orders () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="'.base_url().'store/list-items">List Items</a></li>
            <li>My Orders</li>
        </ol>
        ';
        $data['tab'] = "orders";
        $data['main_content'] = "users/orders";
        $this->load->view('layouts/main', $data);
    }

    public function extend_delivery ($package_no) {
        if ($this->Util_model->row_count("store_order", "WHERE package_no=$package_no AND status=1") == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Invalid package No", "alert-danger", 1));
            redirect(base_url()."store/store-orders");
        } else {
            $this->Db_model->update("store_order", ["expiry"=>set_expire_date(24)], "WHERE package_no=$package_no");
            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Order time extended to 24 hours", "alert-success", 1));
            redirect(base_url()."store/store-orders");
        }
    }

    public function my_store () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li>My Stores</li>
        </ol>
        ';
        $data['tab'] = "my_store";
        $data['main_content'] = "users/my_store";
        $this->load->view('layouts/main', $data);
    }

    public function create_store () {
        $this->form_validation->set_rules("name", "Name", "trim|required");
        $this->form_validation->set_rules("slug", "Slug", "trim|required|callback_slug_check");
        $this->form_validation->set_rules("email", "Email", "trim|required|valid_email|callback_email_check");
        $this->form_validation->set_rules("phone", "Phone number", "trim|required|numeric");
        $this->form_validation->set_rules("address", "Address", "trim|required");
        $this->form_validation->set_rules("bank", "Bank", "trim|required");
        $this->form_validation->set_rules("bank_acct_num", "Bank account number", "trim|required|numeric");
        $this->form_validation->set_rules("bank_acct_name", "Bank account name", "trim|required");

        if ($this->form_validation->run() === TRUE) {
            if (!empty($_FILES['image']['name'][0])) {
                $config = array(
                    'upload_path' => "./assets/img/uploads/",
                    'allowed_types' => 'jpg|gif|png',
                    'max_size' => 1024,
                    'file_name' => date("U"),
                    'file_ext_tolower' => TRUE,
                    'overwrite' => TRUE
                );

                $this->load->library('upload', $config);

                if ($this->upload->do_upload("image")) {
                    $img_data = $this->upload->data();
                    $upload_path = "assets/img/uploads/" . $img_data['file_name'];
                } else {
                    $upload_path = "assets/img/shop.png";
                }
            } else {
                $upload_path = "assets/img/shop.png";
            }
            $sid = $this->Util_model->generate_id(1111111111, 9999999999, "store_main", "sid");
            $main      =  [
                "uid"       =>  userdata(UID),
                "sid"       =>  $sid,
                "name"      =>  ucwords($this->input->post('name')),
                "pic_url"   =>  $upload_path,
                "status"    =>  1
            ];
            $profile   =  [
                "sid"       =>  $sid,
                "slug"      =>  $this->input->post("slug"),
                "email"     =>  strtolower($this->input->post("email")),
                "country"   =>  $this->input->post("phone_code"),
                "phone"     =>  ltrim($this->input->post('phone'),'0'),
                "state"     =>  $this->input->post("state"),
                "region"    =>  $this->input->post("region"),
                "address"   =>  $this->input->post("address")
            ];
            $bank = [
                "sid"       =>  $sid,
                "bank"      =>  $this->input->post('bank'),
                "acct_num"  =>  $this->input->post('bank_acct_num'),
                "acct_name" =>  $this->input->post('bank_acct_name')
            ];
            $this->Db_model->insert("store_main", $main);
            $this->Db_model->insert("store_profile", $profile);
            $this->Db_model->insert("store_bank", $bank);
            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Store created successfully", "alert-success", 1));
        } else {
            set_flashdata("msg", validation_errors());
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="'.base_url().'store/my-store"><i class="fa fa-shopping-cart"></i> My Stores</a></li>
            <li>Create store</li>
        </ol>
        ';
        $data['tab'] = "my_store";
        $data['main_content'] = "users/create_store";
        $this->load->view('layouts/main', $data);
    }

    public function edit_store ($sid) {
        $data['s_main'] = $this->Db_model->select("*", "store_main", "WHERE sid=$sid");
        $data['s_pro'] = $this->Db_model->select("*", "store_profile", "WHERE sid=$sid");
        $data['s_bank'] = $this->Db_model->select("*", "store_bank", "WHERE sid=$sid");

        $this->form_validation->set_rules("name", "Name", "trim|required");
        $this->form_validation->set_rules("slug", "Slug", "trim|required|callback_slug_check");
        $this->form_validation->set_rules("email", "Email", "trim|required|valid_email|callback_email_check");
        $this->form_validation->set_rules("phone", "Phone number", "trim|required|numeric");
        $this->form_validation->set_rules("address", "Address", "trim|required");
        $this->form_validation->set_rules("bank", "Bank", "trim|required");
        $this->form_validation->set_rules("bank_acct_num", "Bank account number", "trim|required|numeric");
        $this->form_validation->set_rules("bank_acct_name", "Bank account name", "trim|required");

        if ($this->form_validation->run() === TRUE) {

        }
    }

    public function slug_check($slug) {
        if (!preg_match('/^[A-Za-z0-9_]+$/', $slug)) {
            $this->form_validation->set_message("slug_check","Error: Invalid slug (must not contain space and special characters)");
            return false;
        } else if ($this->Util_model->row_count("store_profile","WHERE slug = '$slug'") > 0) {
            $this->form_validation->set_message("username_check","Store slug already exist. Choose a new slug for store");
            return false;
        } else
            return true;
    }

    public function view_store ($slug, $pane="active") {
        $s = $this->Db_model->selectGroup("*", "store_profile", "WHERE slug='$slug' LIMIT 1");
        if ($s->num_rows() > 0) {
            $pro = $s->row_array();
            $main = $this->Util_model->get_info("store_main", "*", "WHERE sid=$pro[sid]");
            if ($pane == "add_item") {
                $this->form_validation->set_rules("title", "Title", "required|trim");
                $this->form_validation->set_rules("category", "Category", "required|trim");
                $this->form_validation->set_rules("amount", "Amount", "required|trim|numeric");
                $this->form_validation->set_rules("desc", "Description", "required|trim");
                $this->form_validation->set_rules("pic_url", "Picture", "required|trim");

                if ($this->form_validation->run() === TRUE) {
                    $pictures = "";
                    $picture_x = explode(',', $this->input->post("pic_url"));
                    foreach ($picture_x as $pic) {
                        $this->Util_model->resize_pic("./$pic", false, 550, 550);
                        //$this->Util_model->text_pic_watermark("./$pic", "WWW.MEXONAIRE.COM");
                        $upload_path = './assets/img/uploads/'.date('Ym').'/';
                        if (!file_exists($upload_path)) {
                            makeDir('./assets/img/uploads/'.date('Ym'));
                        }
                        $fname = explode("/", $pic);
                        $fname = $fname[(count($fname)-1)];
                        rename("./".$pic, $upload_path.$fname);
                        $pictures .= $upload_path.$fname.",";
                    }
                    $pictures = rtrim($pictures, ",");
                    $data = array(
                        "sid"           =>  $main['sid'],
                        "cat_id"        =>  $this->input->post('category'),
                        "name"          =>  ucwords($this->input->post('title')),
                        "selling_price" =>  $this->input->post('amount')/$this->Util_model->get_option("coin_price"),
                        "description"   =>  ucfirst($this->input->post('desc')),
                        "picture"       =>  $pictures,
                        "country"       =>  $this->Util_model->get_info("states", "country", "WHERE id=$pro[state]"),
                        "state"         =>  $pro['state'],
                        "region"        =>  $pro['region'],
                        "status"        =>  0
                    );
                    if ($this->Db_model->insert("store_products", $data)) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Item added successfully and awaiting approval", "alert-success", 1));
                        redirect(base_url()."s/$pro[slug]/add-item");
                    } else {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error occurred during addition", "alert-danger", 1));
                    }
                } else {
                    set_flashdata("msg", validation_errors());
                }
            }
            $data['pro'] = $pro;
            $data['main'] = $main;
            $data['my_store'] = ($main['uid'] == userdata(UID))?true:false;
            $data['pane'] = $pane;
            $data['tab'] = "my_store";
            $data['style'] = '<link href="'.base_url().'assets/plugins/starrr/dist/starrr.css" rel="stylesheet">';
            $data['main_content'] = "users/view_store";
            $this->load->view('layouts/main', $data);
        } else {
            redirect(base_url()."home");
        }
    }

    public function post_picture () {
        if (!empty($_FILES['image']['name'][0])) {
            $config = array(
                'upload_path' => "./assets/img/uploads/tmp/",
                'allowed_types' => 'jpg|gif|png',
                'max_size' => 1024,
                'file_name' => date("U"),
                'file_ext_tolower' => TRUE,
                'overwrite' => TRUE
            );

            $this->load->library('upload', $config);

            if ($this->upload->do_upload("image")) {
                $img_data = $this->upload->data();
                $pictures = ((has_userdata('pictures'))?userdata('pictures'):"");
                $pictures .= ",assets/img/uploads/tmp/" . $img_data['file_name'];
                set_flashdata("pictures", $pictures);
                $pictures = ltrim($pictures, ",");
                $pictures_x = explode(",", $pictures);
                $pic_view = "";
                foreach ($pictures_x as $pic) {
                    $pic_view .= "
                    <img src='".base_url()."$pic' style='width:85px; height:85px; border-radius:10px; float:left; margin-right:10px; margin-bottom:10px' >\n
                    ";
                }
                $pic_view .= "
                <input type='hidden' name='pic_url' value='$pictures'>
                ";
                echo $pic_view;
            }
        }
    }

    public function email_check($email) {
        if ($this->Util_model->row_count("store_profile","WHERE email = '$email'") > 0) {
            $this->form_validation->set_message("email_check","Store email already exist. Enter a new email for store");
            return false;
        } else
            return true;
    }

    public function submit_rating () {
        echo $this->Db_model->insert("store_rating", ["sid"=>$_POST['sid'], "uid"=>userdata(UID), "rate"=>$_POST['rate']]);
    }

    public function print_order_invoice ($sid, $order_no) {
        $this->store->print_invoice($order_no, $sid);
    }
}

?>