<?php
class Studio extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
        $this->load->model("Studio_model", "studio");
    }

    public function index()
    {
        $this->ecourses();
    }

    public function manage_courses()
    {
        $this->ecourses();
    }

    public function manage_books()
    {
        $this->ebooks();
    }

    public function ecourses()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . '"><i class="fa fa-dashboard"></i> Dashboard </a></li>
            <li><i class="fa fa-graduationcap"></i> Manage Courses </li>
        </ol>
        ';
        /* $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>'; */
        $data['pane'] = "ecourse";
        $data['main_content'] = 'studio/studio';
        $this->load->view('layouts/main', $data);
    }

    public function ebooks()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . '"><i class="fa fa-dashboard"></i> Dashboard </a></li>
            <li><i class="fa fa-graduationcap"></i> Manage Books </li>
        </ol>
        ';
        /* $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>'; */
        $data['pane'] = "ebook";
        $data['main_content'] = 'studio/studio';
        $this->load->view('layouts/main', $data);
    }

    private function generate_course_code($min, $max, $category, $tbl = '', $field = '')
    {
        $uid = userdata(UID);
        $course_code = '';
        do {
            $chunk = explode(' ', $category);
            $symbol = '';
            if (count($chunk) > 1) {
                $symbol .= (str_split($chunk[0])[0] . str_split($chunk[1])[0]);
            } else {
                $spl = str_split($category);
                $symbol .= ($spl[0] . $spl[strlen($category) - 1]);
            }
            $course_code = $symbol . rand($min, $max);
        } while ($this->Util_model->row_count($tbl, "WHERE $field = '$course_code'") > 0);
        return $course_code;
    }

    public function create_course()
    {
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('level', 'Level', 'required|trim|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('category', 'Category', 'required|trim|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('price', 'Price', 'required|trim|numeric|is_natural|min_length[1]|max_length[11]|integer');
        $this->form_validation->set_rules('old_price', 'Old Price', 'required|trim|numeric|is_natural|min_length[1]|max_length[11]|integer');
        $this->form_validation->set_rules('intro_video', 'Introduction Video', 'required|trim');
        if ($this->form_validation->run()) {
            $title = ucwords($this->input->post('title'));
            $level = $this->input->post('level');
            $category = $this->input->post('category');
            $price = $this->input->post('price');
            $old_price = $this->input->post('old_price');
            $description = $this->input->post('description');
            $intro_video = $this->input->post('intro_video');
            $ct = $this->scansio_db_man->select('academy_category', '', "WHERE id = $category");
            $course_code = $this->generate_course_code(100, 999, $ct['title'], 'academy_course', 'course_code');
            $uid = userdata(UID);
            $dir = './assets/courses/' . $category . '/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('thumbnail', $dir, $course_code . rand(1000, 9999));
                if ($upload_pic['result']) {
                    $course_pic = ltrim($upload_pic['file_name'], './');
                    $fullpath = str_replace('\\', '/', FCPATH) . "$course_pic";
                    $this->Util_model->resize_pic($fullpath, false, 320, 240, true);
                    $data = [
                        'course_title' => $title,
                        'course_code' => $course_code,
                        'course_level' => $level,
                        'course_instructor' => $uid,
                        'category' => $category,
                        'course_price' => $price,
                        'course_old_price' => $old_price,
                        'course_pic' => $course_pic,
                        'course_introduction_link' => $intro_video,
                        'course_desc' => $description,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('academy_course', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/create_topic/$course_code", 'info' => "$title created"]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => validation_errors()]));
        }
    }

    public function creating_course()
    {
        $data['categories'] = $this->Util_model->list_from_table("academy_category", "id", "title", "WHERE status=1");
        $data['levels'] = "
				<option value='" . BEGINNER . "' selected>Beginner</option>
				<option value='" . ADVANCE . "' >Advance</option>
				<option value='" . EXPERT . "' >Expert</option>
				";
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'studio/approved_courses"><i class="fa fa-dashboard"></i> Manage Courses</a></li>
            <li><i class="fa fa-graduationcap"></i> Courses </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'studio/create_course';
        $this->load->view('layouts/main', $data);
    }

    public function create_topic($course_code)
    {
        $uid = userdata(UID);
        $course = $this->scansio_db_man->select("academy_course", '', "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you can\'t access $course_code. Please retry shortly...", "alert-danger", 1));
            redirect('studio/not-submitted-courses');
            return;
        }
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['course_code'] = $course_code;
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'studio/create_topic';
        $this->load->view('layouts/main', $data);
    }

    public function add_topic($course_code)
    {
        $uid = userdata(UID);
        $course_where = "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course || count($course) < 1) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> You don't have access to this course", "alert-danger", 1)]));
            return;
        }
        $this->form_validation->set_rules('topic_title', 'Topic Title', 'required');
        $this->form_validation->set_rules('topic_link', 'Topic Link', 'required');
        $this->form_validation->set_rules('topic_time', 'Loading Video', 'required');
        $this->form_validation->set_message('required', 'Please check your video url then let the video player initialize');
        if ($this->form_validation->run()) {
            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course_code' && status != " . HOTLISTED . " ORDER BY position");
            $num_topics = 0;
            $last_position = 0;
            if ($topics && ($num_topics = count($topics)) > 0) {
                $last_position = ($topics[$num_topics - 1]['position'] + 1);
            }
            $topic_time = $this->input->post('topic_time');
            $data = [
                'course_code' => $course_code,
                'topic_title' => $this->input->post('topic_title'),
                'topic_link' => $this->input->post('topic_link'),
                'topic_time' => $topic_time,
                'description' => $this->input->post('description'),
                'position' => $last_position,
                'status' => 1
            ];
            if ($this->scansio_db_man->insert('academy_topic', $data)) {
                $this->scansio_db_man->update('academy_course', ['course_time' => ($course['course_time'] + $topic_time)], $course_where);
                $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/topics/" . $course_code, 'info' => alert_msg("<i class='fa fa-check-square'></i> $data[topic_title] Created", "alert-success", 1)]));
            } else {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    public function creating_book()
    {
        $data['categories'] = $this->Util_model->list_from_table("book_category", "id", "title", "WHERE status=1");
        $data['types'] = $this->Util_model->list_from_table("book_type", "id", "title", "WHERE status=1");
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url('studio/manage-books') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
            <li><i class="fa fa-graduationcap"></i> Create Book </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_books";
        $data['main_content'] = 'studio/create_new_book';
        $this->load->view('layouts/main', $data);
    }

    public function create_book()
    {
        $uid = userdata(UID);
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('edition', 'Edition', 'trim|required|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('chapters', 'Chapters', 'trim|required|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('category', 'Category', 'trim|required|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('type', 'Type', 'trim|required|numeric|is_natural|max_length[2]|integer');
        $this->form_validation->set_rules('price', 'Price', 'trim|required|numeric|is_natural|min_length[1]|max_length[11]|integer');
        $this->form_validation->set_rules('old_price', 'Price', 'trim|required|numeric|is_natural|min_length[1]|max_length[11]|integer');
        if ($this->form_validation->run()) {
            $title = $this->input->post('title');
            $edition = $this->input->post('edition');
            $chapters = $this->input->post('chapters');
            $category = $this->input->post('category');
            $type = $this->input->post('type');
            $price = $this->input->post('price');
            $old_price = $this->input->post('old_price');
            $description = $this->input->post('description');
            $book_id = $this->Util_model->generate_id(10000000, 99999999, 'book_main', 'book_id');
            $dir = './assets/books/' . $category . '/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            $pdfdir = './ebooks/' . $category . '/';
            if (!file_exists($pdfdir)) {
                try {
                    mkdir($pdfdir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('cover', $dir, $book_id . rand(1000, 9999));
                $upload_pdf = upload_pdf('file', $pdfdir, $book_id . rand(1000, 9999));

                if ($upload_pic['result'] & $upload_pdf['result']) {
                    $pic_url = $upload_pic['file_name'];
                    $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                    $re = $this->Util_model->resize_pic($fullpath, false, 240, 320, true);
                    $file_url = $upload_pdf['file_name'];
                    $data = [
                        'book_id' => $book_id,
                        'title' => $title,
                        'author' => $uid,
                        'cat_id' => $category,
                        'edition' => $edition,
                        'chapters' => $chapters,
                        'type' => $type,
                        'price' => $price,
                        'old_price' => $old_price,
                        'pic_url' => $pic_url,
                        'file' => $file_url,
                        'desc' => $description,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('book_main', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/manage-books", 'info' => alert_msg("<i class='fa fa-check-circle'></i> $title created", "alert-success", 1)]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    public function create_script()
    {
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        if ($this->form_validation->run()) {
            $title = $this->input->post('title');
            $description = $this->input->post('description');
            $dir = './assets/scripts/';
            if (!file_exists($dir)) {
                try {
                    mkdir($dir);
                } catch (Exception $e) {
                }
            }
            $pdfdir = './scripts_pdf/';
            if (!file_exists($pdfdir)) {
                try {
                    mkdir($pdfdir);
                } catch (Exception $e) {
                }
            }
            try {
                $upload_pic = upload_pic('thumbnail', $dir, rand(1000, 9999));
                $upload_pdf = upload_pdf('file', $pdfdir, rand(1000, 9999));

                if ($upload_pic['result'] & $upload_pdf['result']) {
                    $pic_url = $upload_pic['file_name'];
                    $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                    $re = $this->Util_model->resize_pic($fullpath, false, 100, 100, true);
                    $file_url = $upload_pdf['file_name'];
                    $data = [
                        'title' => $title,
                        'author' => userdata(UID),
                        'thumbnail' => $pic_url,
                        'file' => $file_url,
                        'desc' => $description,
                        'status' => PENDING_PUBLISH
                    ];
                    if ($this->scansio_db_man->insert('script', $data)) {
                        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/manage-scripts", 'info' => alert_msg("<i class='fa fa-check-circle'></i> $title created", "alert-success", 1)]));
                    } else {
                        $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
                    }
                } else {
                    $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Thumbnail: $upload_pic[err]", "alert-danger", 1)]));
                }
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    public function command($item_code, $action)
    {
        $uid = userdata(UID);
        $action = empty($action) ? 0 : $action;
        try {
            $temp_item_code = ($item_code + 1) - 1;
            if ($temp_item_code <= 0) throw new Error('Arithmetic exception');
            $publishing_fee = $this->scansio_db_man->select("price", 'amount', "WHERE name = 'book'");
            switch ($action) {

                case APPROVED:
                    $has_paid = $this->scansio_db_man->select("book_publishing_fee", "", "WHERE uid = $uid AND book_id = $item_code AND status = " . ACTIVE);
                    if ($has_paid) {
                        $result = $this->scansio_db_man->update('book_main', ['status' => PENDING_APPROVAL], "WHERE author = $uid AND book_id = $item_code");
                        flash_msg($result);
                    } else {
                        redirect("misc/publishing_payment/$item_code/$publishing_fee/books");
                        return;
                    }
                    break;

                case PENDING_PUBLISH:
                case HOTLIST:
                    $result = $this->scansio_db_man->update('book_main', ['status' => $action], "WHERE author = $uid AND book_id = $item_code");
                    flash_msg($result);
                    break;

                default:
                    redirect('studio/ebooks');
                    break;
            }
            redirect('studio/ebooks');
        } catch (Error $e) {
            $publishing_fee = $this->scansio_db_man->select("price", 'amount', "WHERE name = 'course'");

            switch ($action) {

                case APPROVED:
                    $has_paid = $this->scansio_db_man->select("course_publishing_fee", "", "WHERE uid = $uid AND course_code = '$item_code' AND status = " . ACTIVE);
                    if ($has_paid) {
                        $result = $this->scansio_db_man->update('academy_course', ['status' => PENDING_APPROVAL], "WHERE course_instructor = $uid AND course_code = '$item_code'");
                        flash_msg($result);
                    } else {
                        redirect("misc/publishing_payment/$item_code/$publishing_fee/courses");
                        return;
                    }
                    break;

                case PENDING_PUBLISH:
                case HOTLIST:
                    $result = $this->scansio_db_man->update('academy_course', ['status' => $action], "WHERE course_instructor = $uid AND course_code = '$item_code'");
                    flash_msg($result);
                    break;


                default:
                    redirect('studio');
                    break;
            }
            redirect('studio/ecourses');
        }
    }

    public function course_update($course_code)
    {
        $uid = userdata(UID);
        $course_where = "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the Course didn\'t exist or you didn\'t have access to the Course.']));
            return;
        }
        $dir = './assets/courses/' . ($_POST['category'] != '' ? $this->input->post('category') : $course['category']) . '/';
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        try {
            $upload_pic = '';
            if (isset($_FILES['thumbnail']['name']) && $_FILES['thumbnail']['name'] != '') {
                $upload_pic = upload_pic('thumbnail', $dir, $course_code . rand(1000, 9999));
                if (!$upload_pic['result']) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $upload_pic[err]", "alert-danger", 1));
                }
            }
            $pic_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($course['course_pic']);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false, 300, 220, true);
            }
            $props = [
                'course_title' => ucwords($this->input->post('title')),
                'course_level' => $this->input->post('level'),
                /* 'course_instructor' => userdata(UID), */
                'category' => $this->input->post('category'),
                'course_price' => $this->input->post('price'),
                'course_old_price' => $this->input->post('old_price'),
                'course_pic' => $pic_url,
                'course_introduction_link' => $this->input->post('intro_video'),
                'course_desc' => $this->input->post('description'),
                'last_update' => date_time()
            ];
            $data = [];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            if ($this->scansio_db_man->update('academy_course', $data, $course_where)) {
                $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . 'studio/manage_courses', 'info' => 'Course updated successfully']));
            } else {
                throw new Exception;
            };
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.', 'Error']));
        }
    }

    public function course_edit($course_code)
    {
        $uid = userdata(UID);
        $course = $this->scansio_db_man->select('academy_course', '', "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You don't have access to $course_code", "alert-danger", 1));
            redirect("studio/manage-courses");
            return;
        }
        $data['course_code'] = $course['course_code'];
        $data['title'] = $course['course_title'];
        $level = $course['course_level'];
        $data['levels'] = "
				<option value='" . BEGINNER . "' " . ($level == BEGINNER ? 'selected' : '') . ">Beginner</option>
				<option value='" . ADVANCE . "' " . ($level == ADVANCE ? 'selected' : '') . ">Advance</option>
				<option value='" . EXPERT . "' " . ($level == EXPERT ? 'selected' : '') . ">Expert</option>
				";
        $data['categories'] = $this->Util_model->list_from_table("academy_category", "id", "title", "WHERE status=1", $course['category']);
        $data['description'] = $this->scansio_db_man->parseHtmlEntity($course['course_desc']);
        $data['price'] = $course['course_price'];
        $data['old_price'] = $course['course_old_price'];
        $data['thumbnail'] = base_url() . $course['course_pic'];
        $data['intro_video'] = $course['course_introduction_link'];
        $data['last_update'] = $course["last_update"] == '' ? $course['date'] : $course['last_update'];
        $data['style'] = '<link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['action'] = UPDATE;
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'studio/course_editing';
        $data['breadcrumb'] = '
	        <ol class="breadcrumb">
	            <li><a href="' . base_url() . 'studio/manage_courses"><i class="fa fa-book"></i> Manage Courses </a></li>
	            <li><a ><i class="fa fa-book-reader"></i> Edit Course </li> </a3>
	        </ol>
        ';
        $this->load->view('layouts/main', $data);
    }

    public function book_update($book_id)
    {
        $uid = userdata(UID);
        $book_where = "WHERE author = $uid AND book_id = $book_id";
        $book = $this->scansio_db_man->select('book_main', '', $book_where);
        $category = ($_POST['category'] != '' ? $this->input->post('category') : $book['category']);
        $this->output->set_content_type('json');
        if (!$book) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the book didn\'t exist or you didn\'t have access to the book.']));
            return;
        }
        $dir = "./assets/books/$category/";
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        $pdfdir = './ebooks/' . $category . '/';
        if (!file_exists($pdfdir)) {
            try {
                mkdir($pdfdir);
            } catch (Exception $e) {
            }
        }
        try {
            $upload_pic = '';
            $upload_pdf = '';
            if (isset($_FILES['cover']['name']) && $_FILES['cover']['name'] != '') {
                $old_pic_url = $book['pic_url'];
                $upload_pic = upload_pic('cover', $dir, $book_id . rand(1000, 9999));
            }
            if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
                $old_file = $book['file'];
                $upload_pdf = upload_pdf('file', $pdfdir, $book_id . rand(1000, 9999));
            }
            $pic_url = '';
            $file_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($old_pic_url);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false,  240, 320, true);
            }
            if ($upload_pdf != '' &&  $upload_pdf['result']) {
                $file_url = $upload_pdf['file_name'];
                deleteFile($old_file);
            }
            $props = [
                'title' => ucwords($this->input->post('title')),
                'edition' => $this->input->post('edition'),
                'chapters' => $this->input->post('chapters'),
                'cat_id' => $this->input->post('category'),
                'type' => $this->input->post('type'),
                'price' => $this->input->post('price'),
                'old_price' => $this->input->post('old_price'),
                'pic_url' => $pic_url,
                'file' => $file_url,
                'desc' => $this->input->post('description')
            ];
            $data = ['last_update' => date_time()];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            $this->scansio_db_man->update('book_main', $data, $book_where);
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.']));
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/manage-books", 'info' => 'Book updated successfully']));
    }

    public function book_edit($book_id)
    {
        $uid = userdata(UID);
        $book = $this->scansio_db_man->select('book_main', '', "WHERE author = $uid AND book_id = $book_id");
        if (!$book) {
            flash_msg(false, '', 'Book not found or you don\'t have permission');
            redirect("studio/manage-books");
            return;
        }
        $category = $this->scansio_db_man->select('book_category', '*', 'WHERE id = ' . $book['cat_id']);
        $type = $this->scansio_db_man->select('book_type', '*', 'WHERE id = ' . $book['type']);
        $chapters = $book['chapters'];
        $edition = $book['edition'];
        $data['book_id'] = $book_id;
        $data['title'] = $book['title'];
        $data['edition'] = $edition;
        $data['categories'] = $this->Util_model->list_from_table("book_category", "id", "title", "WHERE status=1", $category['id']);
        $data['types'] = $this->Util_model->list_from_table("book_type", "id", "title", "WHERE status=1", $type['id']);
        $data['chapters'] = $chapters;
        $data['price'] = $book['price'];
        $data['old_price'] = $book['old_price'];
        $data['style'] = '<link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['description'] = $book['desc'];
        $data['last_update'] = $book["last_update"] == '' ? $book['date'] : $book['last_update'];
        $data['tab'] = "manage_books";
        $data['main_content'] = 'studio/book_editing';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'studio/manage_books"><i class="fa fa-book"></i> Manage Book </a></li>
            <li><a ><i class="fa fa-book-reader"></i> Edit Book </li> </a>
        </ol>
        ';
        $this->load->view('layouts/main', $data);
    }

    private function creating_script()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url('studio/manage-scripts') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
            <li><i class="fa fa-graduationcap"></i> Create Script </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "manage_books";
        $data['main_content'] = 'studio/create_script';
        $this->load->view('layouts/main', $data);
    }

    private function script_update($script_id)
    {
        $script_where = "WHERE id = $script_id";
        $script = $this->scansio_db_man->select('script', '', $script_where);
        $this->output->set_content_type('json');
        if (!$script) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the script didn\'t exist or you didn\'t have access to the script.']));
            return;
        }
        $dir = "./assets/scripts";
        if (!file_exists($dir)) {
            try {
                mkdir($dir);
            } catch (Exception $e) {
                $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occured please try again.']));
                return;
            }
        }
        $pdfdir = './scripts_pdf';
        if (!file_exists($pdfdir)) {
            try {
                mkdir($pdfdir);
            } catch (Exception $e) {
            }
        }
        try {
            $upload_pic = '';
            $upload_pdf = '';
            if (isset($_FILES['thumbnail']['name']) && $_FILES['cover']['name'] != '') {
                $old_pic_url = $script['thumbnail'];
                $upload_pic = upload_pic('thumbnail', $dir, $script_id . rand(1000, 9999));
            }
            if (isset($_FILES['file']['name']) && $_FILES['file']['name'] != '') {
                $old_file = $script['file'];
                $upload_pdf = upload_pdf('file', $pdfdir, $script_id . rand(1000, 9999));
            }
            $pic_url = '';
            $file_url = '';
            if ($upload_pic != '' && $upload_pic['result']) {
                deleteFile($old_pic_url);
                $pic_url = $upload_pic['file_name'];
                $fullpath = str_replace('\\', '/', FCPATH) . ltrim($pic_url, './');
                $re = $this->Util_model->resize_pic($fullpath, false,  240, 320, true);
            }
            if ($upload_pdf != '' &&  $upload_pdf['result']) {
                $file_url = $upload_pdf['file_name'];
                deleteFile($old_file);
            }
            $props = [
                'title' => ucwords($this->input->post('title')),
                'thumbnail' => $pic_url,
                'file' => $file_url,
                'desc' => $this->input->post('description')
            ];
            foreach ($props as $column => $value) {
                if ($value != '') {
                    $data[$column] = $value;
                }
            }
            $this->scansio_db_man->update('script', $data, $script_where);
        } catch (Exception $e) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry an error occurred please try again.']));
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/manage-scripts", 'info' => 'Script updated successfully']));
    }

    private function script_edit($script_id)
    {
        $script = $this->scansio_db_man->select('script', '', "WHERE id = $script_id");
        if (!$script) {
            flash_msg(false, '', 'Script not found or you don\'t have permission');
            redirect("studio/manage-scripts");
            return;
        }
        $data['script_id'] = $script_id;
        $data['title'] = $script['title'];
        $data['description'] = $script['desc'];
        $data['created'] = $script['date'];
        $data['tab'] = "manage_scripts";
        $data['main_content'] = 'studio/script_editing';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'studio/manage_scripts"><i class="fa fa-scroll"></i> Manage Scripts </a></li>
            <li><a ><i class="fa fa-script"></i> Edit Script </li> </a>
        </ol>
        ';
        $this->load->view('layouts/main', $data);
    }

    private function script_action($script_id, $action)
    {
        $action = empty($action) ? 0 : $action;
        switch ($action) {
            case PENDING_PUBLISH:
            case APPROVED:
            case APPROVAL_DECLINE:
            case SUSPEND:
            case HOTLIST:
                $result = $this->scansio_db_man->update('script', ['status' => $action], "WHERE id = $script_id");
                flash_msg($result);
                redirect('studio/manage_scripts');

            default:
                flash_msg(false);
                redirect('studio/manage_scripts');
                break;
        }
    }

    private function delete_script($script_id)
    {
        $result = $this->scansio_db_man->delete("script", "WHERE id = $script_id");
        flash_msg($result);
        redirect("studio/manage-scripts");
    }

    public function creating_opportunity()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url('studio/opportunities') . '"><i class="fa fa-dashboard"></i> Manage Opportunities</a></li>
            <li><i class="fa fa-graduationcap"></i> Post opportunity </li>
        </ol>
        ';
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['tab'] = "opportunities";
        $data['main_content'] = 'studio/create_opportunity';
        $this->load->view('layouts/main', $data);
    }

    public function create_opportunity()
    {
        $this->output->set_content_type('json');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('short_desc', 'Short Description', 'trim|required');
        $this->form_validation->set_rules('full_desc', 'Full Detali', 'trim|required');
        if ($this->form_validation->run()) {
            $title = $this->input->post('title');
            $short_desc = $this->input->post('short_desc');
            $full_desc = $this->input->post('full_desc');
            $data = [
                'uid' => userdata(UID),
                'title' => $title,
                'short_desc' => $short_desc,
                'full_desc' => $full_desc,
                'status' => PENDING_PUBLISH
            ];
            if ($this->scansio_db_man->insert('opportunity', $data)) {
                $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/opportunities", 'info' => alert_msg("<i class='fa fa-check-circle'></i> $title created", "alert-success", 1)]));
            } else {
                $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
            }
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> " . validation_errors(), "alert-danger", 1)]));
        }
    }

    public function opportunity_update($opportunity_id)
    {
        $uid = userdata(UID);
        $opportunity_where = "WHERE uid = $uid AND id = $opportunity_id";
        $opportunity = $this->scansio_db_man->select('opportunity', '', $opportunity_where);
        $this->output->set_content_type('json');
        if (!$opportunity) {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'Sorry the opportunity didn\'t exist or you didn\'t have access to the opportunity.']));
            return;
        }
        $props = [
            'title' => ucwords($this->input->post('title')),
            'short_desc' => $this->input->post('short_desc'),
            'full_desc' => $this->input->post('full_desc')
        ];
        $data = [];
        foreach ($props as $column => $value) {
            if ($value != '') {
                $data[$column] = $value;
            }
        }
        $result = $this->scansio_db_man->update('opportunity', $data, $opportunity_where);
        if ($result) {
            $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/opportunities", 'info' => 'Opportunity updated successfully']));
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => 'An error occured please retry']));
        }
    }

    public function opportunity_edit($opportunity_id)
    {
        $opportunity = $this->scansio_db_man->select('opportunity', '', "WHERE id = $opportunity_id");
        if (!$opportunity) {
            flash_msg(false, '', 'Opportunity not found or you don\'t have permission');
            redirect("studio/opportunities");
            return;
        }
        $data['opportunity_id'] = $opportunity_id;
        $data['title'] = $opportunity['title'];
        $data['short_desc'] = $opportunity['short_desc'];
        $data['full_desc'] = $opportunity['full_desc'];
        $data['created'] = $opportunity['created'];
        $data['updated'] = $opportunity['updated'];
        $data['tab'] = "opportunites";
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['main_content'] = 'studio/opportunity_editing';
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'studio/opportunites"><i class="fa fa-scroll"></i> Manage opportunitys </a></li>
            <li><a ><i class="fa fa-opportunity"></i> Edit opportunity </li> </a>
        </ol>
        ';
        $this->load->view('layouts/main', $data);
    }

    public function opportunity_action($opportunity_id, $action)
    {
        $uid = userdata(UID);
        $action = empty($action) ? 0 : $action;
        switch ($action) {
            case PENDING_PUBLISH:
            case APPROVED:
            case APPROVAL_DECLINE:
            case SUSPEND:
            case HOTLIST:
                $result = $this->scansio_db_man->update('opportunity', ['status' => $action], "WHERE uid = $uid AND id = $opportunity_id");
                flash_msg($result);
                redirect('studio/opportunities');

            default:
                flash_msg(false);
                redirect('studio/opportunities');
                break;
        }
    }

    public function delete_opportunity($opportunity_id)
    {
        $result = $this->scansio_db_man->delete("opportunity", "WHERE id = $opportunity_id");
        flash_msg($result);
        redirect("studio/opportunities");
    }

    public function opportunities()
    {
        $where = " ORDER BY date DESC";
        $uid = userdata(UID);
        $opportunities = $this->scansio_db_man->rawQuery("SELECT u.name AS creator, u.uid AS creator_id, o.* FROM user_main u, opportunity o WHERE u.uid = o.uid ORDER BY date DESC");
        $view = "
            <table class='table table-hover table-striped'>
                <thead>
                    <tr>
                        <th>
                            #
                        </th>
                        <th>
                            Status
                        </th>
                        <th>
                            Title
                        </th>
                        <th>
                            Short Description
                        </th>
                        <th>
                            Creator
                        </th>
                        <th>
                            Creator Id
                        </th>
                        <th>
                            Created
                        </th>
                        <th>
                            Updated
                        </th>
                        <th class='action d-print-none'>
                            Action
                        </th>
                    </tr>
                </thead>
            <tbody>
        ";
        $count = 0;
        foreach ($opportunities as $o) {
            ++$count;
            $status = $o['status'];
            $read_link = base_url() . "home/opp-full-detail/$o[id]";
            $statusLink = '';
            $statusText = '';
            if ($status == PUBLISHED) {
                $stat = '<span class="text-success">Approved</span>';
                $statusText = 'Unpublish';
                $statusLink = base_url() . "studio/opportunity-action/$o[id]/" . UNPUBLISH;
            } else if ($status == PENDING_PUBLISH) {
                $stat = '<span class="text-default">Not submitted</span>';
                $statusText = 'Publish';
                $statusLink = base_url() . "studio/opportunity-action/$o[id]/" . PUBLISH;
            } else if ($status == SUSPENDED) {
                $stat = '<span class="text-danger">Suspended</span>';
                $statusText = 'Suspended';
                $statusLink = 'javascript:';
            } else if ($status == PENDING_APPROVAL) {
                $stat = '<span class="text-warning">Pending</span>';
                $statusText = 'Pending';
                $statusLink = 'javascript:';
            } else if ($status == APPROVAL_DECLINED) {
                $stat = '<span class="text-danger">Declined</span>';
                $statusText = 'Re-publish';
                $statusLink = base_url() . "studio/opportunity-action/$o[id]/" . PUBLISH;
            } else if ($status == HOTLISTED) {
                $stat = '<span class="text-danger">Deleted</span>';
                $statusText = 'Recover';
                $statusLink = base_url() . "studio/opportunity-action/$o[id]/" . PENDING_PUBLISH;
            }
            $delete = ($status == HOTLISTED ? base_url() . "studio/delete-opportunity/$o[id]" : base_url() . "studio/opportunity-action/$o[id]/" . HOTLIST);

            $view .= "     
				<tr>
					<td>
						$count
					</td>
					<td >
						$stat
					</td>
					<td>
						$o[title]
					</td>					
                    <td>
						$o[short_desc]
					</td>
					<td>
						$o[creator]
					</td>					
                    <td>
						$o[creator_id]
					</td>
					<td>
						$o[created]
					</td>
                    <td>
						$o[updateed]
					</td>
					<td>
						<a href='$read_link' class='btn btn-info btn-xs no-border' title='View in user dashboard.'><i class='fa fa-eye'></i> View</a>
						<a href='$delete' class='btn btn-danger btn-xs no-border' title='Caution are you sure of this please to retrieve it you have to contact studio.'><i class='fa fa-remove'></i> Delete</a>
						<a href='" . base_url() . "studio/opportunity-edit/$o[id]' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
						<a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='$statusText'><i class='fa fa-check'></i> $statusText </a>
					</td>
				</tr>
			";
        }

        $view .= "
                </tbody>
            </table>
        ";
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="' . base_url() . 'studio"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Manage Opportunities</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['view'] = $view;
        $data['tab'] = "opportunities";
        $data['main_content'] = 'studio/opportunities';
        $this->load->view('layouts/main', $data);
    }

    public function topics($course_code)
    {
        $uid = userdata(UID);
        $course = $this->scansio_db_man->select("academy_course", '', "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Sorry you don't have access to course $course_code", "alert-danger", 1));
            redirect("studio/deleted-courses");
            return;
        }
        $view = "";
        $topics = $this->scansio_db_man->selectGroup("academy_topic", '', "WHERE course_code = '$course_code' AND status=1 ORDER BY position");
        if ($topics) {
            foreach ($topics as $topic) {
                $view .= "
                    <li class='item cursor-pointer' style='padding-left:5px; padding-right:10px;'>
                        <div class='product-img'>
                            <div class='img-circle text-center pull-left' style='width:40px; height:40px; vertical-align: middle'>" . ($topic['position'] + 1) . "</div>
                        </div>
                        <div class='product-info'>
                            <a href='javascript:void(0)' class='product-title'>
                                $topic[topic_title]
                            </a>
                            <span class='product-description'>
                                <i class='fa fa-clock-o'></i> " . getFormattedDuration($topic['topic_time']) . "
								<div class='pull-right'>
									<a href='" . base_url() . "studio/topic_action/" . HOTLIST . "/$course_code/$topic[id]' class='btn btn-danger btn-xs no-border delete-permanent' data-toggle='tooltip' data-title='Are your sure you want to delete this topic'><i class='fa fa-remove'></i> Delete </a>
									<a href='" . base_url() . "studio/topic_action/" . EDIT . "/$course_code/$topic[id]' class='btn btn-success btn-xs no-border' title='Create topic'><i class='fa fa-plus-square'></i> Edit</a>
								</div>
                            </span>
                            
                        </div>
                    </li>
                ";
            }
        }
        $data['breadcrumb'] = "
		        <ol class='breadcrumb'>
		            <li><a href='" . base_url() . "studio/manage-courses'><i class='fa fa-dashboard'></i> Manage Courses</a></li>
		            <li><a href='" . base_url() . "studio/course-edit/$course_code'><i class='fa fa-graduationcap'></i> Course Details</a></li>
		            <li><i class='fa fa-graduationcap'></i> Topics </li>
		        </ol>
		    ";
        $data['course_code'] = $course_code;
        $data['view'] = $view;
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'studio/topics';
        $this->load->view('layouts/main', $data);
    }

    public function topic_action($action, $course_code, $topic_code)
    {
        switch ($action) {
            case EDIT:
                $this->topic_edit($course_code, $topic_code);
                break;

            case HOTLIST:
                $this->topic_delete($course_code, $topic_code);
                break;

            case UPDATE:
                $this->topic_update($course_code, $topic_code);
                break;
        }
    }

    public function topic_edit($course_code, $topic_code)
    {
        $uid = userdata(UID);
        $course = $this->scansio_db_man->select("academy_course", '', "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED);
        if (!$course) {
            set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Sorry you can\'t access this course topic. Please retry shortly...", "alert-danger", 1));
            redirect('studio/manage-courses');
            return;
        }
        $topics = $this->scansio_db_man->selectGroup("academy_topic", '', "WHERE course_code = '$course_code' AND status != " . HOTLISTED . " ORDER BY position ASC");
        $topic = $this->scansio_db_man->select("academy_topic", '', "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED);
        if (!$topic) {
            set_flashdata(alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred. Please retry shortly...", "alert-danger", 1));
            redirect('studio/topics/' . $course_code);
            return;
        }
        $topic_title = $topic['topic_title'];
        $topic_link = $topic['topic_link'];
        $topic_time = $topic['topic_time'];
        $last_topic = $topics[count($topics) - 1];
        $positions = '';
        if ($last_topic) {
            foreach ($topics as $t) {
                $positions .= "<option value='$t[position]' " . ($topic['position'] == $t['position'] ? 'selected' : '') . "> " . ($topic['position'] == $t['position'] ? '' : 'Before | ') . "$t[topic_title]</option>";
            }
            $positions .= $last_topic['position'] == $topic['position'] ? '' : "<option value='" . count($topics) . "' >Last</option>";
        }
        $data['course_code'] = $course_code;
        $data['topic_code'] = $topic_code;
        $data['topic_title'] = $topic_title;
        $data['topic_time'] = $topic_time;
        $data['topic_link'] = $topic_link;
        $data['description'] = $topic['description'];
        $data['positions'] = $positions;
        $data['style'] = ' <link href="' . base_url() . 'assets/plugins/summernote/summernote.min.css" rel="stylesheet">';
        $data['script'] = '<script src="' . base_url() . 'assets/plugins/summernote/summernote.min.js"></script>';
        $data['breadcrumb'] = '
		        <ol class="breadcrumb">
		            <li><a href="' . base_url() . 'studio/topics/' . $course_code . '"><i class="fa fa-dashboard"></i>Manage Topics</a></li>
		            <li><i class="fa fa-graduationcap"></i> ' . $topic_title . ' </li>
		        </ol>
		    ';
        $data['tab'] = "manage_courses";
        $data['main_content'] = 'studio/topic_editing';
        $this->load->view('layouts/main', $data);
    }

    public function topic_delete($course_code, $topic_code)
    {
        $uid = userdata(UID);
        $course_where = "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course || count($course) < 1) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Course not exists or you don't have access to it", "alert-danger", 1)]));
            return;
        }
        $topic_where = "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED;
        $topic = $this->scansio_db_man->select("academy_topic", '', $topic_where);
        if (!$topic) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred. Please retry shortly...", "alert-danger", 1)]));
            return;
        }
        $this->changePosition($course_code, $topic_code, $topic['position']);
        $delete = $this->scansio_db_man->delete('academy_topic', $topic_where);
        if ($delete) {
            $this->scansio_db_man->update('academy_course', ['course_time' => ($course['course_time'] - $topic['topic_time'])], $course_where);
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Error topic not deleted", "alert-danger", 1)]));
            return;
        }
        $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . 'studio/topics/' . $course_code, 'info' => alert_msg("<i class='fa fa-check-square'></i> Topic Deleted", "alert-success", 1)]));
    }

    public function topic_update($course_code, $topic_code)
    {
        $uid = userdata(UID);
        $course_where = "WHERE course_instructor = $uid AND course_code = '$course_code' && status != " . HOTLISTED;
        $course = $this->scansio_db_man->select('academy_course', '', $course_where);
        $this->output->set_content_type('json');
        if (!$course || count($course) < 1) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred please try again", "alert-danger", 1)]));
            return;
        }
        $topic_where = "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED;
        $topic = $this->scansio_db_man->select("academy_topic", '', $topic_where);
        if (!$topic) {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> Sorry an error occurred. Please retry shortly...", "alert-danger", 1)]));
            return;
        }
        $topic_time = $this->input->post('topic_time');
        $position = $this->input->post('position');
        $position = ($position == '' ? 0 : $position);
        $description = $this->input->post('description');
        $tempVals = [
            'course_code' => $course_code,
            'topic_title' => $this->input->post('topic_title'),
            'topic_link' => $this->input->post('topic_link'),
            'topic_time' => $topic_time,
            'description' => $description,
        ];
        $data = [];
        foreach ($tempVals as $columns => $value) {
            if ($value != '')
                $data[$columns] = $value;
        }
        $previous_time = $topic['topic_time'];

        if ($this->scansio_db_man->update('academy_topic', $data, $topic_where)) {
            if (($topic_time - $previous_time) != 0) {
                $this->scansio_db_man->update('academy_course', ['course_time' => (($course['course_time'] - $previous_time) + $topic_time)], $course_where);
            }
            if ($position != $topic['position']) {
                $previous_position = $topic['position'];
                $target_position = $position;
                $this->changePosition($course_code, $topic_code, $previous_position, $target_position);
            }
            $this->output->set_output(json_encode(['status' => true, 'redirect' => base_url() . "studio/topics/" . $course_code, 'info' => alert_msg("<i class='fa fa-check-square'></i> $data[topic_title] updated", "alert-success", 1)]));
        } else {
            $this->output->set_output(json_encode(['status' => false, 'info' => alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again later", "alert-danger", 1)]));
        }
    }

    private function changePosition($course_code, $topic_code, $from, $to = 'last')
    {

        $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course_code' && status != " . HOTLISTED . " ORDER BY position");
        $previous_position = $from;
        $target_position = ($to == 'last' ? count($topics) : $to);
        //Implemeting move operation
        if ($previous_position > $target_position) {
            //Moving up
            for ($i = $target_position; $i < $previous_position; $i++) { /* AND position = $i*/
                $t_where = "WHERE course_code = '$course_code' AND id = " . $topics[$i]['id'] . " AND status != " . HOTLISTED;
                $this->scansio_db_man->update('academy_topic', ['position' => ($i + 1)], $t_where);
            }
        } else {
            //Moving down
            for ($i = $target_position; $i > $previous_position; $i--) {
                $t_where = "WHERE course_code = '$course_code' AND id = " . $topics[$i]['id'] . " AND status != " . HOTLISTED;
                $this->scansio_db_man->update('academy_topic', ['position' => ($i - 1)], $t_where);
            }
        }
        $topic_where = "WHERE course_code = '$course_code' AND id = '$topic_code' AND status != " . HOTLISTED;
        $this->scansio_db_man->update('academy_topic', ['position' => $target_position], $topic_where);
    }
}
