<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 6/29/2021
 * Time: 4:42 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller
{
    private $salt = "@#6$%^&*THIS$%^&IS(&^A%^&LARGE^&**%^&SALT-8,/7%^&*";

    public function __construct()
    {
        parent::__construct();
        $this->load->model("users/Users_model","users");
    }

    public function profile () {

    }

    public function sign_up ($ref_id = '') {
        if (has_userdata(UID)) redirect(base_url()."home");
        if ($ref_id != '') {
            $data['ref_id'] = $ref_id;
        } else if (has_userdata('ref')) {
            $data['ref_id'] = userdata('ref');
        } else $data['ref_id'] = "";

        $this->form_validation->set_rules('name','Name','trim|required');
        $this->form_validation->set_rules('username','Username','trim|required|callback_username_check');
        $this->form_validation->set_rules('email','Email','trim|required|valid_email|callback_email_check');
        $this->form_validation->set_rules('phone','Phone Number','trim|required|numeric|is_natural|min_length[7]|max_length[11]|integer');
        $this->form_validation->set_rules('password','Password','trim|required|alpha_numeric|min_length[6]|max_length[50]');
        $this->form_validation->set_rules('ref','Referral ID','trim');
        $this->form_validation->set_rules('terms','Terms and Conditions','required|callback_terms');

        if($this->form_validation->run() == TRUE) {
            $phone = ltrim($this->input->post('phone'),'0');
            if ($this->Util_model->row_count("user_profile","WHERE `phone_code`='$_POST[country]' AND phone = $phone") > 0) {
                set_flashdata("msg", alert_msg("Error: phones already exist <a href='" . base_url() . "sign-in' class='alert-link'>Sign In instead</a>", "alert-danger", 1));
            } else {
                $email = strtolower($this->input->post("email"));
                $_SESSION['email'] = $email;
                //Referral links 
                $ref_id = $this->input->post("ref");
                $ser = (is_numeric($ref_id) ? "uid=$ref_id" : "email='$ref_id' OR username='$ref_id'");
                $ref1 = (empty($ref_id) ? $this->Util_model->get_info("user_profile", "uid", "WHERE role=2 LIMIT 1") : $this->Util_model->get_info("user_profile", "uid", "WHERE $ser"));
                $ref = $this->Util_model->get_info("user_referrer", "ref1, ref2, ref3, ref4", "WHERE uid=$ref1");
                //---------------------------------------------
                $uid = $this->Util_model->generate_id(10000000, 99999999, 'user_profile', 'uid');
                //$cid = $this->Util_model->get_user_info($ref_id, 'cid', 'profile');
                $uname = $this->input->post('username');
                $pass = $this->input->post('password');

                $input = array(
                    'user_main' => array(
                        'uid' => $uid,
                        'name' => ucwords($this->input->post('name')),
                        'status' => 1 //To be wiped while taking online
                    ),
                    'user_profile' => array(
                        'uid' => $uid,
                        //'cid' => $cid,
                        'username' => $uname,
                        'email' => strtolower($this->input->post('email')),
                        'country' => $this->input->post('country'),
                        'phone' => ltrim($this->input->post('phone'), '0'),
                        'phone_code' => $this->Util_model->get_info("countries", "phone_code", "WHERE id=$_POST[country]"),
                        'package' => 0,
                        'rank'  => 1,
                        'duration' => 0,
                        'password' => md5($this->salt . $pass . $this->salt),
                        //'ref'               =>  $ref_id,
                        //'ref_from'          =>  $this->input->post('advert'),
                        'role' => 1
                    ),
                    'user_referrer' => array(
                        //'cid' => $cid,
                        'uid' => $uid,
                        'ref1' => $ref1,
                        'ref2' => $ref['ref1'],
                        'ref3' => $ref['ref2'],
                        'ref4' => $ref['ref3'],
                        'ref5' => $ref['ref4']
                    )
                );
                
                /*$rank = $this->Util_model->get_info("ranking", "mgr", "WHERE id=1");
                $amb = $this->Util_model->get_info("user_profile", "uid", "WHERE rank=$rank ORDER BY RAND() LIMIT 1");
                if ($amb) {
                    $input['user_rulers'] = array(
                        'uid' => $uid,
                        'u_rank' => 1,
                        'ruler' => $amb,
                        'r_rank' => $rank
                    );
                }*/
                
                if ($this->users->register($input)) {
                    redirect(base_url() . "sign-in/$uname/$pass");
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error during registeration.", "alert-danger", 1));
                }
            }
        } else {
            set_flashdata("msg", validation_errors());
        }

        //$data['breadcrumb'] = '<li><a href="'.base_url().'sign-up">Sign up</a></li>';
        //Load view and layout
        $this->load->view('users/sign_up',$data);
    }

    public function username_check($uname) {
        if (preg_match('/^[a-zA-Z0-9]+$/', $uname)) {
            if (in_array(strtolower($uname), ["house", "home", "admin", "user", "house_of_money", "godwin", "mr_winz", "mrwinz", "nweke", "godwinnweke", "godwin_nweke"])) {
                $this->form_validation->set_message("username_check","Error: <b>$uname</b> is a ".SITE_TITLE." reserved word. Try another username instead.");
                return false;
            } else if ($this->Util_model->row_count("user_profile","WHERE username = '$uname'") > 0) {
                $this->form_validation->set_message("username_check","Error: username already exist");
                return false;
            } else
                return true;
        } else {
            $this->form_validation->set_message("username_check","Error: Only alphabets and numbers are allowed");
            return false;
        }
    }

    public function email_check($email) {
        if ($this->Util_model->row_count("user_profile","WHERE email = '$email'") > 0) {
            $this->form_validation->set_message("email_check","Error: email already exist <a href='".base_url()."sign-in' class='alert-link'>Sign In instead</a>");
            return false;
        } else
            return true;
    }

    public function phone_check($phone) {
        $phone = ltrim($phone,'0');
        if ($this->Util_model->row_count("user_profile","WHERE phone = $phone") > 0) {
            $this->form_validation->set_message("phone_check","Error: phones already exist <a href='".base_url()."sign-in' class='alert-link'>Sign In instead</a>");
            return false;
        } else
            return true;
    }

    public function ref_check($ref) {
        if ($ref == '') {
            $this->form_validation->set_message("ref_check","Error: you need a referral code to sign up. Contact admin if you don't have any.");
            return false;
        } else {
            $ser = (is_numeric($ref) ? "uid=$ref" : "email='$ref' OR username='$ref'");
            if ($this->Util_model->row_count("user_profile","WHERE $ser") == 0) {
                $this->form_validation->set_message("ref_check","Error: the referral doesn't exist");
                return false;
            } else
                return true;
        }
    }

    public function terms($terms) {
        if (empty($terms)) {
            $this->form_validation->set_message("terms","Error: your must accept our terms and condition");
            return false;
        } else {
            return true;
        }
    }

    public function send_email_verification_link ($uid, $page="profile") {
        $email = $this->Util_model->get_user_info($uid,"email","profile");
        $this->Db_model->delete("user_auth","WHERE uid=$uid AND type='email_verify'");
        $this->users->send_email_verification_link($uid, $email);
        if ($page == "profile") {
            redirect(base_url()."profile");
        } else if ($page == "get-started") {
            redirect(base_url()."get-started");
        } else {
            redirect(base_url()."home");
        }
    }

    public function verify_email ($uid, $auth_text, $type, $page='get-started') {
        if ($this->users->user_auth($uid, $auth_text, $type)) {
            /*$ref = $this->Util_model->get_user_info($uid,"ref","profile");
            $this->General_model->add_point($ref, $uid, "verify_email");*/
            $this->Db_model->update("user_profile",array("email_verified"=>1),"WHERE uid=$uid");
            set_flashdata("msg",alert_msg("<i class='fa fa-check-circle'></i> Your email has been verified successfully","alert-success",1));
        } else {
            $email = $this->Util_model->get_user_info($uid,"email","profile");
            set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> Email verification failed.","alert-danger",1));
        }
        if ($page == "profile") {
            redirect(base_url()."profile");
        } else if ($page == "get-started") {
            redirect(base_url()."get-started");
        } else {
            redirect(base_url()."home");
        }
    }

    public function sign_in($uname=NULL, $pass=NULL) {
        if (has_userdata(UID)) redirect(base_url());
        $this->form_validation->set_rules('user','Email/Username','trim|required');
        $this->form_validation->set_rules('pass','Password','trim|required|min_length[6]|max_length[50]');

        if ($this->form_validation->run() == TRUE || $uname != NULL || $pass != NULL) {
            $user = ($uname == NULL) ? $this->input->post('user') : $uname;
            $pass = ($pass == NULL) ? $this->input->post('pass') : $pass;

            $inputs = array(
                "user" => strtolower($user),
                "pass" => md5($this->salt.$pass.$this->salt)
            );

            $result = $this->users->login($inputs);

            switch ($result) {
                case 0:
                    set_flashdata("msg", alert_msg("<i class='fa fa-times'></i> Incorrect email/username or password", "alert-danger",1));
                    break;
                case 1:
                    redirect('user/activate');
                    break;
                case 2:
                    //if (!has_userdata('redirect'))
                        redirect(base_url()."home");
                    //else
                        //redirect(userdata('redirect'));

                    break;
                case 3:
                    set_flashdata("msg", alert_msg("<i class='fa fa-times'></i> Your account has been blocked for violating rule(s). Send a mail to <b>".$this->Util_model->get_option('site_email')."</b> to activate your account.", "alert-danger",1));
                    break;
            }
        } else {
            set_flashdata(false, validation_errors(), false);
        }

        //$data['breadcrumb'] = '<li><a href="'.base_url().'sign-in">Sign in</a></li>';
        //Load view and layout
        $this->load->view('users/sign_in');
    }

    public function sign_out () {
        $this->users->sign_out();
        redirect(base_url());
    }

    public function reset_password ($uid=NULL,$auth_text=NULL,$type=NULL) {
        if ($uid != NULL && $auth_text != NULL && $type != NULL) {
            if ($this->users->user_auth($uid, $auth_text, $type)) {
                set_userdata("uid", $uid);
                set_userdata("auth_text", $auth_text);
                set_userdata("type", $type);
            }
        }
        //Load view and layout
        $this->load->view('users/reset_password');
    }

    public function send_reset_link () {
        $this->form_validation->set_rules('email','Email','trim|required|valid_email');

        if ($this->form_validation->run() == true) {
            if ($this->Util_model->row_count("user_profile","WHERE email='$_POST[email]'") > 0) {
                $uid = $this->Util_model->get_info("user_profile","uid","WHERE email='$_POST[email]'");
                $first = $this->Util_model->get_user_info($uid);
                $this->Db_model->delete("user_auth","WHERE uid=$uid AND type='pass_reset'");
                $data = array (
                    "uid"           =>  $uid,
                    "auth"          =>  md5(rand(1111,9999)),
                    "type"          =>  "pass_reset"
                );
                if ($this->Db_model->insert("user_auth",$data)) {
                    $text = "<h4>Password Reset Request</h4>
                        <p>Click the link below to reset your password.</p>
                        <a href='".base_url()."users/reset-password/$uid/$data[auth]/$data[type]'>".base_url()."users/reset-password/$uid/$data[auth]/$data[type]</a>
                        <p>You are seeing this message because a request was made from 
                            <a href='".base_url()."'>www.".SITE_URL."</a> to change your account password on <a href='".base_url()."'>www.".SITE_URL."</a>. 
                            If this request was not made by you, kindly ignore this message
                        </p>";

                    if ($this->Mail_model->send_mail($_POST['email'], "Password Reset", $text, "Password Reset")) {
                        set_flashdata('msg',alert_msg("<i class='fa fa-check-circle'></i> Password reset link sent to <b>$_POST[email]</b>","alert-success", 1));
                    } else {
                        set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> Error sending mail to <b>$_POST[email]</b>","alert-danger", 1));
                    }
                }
            } else {
                set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> <b>$_POST[email]</b> does not exit. <a href='".base_url()."sign-up'>Register instead</a>","alert-danger", 1));
            }
        } else {
            set_flashdata('msg',validation_errors());
        }
        redirect(base_url()."users/reset-password");
    }

    /*public function verify_email ($uid=NULL, $auth_text=NULL, $type=NULL) {
        if ($uid != NULL && $auth_text != NULL && $type != NULL) {
            if ($this->users->user_auth($uid, $auth_text, $type)) {
                $
                $this->Db_model->update("user_profile",array("status"=>1, "point"=>$this->Util_model->get_info("user_profile","point","WHERE uid=$uid")+500),"WHERE uid=$uid");
                $this->Db_model->delete("user_auth","WHERE uid=$uid AND auth='$auth_text' AND type='$type'");
                set_flashdata("msg",alert_msg("<i class='fa fa-check-circle'></i> Email verified successfully","alert-success",1));
                redirect(base_url());
            } else {
                set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured during verification","alert-danger",1));
                redirect(base_url());
            }
        }
    }*/

    public function change_password () {
        $this->form_validation->set_rules('pass','Password','trim|required|min_length[6]|max_length[50]');

        if ($this->form_validation->run() == true) {
            $data = array(
                "password"      =>  md5($this->salt.$this->input->post('pass').$this->salt)
            );
            if ($this->Db_model->update("user_profile",$data,"WHERE uid=".userdata('uid'))) {
                unset_userdata('uid');
                unset_userdata('auth_text');
                unset_userdata('type');
                set_flashdata('msg',alert_msg("<i class='fa fa-check-circle'></i> Password changed successfully. Sign in with the new password","alert-success", 1));
                redirect(base_url()."sign-in");
            } else {
                set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> Password was not changed successfully. Please try again","alert-danger", 1));
                redirect(base_url()."users/reset-password");
            }
        } else {
            set_flashdata('msg',validation_errors());
            redirect(base_url()."users/reset-password");
        }

    }

    public function wallet ($tab='history', $method=NULL) {
        $this->Util_model->log_redirect();
        $data['breadcrumb'] = '<li>Wallet</li>';
        switch ($tab) {
            case 'deposit':
                $data['tab'] = $tab;
                if ($method == NULL) {
                    $data['method'] = 'card';
                } else {
                    $data['method'] = $method;
                }
                break;
            case 'withdraw':
                $data['tab'] = $tab;
                if ($method == NULL) {
                    $data['method'] = 'bank';
                } else {
                    $data['method'] = $method;
                }
                break;
            case 'history':
                $data['tab'] = $tab;
                if ($method != NULL) {
                    $data['ref'] = $method;
                }
                break;
        }

        //Load view and layout
        $data['main_content'] = 'users/wallet';
        $this->load->view('layouts/main',$data);
    }
}