<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 3/9/2020
 * Time: 4:05 AM
 */
class Wallet extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
        if ($this->Util_model->get_user_info(userdata(UID), "package", "profile") == 0) {
            redirect(base_url()."activate");
        }
        $this->load->model("Payment_model", "pay");
        $this->load->model("Flutterwave_model", "fw");
    }

    public function transactions ($pane="wallet") {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-exchange"></i> Transaction</a></li>
        </ol>
        ';
        if ($pane == "coin-buy") {
            $data['transactions'] = $this->Db_model->selectGroup("*", "coin_buy", "WHERE uid=".userdata(UID)." ORDER BY id DESC, status");
        } else if ($pane == "coin-sell") {
            $data['transactions'] = $this->Db_model->selectGroup("*", "coin_sell", "WHERE uid=".userdata(UID)." ORDER BY id DESC, status"); 
         } else {
            $table = ($pane != "wallet") ? "_$pane" : "";
            $data['transactions'] = $this->Db_model->selectGroup("*", "user_wallet".$table, "WHERE creditor=".userdata(UID)." OR debitor=".userdata(UID)." ORDER BY id DESC, status");
        }
        $data['pane'] = $pane;
        $data['tab'] = "transactions";
        $data['main_content'] = 'users/transactions';
        $this->load->view('layouts/main',$data);
    }

    public function deposit () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#">Wallet</a></li>
            <li><a href="#"><i class="fa fa-money"></i> Deposit</a></li>
        </ol>
        ';
        
        $data['tab'] = "deposit";
        $data['main_content'] = 'users/deposit';
        $this->load->view('layouts/main',$data);
    }

    public function initialize_deposit ($amount=0) {
        if ($amount > 0) {
            $wallet = $this->Main_model->add_to_wallet($amount, userdata(UID), 0, "Wallet funding using Flutterwave", "Wallet funding using Flutterwave", "deposit", "flutterwave", "");
            if ($wallet['return']) {
                $deposit = $this->fw->initialize_deposit($amount, userdata(UID), $wallet['reference']);
                if ($deposit["status"]) {
                    redirect($deposit["redirect"]);
                } else {
                    $this->Db_model->update("user_wallet", ["status" => 2], "WHERE ref='$wallet[reference]'");
                    set_flashdata("msg", alert_msg($deposit["msg"], "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Please try again.", "alert-danger", 1));
            }
        }
        redirect(base_url()."deposit");
    }

    public function verify_deposit () {
        if (isset($_GET['tx_ref'])) {
            $ref = $_GET['tx_ref'];
            $status = $_GET['status'];
            $trans_id = $_GET['transaction_id'];
            if ($status == "successful") {
                if ($this->Db_model->update("user_wallet", ["status" => 1, "extra" => $trans_id], "WHERE ref='$ref'")) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Your wallet has been funded successfully", "alert-success", 1));
                    redirect(base_url()."transactions");
                }
            } else {
                $this->Db_model->update("user_wallet", ["status" => 2], "WHERE ref='$ref'");
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Transaction is pending. Please wait.", "alert-danger", 1));
                redirect(base_url()."deposit");
            }
        } else {
            redirect(base_url()."deposit");
        }
    }

    public function topup_merchant () {
        $this->form_validation->set_rules("mid", "Merchant ID", "required|trim|numeric");
        $this->form_validation->set_rules("amount", "Amount", "required|trim");

        if ($this->form_validation->run() == TRUE) {
            $mid = $this->input->post("mid");
            if ($this->Util_model->row_count("merchant_main", "WHERE mid=$mid") > 0) {
                if ($this->input->post("type") == 'add') {
                    if ($this->Main_model->add_to_merchant_wallet($this->input->post("amount"), $mid, 0, "", "", "Admin top up", "", "", 1)['return']) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant fund topped up successful", "alert-success", 1));
                    } else {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured topping up merchant account", "alert-danger", 1));
                    }
                } else {
                    if ($this->Main_model->add_to_merchant_wallet($this->input->post("amount"), 0, $mid, "", "", "Admin reduction", "", "", 1)['return']) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant fund reduction was successful", "alert-success", 1));
                    } else {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured reducing merchant fund", "alert-danger", 1));
                    }
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Merchant doesn't exist", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."wallet/topup");
    }

    public function topup_user () {
        $this->form_validation->set_rules("mid", "Merchant ID", "required|trim");
        $this->form_validation->set_rules("username", "Username", "required|trim");
        $this->form_validation->set_rules("amount", "Amount", "required|trim");

        if ($this->form_validation->run() == TRUE) {
            if ($this->Util_model->row_count("user_profile", "WHERE username='$_POST[username]' AND mid=$_POST[mid]") > 0) {
                $uid = $this->Util_model->get_info("user_profile", "uid", "WHERE username='$_POST[username]' AND mid=$_POST[mid]");
                if ($this->input->post("type") == 'add') {
                    if ($this->Main_model->add_to_wallet($this->input->post("amount"), $uid, 0, $this->input->post('details'), $this->input->post('details'), "Admin top up", "", "", 1, $_POST['mid'])['return']) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Account top up was successful", "alert-success", 1));
                    }
                } else {
                    if ($this->Main_model->add_to_wallet($this->input->post("amount"), 0, $uid, $this->input->post('details'), $this->input->post('details'), "Deduction", "", "", 1, $_POST['mid'])['return']) {
                        set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Account deduction was successful", "alert-success", 1));
                    }
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The user with that username doesn't exist", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."wallet/topup");
    }

    public function withdraw_status () {
        if ($this->input->post('type') == "merchant") {
            $this->Db_model->update("user_wallet", ["status"=>$this->input->post('status')], "WHERE ref='$_POST[reference]'");
            $this->Db_model->update("merchant_withdrawal", ["status"=>$this->input->post('status')], "WHERE reference='$_POST[reference]'");
        } else {
            $this->Db_model->update("user_wallet", ["status"=>$this->input->post('status')], "WHERE ref='$_POST[reference]'");
            $this->Db_model->update("user_withdraw", ["status"=>$this->input->post('status')], "WHERE reference='$_POST[reference]'");
        }
    }

    public function withdraw () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#">Wallet</a></li>
            <li><a href="#"><i class="fa fa-money"></i> Withdrawals</a></li>
        </ol>
        ';
        
        $data['tab'] = "withdraw";
        $data['main_content'] = 'users/withdraw';
        $this->load->view('layouts/main',$data);
    }

    public function funding ()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-money"></i> Funding</a></li>
        </ol>
        ';
        $data['tab'] = "funding";
        $data['main_content'] = 'admin/funding';
        $this->load->view('admin/layouts/main',$data);
    }

    public function user_funding ($id) {
        $this->admin->check();
        $fund = $this->Util_model->get_info("funding", "*", "WHERE id=$id");
        if ($this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$fund[ref]'")) {
            $this->Db_model->update("funding", ["status" => 1], "WHERE id=$id");
            /*$refID = $this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$fund[uid]");
            if ($refID != 0) {
                if ($this->Util_model->row_count("user_wallet", "WHERE creditor=$fund[uid] AND status=1") == 1) {
                    $bonus = get_percentage($fund['amount'], 5);
                    $data = array(
                        "creditor" => $refID,
                        "debitor" => 0,
                        "amount" => $bonus,
                        "type" => "Referral Bonus",
                        "ref" => $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, "fb"),
                        "status" => 1
                    );
                    $this->Db_model->insert("user_bonus", $data);
                }
            }*/
            set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Account top up was successful", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function merchant_funding ($id) {
        $fund = $this->Util_model->get_info("merchant_funding", "*", "WHERE id=$id");
        if ($this->Db_model->update("merchant_wallet", ["status" => 1], "WHERE ref='$fund[ref]'")) {
            $this->Db_model->update("merchant_funding", ["status" => 1], "WHERE id=$id");
            /*$refID = $this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$fund[uid]");
            if ($refID != 0) {
                if ($this->Util_model->row_count("user_wallet", "WHERE creditor=$fund[uid] AND status=1") == 1) {
                    $bonus = get_percentage($fund['amount'], 5);
                    $data = array(
                        "creditor" => $refID,
                        "debitor" => 0,
                        "amount" => $bonus,
                        "type" => "Referral Bonus",
                        "ref" => $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, "fb"),
                        "status" => 1
                    );
                    $this->Db_model->insert("user_bonus", $data);
                }
            }*/
            set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant account top up was successful", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function merchant_funding_cancel ($id) {
        if ($this->Db_model->update("merchant_funding", ["status"=>2], "WHERE id=$id")) {
            $ref = $this->Util_model->get_info("merchant_funding", "ref", "WHERE id=$id");
            $this->Db_model->update("merchant_wallet", ["status"=>2], "WHERE ref='$ref'");
            set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant funding cancelled successful", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function funding_cancel ($id) {
        if ($this->Db_model->update("funding", ["status"=>2], "WHERE id=$id")) {
            $ref = $this->Util_model->get_info("funding", "ref", "WHERE id=$id");
            $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$ref'");
            set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Funding cancelled successful", "alert-success", 1));
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function bank_transfer () {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/bank/resolve?account_number=$_POST[acct_num]&bank_code=$_POST[bank]",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer sk_live_232c201bd88fa1b60a9c856f487f389dcc97e279",
                "Cache-Control: no-cache",
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function usdt_withdraw () {
        $this->form_validation->set_rules("address", "USDT wallet address", "trim|required");
        $this->form_validation->set_rules("amount", "Amount", "trim|required|integer");
        $this->form_validation->set_rules("password", "Account password", "trim|required|callback_password_check");

        if ($this->form_validation->run() == TRUE) {
            $amount = $this->input->post("amount");
            if ($amount < 75) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Amount must not be less than $75", "alert-danger", 1));
            } else {
                $fee = $this->Util_model->get_option("withdrawal_fee");
                if ($this->Main_model->check_balance(userdata(UID), ($amount+$fee))) {
                    $reference = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "ref", "varchar", true, 'fb');
                    $debit = $this->Main_model->add_to_wallet(
                        ($amount+$fee),
                        0,
                        userdata(UID),
                        "USDT withdrawal to $_POST[address]",
                        "USDT withdrawal to $_POST[address]",
                        "USDT Withdraw + fee",
                        "",
                        $reference
                    );
                    if ($debit['return']) {
                        $data = array(
                            "uid" => userdata(UID),
                            "reference" => $reference,
                            "amount" => ($amount+$fee),
                            "amount_received" => $amount,
                            "details" => $this->input->post("address"),
                            "channel" => "USDT",
                            "status" => 0,
                            "date" => date_time()
                        );
                        if ($this->Db_model->insert("user_withdraw", $data)) {
                            //Send whatsapp notification
                            set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Withdrawal submitted successfully. You will be credited very soon.", "alert-success", 1));
                        } else {
                            $this->Db_model->delete("user_wallet", "WHERE debitor=" . userdata(UID) . " AND ref='$reference'");
                            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured. Try again later.", "alert-danger", 1));
                        }
                    } else {
                        set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured. Try again later.", "alert-danger", 1));
                    }
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance.", "alert-danger", 1));
                }
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."wallet/withdraw");
    }

    public function cancel_withdraw ($reference) {
        $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$reference'");
        $this->Db_model->update("user_withdraw", ["status"=>2], "WHERE reference='$reference'");
        redirect(base_url()."transfer?p=bank");
    }

    public function password_check($password) {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($password)) {
            return true;
        } else {
            $this->form_validation->set_message("password_check","Incorrect password. Try again");
            return false;
        }
    }

    public function get_public_payment_detail () {
        $email = $this->Util_model->get_info("user_profile", "email", "WHERE uid=".userdata(UID));
        $pay_status = $this->Util_model->get_option("paystack_status");
        if ($_POST['account'] == 0) {
            $key = ($pay_status == 'live') ? $this->Util_model->get_option("paystack_live_pk") : $this->Util_model->get_option("paystack_test_pk");
        } elseif ($_POST['account'] == 1) {
            $key = ($pay_status == 'live') ? $this->Util_model->get_option("paystack_live_pk1") : $this->Util_model->get_option("paystack_test_pk1");
        }
        $return = array(
            "uid"       =>  userdata(UID),
            "email"     =>  $email,
            "key"       =>  $key
        );
        echo json_encode($return);
    }

    public function initialize_card_payment () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => false,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $tranx = $this->pay->pay_with_card(userdata(UID), $_POST['amount'], $_POST['reference'], 0, $_POST['save_card']);
            echo json_encode($tranx);
        }
    }

    public function initialize_other_payment () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => false,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $tranx = $this->pay->pay_with_other(userdata(UID), $_POST['amount'], $_POST['reference']);
            echo json_encode($tranx);
        }
    }

    public function verify_recipient () {
        $recipient = (is_numeric($_POST['recipient'])) ? ltrim($_POST['recipient'], 0) : $_POST['recipient'];
        $uid = $this->Util_model->get_info("user_profile", "uid", "WHERE email='$recipient' OR phone='$recipient' OR username='$recipient'");
        if ($uid == NULL) {
            echo "<span class='text-red'><b>Invalid:</b> Recipient not a valid user</span>";
        } else {
            echo "<span class='text-green'><b>Verified:</b> ".$this->Util_model->get_user_info($uid)."</span>";
        }
    }

    public function initialize_transfer () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->wallet_transfer(userdata(UID), $_POST['amount'], $_POST['recipient'], $_POST['pin']);
        }
    }

    public function submit_otp () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->submit_otp($_POST['otp']);
        }
    }

    public function submit_phone () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->submit_phone($_POST['phone']);
        }
    }

    public function auth_deposit () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => false,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $trans = $this->pay->auth_charge(userdata(UID), $_POST['card_id'], $_POST['amount'], $_POST['amount_to_pay']);
            echo json_encode($trans);
        }
    }

    public function delete_card () {
        $this->Db_model->update("user_card", ["status"=>0], "WHERE id=$_POST[id]");
        echo $this->General_model->user_cards(userdata(UID));
    }

    public function initialize_withdraw ($amount, $bank, $acct_num) {
        if ($this->Main_model->check_balance(userdata(UID), $amount)) {
            $ref = $this->Util_model->generate_id(10000000, 99999999, "user_wallet", "ref", "var", true, "fb")."_PMCKDU_1";
            if ($amount > 500000) {
                $fee = 200;
            } else if ($amount > 50000) {
                $fee = 100;
            } else {
                $fee = 50;
            }

            $withdraw = $this->fw->initialize_transfer($amount, $bank, $acct_num, $ref);
            if ($withdraw['status']) {
                $trans_data = $withdraw['data'];
                $data = array(
                    "uid"           =>  userdata(UID),
                    "reference"     =>  $ref,
                    "trans_id"      =>  $trans_data->id,
                    "amount"        =>  $amount,
                    "fee"           =>  $fee,
                    "acct_name"     =>  $trans_data->full_name,
                    "acct_num"      =>  $acct_num,
                    "bank"          =>  $bank
                );
                if ($this->Db_model->insert("user_withdraw", $data)) {
                    $transer_id = $this->Util_model->get_info("user_withdraw", "id", "WHERE uid=".userdata(UID)." AND status=0");
                    $wallet = $this->Main_model->add_to_wallet($fee, 0, userdata(UID), "Withdrawal fee", "Withdrawal fee", "Fee", "user_withdraw:$transer_id");
                    $wallet = $this->Main_model->add_to_wallet($amount, 0, userdata(UID), "Payout of withdrawn amount", "Payout of withdrawn amount", "Withdraw", "user_withdraw:$transer_id", $ref);
                    set_flashdata("msg", alert_msg($withdraw['msg'], "alert-success", 1));
                    redirect(base_url()."transactions");
                } else {
                    set_flashdata("msg", alert_msg($withdraw['msg'], "alert-danger", 1));
                    redirect(base_url()."withdraw");
                }
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance. <a href='".base_url()."deposit'>Deposit</a> to proceed.", "alert-danger", 1));
            redirect(base_url()."withdraw");
        }
    }

    public function initialize_auth_withdraw () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->auth_transfer_to_account($_POST['user_bank_id'], $_POST['amount']);
        }
    }

    public function get_beneficiaries () {
        $s = $this->Db_model->selectGroup("*", "user_beneficiaries", "WHERE uid=".userdata(UID)." AND status=1");
        if ($s->num_rows() == 0) {
            $return = "<p class='text-center text-red'>No beneficiary found</p>";
        } else {
            $return = "";
            foreach ($s->result_array() as $row) {
                $return .= "
                <div class='col-lg-3 col-md-3 col-sm-6 col-xs-12'>
                    <a href='javascript:;' class='btn btn-default btn-sm text-left btn-flat btn-block'>
                        <span onclick=''>
                            ".$this->Util_model->get_info("name", "user_main", "WHERE phone='$row[phone]'")."<br>
                            0
                        </span>
                        <span class='badge bg-red pull-right' onclick=''>
                            <i class='fa fa-trash'></i>
                        </span>
                    </a>

                </div>
                ";
            }
        }
    }

    public function bonus_to_wallet () {
        $bonus = $this->Main_model->get_balance(userdata(UID), false, true);
        if ($bonus > 0) {
            if ($this->Main_model->add_to_wallet($bonus, userdata(UID), 0, "Bonus conversion to wallet", "Bonus conversion to wallet", "bonus", "", "", 1)['return']) {
                $data = array(
                    "creditor"          =>  0,
                    "debitor"           =>  userdata(UID),
                    "amount"            =>  $bonus,
                    "type"              =>  "Referral bonus",
                    "ref"               =>  $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, 'fb'),
                    "status"            =>  1
                );
                $this->Db_model->insert("user_bonus", $data);
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Bonus funded to your wallet successfully.", "alert-success", 1));
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured while converting your bonus. Try again", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You don't have any bonus to covert", "alert-danger", 1));
        }
        redirect(base_url()."home");
    }

    public function book_funding () {
        $this->form_validation->set_rules("bank", "Bank", "trim|required");
        $this->form_validation->set_rules("name", "Sender name", "trim|required");
        $this->form_validation->set_rules("amount", "Amount", "trim|required|numeric");
        $this->form_validation->set_rules("reference", "Reference of Narration", "trim");

        if ($this->form_validation->run() == true) {
            if ($this->input->post('amount') <= 5000000) {
                $bank = $this->input->post('bank');
                $amount = $this->input->post('amount');
                $ref = $this->input->post('reference');
                $name = $this->input->post('name');
                $transRef = $this->Util_model->generate_id(11111111, 99999999, "funding", "ref", "var", true, "fb");
                
                $data = array(
                    "uid"       =>  userdata(UID),
                    "ref"       =>  $transRef,
                    "name"      =>  $name,
                    "bank"      =>  $bank,
                    "reference" =>  $ref,
                    "amount"    =>  $amount
                );
                if ($this->Db_model->insert("funding", $data)) {
                    $funding_id = $this->Util_model->get_info("funding", "id", "ORDER BY id DESC LIMIT 1");
                    $this->Main_model->add_to_wallet($amount, userdata(UID), 0, $ref, $ref, "Manual deposit", $funding_id, $transRef, 0);
                    $additional = "
                    <p><b>Username: </b>".$this->Util_model->get_user_info(userdata(UID), "username", "profile")."</p>
                    <p><b>Bank: </b>".$this->Util_model->get_info("banks", "name", "WHERE code='$bank'")."</p>
                    <p><b>Reference: </b>$ref</p>
                    <p><b>Amount: </b>$amount</p>
                    ";
                    //$this->Mail_model->send_notification("Bank Transfer", "A bank transfer has been made and it requires manual confirmation from you.", "<a href='".base_url()."admin/funding'>Complete Order</a>", $additional, "Admin");
                    //Notification
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Manual deposit booked successfully", "alert-success", 1));
                    redirect(base_url()."transactions");
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try later", "alert-danger", 1));
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Amount must not be greater than ".USD."5,000,000", "alert-danger", 1));
            }
        } else {
            set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."deposit");
    } 

    public function verify_bank_account () {
        $this->output->set_output($this->fw->verify_bank_account($_POST['bank'], $_POST['acct_num']));
    }

    public function validate_password () {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($_POST['password'])) {
            $this->output->set_output(true);
        } else {
            $this->output->set_output(false);
        }
    }

}