<?php
/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/24/2017
 * Time: 10:21 AM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Flutterwave_model extends CI_Model
{
    public $key;

    public function __construct()
    {
        parent::__construct();
        $this->test_key = $this->Util_model->get_option('flutterwave_test_sk');
        $this->live_key = $this->Util_model->get_option('flutterwave_live_sk');
        /* $this->live_subaccount = $this->Util_model->get_option('paystack_live_subaccount');
        $this->test_subaccount = $this->Util_model->get_option('paystack_test_subaccount'); */
        $this->status = $this->Util_model->get_option('flutterwave_status');
        $this->key = ($this->status == 'test') ? $this->test_key : $this->live_key;
        //$this->subaccount = ($this->status == 'test') ? $this->test_subaccount : $this->live_subaccount;
    }

    public function initialize_deposit ($amount, $uid=NULL, $ref=NULL, $success_redirect=NULL, $failure_redirect=NULL, $method="card,banktransfer,ussd,qr,barter", $currency="NGN", $customer=false) {
        $uid = ($uid == NULL) ? userdata(UID) : $uid;
        $ref = ($ref == NULL) ? $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, 'fb') : $ref;
        $success_redirect = ($success_redirect == NULL) ? base_url()."wallet/verify-deposit/" : $success_redirect;
        $failure_redirect = ($failure_redirect == NULL) ? base_url()."deposit" : $failure_redirect;
        $profile = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");

        $custom = array(
            "title" => "Make Payment", 
            "description" => "Pay for an item or deposit into your wallet in the ".SITE_TITLE, 
            "logo" => base_url()."assets/img/favicon.png"
        );
        if (!$customer) {
            $customer = array(
                "email" => $profile['email'],
                "phonenumber" => "0".$profile['phone'],
                "name" => $this->Util_model->get_user_info($uid)
            );
        }
        
        $data = array (
            "tx_ref"            =>  $ref,
            "amount"            =>  $amount,
            //"subaccount"        =>  $this->subaccount,
            "currency"          =>  $currency,
            "redirect_url"      =>  $success_redirect,
            "payment_options"   =>  $method,
            "customer"          =>  $customer,
            "customization"     =>  $custom
        );

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/payments",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer ".$this->key,
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            // there was an error contacting the Paystack API
            $return = array(
                "status"        =>  false,
                "msg"           =>  "<i class='fa fa-times-circle'></i> Curl returned error: $err"
            );

        } else {
            $tranx = json_decode($response);

            if ($tranx->status != "success") {
                // there was an error from the API
                $return = array(
                    "status"        =>  false,
                    "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured: " . $tranx->message
                );
            } else {
                $return = array(
                    "status"        =>  true,
                    "redirect"      =>  $tranx->data->link
                );
            }
        }

        return $return;
    }

    public function verify_bank_account ($bank, $acct_num) {
        $data = array(
            "account_number" => $acct_num,
            "account_bank"  => $bank
        );
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/accounts/resolve",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer ".$this->key,
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            // there was an error contacting the Paystack API
            $return = "Error validating account";
        } else {
            $tranx = json_decode($response);

            if ($tranx->status != "success") {
                // there was an error from the API
                $return = "";
            } else {
                $return = $tranx->data->account_name;
            }
        }

        return $return;
    }

    public function list_banks () {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/banks/NG",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer ".$this->key
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            // there was an error contacting the Paystack API
            $this->output->set_output("Error validating account");
        } else {
            $tranx = json_decode($response, true);

            if ($tranx['status'] != "success") {
                // there was an error from the API
                $this->output->set_output("Error validating account");
            } else {
                $data = $tranx['data'];
                foreach ($data as $row) {
                    if ($this->Util_model->row_count("banks", "WHERE code = '$row[code]'") == 0) {
                        $input = array(
                            "code"  =>  $row["code"],
                            "name"  =>  $row["name"],
                            "longcode" =>   0,
                            "country"  =>   161,
                            "status"   =>   1
                        );
                        $this->Db_model->insert("banks", $input);
                    } else {
                        $input = array(
                            "name"  =>  $row["name"],
                            "status"   =>   1
                        );
                        $this->Db_model->update("banks", $input, "WHERE code='$row[code]'");
                    }
                }
                
            }
        }
        
    }

    public function initialize_transfer ($amount, $bank, $acct_num, $ref="",  $narration="", $success_callback="", $failure_callback="",$currency="NGN", $debit_currency="NGN") {
        $ref = ($ref == "") ? $this->Util_model->generate_id(10000000, 99999999, "user_wallet", "ref", "var", true, "fb") : $ref;
        $success_callback = ($success_callback == "") ? base_url()."wallet/verify_transfer/" : base64_decode($success_callback);
        $failure_callback = ($failure_callback == "") ? base_url()."wallet/cancel-transfer/?ref=$ref" : base64_decode($failure_callback);
        $narration = ($narration == "") ? "Instant payout" : $narration;

        $data = array(
            "account_bank" => $bank,
            "account_number" => $acct_num,
            "amount" => $amount,
            "narration" => $narration,
            "currency" => $currency,
            "reference" => $ref,
            "callback" => $success_callback,
            "debit_currency" => $debit_currency
        );

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/transfers",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer ".$this->key,
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            // there was an error contacting the Flutterwave API
            $return = array(
                "status"        =>  false,
                "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured. Please try again later."
            );
        } else {
            $tranx = json_decode($response);

            if ($tranx->status != "success") {
                // there was an error from the API
                $return = array(
                    "status"        =>  false,
                    "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured while processing transfer. ".$tranx->message
                );
            } else {
                $return = array(
                    "status"        =>  true,
                    "msg"           =>  "<i class='fa fa-check-circle'></i> ".$tranx->message,
                    "data"          =>  $tranx->data
                );
            }
        }

        return $return;
        
    }

    public function verify_transfer ($id) {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/transfers/$id",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer ".$this->key,
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        $tranx = json_decode($response);

        if ($tranx->status == "success") {
            $return = strtolower($tranx->data->status);
        } else {
            $return = "failed";
        }

        return $return;
    }

    public function verify_transaction ($id) {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/transactions/$id/verify",  
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer ".$this->key,
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        $tranx = json_decode($response);

        if ($tranx->status == "success") {
            $return = strtolower($tranx->data->status);
        } else {
            $return = "failed";
        }

        return $return;
    }

}