<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 6/28/2017
 * Time: 8:41 AM
 */
class General_model extends CI_Model
{

    public function get_balance ($uid, $format=true, $today=true) {
        if (!$today) {
            $credit = $this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor=$uid AND status=1 AND date=CURDATE()");
            $balance = $credit;
        } else {
            $credit = $this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor=$uid AND status=1");
            $debit = $this->Util_model->sum_field("user_wallet", "amount", "WHERE debitor=$uid AND (status=1 OR status=0)");
            $balance = $credit - $debit;
        }
        if ($format) {
            return "$".number_format($balance,2);
        } else {
            return $balance;
        }
    }

    public function get_currency ($uid) {
        $currency = $this->Util_model->get_info("countries","currency","WHERE id=".$this->Util_model->get_user_info($uid,'country','profile'));
        return $currency;
    }

    public function investment_earnings ($uid) {
        $interest = 0;
        $s = $this->Db_model->selectGroup("*", "investment", "WHERE uid=$uid AND status=1");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $interest += ($row['amount'] > 0) ? get_percentage($row['amount'], $this->Util_model->get_info("plans", "roi", "WHERE id=$row[plan]")) : 0;
            }
        }
        return $interest;

    }

    private function referral_earnings ($uid) {
        $interest = 0;
        $s = $this->Db_model->selectGroup("*", "user_referre", "WHERE refID=$uid");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $sss = $this->Db_model->selectGroup("*", "investment", "WHERE uid=$row[uid] AND status=1");
                if ($sss->num_row() > 0) {
                    foreach ($sss->result_array() as $row2) {
                        $interest += $row2['amount'];
                    }
                }
            }
        }

        $interest = ($interest > 0) ? get_percentage($interest, $this->Util_model->get_option("referral_bonus")) : 0;
        return $interest;

    }

    private function country_earnings ($uid) {
        $interest = 0;
        $s = $this->Db_model->selectGroup("*", "country_cordinator", "WHERE uid=$uid");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ss = $this->Db_model->selectGroup("*", "user_profile", "WHERE country=$row[country]");
                if ($ss->num_rows() > 0) {
                    foreach ($ss->result_array() as $row1) {
                        $sss = $this->Db_model->selectGroup("*", "investment", "WHERE uid=$row1[uid] AND status=1");
                        if ($sss->num_rows() > 0) {
                            foreach ($sss->result_array() as $row2) {
                                $interest += $row2['amount'];
                            }
                        }
                    }
                }
            }
        }

        $interest = ($interest > 0) ? get_percentage($interest, $this->Util_model->get_option("country_bonus")) : 0;
        return $interest;
    }

    private function state_earnings ($uid) {
        $interest = 0;
        $s = $this->Db_model->selectGroup("*", "state_cordinators", "WHERE uid=$uid");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ss = $this->Db_model->selectGroup("*", "user_profile", "WHERE state=$row[state]");
                if ($ss->num_rows() > 0) {
                    foreach ($ss->result_array() as $row1) {
                        $sss = $this->Db_model->selectGroup("*", "investment", "WHERE uid=$row1[uid] AND status=1");
                        if ($sss->num_rows() > 0) {
                            foreach ($sss->result_array() as $row2) {
                                $interest += $row2['amount'];
                            }
                        }
                    }
                }
            }
        }

        $interest = ($interest > 0) ? get_percentage($interest, $this->Util_model->get_option("state_bonus")) : 0;
        return $interest;
    }

    private function regional_earnings ($uid) {
        $interest = 0;
        $s = $this->Db_model->selectGroup("*", "regional_cordinators", "WHERE uid=$uid");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ss = $this->Db_model->selectGroup("*", "user_profile", "WHERE region=$row[region]");
                if ($ss->num_rows() > 0) {
                    foreach ($ss->result_array() as $row1) {
                        $sss = $this->Db_model->selectGroup("*", "investment", "WHERE uid=$row1[uid] AND status=1");
                        if ($sss->num_rows() > 0) {
                            foreach ($sss->result_array() as $row2) {
                                $interest += $row2['amount'];
                            }
                        }
                    }
                }
            }
        }

        $interest = ($interest > 0) ? get_percentage($interest, $this->Util_model->get_option("region_bonus")) : 0;
        return $interest;
    }

    public function expected_earnings ($uid, $type="total") {
        $return = 0;
        switch ($type) {
            case "investment":
                $return = $this->investment_earnings($uid);
                break;
            case "referral":
                $return = $this->referral_earnings($uid);
                break;
            case "region":
                $return = $this->regional_earnings($uid);
                break;
            case "state":
                $return = $this->state_earnings($uid);
                break;
            case "country":
                $return = $this->country_earnings($uid);
                break;
            default:
                $return = $this->investment_earnings($uid) + $this->referral_earnings($uid) + $this->regional_earnings($uid) + $this->state_earnings($uid) + $this->country_earnings($uid);
                break;
        }

        return $return;
    }

    public function view_stars ($rate) {
        $rate = round($rate, 1);
        $star = "";
        for ($i=1; $i<=5; $i++) {
            if ($rate > 0.5) {
                $star .= "<i class='fa fa-star'></i>";
                $rate -= 1;
            } else if ($rate == 0.5) {
                $star .= "<i class='fa fa-star-half'></i>";
                $rate -= 1;
            } else {
                $star .= "<i class='fa fa-star-o'></i>";
            }
        }
        return $star;
    }

    public function user_cards ($uid) {
        $s = $this->Db_model->selectGroup("*", "user_card", "WHERE uid=$uid AND status=1");
        $user_card = "
                <ul class='todo-list'>
        ";
        if ($s->num_rows() > 0) {
            $count = 1;
            foreach ($s->result_array() as $row) {
                $s_bank = $this->Db_model->selectGroup("logo", "banks", "WHERE name='$row[bank]'");
                if ($s_bank->num_rows() > 0) {
                    $logo = $s_bank->row();
                    $logo = $logo->logo;
                } else {
                    $logo = "assets/img/banks/others.JPG";
                }
                $user_card .= "
                    <li>
                        <label>
                            <!-- radio box -->
                            <input type='radio' name='sel_card' value='$row[id]'>
                            <!-- todo text -->
                            <img src='".base_url()."$logo' title='$row[bank]' data-toggle='tooltip' style='width:25px; height:100%'>
                            <span class='text'> Ends with $row[last4]</span>
                            <!-- Emphasis label -->
                            <small class='label label-danger'>$row[card_type]</small>
                        </label>
                        <!-- General tools such as edit or delete-->
                        <div class='tools'>
                            <i class='fa fa-trash-o' onclick='delete_card(\"".base_url()."\", $row[id], $(this))'></i>
                        </div>
                    </li>
                ";
            }
        }
            $user_card .= "
                    <li>
                        <label>
                            <!-- radio box -->
                            <input type='radio' name='sel_card' checked value='new'>
                            <!-- todo text -->
                            <span class='text'>Pay with new card</span>
                        </label>
                    </li>
                </ul>
        ";
        return $user_card;
    }

    public function user_banks ($uid, $deposit=0) {
        $s = $this->Db_model->selectGroup("*", "user_bank", "WHERE uid=".userdata(UID)." AND status=1");
        $user_bank = "";
        $count = 0;
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                if ($deposit == 1) {
                    if ($this->Util_model->row_count("banks", "WHERE id=$row[bank] AND active=1") == 1) {
                        $check = ($count == 1)?"checked":"";
                        $bank = $this->Util_model->get_info("banks", "*", "WHERE id='$row[bank]'");
                        $user_bank .= "
                        <div class='row text-bold pad'>
                            <div class='col-lg-1 col-md-1 col-sm-1 col-xs-2'>
                                <input type='radio' name='sel_card' value='$row[id]' $check>
                            </div>
                            <div class='col-lg-6 col-md-6 col-sm-6 col-xs-6'>
                                <img src='".base_url()."$bank[logo]' width='30' height='20' class='right-1x'>
                                $bank[name] ****
                            </div>
                            <div class='col-lg-5 col-md-5 col-sm-5 col-xs-4'>
                                ******".substr($row['account_num'], -4)."
                                <i class='fa fa-trash text-red pointer-cursor pull-right left-1x' title='Delete bank' data-toggle='tooltip' onclick='if (confirm(\"Are you sure you want to delete this bank?\")) { window.location = \"".base_url()."profile/delete-bank/$row[id]\" }'></i>
                            </div>
                        </div>
                        <hr>
                        ";
                        $count++;
                    }
                } else {
                    $check = ($count == 1)?"checked":"";
                    $bank = $this->Util_model->get_info("banks", "*", "WHERE id='$row[bank]'");
                    $user_bank .= "
                    <div class='row text-bold pad'>
                        <div class='col-lg-1 col-md-1 col-sm-1 col-xs-2'>
                            <input type='radio' name='sel_card' value='$row[id]' $check>
                        </div>
                        <div class='col-lg-6 col-md-6 col-sm-6 col-xs-6'>
                            <img src='".base_url()."$bank[logo]' width='30' height='20' class='right-1x'>
                            $bank[name] ****
                        </div>
                        <div class='col-lg-5 col-md-5 col-sm-5 col-xs-4'>
                            ******".substr($row['account_num'], -4)."
                            <i class='fa fa-trash text-red pointer-cursor pull-right left-1x' title='Delete bank' data-toggle='tooltip' onclick='if (confirm(\"Are you sure you want to delete this bank?\")) { window.location = \"".base_url()."profile/delete-bank/$row[id]\" }'></i>
                        </div>
                    </div>
                    <hr>
                    ";
                    $count++;
                }
            }
        }
        if ($count == 0) {
            $user_bank =  "
                <div class='row pad'>
                    <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12'>
                        <div class='well'>No bank added yet. Use a new bank</div>
                    </div>
                </div>
            ";
        }
        return $user_bank;
    }

    public function view_package_button ($package) {
        if (isset($_SESSION[UID])) {
            $user_pack = $this->Util_model->get_user_info(userdata(UID), "package", "profile");
            if ($user_pack == $package) {
                $btn = '<button class="btn btn-success btn-flat btn-block" disabled="disabled">Active</button>';
            } else {
                $btn = '<a href="' . base_url() . 'packages/' . $package . '" class="btn btn-primary btn-flat btn-block">Upgrade</a>';
            }
        } else {
            $btn = '<a href="' . base_url() . 'sign-up" class="btn btn-success btn-flat" style="width: 100%">Sign Up</a>';
            set_flashdata('redirect', base_url()."packages");
        }
        echo $btn;
    }
}
?>