<?php

/**
 * Created by PhpStorm.
 * Mr. Winz
 * Date: 5/24/2017
 * Time: 10:21 AM
 */

defined('BASEPATH') or exit('No direct script access allowed');

class Main_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function send_token($uid, $type)
    {
        if ($this->Db_model->row_count("user_auth", "WHERE uid=$uid AND type='$type'") > 0) {
            $this->Db_model->delete("user_auth", "WHERE uid=$uid AND type='$type'");
        }
        $token = $this->Util_model->generate_id(111111, 999999, "user_auth", "auth");
        $inputs = array(
            "uid"           =>  $uid,
            "auth"          =>  $token,
            "type"          =>  $type
        );
        if ($this->Db_model->insert("user_auth", $inputs)) {
            return true;
        } else {
            return false;
        }
    }

    public function verify_token($uid, $auth, $type)
    {
        if ($this->Db_model->row_count("user_auth", "WHERE uid=$uid AND auth='$auth' AND type='$type'") > 0) {
            $this->Db_model->delete("user_auth", "WHERE uid=$uid AND type='$type'");
            return true;
        } else {
            return false;
        }
    }

    public function user_role($role, $output = 'plain')
    {
        switch ($role) {
            case 0:
                switch ($output) {
                    case 'plain':
                        $return = 'Pre-register';
                        break;
                    case 'label':
                        $return = "<span class='label label-danger'>Pre-register</span>";
                        break;
                }
                break;
            case 1:
                switch ($output) {
                    case 'plain':
                        $return = 'Free';
                        break;
                    case 'label':
                        $return = "<span class='badge bg-gradient-danger'>Free</span>";
                        break;
                }
                break;
            case 2:
                switch ($output) {
                    case 'plain':
                        $return = 'Pro';
                        break;
                    case 'label':
                        $return = "<span class='badge bg-gradient-green'>Pro</span>";
                        break;
                }
                break;
            case 3:
                switch ($output) {
                    case 'plain':
                        $return = 'Pro+';
                        break;
                    case 'label':
                        $return = "<span class='badge bg-gradient-blue'>Pro+</span>";
                        break;
                }
                break;
            case 4:
                switch ($output) {
                    case 'plain':
                        $return = 'Pro++';
                        break;
                    case 'label':
                        $return = "<span class='badge bg-gradient-indigo'>Pro++</span>";
                        break;
                }
                break;
        }
        return $return;
    }

    public function get_balance($uid, $format = true, $bonus = false, $this_month = false)
    {
        $month = ($this_month) ? "AND date LIKE '" . date('Y-m') . "%'" : "";
        if (!$bonus) {
            $credit = $this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor=$uid AND status=1 $month");
            $debit = $this->Util_model->sum_field("user_wallet", "amount", "WHERE debitor=$uid AND (status=1 OR status=0) $month");
            $debit += $this->Util_model->sum_field("p2p_orders", "amount", "WHERE seller_uid=" . userdata(UID)." AND status <= 2");
        } else {
            $credit = $this->Util_model->sum_field("user_bonus", "amount", "WHERE uid=$uid AND type='credit' AND status=1 $month");
            $debit = $this->Util_model->sum_field("user_bonus", "amount", "WHERE uid=$uid AND type='debit' AND status=1 $month");
        }
        $balance = $credit - $debit;
        if ($format) {
            return NGN . number_format($balance, 2);
        } else {
            return $balance;
        }
    }

    public function get_saving_balance($uid, $format = true, $this_month = false)
    {
        $month = ($this_month) ? "AND date LIKE '" . date('Y-m') . "%'" : "";
        if (!$this_month) {
            $credit = $this->Util_model->sum_field("user_wallet_saving", "amount", "WHERE creditor=$uid AND status=1 $month");
            $debit = $this->Util_model->sum_field("user_wallet_saving", "amount", "WHERE debitor=$uid AND (status=1 OR status=0) $month");
        } else {
            $credit = $this->Util_model->sum_field("user_wallet_saving", "amount", "WHERE creditor=$uid AND status=1");
            $debit = $this->Util_model->sum_field("user_wallet_saving", "amount", "WHERE debitor=$uid AND (status=1 OR status=0)");
        }
        $balance = $credit - $debit;
        if ($format) {
            return NGN . number_format($balance);
        } else {
            return $balance;
        }
    }

    public function get_investment_balance($uid, $format = true, $this_month = false)
    {
        $month = ($this_month) ? "AND date LIKE '" . date('Y-m') . "%'" : "";
        if (!$this_month) {
            $credit = $this->Util_model->sum_field("user_wallet_investment", "amount", "WHERE creditor=$uid AND status=1 $month");
            $debit = $this->Util_model->sum_field("user_wallet_investment", "amount", "WHERE debitor=$uid AND (status=1 OR status=0) $month");
        } else {
            $credit = $this->Util_model->sum_field("user_wallet_investment", "amount", "WHERE creditor=$uid AND status=1");
            $debit = $this->Util_model->sum_field("user_wallet_investment", "amount", "WHERE debitor=$uid AND (status=1 OR status=0)");
        }
        $balance = $credit - $debit;
        if ($format) {
            return NGN . number_format($balance);
        } else {
            return $balance;
        }
    }

    public function get_project_balance($uid, $format = true, $this_month = false)
    {
        $month = ($this_month) ? "AND date LIKE '" . date('Y-m') . "%'" : "";
        if (!$this_month) {
            $credit = $this->Util_model->sum_field("user_wallet_project", "amount", "WHERE creditor=$uid AND status=1 $month");
            $debit = $this->Util_model->sum_field("user_wallet_project", "amount", "WHERE debitor=$uid AND (status=1 OR status=0) $month");
        } else {
            $credit = $this->Util_model->sum_field("user_wallet_project", "amount", "WHERE creditor=$uid AND status=1");
            $debit = $this->Util_model->sum_field("user_wallet_project", "amount", "WHERE debitor=$uid AND (status=1 OR status=0)");
        }
        $balance = $credit - $debit;
        if ($format) {
            return NGN . number_format($balance);
        } else {
            return $balance;
        }
    }

    public function get_bonus_balance($uid, $format = true)
    {
        $credit = $this->Util_model->sum_field("user_bonus", "amount", "WHERE uid=$uid AND type='credit' AND status=1");
        $debit = $this->Util_model->sum_field("user_bonus", "amount", "WHERE uid=$uid AND type='debit' AND (status=1 OR status=0)");
        $balance = $credit - $debit;
        if ($format) {
            return NGN . number_format($balance, 2);
        } else {
            return $balance;
        }
    }

    public function get_worth($uid, $format = true, $this_month = false, $type="indirect")
    {
        $month = ($this_month) ? "AND date LIKE '" . date('Y-m') . "%'" : "";
        $type = ($type == "direct") ? "AND type='direct'" : "";
        if (!$this_month) {
            $balance = $this->Util_model->sum_field("user_worth", "amount", "WHERE uid=$uid AND status=1 $type $month");
        } else {
            $balance = $this->Util_model->sum_field("user_worth", "amount", "WHERE uid=$uid AND status=1 $type");
        }
        if ($format) {
            return NGN . number_format($balance);
        } else {
            return $balance;
        }
    }

    public function get_point($uid, $format = true, $month = 0)
    {
        if ($month >= 1) {
            $step = $month;
            $search = "AND (";
            for ($i = 1; $i <= $step; $i++) {
                $month = next_prev_date(date_time(), "month", 0, $i, "Y-m");
                $search .= "date LIKE '$month%' OR ";
            }
            $search = rtrim($search, "OR ") . ")";
            $point = $this->Util_model->sum_field("user_point", "point", "WHERE uid=$uid AND status=1 $search");
        } else {
            $point = $this->Util_model->sum_field("user_point", "point", "WHERE uid=$uid AND status=1");
        }
        if ($format) {
            return number_format($point);
        } else {
            return $point;
        }
    }

    public function check_balance($uid, $amount, $bonus = false)
    {
        if (!$bonus) {
            $balance = $this->get_balance($uid, false);
        } else {
            $balance = $this->get_balance($uid, false, true);
        }
        if ($amount > $balance) {
            $this->Util_model->create_redirect();
            $top_up = $amount - $balance;
            //set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance. Top up balance to proceed.", "alert-danger", 1));
            set_flashdata('amount', $top_up);
            return false;
        } else {
            return true;
        }
    }

    public function get_network($prefix)
    {
        $prefix = substr($prefix, 0, 4);
        $prefix = ltrim($prefix, "0");
        $s = $this->Db_model->selectGroup("*", "networks");
        $return = ["net_id" => 0, "network" => "Invalid", "discount" => 0];
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $prefixs = explode(",", $row['prefix']);
                if (in_array($prefix, $prefixs)) {
                    $discount = $this->Util_model->get_info("airtime_discount", "discount", "WHERE network_id=$row[id]");
                    $return = ["net_id" => $row['id'], "network" => $row['network'], "discount" => $discount];
                    break;
                }
            }
        }
        return $return;
    }

    public function add_to_wallet($amount, $creditor, $debitor, $creditor_desc = "", $debitor_desc = "", $type = "deposit", $extra = "", $ref = "", $status = 0, $table="user_wallet")
    {
        ##################################################################
        #                                                                #
        # to: The receiver of the fund (if it's a debit)                 #
        # desc: The description of the fund ie. from the card a deposit  #
        # was made, the reason for the credit etc.                       #
        # type: The type of transaction it was ie. Credit or Debit       #
        # ref: A unique ID used in identifying a transaction             #
        ##################################################################
        $ref = ($ref == "") ? $ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, 'fb') : $ref;
        $input = array(
            "amount" => $amount,
            "creditor" => $creditor,
            "debitor" => $debitor,
            "type" => $type,
            "extra" => $extra,
            "ref" => $ref,
            "status" => $status
        );

        if ($table == "user_wallet") {
            $input["creditor_desc"] = $creditor_desc;
            $input["debitor_desc"] = $debitor_desc;
        } else {
            $input["description"] = $creditor_desc;
        }

        if ($this->Db_model->insert($table, $input)) {
            return array("return" => true, "reference" => $ref);
        } else {
            return array("return" => false, "reference" => NULL);
        }
    }

    public function add_to_bonus($amount, $uid, $type = "Pairing", $status = 0, $cid = '')
    {
        ##################################################################
        #                                                                #
        # to: The receiver of the fund (if it's a debit)                 #
        # desc: The description of the fund ie. from the card a deposit  #
        # was made, the reason for the credit etc.                       #
        # type: The type of transaction it was ie. Credit or Debit       #
        # ref: A unique ID used in identifying a transaction             #
        ##################################################################

        $input = array(
            "cid" => $cid,
            "amount" => $amount,
            "uid" => $uid,
            "type" => $type,
            "status" => $status
        );

        if ($this->Db_model->insert("user_worth", $input)) {
            /*if ($creditor > 0) {
                $this->add_to_wallet_ex($amount, $creditor, "credit", $ref);
            }
            if ($debitor > 0) {
                $this->add_to_wallet_ex($amount, $debitor, "debit", $ref);
            }*/
            return true;
        } else {
            return false;
        }
    }

    public function add_to_worth($amount, $uid, $type = "Pairing", $status = 0, $cid = '')
    {
        ##################################################################
        #                                                                #
        # to: The receiver of the fund (if it's a debit)                 #
        # desc: The description of the fund ie. from the card a deposit  #
        # was made, the reason for the credit etc.                       #
        # type: The type of transaction it was ie. Credit or Debit       #
        # ref: A unique ID used in identifying a transaction             #
        ##################################################################

        $input = array(
            "cid" => $cid,
            "amount" => $amount,
            "uid" => $uid,
            "type" => $type,
            "status" => $status
        );

        if ($this->Db_model->insert("user_worth", $input)) {
            /*if ($creditor > 0) {
                $this->add_to_wallet_ex($amount, $creditor, "credit", $ref);
            }
            if ($debitor > 0) {
                $this->add_to_wallet_ex($amount, $debitor, "debit", $ref);
            }*/
            return true;
        } else {
            return false;
        }
    }

    public function give_coupon($uid, $coupon, $relate)
    {
        $this->Db_model->insert("user_coupon", [
            "uid"       =>  $uid,
            "relate"    =>  $relate,
            "coupon"    =>  $coupon,
            "used"      =>  0,
            "date_added" =>  date_time(),
            "date_used" =>  date_time()
        ]);
    }

    //#####################DATA COUPON######################################################################################
    public function verify_data_coupon($uid, $coupon, $bundle)
    {
        if ($this->Util_model->row_count("data_coupon", "WHERE code='$coupon' AND status=1") == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Coupon doesn't exist or has expired", "alert-danger", 1));
            return false;
        } else if ($this->Util_model->row_count("user_coupon", "WHERE uid=$uid AND coupon='$coupon' AND relate='data_coupon' AND used=0") == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You are not eligible to use this coupon", "alert-danger", 1));
            return false;
        } else {
            $d_coupon = $this->Util_model->get_info("data_coupon", "*", "WHERE code='$coupon'");
            if ($d_coupon['bundle'] != $bundle) {
                $network = $this->Util_model->get_info("networks", "network", "WHERE id=" . $this->Util_model->get_info("data_bundle", "network_id", "WHERE id=$d_coupon[bundle]"));
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> This coupon can only be used for <b>$network " . $this->Util_model->get_info("data_bundle", "bundle", "WHERE id=$d_coupon[bundle]") . "</b> data bundle", "alert-danger", 1));
                return false;
            } else if ($d_coupon['usage_limit'] == 0) {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> This coupon has exceeded it's maximum usage limit", "alert-danger", 1));
                return false;
            } else {
                return true;
            }
        }
    }

    public function calculate_data_coupon_discount($coupon, $amount)
    {
        $coupon = $this->Util_model->get_info("data_coupon", "discount, type", "WHERE code='$coupon'");
        if ($coupon['type'] == "percentage") {
            $discount = get_percentage($amount, $coupon['discount']);
        } else {
            $discount = $coupon['discount'];
        }
        $amount -= $discount;
        return ['amount' => $amount, 'discount' => $discount];
    }

    public function apply_data_coupon($uid, $coupon)
    {
        if ($this->Db_model->update("user_coupon", array("used" => 1, "date_used" => date_time()), "WHERE uid=$uid AND relate='data_coupon' AND coupon='$coupon'")) {
            $usage = $this->Util_model->get_info("data_coupon", "usage_limit", "WHERE code='$coupon'");
            $this->Db_model->update("data_coupon", array("usage_limit" => $usage - 1), "WHERE code='$coupon'");
            return true;
        } else {
            return false;
        }
    }
    //#########################################################################################################################

    //#####################AIRTIME COUPON######################################################################################
    public function verify_airtime_coupon($uid, $coupon, $net_id, $amount)
    {
        if ($this->Util_model->row_count("user_coupon", "WHERE uid=$uid AND coupon='$coupon' AND relate='airtime_coupon' AND used=0") == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You are not eligible to use this coupon", "alert-danger", 1));
            return false;
        } else if ($this->Util_model->row_count("airtime_coupon", "WHERE code='$coupon' AND status=1") == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Coupon doesn't exist or has expired", "alert-danger", 1));
            return false;
        } else if ($this->Util_model->row_count("airtime_coupon", "WHERE code='$coupon' AND network_id=$net_id") == 0 && $this->Util_model->get_info("airtime_coupon", "network_id", "WHERE code='$coupon' AND network_id=$net_id") != 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Coupon cannot be used for the selected network", "alert-danger", 1));
            return false;
        } else if ($min_amount = $this->Util_model->get_info("airtime_coupon", "min_amount", "WHERE code='$coupon'") > $amount) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Coupon cannot be used for amount below N$min_amount", "alert-danger", 1));
            return false;
        } else if ($this->Util_model->get_info("airtime_coupon", "usage_limit", "WHERE code='$coupon'") == 0) {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> This coupon has exceeded it's maximum usage limit", "alert-danger", 1));
            return false;
        } else {
            return true;
        }
    }

    public function calculate_airtime_coupon_discount($coupon, $amount)
    {
        $coupon = $this->Util_model->get_info("airtime_coupon", "discount, type", "WHERE code='$coupon'");
        if ($coupon['type'] == "percentage") {
            $discount = get_percentage($amount, $coupon['discount']);
        } else {
            $discount = $coupon['discount'];
        }
        $amount -= $discount;
        return ['amount' => $amount, 'discount' => $discount];
    }

    public function apply_airtime_coupon($uid, $coupon)
    {
        if ($this->Db_model->update("user_coupon", array("used" => 1, "date_used" => date_time()), "WHERE uid=$uid AND relate='airtime_coupon' AND coupon='$coupon'")) {
            $usage = $this->Util_model->get_info("airtime_coupon", "usage_limit", "WHERE code='$coupon'");
            $this->Db_model->update("airtime_coupon", array("usage_limit" => $usage - 1), "WHERE code='$coupon'");
            return true;
        } else {
            return false;
        }
    }
    //#########################################################################################################################

    //###########################API CALL TO QUERY CLUBKONNECT ORDER#########
    public function query_transaction ($order_id) {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQueryV1.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);
            if ($request['status'] == 'ORDER_COMPLETED') {
                $return = 1;
            } else if ($request['status'] == 'ORDER_CANCELLED') {
                $return = 2;
            } else {
                $return = 0;
            }
        }
        return $return;
    }
    //#######################################################################

    //############################API CALL TO DATA VENDOR##################################
    public function clubkonnect_data_request ($uid, $recipient, $bund_id, $amount_paid, $discount=0, $ref="", $coupon="") {
        $bundle = $this->Util_model->get_info("data_bundle", "*", "WHERE id=".$bund_id);
        $network = $this->Util_model->get_info("networks", "*", "WHERE id=$bundle[network_id]");
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");
        $plan = $bundle['code'];

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIDatabundleV1.asp?UserID=$api_user_id&APIKey=$api_key&MobileNetwork=$network[code]&DataPlan=$plan&MobileNumber=$recipient";
            $request = curl_get_request($url);
            $country = $this->Util_model->get_info("countries", "*", "WHERE id=$network[country]");

            if ($request['status'] == 'ORDER_RECEIVED') {
                if ($this->Db_model->insert("data_purchase", [
                    "uid" => $uid,
                    "order_id" => $request['orderid'],
                    "reference" => $ref,
                    "recipient" => $recipient,
                    "network" => $bundle['network_id'],
                    "bundle" => $bund_id,
                    "bundle_amount" => $bundle['amount'],
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "currency_rate" => $this->Util_model->conversion_rate('NGNT', $country['currency']),
                    "NGN_amount" => $this->Util_model->currency_converter($amount_paid, $country['currency'], 'NGNT'),
                    "coupon" => $coupon,
                    "status" => 0,
                    "status_date" => date_time()
                ])
                ) {
                    $pur_id = $this->Util_model->get_info("data_purchase", "id", "ORDER BY id DESC LIMIT 1");
                    $this->Db_model->update("user_wallet", ["status" => 1, "extra" => "data_purchase:id=$pur_id"], "WHERE ref='$ref'");
                    $return = [
                        "status" => true,
                        "message" => "Your order has been received and is being processed",
                        "order_id" => $request['orderid'],
                        "id" => $pur_id
                    ];
                } else {
                    $return = [
                        "status" => false,
                        "message" => "An error occurred during process. Try again later"
                    ];
                }
            } else if ($request['status'] == 'INVALID_DATAPLAN') {
                $return = [
                    "status" => false,
                    "message" => "The data bundle requested is not available at the moment. Try another data bundle"
                ];
            } else if ($request['status'] == 'INVALID_RECIPIENT') {
                $return = [
                    "status" => false,
                    "message" => "The recipient number is invalid. Try again"
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Unable to complete transaction at the moment. Try again later"
                ];
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function initialize_data_request($uid, $recipient, $bund_id, $amount_paid, $discount = 0, $ref = "", $coupon = "")
    {
        $bundle = $this->Util_model->get_info("data_bundle", "*", "WHERE id='$bund_id'");
        $network = "$bundle[network_id]";
        $plan = $bundle['id'];

        if (is_connected()) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://smeplug.ng/api/v1/data/purchase",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => "{\n\t\"network_id\": $network,\n\t\"plan_id\": $plan,\n\t\"phone\": \"$recipient\"\n}",
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer " . $this->Util_model->get_option("sme_plug_sk")
                ),
            ));

            $response = json_decode(curl_exec($curl), true);

            curl_close($curl);

            if ($response['status']) {
                if ($this->Db_model->insert("data_purchase", [
                    "uid" => $uid,
                    "order_id" => $response['data']['reference'],
                    "reference" => $ref,
                    "recipient" => $recipient,
                    "network" => $bundle['network_id'],
                    "bundle" => $bund_id,
                    "bundle_amount" => $bundle['amount'],
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "coupon" => $coupon,
                    "status" => 1,
                    "status_date" => date_time()
                ])) {
                    $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                    $return = [
                        "status" => true,
                        "message" => $response['data']['msg'],
                        "order_id" => $response['data']['reference']
                    ];
                } else {
                    $return = [
                        "status" => false,
                        "message" => "An error occurred during process. Try again later"
                    ];
                }
            } else {
                $return = [
                    "status" => false,
                    "message" => $response['msg']
                ];
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function query_data_transaction($order_id)
    {
        $data_pur = $this->Util_model->get_info("data_purchase", "*", "WHERE order_id=$order_id");
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] == 'ORDER_COMPLETED') {
                $this->Db_model->update("data_purchase", ["status" => 1, "status_date" => date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$data_pur[reference]'");
            }
        }
    }

    public function update_data_transaction ($order_id=0) {
        if ($order_id > 0) {
            $status = $this->query_transaction($order_id);
            $ref = $this->Util_model->get_info("data_purchase", "reference", "WHERE order_id=$order_id");
            if ($status == 1) {
                $this->Db_model->update("data_purchase", ["status"=>1, "status_date"=>date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status"=>1], "WHERE ref='$ref'");
            } else if ($status == 2) {
                $this->Db_model->update("data_purchase", ["status"=>2, "status_date"=>date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$ref'");
            }
        } else {
            $s = $this->Db_model->selectGroup("*", "data_purchase", "WHERE status=0");
            if ($s->num_rows() > 0) {
                foreach ($s->result_array() as $row) {
                    $status = $this->query_transaction($row['order_id']);
                    if ($status == 1) {
                        $this->Db_model->update("data_purchase", ["status"=>1, "status_date"=>date_time()], "WHERE order_id=$row[order_id]");
                        $this->Db_model->update("user_wallet", ["status"=>1], "WHERE ref='$row[reference]'");
                    } else if ($status == 2) {
                        $this->Db_model->update("data_purchase", ["status"=>2, "status_date"=>date_time()], "WHERE order_id=$row[order_id]");
                        $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$row[reference]'");
                    }
                }
            }
        }
        
    }

    public function cancel_data_transaction ($order_id) {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $status = $this->query_transaction($order_id);

            if ($status != 1) {
                $url = "https://www.nellobytesystems.com/APICancelV1.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
                $request = curl_get_request($url);
                if ($request['status'] == 'ORDER_CANCELLED') {
                    $ref = $this->Util_model->get_info("data_purchase", "reference", "WHERE order_id=$order_id");
                    $this->Db_model->update("data_purchase", ["status"=>2], "WHERE order_id=$order_id");
                    $this->Db_model->update("user_wallet", ["status" => 2], "WHERE ref='$ref'");
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Transaction cancelled successfully", "alert-success", 1));
                    return true;
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured during cancellation. Try again later.", "alert-danger", 1));
                    return false;
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The data has already been delivered", "alert-danger", 1));
                return false;
            }
        }
    }

    public function initialize_data_request_mannual($uid, $recipient, $bund_id, $amount_paid, $discount = 0, $ref = "", $coupon = "")
    {
        $bundle = $this->Util_model->get_info("data_bundle", "*", "WHERE id='$bund_id'");
        /*$api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");*/
        $network = "0$bundle[network_id]";
        $plan = $bundle['unit'];
        $order_id = $this->Util_model->generate_id(11111111, 99999999, 'data_purchase', 'order_id');

        if (is_connected()) {
            /*$url = "https://www.nellobytesystems.com/APIBuy.asp?UserID=$api_user_id&APIKey=$api_key&MobileNetwork=$network&DataPlan=$plan&MobileNumber=$recipient";
            $request = curl_get_request($url);*/

            //if ($request['status'] == 'ORDER_RECEIVED' || $request['status'] == 'ORDER_ONHOLD') {
            if ($this->Db_model->insert("data_purchase", [
                "uid" => $uid,
                "order_id" => $order_id,
                "reference" => $ref,
                "recipient" => $recipient,
                "network" => $bundle['network_id'],
                "bundle" => $bund_id,
                "bundle_amount" => $bundle['amount'],
                "amount_paid" => $amount_paid,
                "discount" => $discount,
                "coupon" => $coupon,
                "status" => 0,
                "status_date" => date_time()
            ])) {
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                $additional = "<p><b>Order ID: </b>$order_id</p>";
                $this->Mail_model->send_notification("Data Notification", "A data purchase request has been made and it requires manual confirmation from you.", "<a href='" . base_url() . "admin/data-orders'>Complete Order</a>", $additional, "Admin");
                //Notification
                $return = [
                    "status" => true,
                    "message" => "Your order has been received and is under process.",
                    "order_id" => $order_id
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "An error occurred during process. Try again later"
                ];
            }
            /*} else if ($request['status'] == 'INVALID_DATAPLAN') {
                $return = [
                    "status" => false,
                    "message" => "The data bundle requested is not available at the moment. Try another data bundle"
                ];
            } else if ($request['status'] == 'INVALID_RECIPIENT') {
                $return = [
                    "status" => false,
                    "message" => "The recipient number is invalid. Try again"
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Unable to complete transaction at the moment. Try again later"
                ];
            }*/
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    //####################################################################################

    //#####################API CALL TO AIRTIME TOP  VENDOR#############################
    public function initialize_airtime_request($uid, $net_id, $amount, $recipient, $amount_paid = 0, $discount = 0, $ref = "", $coupon = "")
    {
        if (is_connected()) {
            $headers = [
                "email: " . $this->Util_model->get_option('ringo_email'),
                "password: " . $this->Util_model->get_option('ringo_password'),
                "content-type: application/json",
                "cache-control: no-cache"

            ];
            $body = [
                "serviceCode" => "VAR",
                "msisdn" => $recipient,
                "amount" => $amount,
                "request_id" => $ref,
                "product_id" => $this->Util_model->get_info("networks", "product_id", "WHERE id=$net_id")
            ];
            $request  = get_curl_request("https://www.api.ringo.ng/api/agent/p2", 'POST', $headers, $body);

            if ($request['status'] == 200) {
                $this->Db_model->insert("airtime_purchase", [
                    "uid" => $uid,
                    "order_id" => $request['TransRef'],
                    "reference" => $ref,
                    "recipient" => $recipient,
                    "network" => $net_id,
                    "amount" => $amount,
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "coupon" => $coupon,
                    "status" => 1,
                    "status_date" => date_time()
                ]);
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                $return = [
                    "status" => true,
                    "message" => "Your order has been received and it is in process.",
                    "order_id" => $request['TransRef']
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Your transaction cannot be completed at the moment. Try again later"
                ];
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function initialize_airtime_request_smeplug($uid, $net_id, $amount, $recipient, $amount_paid = 0, $discount = 0, $ref = "", $coupon = "")
    {
        if (is_connected()) {
            $headers = [
                "authorization: Bearer " . $this->Util_model->get_option("sme_plug_sk"),
                "content-type: application/json",
                "cache-control: no-cache"

            ];
            $body = [
                "network_id" => $net_id,
                "phone_number" => $recipient,
                "amount" => $amount
            ];
            $request  = get_curl_request("https://smeplug.ng/api/v1/vtu", 'POST', $headers, $body);

            if ($request['status']) {
                $this->Db_model->insert("airtime_purchase", [
                    "uid" => $uid,
                    "order_id" => $request['data']['reference'],
                    "reference" => $ref,
                    "recipient" => $recipient,
                    "network" => $net_id,
                    "amount" => $amount,
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "coupon" => $coupon,
                    "status" => 1,
                    "status_date" => date_time()
                ]);
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                $return = [
                    "status" => true,
                    "message" => "Airtime top up to $recipient was successful",
                    "order_id" => $request['data']['reference']
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Your transaction cannot be completed at the moment. Try again later"
                ];
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function initialize_clubkonnect_airtime_request ($uid, $net_id, $amount, $recipient, $amount_paid=0, $discount=0, $ref="", $coupon="") {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");
        $network = $this->Util_model->get_info("networks", "*", "WHERE id=$net_id");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIAirtimeV1.asp?UserID=$api_user_id&APIKey=$api_key&MobileNetwork=$network[code]&Amount=$amount&MobileNumber=$recipient";
            $request = curl_get_request($url);

            if ($request['status'] == 'ORDER_RECEIVED' || $request['status'] == 'ORDER_ONHOLD') {
                $country = $this->Util_model->get_info("countries", "*", "WHERE id=$network[country]");
                $this->Db_model->insert("airtime_purchase", [
                    "uid" => $uid,
                    "order_id" => $request['orderid'],
                    "reference" => $ref,
                    "recipient" => $recipient,
                    "network" => $net_id,
                    "amount" => $amount,
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "currency_rate" => $this->Util_model->conversion_rate('NGNT', $country['currency']),
                    "NGN_amount" => $this->Util_model->currency_converter($amount_paid, $country['currency'], 'NGNT'),
                    "coupon" => $coupon,
                    "status" => 0,
                    "status_date" => date_time()
                ]);
                $pur_id = $this->Util_model->get_info("airtime_purchase", "id", "ORDER BY id DESC LIMIT 1");

                $this->Db_model->update("user_wallet", ["status" => 1, "extra" => "airtime_purchase:id=$pur_id"], "WHERE ref='$ref'");
                $return = [
                    "status" => true,
                    "message" => "Your airtime request has been received and it's under progress",
                    "order_id" => $request['orderid'],
                    "id" => $pur_id
                ];
            } else if ($request['status'] == 'INVALID_RECIPIENT') {
                $return = [
                    "status" => false,
                    "message" => "The recipient number is invalid. Try again"
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Your transaction cannot be completed at the moment. Try again later"
                ];
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function update_airtime_transaction ($order_id=0) {
        if ($order_id > 0) {
            $status = $this->query_transaction($order_id);
            $ref = $this->Util_model->get_info("airtime_purchase", "reference", "WHERE order_id=$order_id");
            if ($status == 1) {
                $this->Db_model->update("airtime_purchase", ["status"=>1, "status_date"=>date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status"=>1], "WHERE ref='$ref'");
            } else if ($status == 2) {
                $this->Db_model->update("airtime_purchase", ["status"=>2, "status_date"=>date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$ref'");
            }
        } else {
            $s = $this->Db_model->selectGroup("*", "airtime_purchase", "WHERE status=0");
            if ($s->num_rows() > 0) {
                foreach ($s->result_array() as $row) {
                    $status = $this->query_transaction($row['order_id']);
                    if ($status == 1) {
                        $this->Db_model->update("airtime_purchase", ["status"=>1, "status_date"=>date_time()], "WHERE order_id=$row[order_id]");
                        $this->Db_model->update("user_wallet", ["status"=>1], "WHERE ref='$row[reference]'");
                    } else if ($status == 2) {
                        $this->Db_model->update("airtime_purchase", ["status"=>2, "status_date"=>date_time()], "WHERE order_id=$row[order_id]");
                        $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$row[reference]'");
                    }
                }
            }
        }
        
    }

    public function query_airtime_transaction($order_id)
    {
        $airtime_pur = $this->Util_model->get_info("airtime_purchase", "*", "WHERE order_id=$order_id");
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] == 'ORDER_COMPLETED') {
                $this->Db_model->update("airtime_purchase", ["status" => 1, "status_date" => date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$airtime_pur[reference]'");
            }
        }
    }

    public function cancel_airtime_transaction($order_id)
    {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] != 'ORDER_COMPLETED') {
                $url = "https://www.nellobytesystems.com/APICancel.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
                $request = curl_get_request($url);
                if ($request['status'] == 'ORDER_CANCELLED') {
                    $ref = $this->Util_model->get_info("airtime_purchase", "reference", "WHERE order_id=$order_id");
                    $this->Db_model->update("airtime_purchase", ["status" => 2], "WHERE order_id=$order_id");
                    $this->Db_model->delete("user_wallet", "WHERE ref='$ref'");
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Transaction cancelled successfully", "alert-success", 1));
                    return true;
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred during cancellation", "alert-danger", 1));
                    return false;
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The airtime has already been delivered", "alert-danger", 1));
                return false;
            }
        }
    }

    public function generate_recharge_card($uid, $net_id, $unit, $qty, $amount_paid, $discount)
    {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");
        $network = "0$net_id";

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIEPINV1.asp?UserID=$api_user_id&APIKey=$api_key&MobileNetwork=$network&Value=$unit&Quantity=$qty";
            $request = curl_get_request($url);
            if (!array_key_exists("status", $request)) {
                $keys = array("uid", "reference", "order_id", "batch_no", "network", "serial", "pin", "unit");
                $values = array();
                $ref = $this->Util_model->generate_id(11111111, 99999999, "airtime_card", "reference", "var", true, 'fb');
                $this->Db_model->insert("airtime_card", array(
                    "uid" => $uid,
                    "reference" => $ref,
                    "network" => $net_id,
                    "unit" => $unit,
                    "amount" => $amount_paid + $discount,
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "qty" => $qty
                ));
                foreach ($request['TXN_EPIN'] as $card) {
                    $data = array(
                        "uid"           =>  $uid,
                        "reference"     =>  $ref,
                        "order_id"      =>  $card->transactionid,
                        "batch_no"      =>  $card->batchno,
                        "network"       =>  $net_id,
                        "serial"        =>  $card->sno,
                        "pin"           =>  $card->pin,
                        "unit"          =>  $unit
                    );
                    $this->Db_model->insert("airtime_card_purchase", $data);
                    $values[] = array(
                        $uid,
                        $ref,
                        $card->transactionid,
                        $card->batchno,
                        $net_id,
                        $card->sno,
                        $card->pin,
                        $unit
                    );
                }
                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> $qty recharge cards generated. <a href='" . base_url() . "airtime/print-recharge-card/$ref' class='badge bg-primary'>Print Cards</a>", "alert-success", 1));
                return ['status' => true, 'ref' => $ref];
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to complete process at the moment. Try again later", "alert-danger", 1));
                return ['status' => false];
            }
        } else {
            set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> No internet connection. Check your internet and try again", "alert-danger", 1));
            return ['status' => false];
        }
    }

    public function print_recharge_card($uid, $ref)
    {
        $s = $this->Db_model->selectGroup("*", "airtime_card_purchase", "WHERE reference='$ref'");
        if ($s->num_rows() == 0) {
            $view = "
            <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12'>
                <p class='text-red'>No recharge card found</p>
            </div>
            ";
        } else {
            $view = "<div class='col-lg-12 col-md-12 col-sm-12 col-xs-12 no-padding'>";
            foreach ($s->result_array() as $row) {
                $pin = "";
                $count = 1;
                for ($i = 0; $i < strlen($row['pin']); $i++) {
                    $pin .= $row['pin'][$i];
                    if ($count % 4 == 0 && $count < strlen($row['pin'])) {
                        $pin .= "-";
                    }
                    $count++;
                }
                $view .= "
                    <div style='float:left; width:325px; height:81px; padding:0px 15px; margin-bottom:20px;'>
                        <table width='100%'>
                            <tr>
                                <td width='55' rowspan='4'>
                                    <img style='width:100%; height:55px;' src='" . base_url() . $this->Util_model->get_info("networks", "logo", "WHERE id=$row[network]") . "'>
                                </td>
                                <td>
                                    <p style='margin-bottom:0px; font-size: 16px;px; line-height:3px; margin-top:5px; margin-left:10px;'>
                                        <span style='font-size:12px;'>$row[date]</span>
                                        <span style='float:right; font-weight: 600'>$$row[unit]</span style>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p style='margin:5px 10px; font-size:14px; font-weight:600;'>WWW.DRIP2DROP.COM</p>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p style='margin:0px 10px; line-height:5px; font-size:12px;'>$row[serial]</p>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <h4 class='text-bold' style='font-size:18px; margin-left:10px'>$pin</h4>
                                </td>
                            </tr>
                        </table>
                    </div>
                ";
            }
            $view .= "</div>";
        }
        return $view;
    }

    public function initialize_airtime_request_manual($uid, $net_id, $amount, $recipient, $amount_paid = 0, $discount = 0, $ref = "", $coupon = "")
    {
        /*$api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");*/
        $network = "$net_id";

        if (is_connected()) {
            /*$url = "https://www.nellobytesystems.com/APIBuyAirTime.asp?UserID=$api_user_id&APIKey=$api_key&MobileNetwork=$network&Amount=$amount&MobileNumber=$recipient";
            $request = curl_get_request($url);

            if ($request['status'] == 'ORDER_RECEIVED' || $request['status'] == 'ORDER_ONHOLD') {*/
            $order_id = $this->Util_model->generate_id(11111111, 99999999, 'airtime_purchase', 'order_id');
            $this->Db_model->insert("airtime_purchase", [
                "uid" => $uid,
                "order_id" => $order_id,
                "reference" => $ref,
                "recipient" => $recipient,
                "network" => $net_id,
                "amount" => $amount,
                "amount_paid" => $amount_paid,
                "discount" => $discount,
                "coupon" => $coupon,
                "status" => 0,
                "status_date" => date_time()
            ]);
            $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
            $additional = "<p><b>Order ID: </b>$order_id</p>";
            $this->Mail_model->send_notification("Airtime Notification", "An airtime purchase request has been made and it requires manual confirmation from you.", "<a href='" . base_url() . "admin/airtime-orders'>Complete Order</a>", $additional, "Admin");
            //Notification
            $return = [
                "status" => true,
                "message" => "Your order has been received and it is in process.",
                "order_id" => $order_id
            ];

            //Send notification on whatsapp

            /*} else if ($request['status'] == 'INVALID_RECIPIENT') {
                $return = [
                    "status" => false,
                    "message" => "The recipient number is invalid. Try again"
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Your transaction cannot be completed at the moment. Try again later"
                ];
            }*/
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }
    //######################################################################################

    public function send_bulk_sms($uid, $amount_paid, $discount, $ref, $data, $type = "user")
    {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");
        $success = 0;
        $failed = 0;
        $refund = 0;
        $return = array();

        if (is_connected()) {
            if (is_multi($data)) {
                foreach ($data as $sms) {
                    $sender = str_replace(" ", "%20", $sms['Sender']);
                    $message = str_replace(" ", "%20", $sms['Message']);
                    $prefix = substr($sms['Recipient'], 0, 1);
                    if ($prefix == 0) {
                        if ($this->Util_model->identify_network($sms['Recipient']) > 0) {
                            $sms['Recipient'] = "234" . ltrim($sms['Recipient'], 0);
                        }
                    }
                    $url = "https://www.nellobytesystems.com/APIBuyBulkSMS.asp?UserID=$api_user_id&APIKey=$api_key&Sender=$sender&Message=$message&Recipient=$sms[Recipient]";
                    $request = curl_get_request($url);
                    if ($request['status'] == 'ORDER_COMPLETED') {
                        $this->Db_model->insert("bulksms_purchase", [
                            "uid" => $uid,
                            "order_id" => $request['orderid'],
                            "reference" => $ref,
                            "recipient" => $sms['Recipient'],
                            "sender_id" => $sms['Sender'],
                            "message" => $sms['Message'],
                            "amount" => $this->Util_model->get_option("bulksms_price"),
                            "amount_paid" => $amount_paid,
                            "discount" => $discount,
                            "status" => 1,
                            "status_date" => date_time()
                        ]);
                        $success++;
                    } else if ($request['status'] == 'ORDER_RECEIVED') {
                        $this->Db_model->insert("bulksms_purchase", [
                            "uid" => $uid,
                            "order_id" => $request['orderid'],
                            "reference" => $ref,
                            "recipient" => $sms['Recipient'],
                            "sender_id" => $sms['Sender'],
                            "message" => $sms['Message'],
                            "amount" => $this->Util_model->get_option("bulksms_price"),
                            "amount_paid" => $amount_paid,
                            "discount" => $discount,
                            "status" => 0,
                            "status_date" => date_time()
                        ]);
                        $success++;
                    } else {
                        $refund += $amount_paid;
                    }
                }
                $return = [
                    "status" => true,
                    "message" => "<b>$success</b> SMS sent successfully while <b>$failed</b> SMS failed."
                ];
            } else {
                $sender = str_replace(" ", "%20", $data['Sender']);
                $message = str_replace(" ", "%20", $data['Message']);
                $prefix = substr($data['Recipient'], 0, 1);
                if ($prefix == 0) {
                    if ($this->Util_model->identify_network($data['Recipient']) > 0) {
                        $data['Recipient'] = "234" . ltrim($data['Recipient'], 0);
                    }
                }
                $url = "https://www.nellobytesystems.com/APIBuyBulkSMS.asp?UserID=$api_user_id&APIKey=$api_key&Sender=$sender&Message=$message&Recipient=$data[Recipient]";
                $request = curl_get_request($url);
                if ($request['status'] == 'ORDER_COMPLETED') {
                    $this->Db_model->insert("bulksms_purchase", [
                        "uid" => $uid,
                        "order_id" => $request['orderid'],
                        "reference" => $ref,
                        "recipient" => $data['Recipient'],
                        "sender_id" => $data['Sender'],
                        "message" => $data['Message'],
                        "amount" => $this->Util_model->get_option("bulksms_price"),
                        "amount_paid" => $amount_paid,
                        "discount" => $discount,
                        "status" => 1,
                        "status_date" => date_time()
                    ]);
                    $return = [
                        "status" => true,
                        "message" => "SMS sent successfully."
                    ];
                } else if ($request['status'] == 'ORDER_RECEIVED') {
                    $this->Db_model->insert("bulksms_purchase", [
                        "uid" => $uid,
                        "order_id" => $request['orderid'],
                        "reference" => $ref,
                        "recipient" => $data['Recipient'],
                        "sender_id" => $data['Sender'],
                        "message" => $data['Message'],
                        "amount" => $this->Util_model->get_option("bulksms_price"),
                        "amount_paid" => $amount_paid,
                        "discount" => $discount,
                        "status" => 0,
                        "status_date" => date_time()
                    ]);
                    $return = [
                        "status" => true,
                        "message" => "SMS sent successfully."
                    ];
                } else {
                    if ($type == 'user') {
                        if ($this->Util_model->row_count("user_wallet", "WHERE debitor=$uid AND ref='$ref' AND status=1") > 0) {
                            $refund += $amount_paid;
                        }
                        $return = [
                            "status" => false,
                            "message" => "Unable to send SMS at the moment. Try again later."
                        ];
                    }
                }
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }

        if ($refund > 0) {
            $new_ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb");
            $debit = $this->Main_model->add_to_wallet(
                $refund,
                userdata(UID),
                0,
                "SMS charge refund",
                "SMS charge refund",
                "SMS refund",
                $ref,
                $new_ref
            );
            $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$new_ref'");
        }
        return $return;
    }

    public function process_offline_data()
    {
        $s = $this->Db_model->selectGroup("*", "offline_data_purchase", "WHERE status=0");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $uid = $row['uid'];
                $net_id = $row['net_id'];
                $bundle_id = $row['bundle'];
                $from = $row['sender'];
                $recipient = $row['recipient'];
                $pin = $row['pin'];

                $status = false;
                $message = "An error occurred. Try again later";

                if ($net_id != $this->Util_model->identify_network($recipient)) {
                    $status = false;
                    $message = "Invalid network for recipient";
                    $this->Db_model->delete("offline_data_purchase", "WHERE id=$row[id]");
                } else if ($this->Util_model->row_count("user_profile", "WHERE phone=" . ltrim($from, 0)) == 0) {
                    $status = false;
                    $message = "User with number $from does not exist";
                    $this->Db_model->delete("offline_data_purchase", "WHERE id=$row[id]");
                } else if ($this->Util_model->row_count("user_profile", "WHERE phone=" . ltrim($from, 0) . " AND pin=$pin") == 0) {
                    $status = false;
                    $message = "Incorrect transaction PIN. Try again";
                    $this->Db_model->delete("offline_data_purchase", "WHERE id=$row[id]");
                } else {
                    $this->Db_model->update("offline_data_purchase", ["status" => 1], "WHERE id=$row[id]"); // Set to ungoing
                    $bundle = $this->Util_model->get_info("data_bundle", "*", "WHERE id=$bundle_id");
                    $discount = $this->Util_model->get_info("packages", "data_discount", "WHERE id=" . $this->Util_model->get_user_info($uid, "package", "profile"));
                    $amount_to_add = $this->General_model->get_balance($uid, false) - ($bundle['amount'] - $discount);
                    if ($amount_to_add < 0) {
                        $amount_to_add *= -1;
                        $this->load->model("Payment_model", "pay");
                        $card_id = $this->Util_model->get_info("user_card", "id", "WHERE uid=$uid AND status=1 ORDER BY id DESC LIMIT 1");
                        $this->pay->auth_charge($uid, $card_id, "3s2b1b1", $amount_to_add);
                    }

                    $amount_to_pay = $bundle['amount'] - $discount;
                    if ($this->Main_model->check_balance($uid, $amount_to_pay)) {
                        $ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb");
                        $debit = $this->Main_model->add_to_wallet(
                            $amount_to_pay,
                            0,
                            $uid,
                            $this->Util_model->get_info("networks", "network", "WHERE id=$bundle[network_id]") . " $bundle[bundle]",
                            $this->Util_model->get_info("networks", "network", "WHERE id=$bundle[network_id]") . " $bundle[bundle]",
                            "Data purchase",
                            $bundle_id,
                            $ref
                        );
                        if ($debit['return']) {
                            $data_request = $this->Main_model->initialize_data_request($uid, $recipient, $bundle['id'], $amount_to_pay, $discount, $ref, "");
                            if ($data_request['status']) {
                                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                                $status = true;
                                $message = "Order received and under process. Don't resend again";
                                $this->Db_model->update("offline_data_purchase", ["status" => 2], "WHERE id=$row[id]"); // Set to ungoing
                            } else {
                                $this->Db_model->delete("user_wallet", "WHERE debitor=$uid AND ref='$ref'");
                                $status = false;
                                $message = "An error occured while processing your order. Try again later";
                                $this->Db_model->delete("offline_data_purchase", "WHERE id=$row[id]");
                            }
                        } else {
                            $status = false;
                            $message = "Unable to complete process at the moment. Try again later";
                            $this->Db_model->update("offline_data_purchase", ["status" => 0], "WHERE id=$row[id]"); // Set to ungoing
                            $this->Db_model->delete("offline_data_purchase", "WHERE id=$row[id]");
                        }
                    } else {
                        $status = false;
                        $message = "Insufficient balance";
                        $this->Db_model->delete("offline_data_purchase", "WHERE id=$row[id]");
                    }
                }

                $sms = [
                    "Sender" => "ISEBABA",
                    "Recipient" => $from,
                    "Message" => $message
                ];
                //$this->Main_model->send_bulk_sms(0, 0, 0, $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb"), $sms, "System");

                if ($status) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> $message", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $message", "alert-danger", 1));
                }
            }
        }
    }

    public function process_offline_airtime()
    {
        $s = $this->Db_model->selectGroup("*", "offline_airtime_purchase", "WHERE status=0");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $uid = $row['uid'];
                $amount = $row['amount'];
                $from = $row['sender'];
                $recipient = $row['recipient'];
                $pin = $row['pin'];
                $net_id = $this->Util_model->identify_network($recipient);

                $status = false;
                $message = "An error occurred. Try again later";
                if ($this->Util_model->row_count("user_profile", "WHERE phone=" . ltrim($from, 0)) == 0) {
                    $status = false;
                    $message = "User with number $from does not exits";
                    $this->Db_model->delete("offline_airtime_purchase", "WHERE id=$row[id]");
                } else if ($this->Util_model->row_count("user_profile", "WHERE phone=" . ltrim($from, 0) . " AND pin=$pin") == 0) {
                    $status = false;
                    $message = "Incorrect transaction PIN. Try again.";
                    $this->Db_model->delete("offline_airtime_purchase", "WHERE id=$row[id]");
                } else {
                    $this->Db_model->update("offline_airtime_purchase", ["status" => 1], "WHERE id=$row[id]"); // Set to ungoing
                    $discount = get_percentage($amount, $this->Util_model->get_info("packages", "airtime_discount", "WHERE id=" . $this->Util_model->get_user_info($uid, "package", "profile")));
                    $amount_to_add = $this->General_model->get_balance($uid, false) - ($amount - $discount);
                    if ($amount_to_add < 0) {
                        $amount_to_add *= -1;
                        $this->load->model("Payment_model", "pay");
                        $card_id = $this->Util_model->get_info("user_card", "id", "WHERE uid=$uid AND status=1 ORDER BY id DESC LIMIT 1");
                        $this->pay->auth_charge($uid, $card_id, "3s2b1b1", $amount_to_add);
                    }

                    $amount_to_pay = $amount - $discount;
                    if ($this->Main_model->check_balance($uid, $amount_to_pay)) {
                        $ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb");
                        $debit = $this->Main_model->add_to_wallet(
                            $amount_to_pay,
                            0,
                            $uid,
                            $this->Util_model->get_info("networks", "network", "WHERE id=$net_id") . " $amount",
                            $this->Util_model->get_info("networks", "network", "WHERE id=$net_id") . " $amount",
                            "Airtime purchase",
                            "",
                            $ref
                        );
                        if ($debit['return']) {
                            $airtime_request = $this->Main_model->initialize_airtime_request($uid, $net_id, $amount, $recipient, $amount_to_pay, $discount, $ref, "");
                            if ($airtime_request['status']) {
                                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                                $status = true;
                                $message = "Order received and under process. Don't resend again.";
                                $this->Db_model->update("offline_airtime_purchase", ["status" => 2], "WHERE id=$row[id]"); // Set to ungoing
                            } else {
                                $this->Db_model->delete("user_wallet", "WHERE debitor=$uid AND ref='$ref'");
                                $status = false;
                                $message = "An error occurred while processing your order. Try again later";
                                $this->Db_model->delete("offline_airtime_purchase", "WHERE id=$row[id]");
                            }
                        } else {
                            $status = false;
                            $message = "Unable to complete process at the moment. Try again later";
                            $this->Db_model->delete("offline_airtime_purchase", "WHERE id=$row[id]");
                        }
                    } else {
                        $status = false;
                        $message = "Insufficient balance. Try again later";
                        $this->Db_model->delete("offline_airtime_purchase", "WHERE id=$row[id]");
                    }
                }

                $sms = [
                    "Sender" => "ISEBABA",
                    "Recipient" => $from,
                    "Message" => $message
                ];
                //$this->Main_model->send_bulk_sms(0, 0, 0, $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb"), $sms, "System");

                if ($status) {
                    set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> $message", "alert-success", 1));
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $message", "alert-danger", 1));
                }
            }
        }
    }

    //############################API CALL TO CABLE VENDOR##################################
    private function dstv($pack_id, $smart_card, $ref)
    {
        $package = $this->Util_model->get_info("cable_package", "*", "WHERE id=" . $pack_id);

        $body = [
            "serviceCode" => "P-TV",
            "type" => "DSTV",
            "smartCardNo" => $smart_card,
            "name" => $package['name'],
            "code" => $package['package_code'],
            "period" => "1",
            "request_id" => $ref,
            "hasAddon" => "True",
            "addondetails" =>
            [
                "name" => "Asian Add-on",
                "addoncode" => "ASIADDE36"
            ]
        ];
        return $body;
    }

    public function initialize_cable_request($uid, $smart_card, $pack_id, $amount_paid, $discount = 0, $ref = "", $coupon = "")
    {
        $package = $this->Util_model->get_info("cable_package", "*", "WHERE id=" . $pack_id);


        /*$api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");*/
        $cable = $package['cable'];

        if (is_connected()) {
            /*$url = "https://www.nellobytesystems.com/APIBuyCableTV.asp?UserID=$api_user_id&APIKey=$api_key&CableTV=$cable&Package=$bouquet&SmartCardNo=$smart_card";
            $request = curl_get_request($url);*/

            //if ($request['status'] == 'ORDER_RECEIVED' || $request['status'] == 'ORDER_ONHOLD') {
            if ($cable == 1) {
                $email = $this->Util_model->get_option("ringo_email");
                $password = $this->Util_model->get_option("ringo_password");

                $headers = [
                    "email: $email",
                    "password: $password",
                    "content-type: application/json",
                    "cache-control: no-cache"

                ];

                $body = $this->dstv($pack_id, $smart_card, $ref);
                $request  = get_curl_request("https://www.api.ringo.ng/api/agent/p2", 'POST', $headers, $body);
                if ($request['status'] == 200) {
                    $orderid = $request['transref'];
                    $status = 1;
                } else {
                    $status = 0;
                    $return = [
                        "status" => false,
                        "message" => "Unable to complete transaction at the moment. Try again later"
                    ];
                }
            } else {
                $orderid = rand(11111111, 99999999);
                $additional = "<p><b>Order ID: </b>$orderid</p>";
                $this->Mail_model->send_notification("Cable Notification", "A cable Tv subscription purchase request has been made and it requires manual confirmation from you.", "<a href='" . base_url() . "admin/cable-orders'>Complete Order</a>", $additional, "Admin");
                //Notification
                $status = 2;
            }

            if ($status > 0) {
                if ($this->Db_model->insert("cable_purchase", [
                    "uid" => $uid,
                    "order_id" => $orderid,
                    "reference" => $ref,
                    "smart_card_num" => $smart_card,
                    "cable" => $cable,
                    "package" => $pack_id,
                    "package_amount" => $package['amount'],
                    "amount_paid" => $amount_paid,
                    "discount" => $discount,
                    "coupon" => $coupon,
                    "status" => ($status == 1) ? 1 : 0,
                    "status_date" => date_time()
                ])) {
                    $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");

                    $return = [
                        "status" => true,
                        "message" => "Your order has been received and is under process.",
                        "order_id" => $orderid
                    ];
                } else {
                    $return = [
                        "status" => false,
                        "message" => "An error occurred during process. Try again later"
                    ];
                }
            }
            /*} else if ($request['status'] == 'INVALID_PACKAGE') {
                $return = [
                    "status" => false,
                    "message" => "The bouquet requested is not available at the moment. Try later"
                ];
            } else if ($request['status'] == 'INVALID_SMARTCARDNO') {
                $return = [
                    "status" => false,
                    "message" => "The smart card number is invalid. Try again"
                ];
            } else {
                $return = [
                    "status" => false,
                    "message" => "Unable to complete transaction at the moment. Try again later"
                ];
            }*/
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function query_cable_transaction($order_id)
    {
        $reference = $this->Util_model->get_info("cable_purchase", "reference", "WHERE order_id=$order_id");
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] == 'ORDER_COMPLETED') {
                $this->Db_model->update("cable_purchase", ["status" => 1, "status_date" => date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$reference'");
            }
        }
    }

    public function cancel_cable_transaction($order_id)
    {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] != 'ORDER_COMPLETED') {
                $url = "https://www.nellobytesystems.com/APICancel.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
                $request = curl_get_request($url);
                if ($request['status'] == 'ORDER_CANCELLED') {
                    $ref = $this->Util_model->get_info("cable_purchase", "reference", "WHERE order_id=$order_id");
                    $this->Db_model->update("cable_purchase", ["status" => 2], "WHERE order_id=$order_id");
                    $this->Db_model->delete("user_wallet", "WHERE ref='$ref'");
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Transaction cancelled successfully", "alert-success", 1));
                    return true;
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured during cancellation", "alert-danger", 1));
                    return false;
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The cable subscription has already been delivered", "alert-danger", 1));
                return false;
            }
        }
    }

    public function verify_smartcardno($cable, $smart_card)
    {
        $email = $this->Util_model->get_option("ringo_email");
        $password = $this->Util_model->get_option("ringo_password");
        $cable = $this->Util_model->get_info("cable", "name", "WHERE id=$cable");

        if (is_connected()) {
            $headers = [
                "email: $email",
                "password: $password",
                "content-type: application/json",
                "cache-control: no-cache"
            ];
            $body = [
                "serviceCode" => "V-TV",
                "type" => strtoupper($cable),
                "smartCardNo" => $smart_card
            ];
            $request  = get_curl_request("https://www.api.ringo.ng/api/agent/p2", 'POST', $headers, $body);

            if ($request['status'] == '200') {
                $customer_name = $request['customerName'];
                $return = [
                    "status" => true,
                    "customer_name" => $customer_name
                ];
            } else {
                $return = [
                    "status" => true,
                    "customer_name" => "Error verifying meter number"
                ];
            }
        } else {
            $return = [
                "status"        =>  false,
                "customer_name" =>  "ERROR VERIFYING SMARTCARDNO"
            ];
        }
        return $return;
    }

    //############################API CALL TO ELECTRICITY VENDOR##################################

    public function initialize_elect_request($uid, $company, $meter_num, $meter_type, $amount, $amount_paid, $phone, $ref = "", $coupon = "")
    {
        $email = $this->Util_model->get_option("ringo_email");
        $password = $this->Util_model->get_option("ringo_password");
        $meter_type = ($meter_type == 1) ? 'PREPAID' : 'POSTPAID';
        $elect = $this->Util_model->get_info("electricity", "company_code", "WHERE id=$company");

        if (is_connected()) {
            $headers = [
                "email: $email",
                "password: $password",
                "content-type: application/json",
                "cache-control: no-cache"

            ];
            $body = [
                "serviceCode" => "P-ELECT",
                "disco" => $elect,
                "meterNo" => $meter_num,
                "type" => $meter_type,
                "amount" => $amount,
                "phonenumber" => $phone,
                "request_id" => $ref
            ];
            $request  = get_curl_request("https://www.api.ringo.ng/api/agent/p2", 'POST', $headers, $body);

            if ($request['status'] == '200') {
                if ($this->Db_model->insert("electricity_purchase", [
                    "uid" => $uid,
                    "reference" => $ref,
                    "company" => $elect,
                    "meter_type" => $meter_type,
                    "meter_number" => $meter_num,
                    "amount" => $amount,
                    "amount_paid" => $amount_paid,
                    "pin" => $request['token'],
                    "phone" => $phone,
                    "status" => 1,
                    "date" => date_time()
                ])) {
                    $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$ref'");
                    /*$additional = "<p><b>Order ID: </b>$ref</p>";
                    $this->Mail_model->send_notification("Electricity Notification", "An electricity purchase request has been made and it requires manual confirmation from you.", "<a href='".base_url()."admin/electricity-orders'>Complete Order</a>", $additional, "Admin");*/
                    //Notification
                    $return = [
                        "status" => true,
                        "message" => "Your order has been received and is under process.",
                        "order_id" => $ref
                    ];
                } else {
                    $return = [
                        "status" => false,
                        "message" => "An error occurred during process. Try again later"
                    ];
                }
            } else {
                $return = [
                    "status" => false,
                    "message" => "Unable to complete transaction at the moment. Try again later"
                ];
            }
        } else {
            $return = [
                "status" => false,
                "message" => "Connection error: check your internet connectivity"
            ];
        }
        return $return;
    }

    public function query_elect_transaction($order_id)
    {
        $reference = $this->Util_model->get_info("cable_purchase", "reference", "WHERE order_id=$order_id");
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] == 'ORDER_COMPLETED') {
                $this->Db_model->update("cable_purchase", ["status" => 1, "status_date" => date_time()], "WHERE order_id=$order_id");
                $this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$reference'");
            }
        }
    }

    public function cancel_elect_transaction($order_id)
    {
        $api_user_id = $this->Util_model->get_option("api_user_id");
        $api_key = $this->Util_model->get_option("api_key");

        if (is_connected()) {
            $url = "https://www.nellobytesystems.com/APIQuery.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
            $request = curl_get_request($url);

            if ($request['status'] != 'ORDER_COMPLETED') {
                $url = "https://www.nellobytesystems.com/APICancel.asp?UserID=$api_user_id&APIKey=$api_key&OrderID=$order_id";
                $request = curl_get_request($url);
                if ($request['status'] == 'ORDER_CANCELLED') {
                    $ref = $this->Util_model->get_info("cable_purchase", "reference", "WHERE order_id=$order_id");
                    $this->Db_model->update("cable_purchase", ["status" => 2], "WHERE order_id=$order_id");
                    $this->Db_model->delete("user_wallet", "WHERE ref='$ref'");
                    set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Transaction cancelled successfully", "alert-success", 1));
                    return true;
                } else {
                    set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured during cancellation", "alert-danger", 1));
                    return false;
                }
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The cable subscription has already been delivered", "alert-danger", 1));
                return false;
            }
        }
    }

    public function verify_meterno($elect, $type, $meterno)
    {
        $email = $this->Util_model->get_option("ringo_email");
        $password = $this->Util_model->get_option("ringo_password");
        $type = ($type == 1) ? 'PREPAID' : 'POSTPAID';
        $elect = $this->Util_model->get_info("electricity", "company_code", "WHERE id=$elect");

        if (is_connected()) {
            $headers = [
                "email: $email",
                "password: $password",
                "content-type: application/json",
                "cache-control: no-cache"
            ];
            $body = [
                "serviceCode" => "V-ELECT",
                "disco" => $elect,
                "meterNo" => $meterno,
                "type" => $type,
                "amount" => "100",
                "phonenumber" => "08125253636",
                "request_id" => rand(11111111, 99999999)
            ];
            $request  = get_curl_request("https://www.api.ringo.ng/api/agent/p2", 'POST', $headers, $body);

            if ($request['status'] == '200') {
                $customer_name = $request['customerName'];
                $return = [
                    "status" => true,
                    "customer_name" => $customer_name
                ];
            } else {
                $return = [
                    "status" => true,
                    "customer_name" => "Error verifying meter number"
                ];
            }
        } else {
            $return = [
                "status"        =>  false,
                "customer_name" =>  "ERROR VERIFYING METERNO"
            ];
        }
        return $return;
    }

    //####################################################################################

    /////////////////////////////////////////User subscriptions///////////////////////////////////////
    public function users_auto_subscription()
    {
        $this->load->model("Payment_model", "pay");
        $s = $this->Db_model->selectGroup("uid, package, date", "user_profile", "WHERE role=1 AND package>1");
        if ($s->num_rows() > 0) {
            $count = 0;
            foreach ($s->result_array() as $row) {
                $last_sub = ($this->Util_model->row_count("user_subscription", "WHERE uid=$row[uid]") == 0) ? $row['date'] : $this->Util_model->get_info("user_subscription", "date", "WHERE uid=$row[uid] ORDER BY id DESC LIMIT 1");
                $days = days_difference($last_sub);
                if ($days >= $this->Util_model->get_option("sub_due_days")) {
                    $count++;
                    $card = $this->Db_model->selectGroup("id, cvv", "user_card", "WHERE uid=$row[uid] AND status=1 ORDER BY id DESC LIMIT 1");
                    $amount = $this->Util_model->get_info("packages", "recurring", "WHERE id=$row[package]");
                    if ($card->num_rows() > 0) {
                        $card = $card->row_array();
                        $charge = json_decode($this->pay->initiate_auth_charge($row['uid'], $card['id'], $card['cvv'], $amount, "recurring"));
                        if ($charge->status == 1) {
                            $settled = $this->settle_upperlevel($row['uid']);
                            $amount -= $settled['total'];
                            $amount -= 10;
                            $admin = $this->Util_model->get_info("user_profile", "uid", "WHERE role=2 ORDER BY id LIMIT 1");
                            $this->add_to_wallet(10, $admin, 0, "From member " . $this->Util_model->get_user_info($row['uid']), "From $row[uid] - $admin", "Admin cut", $row['uid'], "", 1);
                            $input = array(
                                "ref"       =>  $charge->reference,
                                "uid"       =>  $row['uid'],
                                "amount"    =>  $amount,
                                "channel"   =>  "card",
                                "extra"     =>  $card['id'],
                                "benefactors" => 0
                            );
                            $this->Db_model->insert("user_subscription", $input);
                            $this->Db_model->update("user_profile", ["status" => 1], "WHERE uid=$row[uid]");
                        } else {
                            if ($this->General_model->get_balance($row['uid'], false) >= $amount) {
                                $charge = $this->add_to_wallet($amount, 0, $row['uid'], "System charge", "System charge", "Commission", $row['package'], "", 1);
                                $settled = $this->settle_upperlevel($row['uid']);
                                $amount -= $settled['total'];
                                $amount -= 10;
                                $admin = $this->Util_model->get_info("user_profile", "uid", "WHERE role=2 ORDER BY id LIMIT 1");
                                $this->add_to_wallet(10, $admin, 0, "From member " . $this->Util_model->get_user_info($row['uid']), "From $row[uid] - $admin", "Admin cut", $row['uid'], "", 1);
                                $input = array(
                                    "ref"       =>  $charge['reference'],
                                    "uid"       =>  $row['uid'],
                                    "amount"    =>  $amount,
                                    "channel"   =>  "wallet",
                                    "extra"     =>  "",
                                    "benefactors" => $settled['count']
                                );
                                $this->Db_model->insert("user_subscription", $input);
                                $this->Db_model->update("user_profile", ["status" => 1], "WHERE uid=$row[uid]");
                            } else {
                                $this->Db_model->update("user_profile", ["status" => 0], "WHERE uid=$row[uid]");
                            }
                        }
                    } else {
                        if ($this->General_model->get_balance($row['uid'], false) >= $amount) {
                            $charge = $this->add_to_wallet($amount, 0, $row['uid'], "System charge", "System charge", "Commission", $row['package'], "", 1);
                            $settled = $this->settle_upperlevel($row['uid']);
                            $amount -= $settled['total'];
                            $amount -= 10;
                            $admin = $this->Util_model->get_info("user_profile", "uid", "WHERE role=2 ORDER BY id LIMIT 1");
                            $this->add_to_wallet(10, $admin, 0, "From member " . $this->Util_model->get_user_info($row['uid']), "From $row[uid] - $admin", "Admin cut", $row['uid'], "", 1);
                            $input = array(
                                "ref"       =>  $charge['reference'],
                                "uid"       =>  $row['uid'],
                                "amount"    =>  $amount,
                                "channel"   =>  "wallet",
                                "extra"     =>  "",
                                "benefactors" => $settled['count']
                            );
                            $this->Db_model->insert("user_subscription", $input);
                            $this->Db_model->update("user_profile", ["status" => 1], "WHERE uid=$row[uid]");
                        } else {
                            $this->Db_model->update("user_profile", ["status" => 0], "WHERE uid=$row[uid]");
                        }
                    }
                }
                if ($count == 10) {
                    break;
                }
            }
        }
    }

    public function repay_debt($uid, $amount)
    {
        $s = $this->Db_model->selectGroup("*", "user_debts", "WHERE uid=$uid AND status=0");
        if ($s->num_rows() > 0) {
            $debt = $s->row_array();
            $paid = $this->Util_model->sum_field("user_debts_repayment", "amount", "WHERE uid=$uid AND ref=$debt[ref]");
            $amt_to_pay = $debt['amount'] - $paid;
            if (($amt_to_pay - $amount) < 0) {
                $remain = $amount - $amt_to_pay;
                $input = array(
                    "uid"       =>  $uid,
                    "ref"       =>  $debt['ref'],
                    "amount"    =>  $remain,
                    "status"    =>  1
                );
            } else {
                $remain = 0;
                $input = array(
                    "uid"       =>  $uid,
                    "ref"       =>  $debt['ref'],
                    "amount"    =>  $amount,
                    "status"    =>  1
                );
            }
            $this->Db_model->insert("user_debts_repayment", $input);
            $paid = $this->Util_model->sum_field("user_debts_repayment", "amount", "WHERE ref=$debt[ref]");
            if ($paid >= $debt['amount']) {
                $this->Db_model->update("user_debts", ["status" => 1], "WHERE uid=$uid AND ref=$debt[ref]");
            }
            $return = $remain;
        } else {
            $return = $amount;
        }
        return $return;
    }

    public function settle_referral($uid, $i_id)
    {
        $ref = $this->Util_model->get_info("user_referre", "refID", "WHERE uid=$uid");

        $per = get_percentage($this->Util_model->get_info("investment", "amount", "WHERE id=$i_id"), 5);
        if ($ref > 0) {
            $this->add_to_wallet($per, $uid, 0, "Referral investment bonus", "Referral investment bonus", "Referral bonus", $i_id, "");
        } else {
            $this->add_to_wallet($per, $this->Util_model->get_info("user_profile", "uid", "WHERE role=5 LIMIT 1"), 0, "Referral investment bonus", "Referral investment bonus", "Referral bonus", $i_id, "");
        }
    }

    public function update_escrow($uid, $amount, $type = "add")
    {
        if ($type == "add") {
            if ($this->Util_model->row_count("escow", "WHERE uid=$uid") == 0) {
                $this->Db_model->insert("escow", ["uid" => $uid, "amount" => $amount]);
            } else {
                $original_amt = $this->Util_model->get_info("escow", "amount", "WHERE uid=$uid LIMIT 1");
                $this->Db_model->update("escow", ["amount" => ($original_amt + $amount)], "WHERE uid=$uid");
            }
        } else {
            $escrow_amt = $this->Util_model->get_info("escow", "amount", "WHERE uid=$uid");
            $escrow_amt -= $amount;
            $this->Db_model->update("escow", ["amount" => $escrow_amt], "WHERE uid=$uid");
        }
    }

    public function add_credit_bonus($uid, $type)
    {
        switch ($type) {
            case "tier1":
                $credit = 100;
                $desc = "Tier 1 investment bonus";
                break;
            case "tier2":
                $credit = 200;
                $desc = "Tier 2 investment bonus";
                break;
            case "tier3":
                $credit = 300;
                $desc = "Tier 3 investment bonus";
                break;
            case "tier4":
                $credit = 500;
                $desc = "Tier 4 investment bonus";
                break;
            case "new_account":
                $credit = 10;
                $desc = "New account creation bonus";
                break;
            case "referral":
                $credit = 40;
                $desc = "Referral bonus";
                break;
            case "view":
                $credit = 5;
                $desc = "Advert view";
                break;
            default:
                $credit = 0;
                $desc = "";
        }
        if ($credit != 0) {
            $this->add_to_wallet($credit, $uid, 0, "", "", $desc, "", "", 1, true);
        }
        return true;
    }

    public function giveaway_coupon($uid, $coupon, $coupon_table)
    {
        if ($this->Util_model->row_count($coupon_table, "WHERE code='$coupon' AND status=1") == 0) {
            return false;
        } else {
            $data = array(
                "uid"           =>  $uid,
                "relate"        =>  $coupon_table,
                "coupon"        =>  $coupon,
                "used"          =>  0,
                "date_added"    =>  date_time()
            );
            if ($this->Db_model->insert("user_coupon", $data)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function user_cards($uid)
    {
        $s = $this->Db_model->selectGroup("*", "user_card", "WHERE uid=$uid AND status=1");
        $user_card = "
                <ul class='todo-list'>
        ";
        if ($s->num_rows() > 0) {
            $count = 1;
            foreach ($s->result_array() as $row) {
                $s_bank = $this->Db_model->selectGroup("logo", "banks", "WHERE name='$row[bank]'");
                if ($s_bank->num_rows() > 0) {
                    $logo = $s_bank->row();
                    $logo = $logo->logo;
                } else {
                    $logo = "assets/img/banks/others.JPG";
                }
                $user_card .= "
                    <li>
                        <label>
                            <!-- radio box -->
                            <input type='radio' name='sel_card' value='$row[id]'>
                            <!-- todo text -->
                            <img src='" . base_url() . "$logo' title='$row[bank]' data-toggle='tooltip' style='width:25px; height:100%'>
                            <span class='text'> Ends with $row[last4]</span>
                            <!-- Emphasis label -->
                            <small class='label label-danger'>$row[card_type]</small>
                        </label>
                        <!-- General tools such as edit or delete-->
                        <div class='tools'>
                            <i class='fa fa-trash-o' onclick='delete_card(\"" . base_url() . "\", $row[id], $(this))'></i>
                        </div>
                    </li>
                ";
            }
        }
        $user_card .= "
                    <li>
                        <label>
                            <!-- radio box -->
                            <input type='radio' name='sel_card' checked value='new'>
                            <!-- todo text -->
                            <span class='text'>Make new payment</span>
                        </label>
                    </li>
                </ul>
        ";
        return $user_card;
    }

    /////////////////Loan/////////////////////////////////////////////////////
    public function loan_panel($uid)
    {
        $s = $this->Db_model->selectGroup("*", "loan_request", "WHERE uid=$uid");
        if ($s->num_rows() == 0) {
            $view = "
            <h3 class='text-bold text-center'>Request For A Loan</h3>
            <div class='col-lg-8 col-md-8 col-sm-10 col-xs-12 mr-auto ml-auto'>
                <p class='text-center'>You can get up to $96,000 only if you are committed to repaying back your loan on time. Make a request now for just $1,000 and a loan offer will be given to you.</p>
                <button class='btn btn-warning btn-round btn-block btn-lg top-4x' onclick='request_loan($(this));'>Request For Loan</button>
                <label class='text-center bottom-4x'>
                    <input type='checkbox' id='terms'> By requesting for loan, you agree to our <a href='" . base_url() . "terms_conditions'>terms & conditions</a>
                </label>
            </div>
            ";
        } else {
            $row = $s->row_array();
            if ($row['status'] == 0) {
                $view = "
                <h3 class='text-bold text-center'>Waiting For Offer</h3>
                <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12 mr-auto ml-auto'>
                    <center><img class='ml-auto mr-auto' src='" . base_url() . "assets/img/hourglass.gif' width='200' height='200'></center>
                    <p class='text-center'>Invite more people to increase your chances of getting a loan offer faster within minutes. Don't be wicked, help many benefit from this support by telling them about us and sharing your referral link below.</p>
                    <span id='ref-link' class='no-display'>" . base_url() . "sign-up/" . $this->Util_model->get_user_info($uid, 'username', 'profile') . "</span>
                    <button class='btn btn-warning btn-round btn-block top-4x bottom-4x' onclick='copyToClipboard($(this), _(\"ref-link\"))'>Click To Copy Link</button>
                </div>
                ";
            } else if ($row['status'] == 1) {
                $offer = $this->Util_model->get_info("loan_offer", "*", "WHERE uid=$row[uid] ORDER BY id DESC LIMIT 1");
                if ($offer['status'] == 0) {
                    $view = "
                    <h3 class='text-bold text-center text-green'>CONGRATULATIONS</h3>
                    <div class='row'>
                        <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12 text-center'>
                            <h5 class='text-muted'>We Have An Offer For You</h5>
                            <h1>" . NGN . number_format($offer['offer']) . "</h1>
                            <div class='row text-left top-2x left-pad-1x right-pad-1x'>
                                <div class='col-lg-8 col-md-8 col-sm-8 col-xs-8 mr-auto ml-auto'>
                                    Repayment <span class='float-right'>$offer[duration] days</span>
                                </div>
                                <div class='col-lg-8 col-md-8 col-sm-8 col-xs-8 mr-auto ml-auto'>
                                    Principle Amount <span class='float-right'>" . NGN . number_format($offer['offer'], 2) . "</span>
                                </div>
                                <div class='col-lg-8 col-md-8 col-sm-8 col-xs-8 mr-auto ml-auto'>
                                    Commission <span class='float-right'>" . NGN . number_format(($offer['offer'] * $offer['comm']), 2) . "</span>
                                </div>
                                <div class='col-lg-8 col-md-8 col-sm-8 col-xs-8 mr-auto ml-auto top-2x text-bold'>
                                    YOU RECEIVE <span class='float-right'>" . NGN . number_format(($offer['offer'] - ($offer['offer'] * $offer['comm'])), 2) . "</span>
                                </div>
                            </div>
                            <div class='row top-3x'>
                                <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12' style='background-color: rgba(255,140,17,0.05); padding:10px; border-radius: 15px'>
                                    <div class='form-group'>
                                        <textarea id='txt-testimony' class='form-control' style='resize:none; height:110px;' placeholder='Tell us how you feel'></textarea>
                                    </div>
                                </div>
                            </div>
                            <button class='btn btn-warning btn-round btn-block btn-lg top-4x' onclick='accept_loan($(this), \"$offer[id]\", ___(\"txt-testimony\"))'>Accept Offer</button>
                            <label class='text-center bottom-4x no-display'>
                                <input type='checkbox' id='terms' checked> I have read the helpful suggestion
                            </label>
                            <p class='text-red'><i class='fa fa-info-circle'></i> Your loan offer will be cancelled by 11:59pm today and you won't be offered any loan again as we will assume you don't need loan. Act fast.</p>
                        </div>
                    </div>
                    ";
                } else if ($offer['status'] == 1) {
                    $view = "
                    <h4 class='text-bold text-center'>Loan Repayment</h4>
                    <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12 mr-auto ml-auto'>
                        <h2 class='text-center' id='loan-rem-time'>" . day_date_difference($offer['expiry_date'], date_time()) . "</h2>
                        <p class='text-center'>Your loan will reset and you will start afresh by requesting a loan with " . NGN . "1,000 if you didn't repay the loan within the time given.</p>
                        <div class='row top-3x'>
                            <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12' style='background-color: rgba(255,140,17,0.05); padding:10px; border-radius: 15px'>
                                <h6 class='text-yellow text-center'>Benefits of Early Repayment</h6>
                                You will get the following benefits if you repay your loan on time:
                                <ul>
                                    <li>You will get up to 2x your repaid amount</li>
                                    <li>You will be given a loan offer fast within 1 hours</li>
                                    <li>Your loan repayment time will be extended</li>
                                    <li>The commission charge will be reduced</li>
                                    <li>You will be rewarded with free credits</li>
                                </ul>
                            </div>
                        </div>
                        <button class='btn btn-warning btn-round btn-block btn-lg top-4x bottom-4x' onclick='repay_loan($(this), \"$offer[id]\");'>Repay Loan</button>
                    </div>
                    ";
                }
            }
        }

        return $view;
    }

    public function accept_loan($id)
    {
        $s = $this->Db_model->selectGroup("*", "loan_offer", "WHERE id=$id AND status=0");
        if ($s->num_rows() == 0) {
            $return = [
                "status"        =>  false,
                "msg"           =>  "<i class='fa fa-times-circle'></i> No offer has been given to you."
            ];
        } else {
            $offer = $s->row_array();
            $amt = $offer['offer'] - ($offer['offer'] * $offer['comm']);

            if ($this->Db_model->update("user_wallet_bonus", ["status" => 1], "WHERE ref='$offer[extra]'")) {
                $data = [
                    "accepted_date"     =>  date_time(),
                    "expiry_date"       =>  get_next_prev_date(date_time(), $offer['duration'], 'next', 'Y-m-d H:i:s'),
                    "status"            =>  1
                ];
                if ($this->Db_model->update("loan_offer", $data, "WHERE id=$id")) {
                    $return = [
                        "status"        =>  true,
                        "msg"           =>  "<i class='fa fa-times-circle'></i> Your loan has been disbursed. <a href='" . base_url() . "wallet/transaction' class='alert-link'>Check your bonus</a>",
                        "balance"       => $this->get_balance($offer['uid'], true),
                        "panel"         =>  $this->loan_panel($offer['uid'])
                    ];
                } else {
                    $return = [
                        "status"        =>  false,
                        "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured. Try again"
                    ];
                }
            } else {
                $return = [
                    "status"        =>  false,
                    "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured. Try again"
                ];
            }
        }

        return $return;
    }

    public function request_loan($uid)
    {
        $fee = $this->Util_model->get_option("loan_request_fee");
        if ($this->Main_model->check_balance($uid, $fee)) {
            $wallet = $this->Main_model->add_to_wallet($fee, $this->Util_model->get_info("user_profile", "uid", "WHERE role=5"), $uid, "Loan request charge, one-time payment", "Loan request charge, one-time payment", "Loan request", "", "", 1);
            if ($wallet['return']) {

                $s = $this->Db_model->selectGroup("refID", "user_referrer", "WHERE uid=" . $uid);
                $refs = "";
                if ($s->num_rows() > 0) {
                    foreach ($s->result_array() as $row) {
                        $refs .= "uid=$row[refID] OR ";
                    }
                    $refs = rtrim($refs, " OR ");
                    $ref_loan = $this->Util_model->row_count("loan_request", "WHERE $refs");
                } else {
                    $ref_loan = 0;
                }
                $input = array(
                    "uid"           =>  $uid,
                    "invited"       =>  $ref_loan
                );
                if ($this->Db_model->insert("loan_request", $input)) {
                    $this->Main_model->add_to_bonus_wallet(($fee * 0.25), $this->Util_model->get_user_info($uid, "refID", "referrer"), userdata(UID), "Loan referral bonus", "Loan referral bonus", "Bonus", "", "", 1); // Add referral bonus
                    $my_ref = $this->Util_model->get_user_info($uid, "refID", "referrer");     #|HINT:
                    if ($my_ref > 0 && $this->Util_model->row_count("loan_request", "WHERE uid=my_ref") > 0) {          #|Adding to                                                                        #|the invited
                        $my_ref_invited = $this->Util_model->get_info("loan_request", "invited", "WHERE uid=$my_ref");  #|user to increase
                        $this->Db_model->update("loan_request", ["invited" => $my_ref_invited++], "WHERE uid=$my_ref");   #|loan chance and offer
                    }

                    $return = [
                        "status"        =>  true,
                        "msg"           =>  "<i class='fa fa-check-circle'></i> Loan requested successfully. $1,000 has been deducted from your account",
                        "balance" => $this->get_balance(userdata(UID), true),
                        "panel"         =>  $this->loan_panel($uid)
                    ];
                } else {
                    $return = [
                        "status"        =>  false,
                        "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured. Try again."
                    ];
                }
            } else {
                $return = [
                    "status"        =>  false,
                    "msg"           =>  "<i class='fa fa-times-circle'></i> An error occured. Try again."
                ];
            }
        } else {
            $return = [
                "status"        =>  false,
                "msg"           =>  "<i class='fa fa-times-circle'></i> Insufficient balance. <a href='" . base_url() . "wallet/deposit'>Deposit now</a>"
            ];
        }
    }

    public function repay_loan($id)
    {
        $s = $this->Db_model->selectGroup("*", "loan_offer", "WHERE id=$id AND status=1");
        if ($s->num_rows() == 0) {
            $return = [
                "status"        =>  false,
                "msg"           =>  "<i class='fa fa-times-circle'></i> No offer has been given to you."
            ];
        } else {
            $offer = $s->row_array();
            if ($this->Main_model->check_balance($offer['uid'], $offer['offer'])) {
                $wallet = $this->Main_model->add_to_wallet($offer['offer'], $this->Util_model->get_info("user_profile", "uid", "WHERE role=5"), $offer['uid'], "Loan repayment of the COVID-19 support", "Loan repayment of the COVID-19 support", "Loan Repayment", $offer['id'], "", 1);
                if ($wallet['return']) {
                    $data = [
                        "repayment_date" => date_time(),
                        "status" => 2
                    ];
                    if ($this->Db_model->update("loan_offer", $data, "WHERE id=$id AND status=1")) {
                        $this->Db_model->update("loan_request", ["status" => 0], "WHERE uid=$offer[uid]");
                        $return = [
                            "status" => true,
                            "msg" => "<i class='fa fa-times-circle'></i> Your successfully repaid loan. Wait for a new offer",
                            "balance" => $this->get_balance(userdata(UID), true),
                            "panel" => $this->loan_panel($offer['uid'])
                        ];
                    } else {
                        $return = [
                            "status" => false,
                            "msg" => "<i class='fa fa-times-circle'></i> An error occured. Try again"
                        ];
                    }
                } else {
                    $return = [
                        "status" => false,
                        "msg" => "<i class='fa fa-times-circle'></i> An error occured. Try again"
                    ];
                }
            } else {
                $return = [
                    "status"        =>  false,
                    "msg"           =>  "<i class='fa fa-times-circle'></i> Insufficient balance. <a href='" . base_url() . "wallet/deposit'>Deposit now</a>"
                ];
            }
        }

        return $return;
    }

    public function add_to_wallet_ex($amount, $uid, $type, $ref)
    {
        $data = array(
            "amount"        =>  $amount,
            "uid"      =>  $uid,
            "type"       =>  $type,
            "ref"           =>  $ref,
            "status"        =>  1
        );
        $this->Db_model->insert("user_wallet_ex", $data);
    }

    public function recent_trans()
    {
        $s = $this->Db_model->selectGroup("*", "user_wallet_ex", "WHERE status=1 ORDER BY id DESC LIMIT 7");
        if ($s->num_rows() > 0) {
            $view = "
            <table class='table'>
                <thead class=''>
                  <th>Username</th>
                  <th>Amount</th>
                  <th>Date</th>
                </thead>
                <tbody>
            ";
            foreach ($s->result_array() as $row) {
                $color = ($row['type'] == 'credit') ? "table-success" : "table-danger";
                $view .= "
                    <tr class='$color'>
                        <td>" . $this->Util_model->get_user_info($row['uid'], "username", "profile") . "</td>
                        <td>" . NGN . number_format($row['amount']) . "</td>
                        <td>$row[date]</td>
                      </tr>
                ";
            }
            $view .= "
                </tbody>
            </table>
            ";
        } else {
            $view = "<p>No transaction found</p>";
        }
        return $view;
    }

    public function add_testimony($uid, $ref, $content, $status = 1)
    {
        if (trim($content) != "") {
            $data = array(
                "uid"       =>  $uid,
                "ref"       =>  $ref,
                "content"   =>  $content,
                "status"    =>  $status,
                "date"      =>  date_time()
            );
            if ($this->Db_model->insert("testimony", $data)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function get_merchant_balance($mid, $format = true, $today = false)
    {
        if ($today) {
            $debit = $this->Util_model->sum_field("merchant_wallet", "amount", "WHERE debitor=$mid AND (status=1 || status=0) AND date LIKE '" . date_time('d') . "%'");
            $balance = $debit;
        } else {
            $credit = $this->Util_model->sum_field("merchant_wallet", "amount", "WHERE creditor=$mid AND status=1");
            $debit = $this->Util_model->sum_field("merchant_wallet", "amount", "WHERE debitor=$mid AND (status=1 || status=0)");
            $balance = $credit - $debit;
        }
        if ($format) {
            return "$" . number_format($balance, 2);
        } else {
            return $balance;
        }
    }

    public function activation_redirect()
    {
        if ($this->Util_model->get_info("merchant_main", "status", "WHERE mid=" . userdata(MID)) == 0) {
            redirect(base_url() . "activate");
        }
    }

    public function add_to_merchant_wallet($amount, $creditor, $debitor, $creditor_desc = "", $debitor_desc = "", $type = "Funding", $extra = "", $ref = "", $status = 0)
    {
        ##################################################################
        #                                                                #
        # to: The receiver of the fund (if it's a debit)                 #
        # desc: The description of the fund ie. from the card a deposit  #
        # was made, the reason for the credit etc.                       #
        # type: The type of transaction it was ie. Credit or Debit       #
        # ref: A unique ID used in identifying a transaction             #
        ##################################################################
        $ref = ($ref == "") ? $ref = $this->Util_model->generate_id(1111111111, 9999999999, "merchant_wallet", "ref", "varchar", true, 'fb') : $ref;
        $input = array(
            "amount" => $amount,
            "creditor" => $creditor,
            "debitor" => $debitor,
            "type" => $type,
            "extra" => $extra,
            "ref" => $ref,
            "status" => $status
        );
        $table = "merchant_wallet";

        if ($this->Db_model->insert($table, $input)) {
            /*if ($creditor > 0) {
                $this->add_to_wallet_ex($amount, $creditor, "credit", $ref);
            }
            if ($debitor > 0) {
                $this->add_to_wallet_ex($amount, $debitor, "debit", $ref);
            }*/
            return array("return" => true, "reference" => $ref);
        } else {
            return array("return" => false, "reference" => NULL);
        }
    }

    public function get_expected_earnings($uid)
    {
        $cid = $this->Util_model->get_user_info($uid, "cid", "profile");
        $ocs = $this->get_balance($uid, false, true);
        $date = date('Y-m');
        $total = $this->Util_model->sum_field("user_movement", "amount_paid", "WHERE cid='$cid' AND date LIKE '$date%' AND status=1");
        if ($total > 0) {
            $total = get_percentage($total, $this->Util_model->get_option("centre_share"));
            $total_ocs = $this->Util_model->sum_field("user_ocs", "amount", "WHERE cid='$cid' AND status=1");
            $per_ocs = ($total_ocs == 0) ? 0 : $total / $total_ocs;
            $exp_earnings = $per_ocs * $ocs;
        } else {
            $exp_earnings = 0;
        }
        return $exp_earnings;
    }

    public function total_referral_amount($uid)
    {
        $s = $this->Db_model->selectGroup("uid", "user_referrer", "WHERE refID=" . userdata(UID));
        $amount = 0;
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $amount += $this->Util_model->sum_field("user_movement", "amount_paid", "WHERE uid=$row[uid] AND status=1");
            }
        }
        return $amount;
    }

    public function get_centre_revenue($cid, $format = true, $bonus = false, $this_month = false)
    {
        $month = ($this_month) ? "AND date LIKE '" . date('Y-m') . "%'" : "";
        if (!$bonus) {
            $balance = $this->Util_model->sum_field("user_movement", "amount_paid", "WHERE cid='$cid' AND status=1 $month");
            //$debit += $this->Util_model->sum_field("escow", "amount", "WHERE uid=" . userdata(UID));
        } else {
            $balance = $this->Util_model->sum_field("user_ocs", "amount", "WHERE cid='$cid' AND status=1 $month");
        }
        if ($format) {
            return NGN . number_format($balance, 2);
        } else {
            return $balance;
        }
    }

    public function user_chart($uid, $levelID = 1)
    {
        $chart = '
        <div style="float:left; width:100%; height:85px;">
            <center>
                <img src="' . base_url() . $this->Util_model->picture($uid) . '" class="img-circle" style="margin-top:42.5px; width:42.5px; height:42.5px;">
                <p>Me</p>
            </center>
        </div>
        ';
        $upline = array($uid);
        $downline = array();
        $lastLevel = $this->Util_model->get_info("packages", "level", "WHERE status=1 ORDER BY level DESC LIMIT 1");
        for ($level = 1; $level <= $lastLevel; $level++) {
            foreach ($upline as $upliner) {
                if ($upliner == 0) {
                    $downline[] = 0;
                    $downline[] = 0;
                } else {
                    $s = $this->Db_model->selectGroup("uid", "user_referrer", "WHERE upline=$upliner");
                    if ($s->num_rows() == 0) {
                        $downline[] = 0;
                        $downline[] = 0;
                    } else if ($s->num_rows() == 1) {
                        $downline[] = $s->result_array()[0]['uid'];
                        $downline[] = 0;
                    } else {
                        $downline[] = $s->result_array()[0]['uid'];
                        $downline[] = $s->result_array()[1]['uid'];
                    }
                }
            }
            $upline = $downline;
            $div = pow(2, $level);
            $width = (100 / $div) . "%";
            $count = 1;
            foreach ($downline as $r_uid) {
                if ($count % 2 == 1) {
                    $background = base_url() . "assets/img/l_left.png";
                } else {
                    $background = base_url() . "assets/img/l_right.png";
                }
                if ($r_uid == 0) {
                    $username = "None";
                    $picture = base_url() . "assets/img/avatar/question.jpg";
                    $href = "javascript:;";
                } else {
                    $username = $this->Util_model->get_user_info($r_uid, "username", "profile");
                    $picture = base_url() . $this->Util_model->picture($r_uid);
                    $href = base_url() . "profile/$username";
                }

                $chart .= "
                <div style='float:left; width:$width; height:85px; background-image: url($background); background-size:cover; background-repeat:no-repeat;'>
                    <center>
                        <a href='$href'>
                            <img src='$picture' class='img-circle' style='margin-top:42.5px; width:42.5px; height:42.5px;'>
                        </a>
                        <p style='font-size:10px'>$username</p>
                    </center>
                </div>
                ";
                $count++;
                $downline = array();
            }
            if ($level == $this->Util_model->get_info("packages", "level", "WHERE id=$levelID")) {
                break;
            }
        }
        $chart .= "
        <div class='row' style='margin-top:20px'>
            <div class='col-xs-12 text-center text-bold'>
                <div class='well top-3x' style='padding:5px'>
                    " . get_suffix($this->Util_model->get_info("packages", "level", "WHERE id=$levelID")) . " level downline
                </div>
            </div>
        </div>
        ";

        return $chart;
    }

    public function distribute_ocs($id)
    {
        $uid = $this->Util_model->get_info("user_movement", "uid", "WHERE id=$id");
        if ($this->Util_model->row_count("user_level", "WHERE uid=$uid") == 0) {
            $this->Db_model->insert("user_level", ["uid" => $uid]); //Add the user to level
        }
        $refID = $this->Util_model->get_user_info($uid, "refID", "referrer");

        if ($this->Util_model->row_count("user_referrer", "WHERE upline=$refID") >= 2) {
            $s = $this->Db_model->selectGroup("uid", "user_referrer", "WHERE upline=$refID");
            $ref_array = $s->result_array();
            $end = false;
            while (!$end) {
                $ref_array2 = array();
                foreach ($ref_array as $ref) {
                    if ($this->Util_model->row_count("user_referrer", "WHERE upline=$ref[uid]") >= 2) {
                        $ss = $this->Db_model->selectGroup("uid", "user_referrer", "WHERE upline=$ref[uid]");
                        if ($ss->num_rows() > 0) {
                            foreach ($ss->result_array() as $row) {
                                $ref_array2[] = $row['uid'];
                            }
                        }
                    } else {
                        $refID = $ref['uid'];
                        $end = true;
                        break;
                    }
                }
                $ref_array = $ref_array2;
            }
        }

        $this->Db_model->update("user_referrer", ["upline" => $refID], "WHERE uid=$uid"); //Update user upline
        $level1 = $this->Util_model->get_user_info($refID, "level1", "level") + 1;
        $this->Db_model->update("user_level", ["level1" => $level1], "WHERE uid=$refID"); //Update R level 1
        if ($level1 == 2) {
            $upline = $this->Util_model->get_user_info($refID, "upline", "referrer");
            $uplines[] = $upline;
            while ($upline > 0) {
                $upline = $this->Util_model->get_user_info($upline, "upline", "referrer");
                if ($upline > 0) {
                    $uplines[] = $upline;
                }
            } //Get all the uplines

            if ($this->Util_model->get_user_info($refID, "package", "profile") == 3) {
                $this->add_to_bonus($this->Util_model->get_option("complete_ocs_bonus"), $refID, "Shareholder", 1, $this->Util_model->get_user_info($refID, "cid", "profile"));
            } //Make the R a shareholder if R is a V-VIP

            foreach ($uplines as $upline) {
                if ($this->Util_model->get_user_info($upline, "package", "profile") == 3) { //Check if the upline is a V-VIP member
                    $this->add_to_bonus($this->Util_model->get_option("pairing_ocs_bonus"), $upline, "Leverage", 1, $this->Util_model->get_user_info($upline, "cid", "profile"));
                    //Add a pairing bonus
                }
            }
            //Done with level 1

            if (isset($uplines[0]) || $uplines[0] > 0) {
                $level2 = $this->Util_model->get_user_info($uplines[0], "level2", "level");
                if ($level2 < 2) {
                    $level2++;
                    $this->Db_model->update("user_level", ["level2" => $level2], "WHERE uid=$uplines[0]"); //Update R2 level 2
                }

                if ($level2 == 2) {
                    if ($this->Util_model->get_user_info($uplines[0], "package", "profile") == 2) {
                        $shareholder = $uplines[0];
                        $this->add_to_bonus($this->Util_model->get_option("complete_ocs_bonus"), $uplines[0], "Shareholder", 1, $this->Util_model->get_user_info($uplines[0], "cid", "profile"));
                    } //Make the R a shareholder if R is a V-VIP
                    foreach ($uplines as $upline) {
                        if ($this->Util_model->get_user_info($upline, "package", "profile") == 2) { //Check if the upline is a V-VIP member
                            if ($shareholder != $upline) {
                                $this->add_to_bonus($this->Util_model->get_option("pairing_ocs_bonus"), $upline, "Pairing", 1, $this->Util_model->get_user_info($upline, "cid", "profile"));
                            }
                            //Add a pairing bonus
                        }
                    }
                    //Done with level 2

                    if (isset($uplines[1]) || $uplines[1] > 0) {
                        $level3 = $this->Util_model->get_user_info($uplines[1], "level3", "level");
                        if ($level3 < 2) {
                            $level3++;
                            $this->Db_model->update("user_level", ["level3" => $level3], "WHERE uid=$uplines[1]"); //Update R2 level 2
                        }
                        if ($level3 == 2) {
                            if ($this->Util_model->get_user_info($uplines[1], "package", "profile") == 1) {
                                $shareholder = $uplines[1];
                                $this->add_to_bonus($this->Util_model->get_option("complete_ocs_bonus"), $uplines[1], "Shareholder", 1, $this->Util_model->get_user_info($uplines[1], "cid", "profile"));
                            }
                            //Make the R a shareholder if R is a V-VIP
                            foreach ($uplines as $upline) {
                                if ($this->Util_model->get_user_info($upline, "package", "profile") == 1) { //Check if the upline is a V-VIP member
                                    if ($shareholder != $upline) {
                                        $this->add_to_bonus($this->Util_model->get_option("pairing_ocs_bonus"), $upline, "Pairing", 1, $this->Util_model->get_user_info($upline, "cid", "profile"));
                                    }
                                    //Add a pairing bonus
                                }
                            }
                            //Done with level 1


                        }
                    }
                }
            }
        }
    }

    public function add_point($uid)
    {
        $ref = $this->Util_model->get_info("user_referrer", "ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, ref10", "WHERE uid=$uid");
        $s = $this->Db_model->selectGroup("level, package, point", "commission");
        foreach ($s->result_array() as $row) {
            $index = "ref$row[level]";
            $point = $row['point'];
            if ($ref[$index] > 0 && $this->Util_model->get_user_info($ref[$index], "package", "profile") >= $row['package']) {
                $points = $this->Util_model->get_user_info($ref[$index], "point", "profile") + $point;
                $this->Db_model->update("user_profile", ["point" => $points], "WHERE uid=" . $ref[$index]);
                $rankings = $this->Db_model->selectGroup("*", "ranking", "WHERE status=1 ORDER BY id DESC");
                foreach ($rankings->result_array() as $rank) {
                    if ($points >= $rank['target']) {
                        if ($this->Util_model->get_user_info($ref[$index], 'rank', 'profile') != $rank['id']) {
                            $this->Db_model->update("user_profile", ["point" => $points], "WHERE uid=" . $ref[$index]);
                        }
                    }
                }
            }
        }
    }

    public function add_comm($uid, $reference = "", $type = "upgrade")
    {
        $ref = $this->Util_model->get_info("user_referrer", "ref1, ref2, ref3, ref4, ref5", "WHERE uid=$uid");
        $s = $this->Db_model->selectGroup("*", "commission");
        foreach ($s->result_array() as $row) {
            $index = "ref$row[level]";
            if ($ref[$index] > 0 && $this->Util_model->get_user_info($ref[$index], "package", "profile") >= $row['package']) {
                $amount = $this->Util_model->get_info("user_wallet", "amount", "WHERE ref='$reference'");
                $comm = get_percentage($amount, $row[$type]);
                $extra = ($type == "upgrade") ? "user_upgrade" : $type;
                $comm_ref = $this->Main_model->add_to_wallet($comm, $ref[$index], 0, ucfirst($type) . " commission from " . get_suffix($row['level']) . " generation", ucfirst($type) . " commission from " . get_suffix($row['level']) . " generation", "$type commission", "$extra:" . $this->scansio_db_man->select($extra, "id", "WHERE ref='$reference'"), "", 1)["reference"];
                $this->budget_income($comm_ref); //Budget the income for the member
            }
        }
        return true;
    }

    public function budget_income ($ref) {
        $wallet = $this->Util_model->get_info("user_wallet", "amount, creditor, type", "WHERE ref='$ref'");
        if ($wallet) {
            $uid = $wallet['creditor'];
            $amt = $wallet['amount'];
            $saving_share = $this->Util_model->get_info("user_options", "value", "WHERE uid=$uid AND name='savings'");
            $investment_share = $this->Util_model->get_info("user_options", "value", "WHERE uid=$uid AND name='investment'");
            $project_share = $this->Util_model->get_info("user_options", "value", "WHERE uid=$uid AND name='project'");
            $saving_share = ($saving_share == 0) ? 0 : get_percentage($amt, $saving_share);
            $investment_share = ($investment_share == 0) ? 0 : get_percentage($amt, $investment_share);
            $project_share = ($project_share == 0) ? 0 : get_percentage($amt, $project_share);
            $tax = $this->Util_model->get_info("packages", "tax", "WHERE id=".$this->Util_model->get_user_info($uid, "package", "profile"));
            $tax = get_percentage($amt, $tax);
            $this->Main_model->add_to_wallet($tax, 0, $uid, "", "", "Income tax", "user_wallet:ref=$ref", "", 1); //Remove tax
            
            $budget = ($saving_share + $investment_share + $project_share);
            if ($budget > 0) {
                $this->Main_model->add_to_wallet($budget, 0, $uid, "", "", "Budget shares", "user_wallet:ref=$ref", "", 1); //Remove the total budget
            }
            if ($saving_share > 0) {
                $this->Main_model->add_to_wallet($saving_share, $uid, 0, "", "", "$wallet[type] share", "user_wallet:ref=$ref", "", 1, "user_wallet_saving"); //Add to savings wallet
            }
            if ($investment_share > 0) {
                $this->Main_model->add_to_wallet($investment_share, $uid, 0, "", "", "$wallet[type] share", "user_wallet:ref=$ref", "", 1, "user_wallet_investment"); //Add to investment wallet
            }
            if ($project_share > 0) {
                $this->Main_model->add_to_wallet($project_share, $uid, 0, "", "", "$wallet[type] share", "user_wallet:ref=$ref", "", 1, "user_wallet_project"); //Add to project wallet
            }
            
        }
    }

    public function get_total_network($uid, $generation = 0, $this_month = false, $active = 1)
    {
        $ref = array(0, 0, 0, 0, 0);
        for ($i = 1; $i <= 5; $i++) {
            $this_month = ($this_month) ? "AND p.date LIKE '" . date("Y-m") . "%'" : "";
            $duration = ($active == 1) ? "p.duration > 0" : "p.duration = 0";
            $s = $this->Db_model->query("SELECT r.id FROM user_referrer r, user_profile p WHERE r.uid = p.uid AND r.ref$i = $uid AND $duration $this_month");
            $ref[$i] = $s->num_rows();
        }
        if ($generation == 0) {
            $total = 0;
            foreach ($ref as $gen) {
                $total += $gen;
            }
            return $total;
        } else {
            return $ref[$generation];
        }
    }

    public function get_user_ranking($uid, $field = "symbol")
    {
        $rank = $this->Util_model->get_info("ranking", "*", "WHERE id=".$this->Util_model->get_user_info($uid, "rank", "profile"));
        $star = "";
        if ($rank["id"] == 8) {
            $star = "<i class='fa fa-crown'></i>";
        } else {
            if ($rank["star"] > 0) {
                for ($i=1; $i<=$rank["star"]; $i++) {
                    $star .= "<i class='fa fa-star'></i>";
                }
            } else {
                $star = "&nbsp;";
            }
        }
        if ($rank["id"] == 1) {
            $progress = "0% Completed";
            $next_rank = "Next Rank: Member";
        } else if ($rank["id"] >= 7) {
            $progress = "100% Completed</span>";
            $next_rank = "All Ranks Achieved";
        } else {
            $next_rank = $rank["id"] + 1;
            $n_rank = $this->Util_model->get_info("ranking", "*", "WHERE id=$next_rank");
            $worth = $this->get_worth($uid, false, false);
            if ($worth >= $n_rank["target"]) {
                //promote to next rank
            } else {
                $per = ($worth == 0) ? 0 : get_percentage($n_rank["target"], $worth);
                $per = round($per, 2);
                $progress = "$per% Completed";
            }
            $next_rank = "Next Rank: $n_rank[name]";
        }
        return ["rankID"=>$rank["id"], "ranking"=>$rank["name"], "star"=>$star, "progress"=>$progress, "next_rank"=>$next_rank];
    }

    #########################################################################

    public function get_pair_price($pair)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.binance.com/api/v3/ticker/price",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        $price = 0;

        if (!$err) {
            $tranx = json_decode($response, true);
            foreach ($tranx as $pairs) {
                if ($pairs['symbol'] == $pair) {
                    $price = $pairs['price'];
                }
            }
        }
        return $price;
    }

    public function get_trades($uid = NULL)
    {
        $uid = ($uid == NULL) ? userdata(UID) : $uid;
        $trades = $this->Db_model->selectGroup("*", "trading_user", "WHERE status=1 AND uid=$uid");
        if ($trades->num_rows() > 0) {
            foreach ($trades->result_array() as $trade) {
                $trading = $this->Util_model->get_info("trading_main", "*", "WHERE id=$trade[tid]");
                $return = "
                    <div><i class='fa fa-exchange'></i> Buy #$trading[pairs]</div>
                    <div><i class='fa fa-play text-green'></i> Buy Price: $trading[buy]</div>
                    <div><i class='fa fa-check-square text-black'></i> Sell Price: $trading[sell] +" . round(((($trading['sell'] - $trading['buy']) * 100) / $trading['buy']), 2) . "%</div>
                    <div><i class='fa fa-square text-red'></i> Stop Loss: $trading[stop] " . round(((($trading['stop'] - $trading['buy']) * 100) / $trading['buy']), 2) . "%</div>
                    <div><i class='fa fa-times-circle text-red'></i> Cancel Trade: " . remaining_time(next_prev_date($trading['date'], "day", 1, 2, "Y-m-d H:i:s")) . "</div>
                    <div><i class='fa fa-money'></i> Traded Amount: <b>" . NGN . number_format($trade["amount"]) . "</b></div>
                    <hr>
                    <div><i class='fa fa-circle text-green blink'></i> Current Price: $trading[price] <i class='fa fa-long-arrow-right'></i> <b>" . round(((($trading['price'] - $trading['buy']) * 100) / $trading['buy']), 2) . "%</b></div>
                ";
            }
        } else {
            $return = "<p>No trading performed yet</p>";
        }
        return $return;
    }

    public function worth_ranks ($type="direct", $date=NULL) {
        $date = ($date == NULL) ? date('Y') : $date;
	    $s = $this->Db_model->query("SELECT DISTINCT uid FROM user_worth WHERE type='$type' AND date LIKE '$date%' AND status=1");
	    $scores = array();
	    $score = array();
	    if ($s->num_rows() > 0) {
	        foreach ($s->result_array() as $row) {
	            $value = $this->Util_model->sum_field("user_worth", "amount", "WHERE uid=$row[uid] AND type='$type'");
	            $score[] = $value;
	            $scores[] = ["uid"=>$row['uid'], "score"=>$value, "type"=>$type];
            }
        }
        array_multisort($score, SORT_DESC, $scores);
        return $scores;
    }

    public function users_positions ($type="direct", $num=10) {
        $scores = $this->worth_ranks($type);
        $board = array();
        $count = 1;
        foreach ($scores as $users) {
            $board[] = ["position"=>$count, "uid"=>$users['uid'], "type"=>$users['type'], "worth"=>$users['score']];
            $count++;
            if ($count == $num) {
                break;
            }
        }
        return $board;
    }

    public function user_position ($uid, $type="direct") {
        $scores = $this->worth_ranks($type);
        $count = 1;
        $board = ["position" => 0, "uid" => $uid, "type" => $type, "worth" => 0];
        foreach ($scores as $user) {
            if ($uid == $user['uid']) {
                $board = ["position" => $count, "uid" => $uid, "type" => $user['type'], "worth" => $user['score']];
                break;
            }
            $count++;
        }
        return $board;
    }

    public function ranking_comm ($uid, $amount) {
        $refs = $this->Util_model->get_info("user_referrer", "ref1, ref2, ref3, ref4, ref5", "WHERE uid=$uid");
        foreach ($refs as $field => $ref) {
            if ($ref > 0) {
                $type = ($field == 'ref1') ? "direct" : "indirect";
                $this->add_to_worth($amount, $ref, $type, 1);
                $curr_rank = $this->Util_model->get_user_info($ref, "rank", "profile");
                $next_rank = $curr_rank + 1;
                $rank = $this->Util_model->get_info("ranking", "*", "WHERE id=$next_rank");
                if ($rank["target"] > 0) {
                    $worth = $this->get_worth($ref, false, false, false);
                    if ($worth >= $this->$rank["target"]) {
                        if ($this->Db_model->update("user_profile", ["rank" => $next_rank], "WHERE uid=$ref")) {
                            $data = array (
                                "uid" => $uid,
                                "rank" => $next_rank,
                                "worth" => $worth,
                                "prize" => $rank['prize'],
                                "date" => date_time()
                            );
                            $this->Db_model->insert("ranking_achiever", $data);
                        }
                        //Send a congratoratory mail
                    }
                }
            }
        }
    }
}
