<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/9/2020
 * Time: 10:41 PM
 */
/**Class to interact with monnify API
 *
 * @param array $requirements
 */
class Monnify_model extends CI_Model
{

    private $baseUrl = 'https://api.monnify.com/api/v1';
    private $username = '';
    private $password = '';
    private $contractCode = '';
    private $subaccount = [];
    private $accessToken;
    private $tokenExpiry = 0;

    /**Initialise API credentials
     * Monnify constructor.
     * @param $username
     * @param $password
     * @param $contractCode
     */
    public function __construct()
    {
        parent::__construct();
        if ($this->Util_model->get_option("monnify_status") == 'live') {
            $this->username = $this->Util_model->get_option("monnify_live_apikey");
            $this->password = $this->Util_model->get_option("monnify_live_secretkey");
            $this->contractCode = $this->Util_model->get_option("monnify_live_contract_code");
            $this->subaccount = $this->Util_model->get_option("monnify_live_subaccount");
        } else {
            $this->username = $this->Util_model->get_option("monnify_test_apikey");
            $this->password = $this->Util_model->get_option("monnify_test_secretkey");
            $this->contractCode = $this->Util_model->get_option("monnify_test_contract_code");
            $this->subaccount = $this->Util_model->get_option("monnify_test_subaccount");
        }

    }


    /**Return base64 encoded string of username and password
     * @return string
     */
    private function encodedString()
    {
        return base64_encode("$this->username:$this->password");
    }

    /**Attempt to login using default credentials
     * @return $this|bool
     */
    public function authenticate()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->baseUrl . "/auth/login",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => 1,
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Basic " . $this->encodedString(),
                "cache-control: no-cache"
            ],
        ));

        $decodedResponse = json_decode(curl_exec($curl), true);
        $err = curl_error($curl);

        if ($decodedResponse['requestSuccessful']) {
            $this->accessToken = $decodedResponse['responseBody']['accessToken'];
            $this->tokenExpiry = time() + $decodedResponse['responseBody']['expiresIn'];

            return $this;
        }

        return false;

    }

    /**Check if token is still valid, re-authenticate if token expired
     * and return valid token
     * @return string
     */
    public function getRefreshToken()
    {
        if ($this->isTokenValid()) {
            $token = $this->accessToken;
        } else {
            $token = $this->authenticate()->getAccessToken();
        }

        return $token;
    }

    /**
     * @return null|string
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }

    /**
     * @return null|string
     */
    public function getContractCode()
    {
        return $this->contractCode;
    }

    /**
     * @return null|string
     */
    public function getSubaccount()
    {
        return $this->subaccount;
    }

    /**
     * @return null|string
     */
    public function getTokenExpiry()
    {
        return $this->tokenExpiry;
    }

    /**check if the current token
     * hasn't expired
     * @return bool
     */
    public function isTokenValid()
    {
        return ($this->accessToken && time() < $this->tokenExpiry);
    }

    /**I'm using this so as not to rely on third package request package
     * like guzzle
     * @param string $endpoint
     * @param string $method
     * @param array $headers
     * @param array $body
     * @return mixed
     */
    private function request($endpoint, $method = 'POST', array $headers = [], array $body = [])
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->baseUrl . '/' . $endpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => $headers,
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        return json_decode($response, true);

    }

    /**
     * @param array $body
     * @return bool|object
     */
    public function reserveAccount($uid)
    {

        $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
        $main = $this->Util_model->get_info("user_main", "*", "WHERE uid=$uid");
        $data = array(
            "accountReference" => $this->Util_model->generate_id(11111111, 99999999, "user_account", "reference", "var", true, "f"),
            "accountName" => strtoupper(SITE_TITLE." ".$pro['username']),
            "currencyCode" => "USD",
            "contractCode" => $this->monnify->getContractCode(),
            "customerEmail" => $pro['email'],
            "customerName" => $main['name'],
            "incomeSplitConfig" => [
                [
                    "subAccountCode" => $this->monnify->getSubaccount(),
                    "feePercentage" => 100,
                    "splitPercentage" => 99,
                    "feeBearer" => true
                ]
            ]
        );
        $expectedReference = $data['accountReference'];

        $headers = [
            "authorization: Bearer ".$this->getRefreshToken(),
            "content-type: application/json",
            "cache-control: no-cache"

        ];

        $response = $this->request('bank-transfer/reserved-accounts', 'POST', $headers, $data);

        if ($response['requestSuccessful']) {
            $data = [
                "uid"           =>  $uid,
                "reference"     =>  $response['responseBody']['accountReference'],
                "bank"          =>  '101',
                "acct_name"     =>  $response['responseBody']['accountName'],
                "acct_num"      =>  $response['responseBody']['accountNumber'],
                "status"        =>  1
            ];
            if ($this->Db_model->insert("user_account", $data)) {
                return true;
            } else {
                $this->unReserveAccount($response['responseBody']['accountNumber']);
                return false;
            }
        }
        return false;

    }

    /**
     * @param string $reference
     * @return bool|object
     */
    public function getTransactionStatus($reference)
    {

        $headers = [
            "authorization: Bearer ".$this->getRefreshToken(),
            "content-type: application/json",
            "cache-control: no-cache"

        ];

        $response = $this->request("bank-transfer/reserved-accounts/transactions?accountReference=$reference&page=0&size=5", 'GET', $headers);
        return $response;
        /*$uid = $this->Util_model->get_info("user_account", "uid", "WHERE reference='$reference'");

        if ($response['requestSuccessful']) {
            if (count($response['responseBody']['content']) != 0) {
                $values = "";
                $count = 0;
                foreach ($response['responseBody']['content'] as $content) {
                    if ($this->Util_model->row_count("user_wallet", "WHERE ref='$content[transactionReference]'") == 0) {
                        $amount = $content['amountPaid'] - (get_percentage($content['amountPaid'], $this->Util_model->get_option('monnify_fee')));
                        $values .= "($amount, $uid, 0, '$content[paymentDescription]', '$content[paymentDescription]', 'Providus Bank Transfer',
                        '$reference', '$content[transactionReference]', 1), ";
                        $count++;
                    }
                }
                if ($count > 0) {
                    $fields = "(amount, creditor, debitor, creditor_desc, type, ref, status)";
                    $values = rtrim($values, ", ");
                    if ($this->Db_model->query("INSERT INTO user_wallet $fields VALUES $values")) {
                        return true;
                    }
                }
            }
        }
        return false;*/

    }

    public function getTransactions ($page=0, $size=10) {
        $headers = [
            "authorization: Bearer ".$this->getRefreshToken(),
            "content-type: application/json",
            "cache-control: no-cache"

        ];

        $response = $this->request("transactions/search?page=$page&size=$size", 'GET', $headers);
        return $response;
    }

    public function updateTransactions () {
        $response = $this->getTransactions();
        if ($response['requestSuccessful']) {
            if (count($response['responseBody']['content']) != 0) {
                $values = "";
                $count = 0;
                $contents = $response['responseBody']['content'];
                foreach ($contents as $content) {
                    if ($content['paymentStatus'] == 'PAID' && $this->Util_model->row_count("user_wallet", "WHERE ref='$content[paymentReference]'") == 0) {
                        $amount = round($content['amount'] - (get_percentage($content['amount'], $this->Util_model->get_option('monnify_fee'))), 2);
                        $uid = $this->Util_model->get_info("user_profile", "uid", "WHERE email='".$content['customerDTO']['email']."'");
                        $reference = $this->Util_model->get_info("user_account", "reference", "WHERE uid=$uid");
                        $values .= "($amount, $uid, 0, '$content[paymentDescription]', '$content[paymentDescription]', 'Providus Bank Transfer',
                        '$reference', '$content[transactionReference]', 1), ";
                        //Referral bonus
                        $refID = $this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$uid");
                        if ($refID != 0) {
                            if ($this->Util_model->row_count("user_wallet", "WHERE creditor=$uid AND status=1") == 1) {
                                $bonus = get_percentage($this->Util_model->get_info("user_wallet", "amount", "WHERE ref='$reference'"), 5);
                                $data = array(
                                    "creditor" => $refID,
                                    "debitor" => 0,
                                    "amount" => $bonus,
                                    "type" => "Referral Bonus",
                                    "ref" => $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, "fb"),
                                    "status" => 1
                                );
                                $this->Db_model->insert("user_bonus", $data);
                            }
                        }
                        //Referral bonus ends
                        $count++;
                    }
                    //$ref[] = $content['customerDTO']['email'];
                }
                if ($count > 0) {
                    $fields = "(amount, creditor, debitor, creditor_desc, debitor_desc, type, extra, ref, status)";
                    $values = rtrim($values, ", ");
                    if ($this->Db_model->query("INSERT INTO user_wallet $fields VALUES $values")) {
                        return true;
                    }
                    //return "INSERT INTO user_wallet $fields VALUES $values";
                }
            }
        }
        return false;
    }

    /**
     * @param string $accountNumber
     * @return bool|object
     */
    public function unReserveAccount($accountNumber)
    {

        $headers = [
            "authorization: Bearer ".$this->getRefreshToken(),
            "cache-control: no-cache"

        ];

        $response = $this->request("bank-transfer/reserved-accounts/$accountNumber", 'DELETE', $headers);

        if ($response['requestSuccessful']) {
            return $response['responseBody'];
        }
        return false;

    }


}

?>