<?php
function msg($message, $title = 'Message'): string
{
    $info = '<div class="col-lg-offset-3 col-md-offset-3 col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <div class="box box-border">
                    <div class="box-header with-border">
                        <p class="text-center"> ' . $title . ' </p
                    </div>
                    <div class="box-body text-center">
                        <p>' . $message . '</p> 
                    </div>
                    <div class="box-footer">
                        <ul class="products-list product-list-in-box">
                            <li>
                                <a href="javascript:" data-dismiss="alert" class="product-info close">Close</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>';
    return $info;
}

function getFormattedDuration($seconds)
{
    $hour = floor($seconds / 3600);
    $minute = floor(($seconds / 60) % 60);
    $second = floor(($seconds % 60));
    return ($hour >= 1 ? $hour . ':' : '') . "$minute:$second";
}

function flash_msg($success, $message = '', $formatted = true)
{
    $template = "
        
    ";
    $message = ($success && $message == '' ? 'Success!!!' : (!$success && $message == '' ? 'Error' : $message));
    if ($success) {
        if ($formatted) {
            $message = alert_msg("<i class='fa fa-check-circle'></i> $message", "alert-success", 1);
        }
        set_flashdata('msg', $message);
    } else {
        if ($formatted) {
            $message = alert_msg("<i class='fa fa-remove'></i> $message", "alert-danger", 1);
        }
        set_flashdata('msg', $message);
    }
}


