<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Studio_model extends Ci_Model
{

    public function manage_courses()
    {
        $uid = userdata(UID);
        $where = "WHERE course_instructor = $uid AND status != ".HOTLISTED." ORDER BY last_update DESC";
        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where);
        $view = '';
        if ($courses && count($courses) > 0) {
            $view .= "
                        <table class='table table-hover table-striped dataTable'>
                            <thead>
                                <tr>
                                    <th>
                                        Code
                                    </th>
                                    <th>
                                        Thumbnail
                                    </th>
                                    <th>
                                        Title
                                    </th>
                                    <th>
                                        Level
                                    </th>
                                    <th>
                                        Category
                                    </th>
                                    <th>
                                        Topics
                                    </th>
                                    <th>
                                        Price
                                    </th>
                                    <th>
                                        Time
                                    </th>
                                    <th>
                                        Updated
                                    </th>
                                    <th>
                                        Sold
                                    </th>
                                    <th class='action d-print-none'>
                                        Action
                                    </th>
                                </tr>
                            </thead>
                        <tbody>";
    
            foreach ($courses as $course) {
                $code = $course['course_code'];
                $title = $course['course_title'];
                $level = $course['course_level'];
                $level = ($level && $level == EXPERT ? 'Expert' : ($level == ADVANCE ? 'Advance' : 'Beginner'));
                $category = $this->scansio_db_man->select('academy_category', '', 'WHERE id = ' . $course['category']);
                $category = ($category ? $category['title'] : 'Miscellaneous');
                $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]'");
                $topics = ($topics ? count($topics) : 0);
                $price = $course['course_price'];
                $time = $course['course_time'];
                $updated = $course['last_update'];
                $status = $course['status'];
                $sold = $this->scansio_db_man->rowCount('course_purchase', "WHERE course_code = '$course[course_code]'");
                $topics_where = "WHERE course_code='$course[course_code]' ORDER BY position ASC";
                $topic_code = '0';
                $last_watched_topic = $this->scansio_db_man->select('academy_watched', '', "WHERE uid=" . userdata(UID) . " AND course_code='$course[course_code]' ORDER BY date DESC");
                if (!$last_watched_topic || count($last_watched_topic) < 1 || ($topic_code = $last_watched_topic['topic_code']) == 0) {
                    $t_topics = $this->scansio_db_man->selectGroup('academy_topic', '', $topics_where);
                    if ($t_topics && isset($topics[0])) {
                        $topic_code = $topics[0]['id'];
                    }
                }
                $read_link = "window.location = \"" . base_url() . "academy/$course[course_code]/$topic_code\"";
                $statusLink = '';
                $statusText = '';
                if ($status == PUBLISHED) {
                    $statusText = 'Unpublish';
                    $statusLink = base_url() . "studio/command/$course[course_code]/" . UNPUBLISH;
                } else if ($status == PENDING_PUBLISH) {
                    $statusText = 'Publish';
                    $statusLink = $this->scansio_db_man->select("course_publishing_fee", '', "WHERE course_code = '$code' AND status = ".ACTIVE) ? base_url() . "studio/command/$course[course_code]/" . PUBLISH : "javascript:publish_course(\"".base_url() . "studio/command/$course[course_code]/" . PUBLISH."\");";
                } else if ($status == SUSPENDED) {
                    $statusText = 'Suspended';
                    $statusLink = 'javascript:';
                } else if ($status == PENDING_APPROVAL) {
                    $statusText = 'Pending';
                    $statusLink = 'javascript:';
                } else if ($status == APPROVAL_DECLINED) {
                    $statusText = 'Re-publish';
                    $statusLink = base_url() . "studio/command/$course[course_code]/" . PUBLISH;
                }
    
                $view .= "     
                        <tr>
                            <td>
                                $code
                            </td>
                            <td>
                                <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor' onclick='$read_link'>
                            </td>
                            <td>
                                $title
                            </td>
                            <td>
                                $level
                            </td>
                            <td>
                                $category
                            </td>
                            <td>
                                $topics
                            </td>
                            <td>
                                <b>".USD."</b>$price
                            </td>
                            <td>
                                " . getFormattedDuration($time) . "
                            </td>
                            <td>
                                $updated
                            </td>
                            <td>
                                $sold
                            </td>
                            <td>
                                <a href='" . base_url() . "studio/command/$course[course_code]/" . HOTLIST . "' class='btn btn-danger btn-xs no-border' ><i class='fa fa-remove'></i> Delete</a>
    
                                <a href='" . base_url() . "studio/course-edit/$course[course_code]" . "' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
    
                                <a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='$statusText' " . ($status == SUSPENDED ? 'disabled' : '') . "><i class='fa fa-check'></i> $statusText </a>
                            </td>
                        </tr>
                        
                    ";
            }
            $view .= "
                </tbody>
            </table>
            ";
        } else {
            $view = 'You have created any course yet';
        }
        $data['breadcrumb'] = '
            <ol class="breadcrumb">
                <li><a href="' . base_url('studio/approved_courses') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
                <li><i class="fa fa-graduationcap"></i> Manage Courses </li>
            </ol>
            ';
        $data['pane'] = "ecourse";
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['view'] = $view;
        //$data['main_content'] = ;
        $this->load->view('studio/manage_courses', $data);
    }

    public function manage_books()
    {
        $uid = userdata(UID);
        $where = "WHERE author = $uid AND status != ".HOTLISTED." ORDER BY last_update DESC";
        $books = $this->scansio_db_man->selectGroup('book_main', '', $where);
        $view = '';
        if ($books && count($books) > 0) {
            
            $view .= "
                <table class='table table-hover table-striped dataTable'>
                    <thead>
                        <tr>
                            <th>
                                Cover Page
                            </th>
                            <th>
                                Title
                            </th>
                            <th>
                                Price
                            </th>
                            <th>
                                Chapters
                            </th>
                            <th>
                                Edition
                            </th>
                            <th>
                                Category
                            </th>
                            <th>
                                Type
                            </th>
                            <th>
                                Sold
                            </th>
                            <th class='action d-print-none'>
                                Action
                            </th>
                        </tr>
                    </thead>
                <tbody>
            ";
    
            foreach ($books as $row) {
                $book_id = $row['book_id'];
                $author = $this->scansio_db_man->select('user_main', '', 'WHERE uid = ' . $row['author']);
                if (!$author) $author = 'Unknown';
                $author = $row['author'] == userdata(UID) ? 'You' : $author;
                $category = $this->scansio_db_man->select('book_category', '', 'WHERE id = ' . $row['cat_id'])['title'];
                $type = $this->scansio_db_man->select('book_type', '', 'WHERE id = ' . $row['type'])['title'];
                $chapters = $row['chapters'];
                $edition = $row['edition'];
                $status = $row['status'];
                $sold = $this->scansio_db_man->rowCount('book_purchase', "WHERE book_id = $book_id");
                $read_link = "window.location = \"" . base_url() . "academy/ebook/" . urlencode($row['title']) . "/$row[book_id]\"";
                $statusLink = '';
                $statusText = '';
                if ($status == PUBLISHED) {
                    $statusText = 'Unpublish';
                    $statusLink = base_url() . "studio/command/$row[book_id]/" . UNPUBLISH;
                } else if ($status == PENDING_PUBLISH) {
                    $statusText = 'Publish';
                    $statusLink = $this->scansio_db_man->select("book_publishing_fee", '', "WHERE book_id = $book_id AND status = ".ACTIVE) ? base_url() . "studio/command/$book_id/" . PUBLISH : "javascript:publish_book(\"".base_url() . "studio/command/$row[book_id]/" . PUBLISH."\");";
                } else if ($status == SUSPENDED) {
                    $statusText = 'Suspended';
                    $statusLink = 'javascript:';
                } else if ($status == PENDING_APPROVAL) {
                    $statusText = 'Pending';
                    $statusLink = 'javascript:';
                } else if ($status == APPROVAL_DECLINED) {
                    $statusText = 'Re-publish';
                    $statusLink = base_url() . "studio/command/$row[book_id]/" . PUBLISH;
                }
    
                $view .= "     
                    <tr>
                        <td>
                            <img src='" . base_url($row['pic_url']) . "' style='height: 100px; width: 80px;'  class='pointer-cursor' onclick='$read_link'>
                        </td>
                        <td>
                            $row[title]
                        </td>
                        <td>
                            <b>".USD."</b>$row[price]
                        </td>
                        <td>
                            $chapters
                        </td>
                        <td>
                            $edition
                        </td>
                        <td>
                            $category
                        </td>
                        <td>
                            $type
                        </td>
                        <td>
                            $sold
                        </td>
                        <td>
                            <a href='" . base_url() . "studio/command/$row[book_id]/" . HOTLIST . "' class='btn btn-danger btn-xs no-border' title='Caution are you sure of this please to retrieve it you have to contact admin.'><i class='fa fa-remove'></i> Delete</a>

                            <a href='" . base_url() . "studio/book-edit/$row[book_id]' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>

                            <a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='Publish'><i class='fa fa-check'></i> $statusText </a>
                        </td>
                    </tr>
                    
                ";
            }
    
            $view .= "
                    </tbody>
                </table>
            ";
        } else {
            $view = "You have not created any book yet.";
        }
        $data['breadcrumb'] = '
            <ol class="breadcrumb">
                <li><a href="' . base_url('studio/manage-books') . '"><i class="fa fa-dashboard"></i> Manage Books</a></li>
                <li><i class="fa fa-graduationcap"></i> Create Book </li>
            </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['pane'] = "ebook";
        $data['view'] = $view;
        $data['main_content'] = '';
        $this->load->view('studio/manage_books', $data);
    }

    private function manage_scripts()
    {
        $where = "WHERE status != ".HOTLISTED." ORDER BY date DESC";
        $scripts = $this->scansio_db_man->selectGroup('script', '', $where);
        $view = '';
        $view .= "
            <table class='table table-hover table-striped'>
                <thead>
                    <tr>
                        <th>
                            Thumbnail
                        </th>
                        <th>
                            Title
                        </th>
                        <th>
                            Created
                        </th>
                        <th class='action d-print-none'>
                            Action
                        </th>
                    </tr>
                </thead>
            <tbody>
        ";

        foreach ($scripts as $row) {
            $author = $this->scansio_db_man->select('user_main', '', 'WHERE uid = ' . $row['author'])['name'];
            if (!$author) $author = 'Unknown';
            $author = $row['author'] == userdata(UID) ? 'You' : $author;
            $status = $row['status'];
            $read_link = "window.location = \"" . base_url() . "academy/escript/$row[id]\"";
            $statusLink = '';
            $statusText = '';
            if ($status == PUBLISHED) {
                $statusText = 'Unpublish';
                $statusLink = base_url() . "studio/script-action/$row[id]/" . UNPUBLISH;
            } else if ($status == PENDING_PUBLISH) {
                $statusText = 'Publish';
                $statusLink = base_url() . "studio/script-action/$row[id]/" . PUBLISH;
            } else if ($status == SUSPENDED) {
                $statusText = 'Suspended';
                $statusLink = 'javascript:';
            } else if ($status == PENDING_APPROVAL) {
                $statusText = 'Pending';
                $statusLink = 'javascript:';
            } else if ($status == APPROVAL_DECLINED) {
                $statusText = 'Re-publish';
                $statusLink = base_url() . "studio/script-action/$row[id]/" . PUBLISH;
            } else if ($status == HOTLISTED) {
                $statusText = 'Recover';
                $statusLink = base_url() . "studio/script-action/$row[id]/" . PENDING_PUBLISH;
            }
            $delete = ($status == HOTLISTED ? base_url() . "studio/delete-script/$row[id]" : base_url() . "studio/script-action/$row[id]/" . HOTLIST);

            $view .= "     
				<tr>
					<td>
						<img src='" . base_url($row['thumbnail']) . "' style='height: 100px; width: 100px;'  class='pointer-cursor' onclick='$read_link'>
					</td>
					<td>
						$row[title]
					</td>
					<td>
						$row[date]
					</td>
					<td>
						<a href='" . $delete . "' class='btn btn-danger btn-xs no-border' title='Caution are you sure of this please to retrieve it you have to contact admin.'><i class='fa fa-remove'></i> Delete</a>
						<a href='" . base_url() . "studio/script-edit/$row[id]' class='btn btn-info btn-xs no-border' title='Edit'><i class='fa fa-plus-square'></i> Edit</a>
						<a href='$statusLink' class='btn btn-" . ($status == SUSPENDED || $status == PENDING_APPROVAL || $status == APPROVAL_DECLINED ? 'warning' : 'success') . " btn-xs no-border' title='Publish'><i class='fa fa-check'></i> $statusText </a>
					</td>
				</tr>
				
			";
        }

        $view .= "
                </tbody>
            </table>
        ";
        $data['breadcrumb'] = '
            <ol class="breadcrumb">
                <li><a href="' . base_url('admin') . '"><i class="fa fa-dashboard"></i> Manage scripts</a></li>
                <li><i class="fa fa-graduationcap"></i> Create script </li>
            </ol>
        ';
        $data['tab'] = "manage_scripts";
        $data['view'] = $view;
        $data['style'] = "<link rel='stylesheet' href='" . base_url() . "assets/plugins/datatables/dataTables.bootstrap.css'>";
        $data['main_content'] = 'studio/manage_scripts';
        $this->load->view('layouts/main', $data);
    }
}
