<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 *Handles operation concerning books in the database.
 * @author Emmanuel Elom
 * @since 1.0
 * @date 23/08/2022 4:20 pm
 */
class Book_model extends CI_Model
{

	/**
	 * Check to know if a user have purchased the book.
	 * @param int $book_id The book id.
	 * @return bool TRUE if the book is read by the user false otherwise.
	 */
	public function is_book_purchased(
		$book_id
	) {
		$book = $this->scansio_db_man->select('book_main', '*', "WHERE book_id = $book_id && status = " . PUBLISHED, $this->db->database);
		if (!$book) {
			return false;
		}
		$book_already_purchased = false;
		if (($uid = userdata(UID))) {
			$book_already_purchased = $this->scansio_db_man->select('book_purchase', '', "WHERE book_id = $book[id] && uid = $uid", $this->db->database);
			$book_already_purchased = ($book_already_purchased || ($book && $book['price'] == 0) || (bool) ($this->scansio_db_man->select('book_main', '', "WHERE book_id = $book_id && author = $uid", $this->db->database)));
		}
		return $book_already_purchased;
	}

	public function list_books()
	{
		$partition = [
			'default' => [],
			'purchased' => [],
			'other' => []
		];
		$uid = userdata(UID);

		//Compulsory
		$default_books = $this->Db_model->selectGroup("*", "default_book", "WHERE status=1");
		if ($default_books->num_rows() > 0) {
			foreach ($default_books->result_array() as $row) {
				$partition['default'][] = $row["bid"];
			}
		}

		//Already learning course
		$user_learnings = $this->Db_model->selectGroup("*", "user_learning", "WHERE uid=$uid AND type='book'");
		if ($user_learnings->num_rows() > 0) {
			foreach ($user_learnings->result_array() as $row) {
				if (!in_array($row["rid"], $partition['purchased'])) {
					$partition['purchased'][] = $row["rid"];
				}
			}
		}

		//Purchased courses
		$book_purchases = $this->Db_model->selectGroup("*", "book_purchase", "WHERE uid=$uid");
		if ($book_purchases->num_rows() > 0) {
			foreach ($book_purchases->result_array() as $row) {
				if (!in_array($row["course_id"], $partition['purchased'])) {
					$partition['purchased'][] = $row["book_id"];
				}
			}
		}

		//Other courses
		$book_mains = $this->Db_model->selectGroup("*", "book_main", "WHERE status=" . ACTIVE . " ORDER By price DESC, title ASC, last_update DESC");
		if ($book_mains->num_rows() > 0) {
			foreach ($book_mains->result_array() as $row) {
				if (!in_array($row["id"], $partition['default']) && !in_array($row["id"], $partition['purchased'])) {
					$partition['other'][] = $row["id"];
				}
			}
		}

		//Opportunity courses
		$opportunities_participating = $this->scansio_db_man->selectGroup('opportunity_participant', '', "WHERE uid = $uid AND status = " . ACTIVE);
		foreach ($opportunities_participating as $opportunity_participating) {
			$opportunity = $this->scansio_db_man->select('opportunity', '', "WHERE id = $opportunity_participating[oid] && status = " . ACTIVE);
			$opportunity_resources = $this->scansio_db_man->selectGroup('opportunity_resources', '', "WHERE oid = $opportunity[id] && type = 'ebook'");
			$active_opportunity = date_inrange($opportunity['end']);
			if ($active_opportunity) {
				foreach ($opportunity_resources as $opportunity_resource) {
					if (in_array($opportunity_resource['rid'], $partition['default'])) {
						unset($partition['default'][array_search($opportunity_resource['rid'], $partition['default'])]);
						$partition['default'] = array_values($partition['default']);
					}
					if (in_array($opportunity_resource['rid'], $partition['purchased'])) {
						unset($partition['purchased'][array_search($opportunity_resource['rid'], $partition['purchased'])]);
						$partition['purchased'] = array_values($partition['purchased']);
					}
					if (in_array($opportunity_resource['rid'], $partition['other'])) {
						unset($partition['other'][array_search($opportunity_resource['rid'], $partition['other'])]);
						$partition['other'] = array_values($partition['other']);
					}
				}
			}
		}

		$container = '';
		foreach ($partition as $partition_key => $ids) {
			$view = "";
			if (count($ids) > 0) {
				$partition_name = $partition_key == 'default' ? "<i class='bg-red text-bold' style='border-radius:5px; padding: 5px;'>Compulsory  Courses</i>" : ($partition_key == 'purchased' ? "<i class='bg-green text-bold' style='border-radius:5px; padding: 5px;'>Purchased Courses</i>" : "<i class='bg-blue text-bold' style='border-radius:5px; padding: 5px;'>Other Courses</i>");
				$view .= "
						$partition_name
						<div class='row s-start-grid padding-1x'>
					";
				foreach ($ids as $id) {
					$book = $this->scansio_db_man->select('book_main', '*', "WHERE id=$id AND status=" . ACTIVE);
					if ($book) {
						$read_link = base_url() . "academy/ebook/" . urlencode($book['title']) . "/$book[book_id]";
						$author = $this->scansio_db_man->select('user_main', '*', 'WHERE uid = ' . $book['author'])['name'];
						$author = $book['author'] == userdata(UID) ? 'You' : $author;
						$is_system = ($this->Util_model->row_count('default_book', "WHERE bid = $book[id] AND status = " . ACTIVE) > 0) ? "<span class='label label-warning'>Compulsory</span>" : "";
						$course_pane_footer = $partition_key == 'other' ? "
							<h4 class='text-right'>" .
							($book['price'] == 0 ? "Free" :
								"<small class='text-muted' style='text-decoration:line-through'>$$book[old_price]</small>
                            $$book[price]") .
							"</h4>
							" : "
								<p class='overflow text-muted'>
									$is_system
									<span class='pull-right' style='margin-top:5px; font-size:11px;'></span>
								</p>
							";
						$view .= "
							<div class='col-lg-4 col-md-4 col-sm-4 col-xs-12'>
								<div class='box box-border'>
									<div class='box-body no-padding'>
										<div class='col-sm-12 col-xs-3 no-padding'>
										<img src='" . base_url() . "$book[pic_url]' class='pointer-cursor' width='100%' height='100%' onclick='window.location = \"$read_link\"'>
										</div>
										<div class='col-sm-12 col-xs-9'>
											<p class='pointer-cursor text-bold top-pad-1x' onclick='window.location = \"$read_link\"'>$book[title]</p>
											<p class='overflow text-muted font-xs'>
												<span class='pull-left'>
													$author
												</span>
												<span class='pull-right'>
													<i class='fa fa-file' title='Chapter' data-toggle='tooltip'></i> $book[chapters]
												</span>
											</p>
											$course_pane_footer
										</div>
									</div>
								</div>
							</div>
							";
					}
				}
				$view .= "</div>";
			}
			$container .= $view;
		}
		return $container == '' ? "<p>Books are unavailable at this moment please check back later.</p>" : $container;
	}

	public function has_access($book_id)
	{
		$uid = userdata(UID);
		$book = $this->scansio_db_man->select('book_main', '', "WHERE book_id = $book_id");
		if (!$book) {
			return false;
		}
		$opportunity_resources = $this->scansio_db_man->select('opportunity_resources', '', "WHERE rid = $book[id] && type = 'ebook'");
		$opportunity_participant = $this->scansio_db_man->select('opportunity_participant', '', "WHERE uid = $uid AND oid = $opportunity_resources[oid] && status = " . ACTIVE);
		$opportunity = $this->scansio_db_man->select('opportunity', '', "WHERE id = $opportunity_resources[oid] && status = " . ACTIVE);
		$active_opportunity = date_inrange($opportunity['end']);
		$is_system = $this->scansio_db_man->select('default_book', '', "WHERE bid = $book[id] AND status = " . ACTIVE);
		$has_purchased = $this->scansio_db_man->select("book_purchase", '', "WHERE book_id = $book[id] AND uid = $uid");
		$has_access = ($book['author'] == $uid || $is_system || ($opportunity_participant && $active_opportunity) || $has_purchased);
		return $has_access;
	}
}