<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Course_model extends CI_Model
{
    public function has_user_purchase($course_code, $uid = NULL)
    {
        $uid = $uid == NULL ? userdata(UID) : $uid;
        if (!$uid) {
            return false;
        }
        $course_availability = $this->scansio_db_man->select("academy_course", '', "WHERE course_code = '$course_code' && status = " . PUBLISHED, $this->db->database);
        if (!$course_availability || !isset($course_availability['course_instructor'])) {
            return false;
        }
        $where = "WHERE uid = $uid && course_code = '$course_code'";
        $course_purchase = $this->scansio_db_man->select('course_purchase', '', "WHERE uid = $uid && course_id = '$course_availability[id]'", $this->db->database);
        if (!$course_purchase || !isset($course_purchase['uid'])) {
            $where = "WHERE course_instructor = $uid && course_code = '$course_code'";
            $course_purchase = $this->scansio_db_man->select('academy_course', '', $where, $this->db->database);
            if ($course_purchase && isset($course_purchase['uid'])) {
                return true;
            }
            return false;
        } else {
            return true;
        }
    }

    public function list_courses()
    {
        $partition = [
            'default' => [],
            'purchased' => [],
            'other' => []
        ];
        $uid = userdata(UID);

        //Compulsory
        $default_courses = $this->Db_model->selectGroup("*", "default_course", "WHERE status=1");
        if ($default_courses->num_rows() > 0) {
            foreach ($default_courses->result_array() as $row) {
                $partition['default'][] = $row["cid"];
            }
        }

        //Already learning course
        $user_learnings = $this->Db_model->selectGroup("*", "user_learning", "WHERE uid=$uid AND type='video'");
        if ($user_learnings->num_rows() > 0) {
            foreach ($user_learnings->result_array() as $row) {
                if (!in_array($row["rid"], $partition['purchased'])) {
                    $partition['purchased'][] = $row["rid"];
                }
            }
        }

        //Purchased courses
        $course_purchases = $this->Db_model->selectGroup("*", "course_purchase", "WHERE uid=$uid");
        if ($course_purchases->num_rows() > 0) {
            foreach ($course_purchases->result_array() as $row) {
                if (!in_array($row["course_id"], $partition['purchased'])) {
                    $partition['purchased'][] = $row["course_id"];
                }
            }
        }

        //Other courses
        $academy_courses = $this->Db_model->selectGroup("*", "academy_course", "WHERE status=" . ACTIVE . " ORDER By course_price DESC, course_title ASC, last_update DESC");
        if ($academy_courses->num_rows() > 0) {
            foreach ($academy_courses->result_array() as $row) {
                if (!in_array($row["id"], $partition['default']) && !in_array($row["id"], $partition['purchased'])) {
                    $partition['other'][] = $row["id"];
                }
            }
        }
        //Opportunity courses
        $opportunities_participating = $this->scansio_db_man->selectGroup('opportunity_participant', '', "WHERE uid = $uid AND status = " . ACTIVE);
        foreach ($opportunities_participating as $opportunity_participating) {
            $opportunity = $this->scansio_db_man->select('opportunity', '', "WHERE id = $opportunity_participating[oid] && status = " . ACTIVE);
            $opportunity_resources = $this->scansio_db_man->selectGroup('opportunity_resources', '', "WHERE oid = $opportunity[id] && type = 'video'");
            $active_opportunity = date_inrange($opportunity['end']);
            if ($active_opportunity) {
                foreach ($opportunity_resources as $opportunity_resource) {
                    if (in_array($opportunity_resource['rid'], $partition['default'])) {
                        unset($partition['default'][array_search($opportunity_resource['rid'], $partition['default'])]);
                        $partition['default'] = array_values($partition['default']);
                    }
                    if (in_array($opportunity_resource['rid'], $partition['purchased'])) {
                        unset($partition['purchased'][array_search($opportunity_resource['rid'], $partition['purchased'])]);
                        $partition['purchased'] = array_values($partition['purchased']);
                    }
                    if (in_array($opportunity_resource['rid'], $partition['other'])) {
                        unset($partition['other'][array_search($opportunity_resource['rid'], $partition['other'])]);
                        $partition['other'] = array_values($partition['other']);
                    }
                }
            }
        }


        $container = '';
        foreach ($partition as $partition_key => $ids) {
            $view = "";
            if (count($ids) > 0) {
                $partition_name = $partition_key == 'default' ? "<i class='bg-red text-bold' style='border-radius:5px; padding: 5px;'>Compulsory  Courses</i>" : ($partition_key == 'purchased' ? "<i class='bg-green text-bold' style='border-radius:5px; padding: 5px;'>Purchased Courses</i>" : "<i class='bg-blue text-bold' style='border-radius:5px; padding: 5px;'>Other Courses</i>");
                $view .= "
                    $partition_name
                    <div class='row s-start-grid padding-1x'>
                ";
                foreach ($ids as $id) {
                    $course = $this->scansio_db_man->select('academy_course', '', "WHERE id = $id && status = " . ACTIVE);
                    if ($course) {
                        $code = $course['course_code'];
                        $read_link = base_url() . "academy/ecourse/preview/$code";
                        if ($this->has_access($code)) {
                            $watched = $this->Util_model->row_count("academy_watched", "WHERE uid=" . $uid . " AND course_code='$code'");
                            $topics_where = "WHERE course_code='$code' ORDER BY position ASC";
                            $topics = $this->scansio_db_man->rowCount('academy_topic', $topics_where);
                            $per = round(get_percentage($topics, $watched, false));
                            $topic = ($watched == 0) ? $this->Util_model->get_info("academy_topic", "id", "WHERE course_code='$code' AND status=1 ORDER BY position LIMIT 1") : $this->Util_model->get_info("academy_watched", "topic_code", "WHERE uid=" . $uid . " AND course_code='$code' ORDER BY date DESC");
                            if ($topic == '')
                                $topic = '1';
                            //$read_link = base_url() . "academy/$code/$topic";
                        }
                        $load_url = 'window.location = \'' . $read_link . '\'';
                        $time = getFormattedDuration($course['course_time']);
                        $instructor = ($course['course_instructor'] == $uid) ? 'You' : $this->Util_model->get_info('user_main', 'name', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED);
                        $is_system = ($this->Util_model->row_count('default_course', "WHERE cid = $id AND status = " . ACTIVE) > 0) ? "<span class='label label-warning pull-right' style='margin-top:5px;'>Compulsory</span>" : "";
                        $course_pane_footer = $partition_key == 'other' ? "
                        <h4 class='text-right'>" .
                            ($course['course_price'] == 0 ? "Free" :
                                "<small class='text-muted' style='text-decoration:line-through'>$$course[course_old_price]</small>
                            $$course[course_price]") .
                            "</h4>
                        
                        " : "
                            <div class='progress progress-xxs top-2x' style='margin-bottom:3px;'>
                                <div class='progress-bar progress-bar-danger progress-bar-striped' role='progressbar' aria-valuenow='$per' aria-valuemin='0' aria-valuemax='100' style='width: $per%'>
                                    <span></span>
                                </div>
                            </div>
                            <small class='text-center text-bold'>$per% Complete</small>
                            $is_system
                        ";
                        //$sold = $this->scansio_db_man->rowCount('course_purchase', "WHERE code = '$course[code]'");
                        //$sales_link = $this->misc->create_sales_link('course', $course['code']);
                        $view .= "
                        <div class='col-lg-4 col-md-4 col-sm-6 col-xs-12'>
                            <div class='box box-border pointer-cursor' onclick=\"" . $load_url . "\">
                                <div class='box-body no-padding'>
                                    <div class='col-sm-12 col-xs-3 no-padding'>
                                        <img src='" . base_url() . "$course[course_pic]' class='pointer-cursor' width='100%' height='100%' onclick=\"" . $load_url . "\">
                                    </div>
                                    <div class='col-sm-12 col-xs-9' style='padding-right:5px; padding-left:5px;'>
                                        <p class='pointer-cursor text-bold top-pad-1x' onclick=\"" . $load_url . "\">$course[course_title]</p>
                                        <p class='overflow text-muted font-xs'>
                                            <span class='pull-left'>
                                                $instructor
                                            </span>
                                            <span class='pull-right'>
                                                <i class='fa fa-film'></i> " . $this->Util_model->row_count("academy_topic", "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED) . " &nbsp;&nbsp;
                                                <i class='fa fa-clock-o'></i> $time
                                            </span>
                                            $course_pane_footer
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        ";
                    }
                }
                $view .= "</div>";
            }
            $container .= $view;
        }
        return $container == '' ? "<p>Courses are unavailable at this moment please check back later.</p>" : $container;
    }

    public function recommended_courses($uid)
    {
        $courses = $this->Db_model->selectGroup("*", "academy_course", "WHERE status=1 ORDER BY RAND() LIMIT 3");
        $view = "";
        if ($courses->num_rows() > 0) {
            foreach ($courses->result_array() as $course) {
                $watched = $this->Util_model->row_count("academy_watched", "WHERE uid=" . userdata(UID) . " AND course_code='$course[course_code]'");
                $topics = $this->Util_model->row_count("academy_topic", "WHERE course_code='$course[course_code]'");
                $per = round(get_percentage($topics, $watched, false));
                $topic = ($watched == 0) ? $this->Util_model->get_info("academy_topic", "id", "WHERE course_code='$course[course_code]' AND status=1 ORDER BY position LIMIT 1") : $this->Util_model->get_info("academy_watched", "topic_code", "WHERE uid=" . userdata(UID) . " AND course_code='$course[course_code]' ORDER BY date DESC");
                if ($topic == '')
                    $topic = '1';
                $btn = "<a href='" . base_url() . "academy/$course[course_code]/$topic' class='btn btn-flat btn-block btn btn-primary'>Watch Course</a>";
                $course_instructor = $course['course_instructor'] == userdata(UID) ? 'You' : $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED)['name'];
                $view .= "
                <div class='col-lg-4 col-md-4 col-sm-6 col-xs-12'>
                    <div class='box box-border'>
                        <div class='box-body no-padding'>
                            <img src='" . base_url() . "$course[course_pic]' width='100%' height='100%'>
                        </div>
                        <div class='box-footer text-center overflow' data-toggle='tooltip' title='$course[course_title]'>
                            <b>$course[course_title]</b>
                            <p class='overflow text-muted font-xs'>
                                <span class='pull-left'>
                                    $course_instructor
                                </span>
                                <span class='pull-right'>
                                    <i class='fa fa-film'></i> " . $this->Util_model->row_count("academy_topic", "WHERE course_code='$course[course_code]' AND status=1") . " &nbsp;&nbsp;
                                    <i class='fa fa-clock-o'></i> $course[course_time]
                                </span>
                            </p>
                            <div class='progress progress-xxs top-2x' style='margin-bottom:3px;'>
                                <div class='progress-bar progress-bar-danger progress-bar-striped' role='progressbar' aria-valuenow='$per' aria-valuemin='0' aria-valuemax='100' style='width: $per%'>
                                    <span></span>
                                </div>
                            </div>
                            <small class='text-center text-bold'>$per% Complete</small>
                        </div>
                        <div class='box-footer'>
                            $btn
                        </div>
                    </div>
                </div>
                ";
            }
        } else {
            $view .= "<p>No course recommended</p>";
        }

        return $view;
    }

    public function default_courses()
    {
        $query = "SELECT 
        a.*
        FROM 
        academy_course a, 
        default_course d 
        WHERE 
        a.id = d.cid AND d.status = " . ACTIVE . " AND a.status=" . ACTIVE;
        $courses = $this->db->query($query);
        $view = "";
        if ($courses->num_rows() > 0) {
            foreach ($courses->result_array() as $course) {
                $watched = $this->Util_model->row_count("academy_watched", "WHERE uid=" . userdata(UID) . " AND course_code='$course[course_code]'");
                $topics = $this->Util_model->row_count("academy_topic", "WHERE course_code='$course[course_code]'");
                $per = round(get_percentage($topics, $watched, false));
                $topic = ($watched == 0) ? $this->Util_model->get_info("academy_topic", "id", "WHERE course_code='$course[course_code]' AND status=1 ORDER BY position LIMIT 1") : $this->Util_model->get_info("academy_watched", "topic_code", "WHERE uid=" . userdata(UID) . " AND course_code='$course[course_code]' ORDER BY date DESC");
                if ($topic == '')
                    $topic = '1';
                $load_url = base_url() . "academy/$course[course_code]/$topic";
                $course_instructor = $course['course_instructor'] == userdata(UID) ? 'You' : $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED)['name'];
                $time = getFormattedDuration($course['course_time']);
                $is_system = ($this->Util_model->row_count('default_course', "WHERE cid = $course[id] AND status = " . ACTIVE) > 0) ? "<span class='label label-warning pull-right' style='margin-top:5px;'>Compulsory</span>" : "";
                $view .= "
                <div class='col-lg-4 col-md-4 col-sm-6 col-xs-12'>
                    <div class='box box-border pointer-cursor' onclick='window.location = \"$load_url\"'>
                        <div class='box-body no-padding'>
                            <div class='col-sm-12 col-xs-3 no-padding'>
                                <img src='" . base_url() . "$course[course_pic]' class='pointer-cursor' width='100%' height='100%' onclick=\"" . $load_url . "\">
                            </div>
                            <div class='col-sm-12 col-xs-9'>
                                <p class='pointer-cursor text-bold top-pad-1x' onclick=\"" . $load_url . "\">$course[course_title]</p>
                                <p class='overflow text-muted font-xs'>
                                    <span class='pull-left'>
                                        $course_instructor
                                    </span>
                                    <span class='pull-right'>
                                        <i class='fa fa-film'></i> " . $this->Util_model->row_count("academy_topic", "WHERE course_code = '$course[course_code]' AND status=1") . " &nbsp;&nbsp;
                                        <i class='fa fa-clock-o'></i> $time
                                    </span>
                                    <div class='progress progress-xxs top-2x' style='margin-bottom:3px;'>
                                        <div class='progress-bar progress-bar-danger progress-bar-striped' role='progressbar' aria-valuenow='$per' aria-valuemin='0' aria-valuemax='100' style='width: $per%'>
                                            <span></span>
                                        </div>
                                    </div>
                                    <small class='text-center text-bold'>$per% Complete</small>
                                    $is_system
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                ";
            }
        } else {
            $view .= "<p>Comming Soon</p>";
        }

        return $view;
    }

    public function topic_comments($course, $topic)
    {
        $s = $this->Db_model->selectGroup("*", "academy_comment", "WHERE course_code='$course' AND topic_code='$topic' ORDER BY last_update DESC LIMIT 10" . LIMIT);
        $view = "
        <p class='text-muted text-center'>" . number_format($this->Util_model->row_count("academy_comment", "WHERE course_code='$course' AND topic_code='$topic'")) . " comments</p>
        <div class='col-xs-12 box-comments'>
        ";
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $view .= "
                <div class='box-comment top-1x'>
                    <!-- User image -->
                    <img class='img-circle img-sm' src='" . base_url() . $this->Util_model->picture($row['uid']) . "' alt='User Image'>
        
                    <div class='comment-text'>
                      <span class='username'>
                        " . $this->Util_model->get_user_info($row['uid']) . "
                        <span class='text-muted pull-right'>" . get_time_ago($row['date']) . "</span>
                      </span><!-- /.username -->
                        $row[comment]
                    </div>
                    <!-- /.comment-text -->
                </div>
                ";
            }
        }

        $view .= "
        </div>
        <div class='col-xs-12 top-1x no-padding'>
            <img class='img-responsive img-circle img-sm' src='" . base_url() . $this->Util_model->picture() . "' alt='Alt Text'>
            <!-- .img-push is used to add margin to elements next to floating images -->
            <div class='img-push'>
                <input type='text' class='form-control input-sm' placeholder='Press enter to post comment' onkeyup='post_comment(event, $(this), \"$course&topic=$topic\", \"" . base_url() . "\")'>
            </div>
        </div>
        ";
        return $view;
    }

    public function has_access($course_code)
    {
        $uid = userdata(UID);
        $course = $this->scansio_db_man->select('academy_course', '', "WHERE course_code = '$course_code'");
        if (!$course) {
            return false;
        }
        $opportunity_resources = $this->scansio_db_man->select('opportunity_resources', '', "WHERE rid = $course[id] && type = 'video'");
        $opportunity_participant = $this->scansio_db_man->select('opportunity_participant', '', "WHERE uid = $uid AND oid = $opportunity_resources[oid] AND status = " . ACTIVE);
        $opportunity = $this->scansio_db_man->select('opportunity', '', "WHERE id = $opportunity_resources[oid] && status = " . ACTIVE);
        $active_opportunity = date_inrange($opportunity['end']);
        $is_system = $this->scansio_db_man->select("default_course", '', "WHERE cid = $course[id] AND status = " . ACTIVE);
        $has_purchased = $this->scansio_db_man->select("course_purchase", '', "WHERE course_id = $course[id] AND uid = $uid");
        $has_access = ($course['course_instructor'] == $uid || $is_system || ($opportunity_participant && $active_opportunity) || $has_purchased);
        return $has_access;
    }
}