<?php
/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/24/2017
 * Time: 10:21 AM
 */

defined('BASEPATH') or exit('No direct script access allowed');

class Opportunity_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function home_opportunity($sm = 0)
    {
        $ids = array();
        $s = $this->Db_model->selectGroup("oid", "opportunity_system", "ORDER BY position LIMIT 14");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ids[] = $row["oid"];
            }
        }
        $list = 24 - $s->num_rows();
        if ($list > 0) {
            $s = $this->Db_model->selectGroup("oid", "opportunity_sponsored", "WHERE status=1 ORDER BY RAND() LIMIT $list");
            if ($s->num_rows() > 0) {
                foreach ($s->result_array() as $row) {
                    if (!in_array($row['id'], $ids)) {
                        $ids[] = $row["oid"];
                    }
                }
            }
        }
        $list -= count($ids);
        if ($list > 0) {
            $s = $this->Db_model->selectGroup("id", "opportunity", "WHERE status=1 ORDER BY RAND() LIMIT 24");
            if ($s->num_rows() > 0) {
                foreach ($s->result_array() as $row) {
                    if (!in_array($row['id'], $ids)) {
                        $ids[] = $row["id"];
                    }
                    if (count($ids) == 24)
                        break;
                }
            }
        }

        if (count($ids) > 0) {

            $col = ($sm == 0) ? 3 : 1;
            $slides = ceil(count($ids) / $col);
            $key = 0;

            $view = '';

            for ($r = 1; $r <= $slides; $r++) {
                $active = ($r == 1) ? "active" : "";
                $view .= "
                    <div class='item $active'>";
                for ($c = $col; $c > 0; $c--) {
                    if (array_key_exists($key, $ids)) {
                        $row = $this->Db_model->select("*", "opportunity", "WHERE id=" . $ids[$key]);
                        $video_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $row[id] AND type = 'video'");
                        $ebook_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $row[id] AND type = 'ebook'");

                        $view .= "
                        <div class='col-lg-4 col-md-4 col-sm-6 col-xs-12'>
                            <div class='box no-padding box-border' style='box-shadow:none; border-radius:10px;'>
                                <div class='box-body no-padding' style='padding-bottom:0px; border-radius:10px 10px 0px 0px'>
                                    <img src='" . base_url() . "$row[thumbnail]' style='width:100%; height:auto; border-radius:10px 10px 0px 0px' class='pointer-cursor' onclick='window.location = \"" . base_url() . "opportunity/view/$row[id]\"'>
                                    <div class='col-xs-12' style='padding:10px'>
                                        <small class='text-overflow'></small><br>
                                        <p style='font-weight:bold; width:100%; padding:0px; margin:0px;' class='text-overflow pointer-cursor' onclick='window.location = \"" . base_url() . "opportunity/view/$row[id]\"'>$row[title]</p>
                                    </div>
                                    <div class='col-xs-12 font-sm no-padding' style='margin:0px 10px 10px;'>
                                        Ends " . remaining_time($row['end'], 'year') . "
                                    </div>
                                    <div class='col-xs-12 bottom-1x text-center font-sm text-overflow'>
                                        Posted by " . $this->Util_model->get_user_info($row['uid'], "username", "profile") . "
                                    </div>
                                </div>
                                <div class='box-footer' style='border-radius:0px 0px 10px 10px'>
                                    <i class='fa fa-film'></i> $video_resources <i class='fa fa-book left-1x'></i> $ebook_resources
                                </div>
                            </div>
                        </div>
                        ";
                        $key++;
                    } else {
                        break;
                    }
                }
                $view .= "
                    </div>
                ";
            }
        } else {
            $view = "<p>No opportunity at the moment</p>";
        }
        return $view;
    }

    public function list_opportunity()
    {
        $uid = userdata(UID);
        $ids = array();
        $s = $this->Db_model->selectGroup("oid", "opportunity_system", "ORDER BY position");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ids[] = $row["oid"];
            }
        }
        $s = $this->Db_model->selectGroup("oid", "opportunity_sponsored", "WHERE status=1 ORDER BY RAND()");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                if (!in_array($row['id'], $ids)) {
                    $ids[] = $row["oid"];
                }
            }
        }
        $s = $this->Db_model->selectGroup("id", "opportunity", "WHERE status=1 ORDER BY RAND()");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                if (!in_array($row['id'], $ids)) {
                    $ids[] = $row["id"];
                }
            }
        }
        $participating_opportunity = $this->Db_model->selectGroup("*", "opportunity_participant", "WHERE uid = $uid AND status = " . ACTIVE);
        if ($participating_opportunity->num_rows() > 0) {
            foreach ($participating_opportunity->result_array() as $opp) {
                if (in_array($opp['oid'], $ids)) {
                    unset($ids[array_search($opp['oid'], $ids)]);
                }
            }
        }
        $view = "";
        foreach ($ids as $id) {
            $row = $this->Db_model->select("*", "opportunity", "WHERE id=$id");
            $video_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $row[id] AND type = 'video'");
            $ebook_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $row[id] AND type = 'ebook'");

            $view .= "
            <div class='col-lg-4 col-md-4 col-sm-6 col-xs-12'>
                <div class='box no-padding box-border' style='box-shadow:none; border-radius:10px;'>
                    <div class='box-body no-padding' style='padding-bottom:0px; border-radius:10px 10px 0px 0px'>
                        <div class='col-lg-12 col-md-12 col-sm-4 col-xs-4 no-padding'>
                            <img src='" . base_url() . "$row[thumbnail]' style='width:100%; height:auto; border-radius:10px 10px 0px 0px' class='pointer-cursor sm-0' onclick='window.location = \"" . base_url() . "opportunity/view/$row[id]\"'>
                            <img src='" . base_url() . "$row[thumbnail]' style='width:100%; height:auto; border-radius:10px 0px 0px 10px; margin-top:10px; padding-right:10px; margin-left:10px;' class='pointer-cursor no-display sm-1' onclick='window.location = \"" . base_url() . "opportunity/view/$row[id]\"'>
                        </div>
                        <div class='col-lg-12 col-md-12 col-sm-8 col-xs-8 no-padding'>
                            <div class='col-xs-12' style='padding-left:10px'>
                                <small class='text-overflow'></small><br>
                                <p style='font-weight:bold; width:100%; padding:0px; margin:0px;' class='overflow pointer-cursor' onclick='window.location = \"" . base_url() . "opportunity/view/$row[id]\"'>$row[title]</p>
                            </div>
                            <div class='col-xs-12 font-sm no-padding' style='margin:0px 10px 10px;'>
                                Ends " . remaining_time($row['end'], 'year') . "
                            </div>
                            <div class='col-xs-12 bottom-1x font-sm text-overflow' style='padding-left:10px;'>
                                <span class='text-muted' style='font-size:11px;'>Posted by " . $this->Util_model->get_user_info($row['uid'], "username", "profile") . "</span>
                            </div>
                        </div>
                        <div class='box-footer' style='border-radius:0px 0px 10px 10px;'>
                            <i class='fa fa-film'></i> $video_resources <i class='fa fa-book left-1x'></i> $ebook_resources
                        </div>
                    </div>
                </div>
            </div>
            ";

        }
        return $view;
    }

    public function participating()
    {
        $uid = userdata(UID);
        $ids = array();
        $s = $this->Db_model->selectGroup("oid", "opportunity_system", "ORDER BY position");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ids[] = $row["oid"];
            }
        }
        $s = $this->Db_model->selectGroup("oid", "opportunity_sponsored", "WHERE status=1 ORDER BY RAND()");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                if (!in_array($row['id'], $ids)) {
                    $ids[] = $row["oid"];
                }
            }
        }
        $participating_opportunity = $this->Db_model->selectGroup("*", "opportunity_participant", "WHERE uid = $uid AND status = " . ACTIVE);
        if ($participating_opportunity->num_rows() > 0) {
            foreach ($participating_opportunity->result_array() as $opp) {
                if (!in_array($opp['oid'], $ids)) {
                    $ids[] = $opp["oid"];
                }
            }
        }
        $view = "";
        foreach ($ids as $id) {
            $row = $this->Db_model->select("*", "opportunity", "WHERE id=$id");
            $video_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $row[id] AND type = 'video'");
            $ebook_resources = $this->scansio_db_man->rowCount("opportunity_resources", "WHERE oid = $row[id] AND type = 'ebook'");
            $preview_link = base_url() . "opportunity/view/$id/participating";
            $view .= "
            <div class='col-lg-4 col-md-4 col-sm-6 col-xs-12'>
                <div class='box no-padding box-border' style='box-shadow:none; border-radius:10px;'>
                    <div class='box-body no-padding' style='padding-bottom:0px; border-radius:10px 10px 0px 0px'>
                        <img src='" . base_url() . "$row[thumbnail]' style='width:100%; height:auto; border-radius:10px 10px 0px 0px' class='pointer-cursor' onclick='window.location = \"$preview_link\"'>
                        <div class='col-xs-12' style='padding:10px'>
                            <small class='text-overflow'></small><br>
                            <p style='font-weight:bold; width:100%; padding:0px; margin:0px;' class='overflow pointer-cursor' onclick='window.location = \"$preview_link\"'>$row[title]</p>
                        </div>
                        <div class='col-xs-12 font-sm no-padding' style='margin:0px 10px 10px;'>
                            Ends " . remaining_time($row['end']) . "
                        </div>
                        <div class='col-xs-12 bottom-1x text-center font-sm text-overflow'>
                            Posted by " . $this->Util_model->get_user_info($row['uid'], "username", "profile") . "
                        </div>
                    </div>
                    <div class='box-footer' style='border-radius:0px 0px 10px 10px'>
                        <i class='fa fa-film'></i> $video_resources <i class='fa fa-book'></i> $ebook_resources
                    </div>
                </div>
            </div>
            ";

        }
        return $view;
    }
}