<?php
/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/24/2017
 * Time: 10:21 AM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class P2p_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function get_merchant ($amount, $method, $type="Buy") {
        $s = $this->Db_model->selectGroup("*", "p2p_merchant", "WHERE uid<>".userdata(UID)." AND method=$method AND type='$type' AND min<=$amount AND max>=$amount AND status=1 ORDER BY RAND() LIMIT 100");
        $merchant = 0;
        if ($s->num_rows() > 0) {
            if ($type == "Buy") {
                foreach ($s->result_array() as $row) {
                    if ($this->Main_model->get_balance($row["uid"], false) >= $amount) {
                        $merchant = $row;
                        break;
                    }
                }
            } else {
                $merchant = $s->row_array();
            }
        }
        return $merchant;
    }

    public function list_merchants ($amount, $method, $type="Buy") {
        $s = $this->Db_model->selectGroup("*", "p2p_merchant", "WHERE mid=".MID." AND uid<>".userdata(UID)." AND method=$method AND type='$type' AND min<=$amount AND max>=$amount AND status=1 ORDER BY interest LIMIT 50");
        if ($s->num_rows() > 0) {
            $count = 0;
            $view = "<ul class='products-list product-list-in-box'>";
            foreach ($s->result_array() as $row) {
                $method = $this->Util_model->get_info("merchant_payment_methods", "*", "WHERE id=$row[method]");
                $currency = $method['currency'];
                if ($method['category'] == 'coin') {
                    $rate = $this->Util_model->conversion_rate($currency, 'USDT');
                    $rate = ($row['type'] == 'Buy') ? $rate + get_percentage($rate, ($row['interest'] + 1)) : $rate - get_percentage($rate, ($row['interest'] + 1));
                    if ($currency != 'USDT') {
                        $rate = round((1 / $rate), 8);
                    }
                    $formated_rate = $rate;
                    $convert_amount = round(($amount * COIN_PRICE) * $rate, 8);
                    $amount_array = ["amount"=>(float)$amount, "format_amount"=>$convert_amount];
                } else {
                    $rate = $this->Util_model->conversion_rate('USDT', $currency);
                    $rate = ($row['type'] == 'Buy') ? $rate + get_percentage($rate, ($row['interest'] + 1)) : $rate - get_percentage($rate, ($row['interest'] + 1));
                    $formated_rate = number_format($rate, 2);
                    $convert_amount = round(((float)$amount * COIN_PRICE) * $rate, 2);
                    $amount_array = ["amount"=>(float)$amount, "format_amount"=>number_format($convert_amount, 2)];
                }
                
                if ($row['type'] == "Buy") {
                    $btn = "<a href='javascript:;' class='btn btn-success pull-right buy' onclick='create_buy_order($row[id], ".$amount_array['amount'].", $convert_amount, $rate, \"$currency\", $(this))'>Buy</a>";
                    $pay_get = "You pay";
                    if ($this->General_model->get_balance($row['uid'], false) >= $amount_array['amount']) {
                        $count++;
                        $view .= "
                        <li class='item'>
                        <div class='product-img'>
                            <img class='img-circle' src='".base_url().$this->Util_model->picture($row['uid'])."' style='width:45px; height:45px;' alt='Merchant Image'>
                        </div>
                        <div class='product-info'>
                            <small class='text-muted'>".$this->Util_model->get_user_info($row['uid'], "username", "profile")."</small>
                            <h4 class='product-title'>
                                <span style='font-size:12px' class='text-muted'>Rate</span> $formated_rate $currency
                                $btn
                            </h4>
                            <span class='product-description'>
                                <span class='text-muted'>$pay_get</span> <span class='text-black'>$amount_array[format_amount] $currency</span><br>
                                <a href='javascript:;' class='text-italic text-underline'>Terms and conditions</a>
                            </span>
                        </div>
                        </li>
                        ";
                    }
                } else {
                    $btn = "<a href='javascript:;' class='btn btn-danger pull-right sell' onclick='_(\"merchant\").text($row[id]); _(\"currency\").text(\"$currency\"); _(\"rate\").text(\"$rate\"); select_payment_details($row[method])'>Sell</a>";
                    $pay_get = "You get";
                    $count++;
                    $view .= "
                    <li class='item'>
                    <div class='product-img'>
                        <img class='img-circle' src='".base_url().$this->Util_model->picture($row['uid'])."' style='width:45px; height:45px;' alt='Merchant Image'>
                    </div>
                    <div class='product-info'>
                        <small class='text-muted'>".$this->Util_model->get_user_info($row['uid'], "username", "profile")."</small>
                        <h4 class='product-title'>
                            <span style='font-size:12px' class='text-muted'>Rate</span> $formated_rate $currency
                            $btn
                        </h4>
                        <span class='product-description'>
                            <span class='text-muted'>$pay_get</span> <span class='text-black'>$amount_array[format_amount] $currency</span><br>
                            <a href='javascript:;' class='text-italic text-underline'>Terms and conditions</a>
                        </span>
                    </div>
                    </li>
                    ";
                }
                
                
            }
            $view .= "</ul>";
            if ($count == 0) {
                $view = "
                    <p class='text-center'>No merchant met your criteria</p>
                ";
            }
        } else {
            $view = "
                <p class='text-center'>No merchant met your criteria</p>
            ";
        }
        return $view;
    }

    public function get_response_time ($type='Buy') {
        $field = strtolower($type)."er_uid";
        $sum = $this->Util_model->sum_field("p2p_orders", "time", "WHERE $field=".userdata(UID)." AND type='$type' AND status <> 0", 1);
        $average = ($sum['sum'] == 0) ? 0 : ($sum['sum']/$sum['counts']);
        $time = 15 + $average;
        return $time;
    }

    public function awaiting_sell_trade() {
        $s = $this->Db_model->selectGroup("*", "sell_order", "WHERE uid=".userdata(UID));
        $count = 0;
        $view = "";
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $count++;
                $view .= "
                <tr>
                    <td>$count</td>
                    <td>$row[amount]</td>
                    <td>".number_format($row['amount'] * $this->Util_model->get_option("coin_price"))."</td>
                    <td>$row[bank]</td>
                    <td>$row[acct_name]</td>
                    <td>$row[acct_number]</td>
                    <td>$row[date]</td>
                </tr>
                ";
            }
        }
        return $view;
    }

    public function buy_trade() {
        $s = $this->Db_model->selectGroup("*", "trans", "WHERE buyer=".userdata(UID));
        if ($s->num_rows() == 0) {
            $view = '
            <td colspan="8">No buy trade at the moment</td>
            ';
        } else {
            $view = "";
            $count = 0;
            foreach ($s->result_array() as $row) {
                $count++;
                $btn = "";
                if ($row['status'] == 0) {
                    $status = "<span class='label text-yellow'>Make payment</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                } else if ($row['status'] == 1) {
                    $status = "<span class='label text-blue'>Awaiting release</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                } else if ($row['status'] == 2) {
                    $status = "<span class='label text-green'>Completed</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                } else if ($row['status'] == 3) {
                    $status = "<span class='label text-red'>Cancelled</span>";
                } else {
                    $status = "<span class='label text-red'>Disputed</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                }
                $view .= "
                <tr>
                    <td>$count</td>
                    <td>".$this->Util_model->get_user_info($row['seller'], 'username', 'profile')."</td>
                    <td>$row[amount]</td>
                    <td>".number_format($row['fiat_amount'])."</td>
                    <td>$row[trans_id]</td>
                    <td>".date_difference($row['expiry_date'],date_time(),"H:i:s")."</td>
                    <td>$row[created_date]</td>
                    <td>$status</td>
                    <td>$btn</td>
                </tr>
                ";
            }
        }

        return $view;
    }

    public function sell_trade() {
        $s = $this->Db_model->selectGroup("*", "trans", "WHERE seller=".userdata(UID));
        if ($s->num_rows() == 0) {
            $view = '
            <td colspan="8">No sell trade at the moment</td>
            ';
        } else {
            $view = "";
            $count = 0;
            foreach ($s->result_array() as $row) {
                $count++;
                $btn = "";
                if ($row['status'] == 0) {
                    $status = "<span class='label text-yellow'>Awaiting payment</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                } else if ($row['status'] == 1) {
                    $status = "<span class='label text-blue'>Release MEX</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                } else if ($row['status'] == 2) {
                    $status = "<span class='label text-green'>Completed</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                } else if ($row['status'] == 3) {
                    $status = "<span class='label text-red'>Cancelled</span>";
                } else {
                    $status = "<span class='label text-red'>Disputed</span>";
                    $btn = "<a href='".base_url()."trade/view-trade/$row[trans_id]' class='btn btn-success btn-xs'>View Trade</a>";
                }
                $view .= "
                <tr>
                    <td>$count</td>
                    <td>".$this->Util_model->get_user_info($row['buyer'], 'username', 'profile')."</td>
                    <td>$row[amount]</td>
                    <td>".number_format($row['fiat_amount'])."</td>
                    <td>$row[trans_id]</td>
                    <td>".date_difference($row['expiry_date'],date_time(),"H:i:s")."</td>
                    <td>$row[created_date]</td>
                    <td>$status</td>
                    <td>$btn</td>
                </tr>
                ";
            }
        }

        return $view;
    }

    public function create_buy_order($amount) {
        $s = $this->Db_model->selectGroup("*", "sell_order");
        $amt = 0;
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                if ($amount > $row['amount']) {
                    $amt = $amount - $row['amount'];
                    $data = [
                        "trans_id" => $this->Util_model->generate_id(11111111, 99999999, "trans", "trans_id", "varchar", true, "fb"),
                        "buyer" => userdata(UID),
                        "seller" => $row['uid'],
                        "amount" => $row['amount'],
                        "fiat_amount" => $row['amount'] * $this->Util_model->get_option("coin_price"),
                        "bank" => $row['bank'],
                        "acc_name" => $row['acct_name'],
                        "acc_num" => $row['acct_number'],
                        "status" => 0,
                        "created_date" => date_time(),
                        "expiry_date" => ''
                    ];
                    $this->Db_model->insert("trans", $data);
                    $this->Db_model->delete("sell_order", "WHERE id=$row[id]");
                    if ($amt < 100) {
                        $amt = 0;
                        break;
                    }
                } else if ($amount == $row['amount']) {
                    $amt = $amount - $row['amount'];
                    $data = [
                        "trans_id" => $this->Util_model->generate_id(11111111, 99999999, "trans", "trans_id", "varchar", true, "fb"),
                        "buyer" => userdata(UID),
                        "seller" => $row['uid'],
                        "amount" => $row['amount'],
                        "fiat_amount" => $row['amount'] * $this->Util_model->get_option("coin_price"),
                        "bank" => $row['bank'],
                        "acc_name" => $row['acct_name'],
                        "acc_num" => $row['acct_number'],
                        "status" => 0,
                        "created_date" => date_time(),
                        "expiry_date" => ''
                    ];
                    $this->Db_model->insert("trans", $data);
                    $this->Db_model->delete("sell_order", "WHERE id=$row[id]");
                    break;
                } else {
                    $amt = $amount - $row['amount'];
                    $data = [
                        "trans_id" => $this->Util_model->generate_id(11111111, 99999999, "trans", "trans_id", "varchar", true, "fb"),
                        "buyer" => userdata(UID),
                        "seller" => $row['uid'],
                        "amount" => $amount,
                        "fiat_amount" => $amount * $this->Util_model->get_option("coin_price"),
                        "bank" => $row['bank'],
                        "acc_name" => $row['acct_name'],
                        "acc_num" => $row['acct_number'],
                        "status" => 0,
                        "created_date" => date_time(),
                        "expiry_date" => ''
                    ];
                    $this->Db_model->insert("trans", $data);
                    $this->Db_model->update("sell_order", ["amount"=>( $row['amount'] - $amount )], "WHERE id=$row[id]");
                    break;
                }
            }
            if ($amt > 0) {
                $seller = $this->Db_model->select("*", "sell_order_bot", "ORDER BY RAND() LIMIT 1");
                $data = [
                    "trans_id" => $this->Util_model->generate_id(11111111, 99999999, "trans", "trans_id", "varchar", true, "fb"),
                    "buyer" => userdata(UID),
                    "seller" => $seller['uid'],
                    "amount" => $amt,
                    "fiat_amount" => $amt * $this->Util_model->get_option("coin_price"),
                    "bank" => $seller['bank'],
                    "acc_name" => $seller['acct_name'],
                    "acc_num" => $seller['acct_number'],
                    "status" => 0,
                    "created_date" => date_time(),
                    "expiry_date" => ''
                ];
                $this->Db_model->insert("trans", $data);
            }
        } else {
            $seller = $this->Db_model->select("*", "sell_order_bot", "ORDER BY RAND() LIMIT 1");
            $data = [
                "trans_id" => $this->Util_model->generate_id(11111111, 99999999, "trans", "trans_id", "varchar", true, "fb"),
                "buyer" => userdata(UID),
                "seller" => $seller['uid'],
                "amount" => $amount,
                "fiat_amount" => $amount / $this->Util_model->get_option("coin_price"),
                "bank" => $seller['bank'],
                "acc_name" => $seller['acct_name'],
                "acc_num" => $seller['acct_number'],
                "status" => 0,
                "created_date" => date_time(),
                "expiry_date" => ''
            ];
            $this->Db_model->insert("trans", $data);
        }
    }

    public function create_sell_order ($amount, $inputs, $method) {
        $amt = $amount + get_percentage($amount, $this->Util_model->get_option("coin_sell_percentage"));
        if ($amt > $this->General_model->get_balance(userdata(UID), false)) {
            $return = [
                "status"    =>  0,
                "msg"       =>  "<i class='fa fa-times-circle'></i> Not enough MEX coin to sell"
            ];
        } else {
            $in_split = explode(",", $inputs);
            $input = array();
            foreach ($in_split as $row) {
                $row_split = explode(":", $row);
                $input[$row_split[0]] = $row_split[1];
            }

            $this->load->model("users/Users_model", "user");
            if (!$this->user->confirm_pass($input['password'])) {
                $return = [
                    "status"    =>  0,
                    "msg"       =>  "<i class='fa fa-times-circle'></i> Incorrect password"
                ];
            } else {
                unset($input['password']);
                $details = implode(",", $input);
                $this->Main_model->add_to_wallet(get_percentage($amount, $this->Util_model->get_option("coin_sell_percentage")), 0, userdata(UID), "1.5% commission for the sell of $amount MEX", "1.5% sell commission", "Sell Commission", "", "", 1);
                if ($method == "bank") {
                    $extra = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "extra");
                    $fiat = $amount * $this->Util_model->get_option("coin_price");
                    $data = [
                        "uid"           =>  userdata(UID),
                        "amount"        =>  $amount,
                        "bank"          =>  $input['bank'],
                        "acct_number"   =>  $input['acct_num'],
                        "acct_name"     =>  $input['acct_name']
                    ];
                    $this->Db_model->insert("sell_order", $data);
                    $this->Main_model->update_escrow(userdata(UID), $amount);
                } else {
                    $wallet = $this->Main_model->add_to_wallet($amount, 0, userdata(UID), "Withdrawal", "Withdrawal", "Withdraw", $method." ($details)");
                }

                set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Withdrawal booked successfully.", "alert-success", 1));
                $return = [
                    "status"    =>  1,
                    "url"       =>  base_url()."trade"
                ];
            }
        }
        return $return;
    }

    public function list_chat ($order_id) {
        $s = $this->Db_model->selectGroup("*", "p2p_chat", "WHERE order_id=$order_id AND (sender=".userdata(UID)." OR receiver=".userdata(UID).")");
        if ($s->num_rows() == 0) {
            $view = "
            <p class='text-muted'>Start a new conversation <i class='fa fa-long-arrow-down'></i></p>
            ";
        } else {
            $view = "";
            foreach ($s->result_array() as $row) {
                if ($row['receiver'] == userdata(UID)) {
                    $view .= "
                    <!-- Message. Default to the left -->
                    <div class='direct-chat-msg'>
                        <div class='direct-chat-info clearfix'>
                            <span class='direct-chat-name pull-left'>".$this->Util_model->get_user_info($row['sender'], 'username', 'profile')."</span>
                            <span class='direct-chat-timestamp pull-right'>".get_time_ago($row['date'])."</span>
                        </div>
                        <!-- /.direct-chat-info -->
                        <img class='direct-chat-img' src='".base_url().$this->Util_model->picture($row['sender'])."' alt='".$this->Util_model->get_user_info($row['sender'], 'username', 'profile')."'><!-- /.direct-chat-img -->
                        <div class='direct-chat-text'>";
                        if ($row['type'] == 'text') {
                            $view .= "
                            $row[content]
                            ";
                        } else {
                            $view .= "
                            <a class='example-image-link' href='".base_url()."$row[content]' data-lightbox='image-set' data-title='Click the right half of the image to move forward.'><img class='example-image' src='".base_url()."$row[content]' alt='' style='width:100%; height:auto;'/></a>
                            ";
                        }
                        $view .= "</div>
                        <!-- /.direct-chat-text -->
                    </div>
                    <!-- /.direct-chat-msg -->
                    ";
                    $this->Db_model->update("p2p_chat", ["new"=>0], "WHERE id=$row[id]");
                } else {
                    $view .= "
                    <!-- Message. Default to the left -->
                    <div class='direct-chat-msg right'>
                        <div class='direct-chat-info clearfix'>
                            <span class='direct-chat-name pull-right'>Me</span>
                            <span class='direct-chat-timestamp pull-left'>".get_time_ago($row['date'])."</span>
                        </div>
                        <!-- /.direct-chat-info -->
                        <img class='direct-chat-img' src='".base_url().$this->Util_model->picture($row['sender'])."' alt='".$this->Util_model->get_user_info($row['sender'], 'username', 'profile')."'><!-- /.direct-chat-img -->
                        <div class='direct-chat-text'>";
                    if ($row['type'] == 'text') {
                        $view .= "
                            $row[content]
                            ";
                    } else {
                        $view .= "
                            <a class='example-image-link' href='".base_url()."$row[content]' data-lightbox='image-set' data-title='Click the right half of the image to move forward.'><img class='example-image' src='".base_url()."$row[content]' alt='' style='width:100%; height:auto;'/></a>
                            ";
                    }
                    $view .= "</div>
                        <!-- /.direct-chat-text -->
                    </div>
                    <!-- /.direct-chat-msg -->
                    ";
                }
            }
        }
        return $view;
    }

    public function post_chat ($sender, $receiver, $order_id, $content, $type="text") {
        $data = array (
            "mid"           =>  MID,
            "sender"        =>  $sender,
            "receiver"      =>  $receiver,
            "order_id"      =>  $order_id,
            "content"       =>  $content,
            "type"          =>  $type,
            "new"           =>  1
        );
        if ($this->Db_model->insert("p2p_chat", $data)) {
            return true;
        } else {
            return false;
        }
    }

    public function made_payment($trans_id) {
        if ($this->Util_model->get_info("p2p_orders", "status", "WHERE id=$trans_id") == 1) {
            if ($this->Db_model->update("p2p_orders", ["status" => 2, "paid_date" => date_time()], "WHERE id=$trans_id")) {
                set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Order marked as paid. Awaiting confirmation.", "alert-success", 1));
                //Send message to seller to release order
            } else {
                set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
            }
        }
    }

    public function release_trade ($trans_id) {
        $trans = $this->Util_model->get_info("p2p_orders", "*", "WHERE id='$trans_id'");
        if ($trans['status'] <= 2) {
            if ($this->Db_model->update("p2p_orders", ["status" => 3, "confirm_date" => date_time()], "WHERE id='$trans_id'")) {
                $this->Main_model->add_to_wallet($trans['amount'], $trans['buyer_uid'], $trans['seller_uid'], "Purchased $trans[amount] USD from @".$this->Util_model->get_user_info($trans['seller_uid'], "username", "profile"), "Sold $trans[amount] USD to @".$this->Util_model->get_user_info($trans['buyer_uid'], "username", "profile"), "deposit/withdraw", "p2p_order:id=$trans_id", "", 1);
                return true;
            } else {
                return false;
            }
        }
    }

    public function trade_time_up ($trans_id) {
        $trans = $this->Util_model->get_info("p2p_orders", "status, expiry_date", "WHERE id='$trans_id'");
        $remain = get_time_stamp($trans['expiry_date']) - get_time_stamp(date_time());
        if ($remain <= 0) {
            if ($trans['status'] == 1) {
                return $this->cancel_trade($trans_id);
            }
        }
        return true;        
    }

    public function cancel_trade ($trans_id) {
        $trans = $this->Util_model->get_info("p2p_orders", "*", "WHERE id='$trans_id'");
        if ($trans['status'] <= 2) {
            if ($this->Db_model->update("p2p_orders", ["status" => 4], "WHERE id='$trans_id'")) {
                //$this->Main_model->update_escrow($trans['seller'], $trans['amount'], 'reduce');
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function appeal_order ($trans_id) {
        $trans = $this->Db_model->select("*", "trans", "WHERE trans_id='$trans_id'");
        if ($trans['status'] == 0 || $trans['status'] == 1) {
            if ($this->Db_model->update("trans", ["status" => 4], "WHERE trans_id='$trans_id'")) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function remaining_time ($date) {
        $remain = get_time_stamp($date) - get_time_stamp(date_time());
        if ($remain <= 0) {
            return "00:0:0";
        } else {
            return date_difference($date, date_time());
        }
    }

    public function list_seller_details($uid, $method) {
        $s = $this->Db_model->selectGroup("*", "p2p_user_payment_details", "WHERE uid=$uid AND method=$method");
        $view = '<ul class="todo-list">';
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $view .= "
                <li>
                    <span class='text pointer-cursor' onclick='verify_password(\"".base_url()."p2p/create-sell-order/?merchant=\"+____(\"merchant\")+\"&amount=\"+____(\"amount\")+\"&detail=$row[id]&currency=\"+____(\"currency\")+\"&rate=\"+____(\"rate\")+\"&\")'>";
                if (strstr($row['details'], ",")) {
                    $detail = explode(",", $row['details']);
                    foreach ($detail as $row1) {
                        $detail1 = explode("=", $row1);
                        $view .= "
                            <span class='badge'>$detail1[0]</span> 
                            $detail1[1] <br>
                        ";
                    }
                } else {
                    $detail1 = explode("=", $row['details']);
                    $view .= "
                        <span class='badge'>$detail1[0]</span> 
                        $detail1[1] <br>
                    ";
                }
                $view .= "
                    </span>
                    <div class='tools'>
                        <i class='fa fa-edit pointer-cursor' onclick='window.location = \"".base_url()."manage-payment-details/$row[method]/$row[id]\"'></i>
                        <i class='fa fa-trash-o pointer-cursor' onclick='verify_password(\"".base_url()."p2p/delete-payment-detail/?id=$row[id]&method=$row[method]&\")'></i>
                    </div>
                </li>";
            }
        } else {
            $view .= "<li><span class='text'>No payment detail found</span></li>";
        }
        $view .= "</ul>";
        return $view;
    }

}