<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Approved Books</h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                    </div>
                    <div class="box-body tab-content table-responsive">
                        <table class="dataTable table table-striped">
                            <thead>
                                <tr>
                                    <th>
                                        Cover Page
                                    </th>
                                    <th>
                                        Title
                                    </th>
                                    <th>
                                        Chapter
                                    </th>
                                    <th>
                                        Edition
                                    </th>
                                    <th>
                                        Owner
                                    </th>
                                    <th class='action d-print-none'>
                                        Action
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                                $where = " WHERE status = " . ACTIVE . " ORDER BY last_update DESC LIMIT ".LIMIT;
                                $books = $this->scansio_db_man->selectGroup('book_main', '', $where);                                
                                foreach ($books as $row) {
                                    $author = $this->scansio_db_man->select('user_main', '', 'WHERE uid = ' . $row['author'])['name'];
                                    if (!$author) $author = 'Unknown';
                                    $chapters = $row['chapters'];
                                    $edition = $row['edition'];
                                    $code = $row['book_id'];
                                    $status = $row['status'];
                                    $promote_btn = (!$this->scansio_db_man->select('default_book', '', "WHERE bid = $row[id] AND status = ".ACTIVE) ? "<a href='" . base_url() . "admin/promote/" . $code . "' class='btn btn-info btn-xs no-border' title='Make Default Course'><i class='fa fa-check'></i> Make Default </a>"
                                    : "<a href='" . base_url() . "admin/depromote/" . $code . "' class='btn btn-warning btn-xs no-border' title='Remove from default'><i class='fa fa-remove'></i> Remove Default </a>");
                                    $statusLink = '';
                                    $statusText = '';
                                    if ($status == PUBLISHED) {
                                        $statusText = 'Unpublish';
                                        $statusLink = base_url("books/pub/" . UNPUBLISH . "/$row[book_id]");
                                    } else if ($status == PENDING_PUBLISH) {
                                        $statusText = 'Publish';
                                        $statusLink = base_url("books/pub/" . PUBLISH . "/$row[book_id]");
                                    }else if ($status == SUSPENDED) {
                                        $statusText = 'Suspended';
                                        $statusLink = 'javascript:';
                                    }
                                    else if ($status == PENDING_APPROVAL) {
                                        $statusText = 'Pending';
                                        $statusLink = 'javascript:';
                                    }
                                    else if ($status == APPROVAL_DECLINED) {
                                        $statusText = 'Re-publish';
                                        $statusLink = base_url("books/pub/" . PUBLISH . "/$row[book_id]");
                                    }
                    
                                    echo "     
                                        <tr>
                                            <td>
                                            <img src='" . base_url($row['pic_url']) . "' style='height: 100px; width: 80px;'  class='pointer-cursor'>
                                            </td>
                                            <td>
                                                $row[title]
                                            </td>
                                            <td>
                                                $chapters
                                            </td>
                                            <td>
                                                $edition
                                            </td>
                                            <td>
                                                $author
                                            </td>
                                            <td>
                                                <a href='" . base_url() . "admin/read/" . $code . "' class='btn btn-info btn-xs no-border' title='View'><i class='fa fa-eye'></i> View </a>
                                                $promote_btn
                                                <a href='".base_url()."admin/command/$code/".SUSPEND."' class='btn btn-warning btn-xs no-border' title='Suspend this course'><i class='fa fa-remove'></i> Suspend </a>
                                                <a href='".base_url()."admin/command/$code/".HOTLIST."' class='btn btn-danger btn-xs no-border' title='Delete this course'><i class='fa fa-remove'></i> Delete </a>
                                            </td>
                                        </tr>
                                ";
                                }
                            ?>
                            </tbody>
                        </table> 
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('.dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true
        });
    });
</script>
