<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Credit/Debit User
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header no-padding">
                        <ul class="nav nav-tabs no-padding">
                            <li class="active"><a href="#add-remove-fund" data-toggle="tab">Credit/Debit User</a>
                            </li>
                            <li><a href="#history" data-toggle="tab">History</a></li>
                        </ul>
                    </div>
                    <div class="box-body no-padding">
                        <div class="tab-content">
                            <div class="tab-pane active" id="add-remove-fund">
                                <div
                                    class="col-lg-offset-3 col-md-offset-3 col-sm-offset-2 col-lg-6 col-md-6 col-sm-8 top-2x">
                                    <?php echo form_open(base_url() . "admin/credit_debit_user"); ?>
                                    <div class="form-group">
                                        <label>Type</label>
                                        <select name="type" class="form-control" required>
                                            <option value="">Select Type</option>
                                            <option value="credit" <?=$type && $type=="credit" ? "selected" : ""?>>
                                                Crediting</option>
                                            <option value="debit" <?=$type && $type=="debit" ? "selected" : ""?>>
                                                Debiting</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Username</label>
                                        <input class="form-control" type="text" name="username" required
                                            placeholder="Enter the username of the user"
                                            title="Enter the username of the user" data-toggle="tooltip"
                                            value="<?= $username?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Amount</label>
                                        <input class="form-control" type="number" name="amount" required
                                            placeholder="Enter the amount you want to credit or debit"
                                            title="Enter the amount you want to credit or debit" data-toggle="tooltip"
                                            value="<?= $amount?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Description</label>
                                        <input class="form-control" type="text" name="description" required
                                            placeholder="Enter the description of the transaction"
                                            title="Enter the description of the transaction" data-toggle="tooltip"
                                            value="<?= $description?>">
                                    </div>
                                    <div class="form-group">
                                        <label>Password</label>
                                        <input type="password" name="password" placeholder="Enter your password"
                                            class="form-control" required title="Enter your password"
                                            data-toggle="tooltip" value="">
                                    </div>
                                    <div class="form-group">
                                        <button class="btn btn-primary btn-flat btn-block no-border"
                                            type="submit">Proceed</button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                            <div class="tab-pane" id="history">
                                <div class="col-xs-12 top-2x">
                                    <table class="table table-bordered table-striped transTable">
                                        <thead>
                                            <tr>
                                                <th class="text-center">Status</th>
                                                <th class="text-center">Name</th>
                                                <th class="text-center">Amount</th>
                                                <th class="text-center">Type</th>
                                                <th class="text-center">Reference</th>
                                                <th class="text-center">Description</th>
                                                <th class="text-center">Verified By</th>
                                                <th class="text-center">Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "credit_debit_user", "ORDER BY id DESC, status LIMIT ".LIMIT);
                                            if ($s->num_rows() > 0) {
                                                foreach ($s->result_array() as $row) {
                                                    $amount = number_format($row['amount']);
                                                    $user = $this->Util_model->get_info("user_main", "name", "WHERE uid=$row[uid]");
                                                    $verified_by = $this->Util_model->get_info("user_main", "name", "WHERE uid=$row[admin_uid]");
                                                    $description = $row['description'];
                                                    $reference = $row['ref'];
                                                    $type = $row['type'];
                                                    $date = $row['date'];
                                                    if ($row['status'] == 0) {
                                                        $status = "<span class='text-red'>Pending</span>";
                                                    }
                                                    else if ($row['status'] == HOTLISTED) {
                                                        $status = "<span class='text-gray'>Failed</span>";
                                                    }
                                                    else if ($row['status'] == ACTIVE) {
                                                        $status = "<span class='text-green'>Success</span>";
                                                    }
                                                    echo "
                                                    <tr class='text-center'>
                                                        <td>$status</td>
                                                        <td>$user</td>
                                                        <td>" . USD . "$amount</td>
                                                        <td>$type</td>
                                                        <td>$reference</td>
                                                        <td>$description</td>
                                                        <td>$verified_by</td>
                                                        <td>$date</td>
                                                    </tr>\n
                                                    ";
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
$(function() {

    $('.transTable').DataTable({
        "order": [0, "desc"]
    });

    _("USD-amount").keyup(function() {
        var rate = <?php echo $this->Util_model->get_option("dollar_rate"); ?>;
        var convert = $(this).val() * rate;
        _("fiat-amount").text(convert.toFixed(2));
    });

    _("fiat-pay").click(function() {
        var amount = ____("fiat-amount");
        if (amount < 50) {
            msg("<i class='fa fa-times-cirlce'></i> Minimum deposit amount is <?php echo USD; ?>0.1",
                "alert-danger", 1, _("msg"));
        } else if (amount > 500000) {
            msg("<i class='fa fa-times-cirlce'></i> Maximum deposit amount is <?php echo USD; ?>1,000",
                "alert-danger", 1, _("msg"));
        } else {
            window.location = "<?php echo base_url(); ?>wallet/initialize-deposit/" + amount;
        }
    });

    _("USD-amount").keyup();

});

function update_withdraw_status(ref, status, type) {
    var type = (!type) ? "merchant" : type;
    $.post('<?php echo base_url(); ?>wallet/withdraw_status', {
        "reference": ref,
        "status": status,
        "type": type
    }, function() {
        msg("<i class='fa fa-check-circle'></i> Status updated successfully", "alert-success", 1, _('msg'));
        reloadPage(200);
    });
}

function add_fee(amount) {
    if (amount.val() > 0 || amount.val().trim().length > 0) {
        var total = "$";
        total += numberWithCommas(parseFloat(amount.val()) + 1);
        total += " +fee"
        _('total').text(total);
    } else {
        _('total').text("Total Amount")
    }
}
</script>