<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Deleted Courses</h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                    </div>
                    <div class="box-body table-responsive">
                        <table class="dataTable table table-striped">
                            <thead>
                                <tr>
                                    <th>
                                        Course Code
                                    </th>
                                    <th>
                                        Thumbnail
                                    </th>
                                    <th>
                                        Title
                                    </th>
                                    <th>
                                        Topics
                                    </th>
                                    <th>
                                        Time
                                    </th>
                                    <th>
                                        Owner
                                    </th>
                                    <th>
                                        Updated
                                    </th>
                                    <th class='action d-print-none'>
                                        Action
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                                $where = " WHERE status = " . HOTLISTED . " ORDER BY last_update DESC LIMIT ".LIMIT;
                                $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where);                                
                                foreach ($courses as $course) {
                                    $course_instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED)['name'];
                                    $code = $course['course_code'];
                                    $title = $course['course_title'];
                                    $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED);
                                    $topics = ($topics ? count($topics) : 0);
                                    $time = $course['course_time'];
                                    $updated = $course['last_update'];
                        
                                    echo "     
                                            <tr>
                                                <td>
                                                    $code
                                                </td>
                                                <td>
                                                    <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor'>
                                                </td>
                                                <td>
                                                    $title
                                                </td>
                                                <td>
                                                    $topics
                                                </td>
                                                <td>
                                                    " . getFormattedDuration($time) . "
                                                </td>
                                                <td>
                                                    $course_instructor
                                                </td>
                                                <td>
                                                    $updated
                                                </td>
                                                <td>
                                                    <a href='" . base_url() . "admin/read/" . $code . "' class='btn btn-info btn-xs no-border' title='View'><i class='fa fa-eye'></i> View </a>
                                                    <a href='".base_url()."admin/delete/$code' class='btn btn-danger btn-xs no-border' data-toggle='tooltip' data-title='This action is irriversible proceed with caution'><i class='fa fa-remove'></i> Delete </a>
                                                    <a href='".base_url()."admin/command/$code/".PENDING_PUBLISH."' class='btn btn-success btn-xs no-border' title='Release this course'><i class='fa fa-check'></i> Recover </a>
                                                </td>
                                            </tr>
                                        ";
                                }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('.dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });
    });
</script>
