<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Home</h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!--Message status-->
    <section id="msg">
        <?php echo userdata("msg"); ?>
    </section>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12 s-start-grid">
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <!-- small box -->
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Users</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("user_main", "WHERE status = " . ACTIVE . "")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("user_main", "WHERE status = " . ACTIVE . " AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/users" class="">View Users</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Active Users</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("user_profile", "WHERE duration > 0")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("user_profile", "WHERE duration > 0 AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/active_users" class="">View Active Users</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Inactive Users</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("user_profile", "WHERE duration = 0")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("user_profile", "WHERE duration = 0 AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/inactive_users" class="">View Inactive Users</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Deposits</b></div>
                        <div class="box-body">
                            <h2>
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%deposit%' AND status=" . ACTIVE . "")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%deposit%' AND status=" . ACTIVE . " AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/deposits" class="">View Deposits</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Manual Deposits</b></div>
                        <div class="box-body">
                            <h2>
                                <?php echo USD . count_format($this->Util_model->sum_field("funding", "amount", "WHERE status=" . ACTIVE . "")); ?>
                            </h2>
                            <p class="text-center">Pending
                                <span class="badge bg-black">
                                    <?php echo count_format($this->Util_model->row_count("funding", "WHERE status=0")); ?>
                                </span>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/manual_deposits" class="">View Manual Deposits</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Circulating Funds</b></div>
                        <div class="box-body">
                            <h2>
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%deposit%' AND status=" . ACTIVE . "") - $this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%withdraw%' AND status=" . ACTIVE . "")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%deposit%' AND status=" . ACTIVE . " AND date LIKE '" . date_time('d') . "%'") - $this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%withdraw%' AND status=" . ACTIVE . " AND date
                                LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/deposits" class="">View Deposits</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>System Revenue</b></div>
                        <div class="box-body">
                            <h2>
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE debitor = 0 AND status = " . APPROVED) - $this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor = 0 AND status = " . APPROVED)); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE debitor = 0 AND status = " . APPROVED . " AND date LIKE '" . date_time('d') . "%'") - $this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor = 0 AND status = " . APPROVED . " AND date
                                LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Withdrawals</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%withdraw%' AND status=" . ACTIVE . "")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo USD . count_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE type LIKE '%withdraw%' AND status=" . ACTIVE . " AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/withdrawals" class="">View Withdrawals</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Approved Courses</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("academy_course", "WHERE status=" . PUBLISHED . "")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("academy_course", "WHERE status=" . PUBLISHED . " AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                            <a href="<?= base_url() ?>/admin/pending_courses">
                                <p class="text-center">Pending
                                    <span class="badge bg-black">
                                        <?php echo count_format($this->Util_model->row_count("academy_course", "WHERE status = " . PENDING_APPROVAL)); ?>
                                    </span>
                                </p>
                            </a>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/approved_courses" class="">View Courses</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Approved Books</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("book_main", "WHERE status=" . PUBLISHED . "")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("book_main", "WHERE status=" . PUBLISHED . " AND date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                            <a href="<?= base_url() ?>/admin/pending_books">
                                <p class="text-center">Pending
                                    <span class="badge bg-black">
                                        <?php echo count_format($this->Util_model->row_count("book_main", "WHERE status = " . PENDING_APPROVAL)); ?>
                                    </span>
                                </p>
                            </a>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/approved_books" class="">View Books</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Approved Opportunity</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("opportunity", "WHERE status = " . PUBLISHED . "")); ?>
                            </h2>
                            <p class="text-center">Pending
                                <span class="badge bg-black">
                                    <?php echo count_format($this->Util_model->row_count("opportunity", "WHERE status = " . PENDING_APPROVAL)); ?>
                                </span>
                            </p>

                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/opportunities" class="">View Opportunity</a>
                        </div>
                    </div>
                </div>
                <!-- Sold Courses -->
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Sold Courses</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("course_purchase")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("course_purchase", "WHERE date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/approved_courses" class="">View Courses</a>
                        </div>
                    </div>
                </div>
                <!-- Sold Books -->
                <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6">
                    <div class="box text-center no-border no-padding">
                        <div class="box-header"><b>Sold Books</b></div>
                        <div class="box-body ">
                            <h2>
                                <?php echo count_format($this->Util_model->row_count("book_purchase")); ?>
                            </h2>
                            <p class="text-center">Today
                                <?php echo count_format($this->Util_model->row_count("book_purchase", "WHERE date LIKE '" . date_time('d') . "%'")); ?>
                            </p>
                        </div>
                        <div class="box-footer">
                            <a href="<?php echo base_url(); ?>admin/approved_books" class="">View Books</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xs-12 row">
                <div class="col-sm-6 col-xs-12">
                    <div class="box no-border no-padding">
                        <div class="box-header with-border"><b>Course Category</b></div>
                        <div class="box-body s-100h" style="overflow: auto;">
                            <?php
                            $course_category = $this->scansio_db_man->selectGroup("academy_category", '*', "WHERE " . ACTIVE . " ORDER BY date DESC");
                            $count = 0;
                            foreach ($course_category as $cat) {
                                ++$count;
                            ?>
                            <p class="with-border border"><span class="text-danger">
                                    <?= $count ?>
                                </span>.
                                <?= $cat['title'] ?>
                            </p>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="box-footer">
                            <?= form_open('admin/add-course-category') ?>
                            <div class="form-group" style="display: flex;">
                                <input type="text" name="category" class="form-control"
                                    placeholder="Add Course Category">
                                <button type="submit" class="btn btn-info no-border no-curve">Add</button>
                            </div>
                            <?= form_close() ?>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="box no-border no-padding">
                        <div class="box-header with-border"><b>Book Category</b></div>
                        <div class="box-body s-100h" style="overflow: auto;">
                            <?php
                            $book_category = $this->scansio_db_man->selectGroup("book_category", '', "WHERE " . ACTIVE . " ORDER BY date DESC");
                            $count = 0;
                            foreach ($book_category as $cat) {
                                ++$count;
                            ?>
                            <p class="with-border border"><span class="text-danger">
                                    <?= $count ?>
                                </span>.
                                <?= $cat['title'] ?>
                            </p>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="box-footer">
                            <?= form_open('admin/add-book-category') ?>
                            <div class="form-group" style="display: flex;">
                                <input type="text" name="category" class="form-control" placeholder="Add Book Category">
                                <button type="submit" class="btn btn-info no-border no-curve">Add</button>
                            </div>
                            <?= form_close() ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>