<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Manual Deposits
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Manual Deposits</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#user" data-toggle="tab">Pending <span class="badge bg-black">
                                            <?php echo count_format($this->Util_model->row_count("funding", "WHERE status=0")); ?>
                                        </span></a> </li>
                            </ul>
                            <div class="tab-content table-responsive">
                                <div class="tab-pane active" id="user">
                                    <h4 class="bottom-2x">User Funding</h4>
                                    <table class="table table-bordered table-striped transTable">
                                        <thead>
                                            <tr>
                                                <th class="text-center">Status</th>
                                                <th class="text-center">Username</th>
                                                <th class="text-center">Sender Name</th>
                                                <th class="text-center">Sender Bank</th>
                                                <th class="text-center">Amount Paid</th>
                                                <th class="text-center">Amount</th>
                                                <th class="text-center">Narration</th>
                                                <th class="text-center">Reference</th>
                                                <th class="text-center">Balance</th>
                                                <th class="text-center">Verified By</th>
                                                <th class="text-center">Date</th>
                                                <th class="text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "funding", "ORDER BY id DESC, status LIMIT ".LIMIT);
                                            if ($s->num_rows() > 0) {
                                                foreach ($s->result_array() as $row) {
                                                    $bank = $this->Util_model->get_info("banks", "name", "WHERE code='$row[bank]'");
                                                    $amount = number_format($row['amount']);
                                                    $username = $this->Util_model->get_info("user_profile", "username", "WHERE uid=$row[uid]");

                                                    if ($row['status'] == 0) {
                                                        $status = "<span class='text-red'>Pending</span>";
                                                        $approve_btn = "<a href='" . base_url() . "wallet/user_funding/$row[id]' class='btn btn-success btn-xs' data-toggle='tooltip'> Confirm</a>";
                                                        $cancel_btn = "<a href='" . base_url() . "wallet/funding-cancel/$row[id]' class='btn btn-danger btn-xs' data-toggle='tooltip'>
                                                            Cancel</a>";
                                                    }
                                                    else if ($row['status'] == HOTLISTED) {
                                                        $status = "<span class='text-gray'>Cancelled</span>";
                                                        $approve_btn = "";
                                                        $cancel_btn = "";
                                                    }
                                                    else if ($row['status'] == ACTIVE) {
                                                        $status = "<span class='text-green'>Completed</span>";
                                                        $approve_btn = "";
                                                        $cancel_btn = "";
                                                    }
                                                    echo "
                                                <tr class='text-center'>
                                                    <td>$status</td>
                                                    <td>$username</td>
                                                    <td>$row[name]</td>
                                                    <td>$bank</td>
                                                    <td>".USD.number_format($row['amount_paid'])."</td>
                                                    <td>".USD."$amount</td>
                                                    <td>$row[reference]</td>
                                                    <td>$row[ref]</td>
                                                    <td>" . $this->General_model->get_balance($row['uid']) . "</td>
                                                    <td>".$this->Util_model->get_info("user_main", "name", "WHERE uid = $row[verified_by]")."</td>
                                                    <td>$row[date]</td>
                                                    <td>
                                                        ".$approve_btn."
                                                        ".$cancel_btn."
                                                    </td>
                                                </tr>\n
                                                ";
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
$(function() {

    $('.transTable').DataTable({
        "order": [0, "desc"]
    });

});
</script>