<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Mailer
            <small>Send email messages to your clients</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <div class=''>
                            <button onclick='get_users("all")' class='btn btn-primary btn-xs no-border'
                                data-toggle='tooltip' data-title='Send to all users'>
                                All </button>
                            <button onclick='get_users("paid")' class='btn btn-primary btn-xs no-border'
                                data-toggle='tooltip' data-title='Send to paid users'>
                                Paid </button>
                            <button onclick='get_users("unpaid")' class='btn btn-primary btn-xs no-border'
                                data-toggle='tooltip' data-title='Send to unpaid users'>
                                Unpaid </button>
                            <button onclick='get_users("vendors")' class='btn btn-primary btn-xs no-border'
                                data-toggle='tooltip' data-title='Send to vendors'>
                                Vendors </button>
                            <button onclick='get_users("basic")' class='btn btn-primary btn-xs no-border'
                                data-toggle='tooltip' data-title='Basic users'>
                                Basic users </button>

                        </div>
                    </div>
                    <div class="box-body table-responsive top-pad-3x bottom-pad-3x">
                        <?php echo form_open(base_url() . "admin/newsletter", ['id' => 'newsletter-form']); ?>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Receiver</label>
                                <input class="form-control" name="receiver" required type="text"
                                    placeholder="example@example.com" value="<?= $receiver?>">
                                <small>You can use comma to separate multiple emails</small>
                            </div>
                            <div class="form-group">
                                <label>Subject</label>
                                <input class="form-control" name="subject" required type="text" value="<?= $subject?>">
                            </div>
                            <div class="form-group">
                                <label>Heading</label>
                                <input class="form-control" name="heading" required type="text" value="<?= $heading?>">
                            </div>
                            <div class="form-group">
                                <label>Button Label</label>
                                <input class="form-control" name="button_label" type="text" placeholder="Visit Our Site"
                                    value="<?= $button_label?>">
                            </div>
                            <div class="form-group">
                                <label>Button Link</label>
                                <input class="form-control" name="button_href" type="text"
                                    placeholder="Where will viewer be directed when clicked on the button"
                                    value="<?= $button_link?>">
                            </div>
                            <div class="form-group">
                                <label>Message</label>
                                <form method="post" class="form-control">
                                    <textarea id="summernote" name="message"
                                        form="newsletter-form"><?= $message?></textarea>
                                </form>
                            </div>
                            <label>&nbsp;</label>
                            <button class="btn btn-success btn-block" type="submit">Send Message</button>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="box no-border no-padding top-2x">
                                <div class="box-header with-border"><b>Newsletters Template</b></div>
                                <div class="box-body" style="overflow: auto; max-height: 300px;">
                                    <ul class="products-list product-list-in-box">
                                        <?php
                                        $newsletter_templates = $this->scansio_db_man->selectGroup("newsletter_template", '', "WHERE " . ACTIVE . " ORDER BY date DESC");
                                        $count = 0;
                                        foreach ($newsletter_templates as $template) {
                                            ++$count;
                                        ?>
                                        <li class='item cursor-pointer' style='padding-left:5px; padding-right:5px;'>
                                            <div class='product-img'>
                                                <div class='img-circle text-center pull-left bg-danger'
                                                    style='width:40px; height:40px; vertical-align: middle'>
                                                    <?= $count?>
                                                </div>
                                            </div>
                                            <div class='product-info'>
                                                <a href='<?= base_url()?>admin/newsletter/<?= $template['id'] ?>'
                                                    class='product-title'>
                                                    <?= $template['subject'] ?>
                                                </a>
                                                <button
                                                    onclick='window.location = "<?= base_url()?>admin/remove_template/<?= $template["id"] ?>"'
                                                    class='btn btn-danger btn-xs no-border pull-right'
                                                    data-toggle='tooltip' data-title='Remove this template'><i
                                                        class='fa fa-remove'></i>
                                                </button>
                                            </div>
                                        </li>
                                        <?php
                                        }?>
                                    </ul>
                                </div>
                                <div class="box-footer">
                                    <div class="form-group" style="display: flex;">
                                        <input class="form-control" placeholder="Save this template" disabled>
                                        <button type="submit" class="btn btn-info no-border no-curve"
                                            onclick='add_newsletter()'>Save</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote.min.js"></script>
<script>
$(document).ready(function() {
    $('#summernote').summernote();
});

function add_newsletter(e) {
    let newsletter = $('#newsletter-form');
    newsletter.attr("action", "<?= base_url()?>admin/add-newsletter");
    newsletter.submit();
}

function get_users(group) {
    $.ajax({
        type: "POST",
        url: "<?= base_url()?>admin/get_users/" + group,
        cache: false,
        processData: false,
        success: function(response) {
            $('input[name="receiver"]').val(response);
        }
    });
}
</script>