<div class="content-wrapper">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			Editing <i class="text-danger"><?= $title ?></i>
			<small></small>
		</h1>
		<?php
		echo $breadcrumb; ?>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class=" col-xs-12" id="msg">
				<?php
				echo userdata('msg'); ?>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<div class="box no-border">
					<div class="box-body">
						<div class="modal-header">
							<h4 class="modal-title text-success">Edit Opportunity</h4>
						</div>
						<div class="modal-body">
							<div class="form-group">
								<?= form_open("admin/opportunity-update/$opportunity_id", ['class' => 'update-opportunity', 'id' => 'opportunity-editing-form']) ?>
								<div class="row">
									<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
										<!-- Title -->
										<div class="form-group has-feedback">
											<label class="control-label" for="title">Title </label>
											<input type="text" name="title" class="form-control" placeholder="Title" value="<?= $title ?>">
										</div><!-- Category -->
										<div class="form-group has-feedback">
											<label class="control-label">Category </label>
											<select class="form-control" name="category" require>
												<?= $categories ?>
											</select>
										</div>
										<div class="form-group has-feedback">
											<label class="control-label" for="price">Price </label>
											<div class="input-group">
												<span class="input-group-addon">
													<?= USD ?>
												</span>
												<input type="number" name="price" class="form-control" placeholder="Enter participation fee" step=".1" value="<?= $price ?>">
											</div>
										</div>
										<div class="form-group has-feedback">
											<label class="control-label" for="old_price">Old Price </label>
											<div class="input-group">
												<span class="input-group-addon">
													<?= USD ?>
												</span>
												<input type="number" name="old_price" class="form-control" placeholder="Enter old participation fee" step=".1" value="<?= $old_price ?>">
											</div>
										</div>
										<div class="form-group has-feedback">
											<label class="control-label" for="end">Duration (Ending) </label>
											<input type="date" name="end" class="form-control" placeholder="Duration of this opportunity" value="<?= $end ?>">
										</div>
										<div class="form-group has-feedback">
											<label class="control-label" for="thumbnail">Thumbnail </label>
											<input type="file" name="thumbnail" class="form-control" placeholder="Cover photo of the opportunity" >
											<div class="s-100w-p top-2x">
												<img src="<?= $thumbnail ?>" alt="Cover Photo" style="width: 100%">
											</div>
										</div>
										<div class="form-group has-feedback">
											<label class="control-label" for="short_desc">Short Description <span class="required">(160 character only) </span></label>
											<textarea cols="12" name="short_desc" class="form-control" ><?= $short_desc ?></textarea>
										</div>
									</div>

									<!-- summernote col -->
									<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
										<div class="form-group has-feedback">
											<label class="control-label" for="full_desc" title="Full Detail">Full Detail </label><br>
											<textarea cols="12" name="full_desc" class="form-control summernote" > <?= $full_desc ?></textarea>
										</div>
									</div>
								</div>
								<button type="submit" class="btn btn-primary btn-block text-bold " data-toggle="tooltip" data-title="This Changes is irreversible Proceed with caution">Update</button>
								<?= form_close() ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--/.row-->
	</section>
</div>
<opportunity>
</opportunity>