<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="">Trading</h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <button class="btn btn-primary btn-sm pull-right" onclick="dialog('<?php echo base_url(); ?>admin/add-trade', '', 'gen-modal', 'sm')"><i class="fa fa-plus"></i> Add Trade</button>    
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table class="table table-bordered table-striped transTable">
                            <thead>
                            <tr>
                                <th></th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Pair</th>
                                <th class="text-center">Buy</th>
                                <th class="text-center">Sell</th>
                                <th class="text-center">Price</th>
                                <th class="text-center">Profit</th>
                                <th class="text-center">Traded By</th>
                                <th class="text-center">Traded Amount</th>
                                <th class="text-center">Date</th>
                                <th class="text-center"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $trades = $this->scansio_db_man->selectGroup('trading_main', '', "ORDER BY id DESC");
                            $count = 0;
                            foreach ($trades as $row) {
                                $traders = $this->Util_model->sum_field("trading_user", "amount", "WHERE tid=$row[id]", true);
                                $count++;
                                if ($row["status"] == 1) {
                                    $status = "<span class='label label-warning label-small'>Open</span>";
                                } else if ($row["status"] == 2) {
                                    $status = "<span class='label label-danger label-small'>Cancelled</span>";
                                } else {
                                    $status = "<span class='label label-success label-small'>Completed</span>";
                                }
                                echo "
                                    <tr>
                                        <td>$count</td>
                                        <td>$status</td>
                                        <td>$row[pairs]</td>
                                        <td>$row[buy]</td>
                                        <td>$row[sell]</td>
                                        <td>$row[price]</td>
                                        <td>$row[profit]</td>
                                        <td>".number_format($traders['counts'])."</td>
                                        <td>".USD.number_format($traders['sum'])."</td>
                                        <td>".get_time_ago($row['date'])."</td>
                                        <td>
                                            <button class='btn btn-warning btn-xs'><i class='fa fa-edit'></i> Edit</button>
                                            <button class='btn btn-primary btn-xs'><i class='fa fa-stop'></i> End</button></button>
                                        </td>
                                    </tr>\n
                                ";
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('.transTable').DataTable({
            "order":[0, "desc"]
        });

    });
</script>
