<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="">Withdrawals</h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table class="table table-bordered table-striped transTable">
                            <thead>
                            <tr>
                                <th></th>
                                <th class="text-center">Time</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Amount</th>
                                <th class="text-center">Type</th>
                                <th class="text-center">From</th>
                                <th class="text-center">To</th>
                                <th class="text-center">Reference</th>
                                <th class="text-center">Description</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $transactions = $this->scansio_db_man->selectGroup('user_wallet', '', "WHERE type LIKE '%withdraw%' LIMIT ".LIMIT);
                            foreach ($transactions as $row) {
                                $amount = $row['amount'];
                                $deposit_withdraw = ($row['debitor'] == 0) ? "<i class='fa fa-plus text-green'></i>" : "<i class='fa fa-minus text-red'></i>";

                                if ($row['status'] == 0) {
                                    $status = "<span class='text-red'>Pending</span>";
                                } else if ($row['status'] == 1) {
                                    $status = "<span class='text-green'>Success</span>";
                                } else if ($row['status'] == 2) {
                                    $status = "<span class='text-gray'>Failed</span>";
                                }
                                
                                if ($row['debitor'] == 0) {
                                    $from = "Community";
                                } else if ($row['debitor'] == userdata(UID)) {
                                    $from = "Me";
                                } else {
                                    $from = $this->Util_model->get_user_info($row['debitor'],'username','profile');
                                }
                                if ($row['creditor'] == 0) {
                                    $to = "Community";
                                } else if ($row['creditor'] == userdata(UID)) {
                                    $to = "Me";
                                } else {
                                    $to = $this->Util_model->get_user_info($row['creditor'],'username','profile');
                                }

                                if ($row['creditor'] == userdata(UID)) {
                                    $desc = $row['creditor_desc'];
                                } else {
                                    $desc = $row['debitor_desc'];
                                }
                                    echo "
                                    <tr class='text-center'>
                                        <td>$deposit_withdraw</td>
                                        <td>$row[date]</td>
                                        <td>$status</td>
                                        <td>".USD.number_format($amount, 2)."</td>
                                        <td>$row[type]</td>
                                        <td>$from</td>
                                        <td>$to</td>
                                        <td>$row[ref]</td>
                                        <td>$desc</td>
                                    </tr>\n
                                ";
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('.transTable').DataTable({
            "order":[0, "desc"]
        });

    });
</script>
