<div class="content-wrapper">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			Editing <i class="text-danger"><?= $title ?></i>
			<small></small>
		</h1>
		<?php
		echo $breadcrumb; ?>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class=" col-xs-12" id="msg">
				<?php
				echo userdata('msg'); ?>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<div class="box no-border">
					<div class="box-body">
						<div class="modal-header">
							<h4 class="modal-title text-success">Edit Book</h4>
						</div>
						<div class="modal-body">
							<div class="form-group">
								<?= form_open_multipart("studio/book-update/$book_id", ['class' => 'update-book', 'id' => 'book-editing-form']) ?>
								<div class="row">
									<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
										<!-- Title -->
										<div class="form-group has-feedback">
											<label class="control-label" for="title">Title </label>
											<input type="text" name="title" class="form-control" placeholder="The Book Title" value="<?= $title ?>">
										</div>
										<!-- Edition -->
										<div class="form-group has-feedback">
											<label class="control-label" for="edition">Edition </label>
											<input type="number" name="edition" class="form-control" placeholder="The Book Edition" value="<?= $edition ?>">
										</div>
										<!-- Chapters -->
										<div class="form-group has-feedback">
											<label class="control-label" for="chapters">Chapters </label>
											<input type="number" name="chapters" class="form-control" placeholder="The number of chapters your book have" value="<?= $chapters ?>">
										</div>
										<!-- Category -->
										<div class="form-group has-feedback">
											<label class="control-label">Category </label>
											<select class="form-control" name="category">
												<?= $categories ?>
											</select>
										</div>
										<!-- Type -->
										<div class="form-group has-feedback">
											<label for="type" class="control-label">Type </label>
											<select class="form-control" name="type">
												<?= $types ?>
											</select>
										</div>
										<!-- Price -->
										<div class="form-group has-feedback">
											<label class="control-label" for="price">Price </label>
											<div class="input-group">
												<span class="input-group-addon">
													USD
												</span>
												<input type="number" name="price" id="price" class="form-control" placeholder="New price of this product" value="<?= $price ?>">
											</div>
										</div>
										<!-- Old Price -->
										<div class="form-group has-feedback">
											<label class="control-label" for="old_price">Old Price</label>
											<div class="input-group">
												<span class="input-group-addon">
													USD
												</span>
												<input type="number" name="old_price" id="old_price" class="form-control" placeholder="Old price of this product" value="<?= $old_price ?>">
											</div>
										</div>
										<!-- Cover page -->
										<div class="form-group has-feedback">
											<label class="control-label custom-file-label" for="cover" title="Cover Page">Change Cover Page</label>
											<input type="file" accept="image/*" name="cover" class="custom-file-input" placeholder="Upload Cover">
										</div>
										<!-- PDF -->
										<div class="form-group has-feedback">
											<label class="control-label custom-file-label" for="file" title="PDF File">Change PDF</label>
											<input type="file" accept="application/pdf" name="file" class="custom-file-input" placeholder="PDF">
										</div>
										<p class="text-center text-bold">Last Update:
											<span class="text-danger"> <?= $last_update ?></span>
										</p>
									</div>

									<!-- summernote col -->
									<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
										<!-- description -->
										<div class="form-group has-feedback">
											<label class="control-label" for="description" title="Description">Description</label>
											<textarea class="summernote" name="description" class="form-control" ><?= $description ?> </textarea>
										</div>
									</div>
								</div>
								<button type="submit" class="btn btn-primary btn-block text-bold " data-toggle="tooltip" data-title="This Changes is irreversible Proceed with caution" data-original-title="" title="" onclick="$('#book-editing-form').submit();">Update</button>
								<?= form_close() ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--/.row-->
	</section>
</div>
<script>
</script>