<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h4 class="modal-title text-success">Updating <small><?= $title ?></small></h4>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php
				echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="modal-header">
                            <a href='<?= base_url() ?>studio/topics/<?= "$course_code" ?>'
                                class='btn btn-info btn-xs no-border pull-right' title='Edit Topics'><i
                                    class='fa fa-plus-square'></i> Manage Topics</a>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <?= form_open_multipart(base_url() . "studio/course-update/$course_code", ['class' => 'edit-course', 'id' => 'course-editing-form']) ?>
                                <div class="row ">
                                    <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12 form-element-container">
                                        <!-- Title -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label" for="title">Title</label>
                                            <input type="text" name="title" class="form-control"
                                                placeholder="The Course Title" value="<?= $title ?>">
                                        </div>
                                        <!-- Level -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label" for="level">Level</label>
                                            <select class="form-control" name="level">
                                                <?= $levels ?>
                                            </select>
                                        </div>
                                        <!-- Category -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label">Category</label>
                                            <select class="form-control" name="category">
                                                <?= $categories ?>
                                            </select>
                                        </div>
                                        <!-- Price -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label" for="price">Price </label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    USD
                                                </span>
                                                <input type="number" name="price" id="price" class="form-control"
                                                    placeholder="New price of this product" value="<?= $price ?>">
                                            </div>
                                        </div>
                                        <!-- Old Price -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label" for="old_price">Old Price </label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    USD
                                                </span>
                                                <input type="number" name="old_price" id="old_price"
                                                    class="form-control" placeholder="Old price of this product"
                                                    value="<?= $old_price ?>">
                                            </div>
                                        </div>
										<!-- Thumbnail -->
                                        <div id="label-for-img" class="form-group has-feedback">
                                            <label class="control-label" for="thumbnail"
                                                title="Thumbnail">Thumbnail</label>
                                            <input type="file" accept="image/*" name="thumbnail"
                                                class="form-control-file" placeholder="Upload Thumbnail">
												<img id="display-thumbnail" class="thumbnail s-100w-p" src="<?= $thumbnail ?>" />
                                        </div>
                                        <!-- Introduction video -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label" for="intro_video" data-toggle="tooltip"
                                                data-title="Introduction video link">Introduction video url</label>
                                            <input name="intro_video" class="form-control url ytp-url-input"
                                                placeholder="Introduction" value="<?= $intro_video ?>">
                                        </div>
                                        <div class="col-xs-12 bottom-2x " id="loading-signal"></div>
                                        <div class="col-xs-12 no-padding bottom-2x " id="ytp-container">
                                            <script>
												$(() => {
													setTimeout((e) => {
														loadYoutubePreview("<?= $intro_video ?>");
													}, 2000);
												});
                                            </script>
                                        </div>
                                    </div>
                                    <!-- summernote col -->
                                    <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                                        <!-- description -->
                                        <div class="form-group has-feedback">
                                            <label class="control-label" for="description"
                                                title="Description">Description</label>
                                            <textarea class="summernote" name="description"
                                                class="form-control"><?= $description ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class=" top-2x">
                                    <button type="submit" class="btn btn-primary btn-block"
                                        onclick="$('#course-editing-form').submit();">Update Course</button>
                                </div>
                                <?= form_close() ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/.row-->
    </section>
</div>