<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            User Courses
            <small>All the user courses of the program</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <ul class="nav nav-tabs">
                            <li class="active"><a class="" href="#approved" data-toggle="tab">Approved</a></li>
                            <li class=""><a class="" href="#pending" data-toggle="tab">Pending Approval</a></li>
                            <li class=""><a class="" href="#suspended" data-toggle="tab">Suspended</a></li>
                            <li class=""><a class="" href="#deleted" data-toggle="tab">Deleted</a></li>
                            <li class=""><a class="" href="#not-submitted" data-toggle="tab">Not Submitted</a></li>
                        </ul>
                    </div>
                    <div class="box-body tab-content">
                        <div id="approved" class="tab-pane active">
                            <div class="table-responsive">
                                <table class="dataTable table table-striped">
                                    <thead>
                                        <tr>
                                            <th>
                                                Course Code
                                            </th>
                                            <th>
                                                Thumbnail
                                            </th>
                                            <th>
                                                Title
                                            </th>
                                            <th>
                                                Level
                                            </th>
                                            <th>
                                                Category
                                            </th>
                                            <th>
                                                Topics
                                            </th>
                                            <th>
                                                Price
                                            </th>
                                            <th>
                                                Time
                                            </th>
                                            <th>
                                                Owner
                                            </th>
                                            <th>
                                                Updated
                                            </th>
                                            <th class='action d-print-none'>
                                                Action
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $where = " WHERE status = " . ACTIVE . " ORDER BY last_update DESC";
                                        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where, $this->db->database);                                
                                        foreach ($courses as $course) {
                                            $course_instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED, $this->db->database)['name'];
                                            $code = $course['course_code'];
                                            $title = $course['course_title'];
                                            $level = $course['course_level'];
                                            $level = ($level && $level == EXPERT ? 'Expert' : ($level == ADVANCE ? 'Advance' : 'Beginner'));
                                            $category = $this->scansio_db_man->select('academy_category', '', 'WHERE id = ' . $course['category'], $this->db->database);
                                            $category = ($category ? $category['title'] : 'Miscellaneous');
                                            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED, $this->db->database);
                                            $topics = ($topics ? count($topics) : 0);
                                            $price = $course['course_price'];
                                            $time = $course['course_time'];
                                            $updated = $course['last_update'];

                                            echo "     
                                                    <tr>
                                                        <td>
                                                            $code
                                                        </td>
                                                        <td>
                                                            <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor'>
                                                        </td>
                                                        <td>
                                                            $title
                                                        </td>
                                                        <td>
                                                            $level
                                                        </td>
                                                        <td>
                                                            $category
                                                        </td>
                                                        <td>
                                                            $topics
                                                        </td>
                                                        <td>
                                                            $price
                                                        </td>
                                                        <td>
                                                            " . getFormattedDuration($time) . "
                                                        </td>
                                                        <td>
                                                            $course_instructor
                                                        </td>
                                                        <td>
                                                            $updated
                                                        </td>
                                                        <td>
                                                            <a href='".base_url()."studio/command/$code/".SUSPEND."' class='btn btn-warning btn-xs no-border' title='Suspend this course'><i class='fa fa-remove'></i> Suspend </a>
                                                            <a href='".base_url()."studio/command/$code/".HOTLIST."' class='btn btn-danger btn-xs no-border' title='Delete this course'><i class='fa fa-remove'></i> Delete </a>
                                                        </td>
                                                    </tr>
                                                ";
                                        }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="pending" class="tab-pane">
                            <div class="table-responsive">
                                <table class="dataTable table table-striped">
                                    <thead>
                                        <tr>
                                            <th>
                                                Course Code
                                            </th>
                                            <th>
                                                Thumbnail
                                            </th>
                                            <th>
                                                Title
                                            </th>
                                            <th>
                                                Level
                                            </th>
                                            <th>
                                                Category
                                            </th>
                                            <th>
                                                Topics
                                            </th>
                                            <th>
                                                Price
                                            </th>
                                            <th>
                                                Time
                                            </th>
                                            <th>
                                                Owner
                                            </th>
                                            <th>
                                                Updated
                                            </th>
                                            <th class='action d-print-none'>
                                                Action
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $where = " WHERE status = " . PENDING_APPROVAL . " ORDER BY last_update DESC";
                                        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where, $this->db->database);                                
                                        foreach ($courses as $course) {
                                            $course_instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED, $this->db->database)['name'];
                                            $code = $course['course_code'];
                                            $title = $course['course_title'];
                                            $level = $course['course_level'];
                                            $level = ($level && $level == EXPERT ? 'Expert' : ($level == ADVANCE ? 'Advance' : 'Beginner'));
                                            $category = $this->scansio_db_man->select('academy_category', '', 'WHERE id = ' . $course['category'], $this->db->database);
                                            $category = ($category ? $category['title'] : 'Miscellaneous');
                                            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED, $this->db->database);
                                            $topics = ($topics ? count($topics) : 0);
                                            $price = $course['course_price'];
                                            $time = $course['course_time'];
                                            $updated = $course['last_update'];

                                            echo "     
                                                    <tr>
                                                        <td>
                                                            $code
                                                        </td>
                                                        <td>
                                                            <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor'>
                                                        </td>
                                                        <td>
                                                            $title
                                                        </td>
                                                        <td>
                                                            $level
                                                        </td>
                                                        <td>
                                                            $category
                                                        </td>
                                                        <td>
                                                            $topics
                                                        </td>
                                                        <td>
                                                            $price
                                                        </td>
                                                        <td>
                                                            " . getFormattedDuration($time) . "
                                                        </td>
                                                        <td>
                                                            $course_instructor
                                                        </td>
                                                        <td>
                                                            $updated
                                                        </td>
                                                        <td>
                                                            <a href='".base_url()."studio/read/".$code."' class='btn btn-info btn-xs no-border' title='View'><i class='fa fa-eye'></i> View </a>
                                                            <a href='".base_url()."studio/command/$code/".APPROVAL_DECLINE."' class='btn btn-warning btn-xs no-border' title='Decline'><i class='fa fa-remove'></i> Decline </a>
                                                            <a href='".base_url()."studio/command/$code/".APPROVE."' class='btn btn-success btn-xs no-border' title='Approve this course'><i class='fa fa-check'></i> Approve </a>
                                                        </td>
                                                    </tr>
                                                ";
                                        }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="suspended" class="tab-pane">
                            <div class="table-responsive">
                                <table class="dataTable table table-striped">
                                    <thead>
                                        <tr>
                                            <th>
                                                Course Code
                                            </th>
                                            <th>
                                                Thumbnail
                                            </th>
                                            <th>
                                                Title
                                            </th>
                                            <th>
                                                Level
                                            </th>
                                            <th>
                                                Category
                                            </th>
                                            <th>
                                                Topics
                                            </th>
                                            <th>
                                                Price
                                            </th>
                                            <th>
                                                Time
                                            </th>
                                            <th>
                                                Owner
                                            </th>
                                            <th>
                                                Updated
                                            </th>
                                            <th class='action d-print-none'>
                                                Action
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $where = " WHERE status = " . SUSPENDED . " ORDER BY last_update DESC";
                                        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where, $this->db->database);                                
                                        foreach ($courses as $course) {
                                            $course_instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED, $this->db->database)['name'];
                                            $code = $course['course_code'];
                                            $title = $course['course_title'];
                                            $level = $course['course_level'];
                                            $level = ($level && $level == EXPERT ? 'Expert' : ($level == ADVANCE ? 'Advance' : 'Beginner'));
                                            $category = $this->scansio_db_man->select('academy_category', '', 'WHERE id = ' . $course['category'], $this->db->database);
                                            $category = ($category ? $category['title'] : 'Miscellaneous');
                                            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED, $this->db->database);
                                            $topics = ($topics ? count($topics) : 0);
                                            $price = $course['course_price'];
                                            $time = $course['course_time'];
                                            $updated = $course['last_update'];

                                            echo "     
                                                    <tr>
                                                        <td>
                                                            $code
                                                        </td>
                                                        <td>
                                                            <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor'>
                                                        </td>
                                                        <td>
                                                            $title
                                                        </td>
                                                        <td>
                                                            $level
                                                        </td>
                                                        <td>
                                                            $category
                                                        </td>
                                                        <td>
                                                            $topics
                                                        </td>
                                                        <td>
                                                            $price
                                                        </td>
                                                        <td>
                                                            " . getFormattedDuration($time) . "
                                                        </td>
                                                        <td>
                                                            $course_instructor
                                                        </td>
                                                        <td>
                                                            $updated
                                                        </td>
                                                        <td>
                                                            <a href='".base_url()."studio/command/$code/".PENDING_PUBLISH."' class='btn btn-success btn-xs no-border' title='Release this course'><i class='fa fa-check'></i> Release </a>
                                                        </td>
                                                    </tr>
                                                ";
                                        }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="not-submitted" class="tab-pane">
                            <div class="table-responsive">
                                <table class="dataTable table table-striped">
                                    <thead>
                                        <tr>
                                            <th>
                                                Course Code
                                            </th>
                                            <th>
                                                Thumbnail
                                            </th>
                                            <th>
                                                Title
                                            </th>
                                            <th>
                                                Level
                                            </th>
                                            <th>
                                                Category
                                            </th>
                                            <th>
                                                Topics
                                            </th>
                                            <th>
                                                Price
                                            </th>
                                            <th>
                                                Time
                                            </th>
                                            <th>
                                                Owner
                                            </th>
                                            <th>
                                                Updated
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $where = " WHERE status = " . PENDING_PUBLISH . " ORDER BY last_update DESC";
                                        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where, $this->db->database);                                
                                        foreach ($courses as $course) {
                                            $course_instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED, $this->db->database)['name'];
                                            $code = $course['course_code'];
                                            $title = $course['course_title'];
                                            $level = $course['course_level'];
                                            $level = ($level && $level == EXPERT ? 'Expert' : ($level == ADVANCE ? 'Advance' : 'Beginner'));
                                            $category = $this->scansio_db_man->select('academy_category', '', 'WHERE id = ' . $course['category'], $this->db->database);
                                            $category = ($category ? $category['title'] : 'Miscellaneous');
                                            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED, $this->db->database);
                                            $topics = ($topics ? count($topics) : 0);
                                            $price = $course['course_price'];
                                            $time = $course['course_time'];
                                            $updated = $course['last_update'];

                                            echo "     
                                                    <tr>
                                                        <td>
                                                            $code
                                                        </td>
                                                        <td>
                                                            <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor'>
                                                        </td>
                                                        <td>
                                                            $title
                                                        </td>
                                                        <td>
                                                            $level
                                                        </td>
                                                        <td>
                                                            $category
                                                        </td>
                                                        <td>
                                                            $topics
                                                        </td>
                                                        <td>
                                                            $price
                                                        </td>
                                                        <td>
                                                            " . getFormattedDuration($time) . "
                                                        </td>
                                                        <td>
                                                            $course_instructor
                                                        </td>
                                                        <td>
                                                            $updated
                                                        </td>
                                                    </tr>
                                                ";
                                        }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="deleted" class="tab-pane">
                            <div class="box-body table-responsive">
                                <table class="dataTable table table-striped">
                                    <thead>
                                        <tr>
                                            <th>
                                                Course Code
                                            </th>
                                            <th>
                                                Thumbnail
                                            </th>
                                            <th>
                                                Title
                                            </th>
                                            <th>
                                                Level
                                            </th>
                                            <th>
                                                Category
                                            </th>
                                            <th>
                                                Topics
                                            </th>
                                            <th>
                                                Price
                                            </th>
                                            <th>
                                                Time
                                            </th>
                                            <th>
                                                Owner
                                            </th>
                                            <th>
                                                Updated
                                            </th>
                                            <th class='action d-print-none'>
                                                Action
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $where = " WHERE status = " . HOTLISTED . " ORDER BY last_update DESC";
                                        $courses = $this->scansio_db_man->selectGroup('academy_course', '', $where, $this->db->database);                                
                                        foreach ($courses as $course) {
                                            $course_instructor = $this->scansio_db_man->select('user_main', '', "WHERE uid = $course[course_instructor] && status != " . HOTLISTED, $this->db->database)['name'];
                                            $code = $course['course_code'];
                                            $title = $course['course_title'];
                                            $level = $course['course_level'];
                                            $level = ($level && $level == EXPERT ? 'Expert' : ($level == ADVANCE ? 'Advance' : 'Beginner'));
                                            $category = $this->scansio_db_man->select('academy_category', '', 'WHERE id = ' . $course['category'], $this->db->database);
                                            $category = ($category ? $category['title'] : 'Miscellaneous');
                                            $topics = $this->scansio_db_man->selectGroup('academy_topic', '', "WHERE course_code = '$course[course_code]' AND status != " . HOTLISTED, $this->db->database);
                                            $topics = ($topics ? count($topics) : 0);
                                            $price = $course['course_price'];
                                            $time = $course['course_time'];
                                            $updated = $course['last_update'];
                                
                                            echo "     
                                                    <tr>
                                                        <td>
                                                            $code
                                                        </td>
                                                        <td>
                                                            <img src='" . base_url($course['course_pic']) . "' style='height: 100px; width: 150px;'  class='pointer-cursor'>
                                                        </td>
                                                        <td>
                                                            $title
                                                        </td>
                                                        <td>
                                                            $level
                                                        </td>
                                                        <td>
                                                            $category
                                                        </td>
                                                        <td>
                                                            $topics
                                                        </td>
                                                        <td>
                                                            $price
                                                        </td>
                                                        <td>
                                                            " . getFormattedDuration($time) . "
                                                        </td>
                                                        <td>
                                                            $course_instructor
                                                        </td>
                                                        <td>
                                                            $updated
                                                        </td>
                                                        <td>
                                                            <a href='".base_url()."studio/delete/$code' class='btn btn-danger btn-xs no-border' data-toggle='tooltip' data-title='This action is irriversible proceed with caution'><i class='fa fa-remove'></i> Delete </a>
                                                            <a href='".base_url()."studio/command/$code/".PENDING_PUBLISH."' class='btn btn-success btn-xs no-border' title='Release this course'><i class='fa fa-check'></i> Recover </a>
                                                        </td>
                                                    </tr>
                                                ";
                                        }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('.dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });
    });
</script>
