<div class="content-wrapper">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			Create Book
			<small></small>
		</h1>
		<?php
		echo $breadcrumb; ?>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12" id="msg">
				<?php
				echo userdata('msg'); ?>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<div class="box no-border">
					<div class="box-body">
						<div class="modal-header">
							<h4 class="modal-title text-success">Create Book</h4>
						</div>
						<div class="modal-body">
							<div class="form-group">
								<?= form_open_multipart('studio/create_book', ['class' => 'create-book', 'id' => 'book-creating-form']) ?>
								<div class="row">
									<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
										<!-- Title -->
										<div class="form-group has-feedback">
											<label class="control-label" for="title">Title <span class="required"> *</span></label>
											<input type="text" name="title" class="form-control" placeholder="The Book Title" required>
										</div>
										<!-- Edition -->
										<div class="form-group has-feedback">
											<label class="control-label" for="edition">Edition <span class="required"> *</span></label>
											<input type="number" name="edition" class="form-control" placeholder="The Book Edition" required>
										</div>
										<!-- Chapters -->
										<div class="form-group has-feedback">
											<label class="control-label" for="chapters">Chapters <span class="required"> *</span></label>
											<input type="number" name="chapters" class="form-control" placeholder="The number of chapters your book have" required>
										</div>
										<!-- Category -->
										<div class="form-group has-feedback">
											<label class="control-label">Category <span class="required"> *</span></label>
											<select class="form-control" name="category"> <?= $categories ?>
											</select>
										</div>
										<!-- Type -->
										<div class="form-group has-feedback">
											<label for="type" class="control-label">Type <span class="required"> *</span></label>
											<select class="form-control" name="type"> <?= $types ?>
											</select>
										</div>
										<!-- Price -->
										<div class="form-group has-feedback">
											<label class="control-label" for="price">Price <span class="required"> *</span></label>
											<div class="input-group">
												<span class="input-group-addon">
													USD
												</span>
												<input type="number" name="price" id="price" class="form-control" placeholder="New price of this product" required>
											</div>
										</div>
										<!-- Old Price -->
										<div class="form-group has-feedback">
											<label class="control-label" for="old_price">Old Price <span class="required"> *</span></label>
											<div class="input-group">
												<span class="input-group-addon">
													USD
												</span>
												<input type="number" name="old_price" id="price" class="form-control" placeholder="Old price of this product" required>
											</div>
										</div>
										<!-- Cover page -->
										<div class="form-group has-feedback">
											<label class="control-label custom-file-label" for="cover" title="Cover Page">Cover Page <span class="required"> *</span></label>
											<input type="file" accept="image/*" name="cover" class="custom-file-input" placeholder="Upload Cover" required>
										</div>
										<!-- PDF -->
										<div class="form-group has-feedback">
											<label class="control-label custom-file-label" for="file" title="PDF File"> PDF File <span class="required"> *</span></label>
											<input type="file" accept="application/pdf" name="file" class="custom-file-input" placeholder="PDF " required>
										</div>
									</div>

									<!-- summernote col -->
									<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
										<!-- description -->
										<div class="form-group has-feedback">
											<label class="control-label" for="description" title="Description">Description <span class="required"> *</span></label>
											<textarea class="summernote" name="description" class="form-control" > </textarea>
										</div>
									</div>
								</div>
								<button type="submit" class="btn btn-primary btn-block btn-flat pull-right">Create</button>
								<?= form_close() ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--/.row-->
	</section>
</div>
<script>
</script>