<!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header no-padding">
                        <div class="nav-tabs-custom tab-warning">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#buy" data-toggle="tab">Purchase</a></li>
                                <li><a href="#history" data-toggle="tab">History</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-pad-3x bottom-pad-3x bottom-3x" style="padding-right:0px; padding-left:0px;">
                            <?php 
                            $country = $this->Util_model->get_user_info(userdata(UID), "country", "profile");
                            if ($this->Util_model->row_count("networks", "WHERE country=$country") > 0) : 
                            ?>
                            <div class="tab-content">
                                <div class="tab-pane active" id="buy">
                                    <?php echo form_open(base_url()."airtime/process_airtime"); ?>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label>Network <span class="required">*</span></label>
                                            <div class="form-group">
                                                <select name="network" class="form-control" id="network">
                                                    <option value="">-Select network-</option>
                                                    <?php echo $this->Util_model->list_from_table("networks", "id", "network"); ?>
                                                </select>
                                            </div>
        
                                        </div>
                                    </div>
                                    <div id="more-details" class="no-display">
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Recipient <span class="required">*</span></label>
                                                <div class="form-group">
                                                    <span class="no-display" id="net-id"></span>
                                                    <input class="form-control" id="recipient" name="recipient" type="tel" placeholder="eg. 08120203636" required="required" value="<?php echo set_value('recipient'); ?>">
                                                </div>
            
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                            <label>Amount <span class="required">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-addon"><?php echo $this->Util_model->get_country_info("currency_symbol"); ?></span>
                                                <input class="form-control text-bold text-center" name="amount" required="required" id="amount" placeholder="Min. 100 - 5,000 Max.">
                                                <span class="input-group-addon text-bold">You Pay $<span id="amt-pay">0</span></span>
                                            </div>
                                            <small><span id="discount">0</span>% discount</small>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Password <span class="required">*</span></label>
                                                <div class="form-group">
                                                    <span class="no-display"></span>
                                                    <input class="form-control" id="password" name="password" type="password" placeholder="Verify operation" required="required" autocomplete="off">
                                                </div>
            
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>
                                                    <input name="ported" type="checkbox" value="no"> Bypass number verification for ported numbers
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <button class="btn btn-success pull-right" type="submit" name="buyAirtime" disabled>Unavailable</button>
                                        </div>
                                        <?php echo form_close(); ?>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-2x">
                                            <div class="alert alert-info">
                                                <p>
                                                    <b><i class="fa fa-info-circle"></i> Important Notice</b> <br>
                                                    Please make sure to double check the phone number before submitting because once it is been processed, it can't be undone.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="history">
                                    <div class="col-xs-12 no-padding table-responsive">
                                        <table id="dataTable" class="table table-bordered table-striped">
                                            <thead>
                                            <tr>
                                                <th class="text-center">Network</th>
                                                <th class="text-center">Recipient</th>
                                                <th class="text-center">Amount (Paid)</th>
                                                <th class="text-center">Date</th>
                                                <th class="text-center">Status</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "airtime_purchase", "WHERE uid=".userdata(UID)." ORDER BY id DESC");
                                            if ($s->num_rows() > 0) {
                                                foreach ($s->result_array() as $row) {
                                                    $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network]");
                                                    if ($row['status'] == 0) {
                                                        $status = "<span class='label bg-aqua'>Processing <i class='fa fa-spinner fa-spin'></i></span>";
                                                    } else if ($row['status'] == 1) {
                                                        $status = "<span class='label bg-green'>Delivered</span>";
                                                    } else {
                                                        $status = "<span class='label bg-red'>Cancelled</span>";
                                                    }
            
                                                    echo "
                                            <tr class='text-center'>
                                                <td>$network</td>
                                                <td>0$row[recipient]</td>
                                                <td>$$row[amount] ($$row[amount_paid])</td>
                                                <td>$row[status_date]</td>
                                                <td>$status</td>
                                            </tr>\n
                                        ";
                                                }
                                            }
                                            ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                </div>
                            </div><!-- /.tab-content --> 
                            <?php else : ?>
                                <h3>Opps! This utility is not available in you region. You will be notified via email once it is available</h3>
                                <a href="<?php echo base_url('home'); ?>" class="btn btn-warning btn-flat">Go back home Now</a>
                            <?php endif; ?>
                        </div><!-- /.col -->
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });

        $('#network').change(function() {
            if ($(this).val().trim().length > 0) {
                $("#more-details").show();
                $.post("<?php echo base_url(); ?>airtime/get_discount/"+$(this).val(),"",function (data) {
                    $("#discount").text(data);
                });
            }
        });
        
        $('#amount').keyup(function() {
            if ($(this).val().trim().length > 0) {
                var discount = $('#discount').text();
                var charge = <?php echo $this->Util_model->get_option("utility_charge"); ?>;
                var discount_per = (discount == 0) ? 0 : ($(this).val() * discount) / 100;
                var charge_per = (charge == 0) ? 0 : ($(this).val() * charge) / 100;
                var amt = $(this).val() - discount_per;
                var amt = amt + charge_per;
                var curr_rate = <?php echo $this->Util_model->get_info("payment_rates", "rate", "WHERE base='USDT' AND currency='".$this->Util_model->get_country_info('currency')."' AND status=1"); ?>;
                var equ = (amt / curr_rate);
                $("#amt-pay").text(equ.toString().match(/^-?\d+(?:\.\d{0,2})?/)[0]);
            } else {
                $("#amt-pay").text(0);
            }
        });
    });
</script>

