<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Airtime To Cash
            <small>convert airtime to cash</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <?php
                    if (isset($_GET['reference'])) :
                    $info = $this->Db_model->select("*", "airtime_to_cash", "WHERE reference='$_GET[reference]'");
                    ?>
                    <div class="box-header">
                        <h3 class="text-center text-bold">ORDER DETAILS</h3>
                    </div>
                    <div class="box-body">
                        <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                            <table class="table table-bordered table-striped">
                                <tbody>
                                    <tr>
                                        <td class="text-bold">Status</td>
                                        <?php
                                        if ($info['status'] == 0) {
                                            echo "<td class='text-yellow'>Awaiting payment</td>";
                                        } else if ($info['status'] == 1) {
                                            echo "<td class='text-yellow'>Awaiting confirmation</td>";
                                        } else if ($info['status'] == 2) {
                                            echo "<td class='text-green'>Confirmed</td>";
                                        } else {
                                            echo "<td class='text-red'>Cancelled</td>";
                                        }
                                        ?>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Reference</td>
                                        <td><?php echo $info['reference']; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Depositor</td>
                                        <td><?php echo $this->Util_model->get_user_info($info['uid'], 'username', 'profile'); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Amount</td>
                                        <td><?php echo USD.number_format($info['amount'], 2); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Received Amount</td>
                                        <td><?php echo USD.number_format($info['amount_received'], 2); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Network</td>
                                        <td><?php echo $this->Util_model->get_info("networks", "network", "WHERE id=$info[network]"); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Phone Number</td>
                                        <td><?php echo $info['phone_pin'] ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-bold">Funded To</td>
                                        <td><?php echo $info['method']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                            <h4 class="text-muted text-center bottom-3x">
                                To complete this order, following instructions
                            </h4>
                        </div>
                        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                            <div class="box box-border">
                                <div class="box-body">
                                    <?php if ($info['network'] == 1) : ?>
                                        <h4 class="text-aqua text-center bottom-3x">
                                            Kindly transfer the sum of <?php echo USD.number_format($info['amount']); ?> to <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=1"); ?> and follow the process below to complete transaction
                                        </h4>
                                        <hr>
                                        <p class="bottom-2x">How to transfer on MTN network</p>
                                        Dial <b>*600*<?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=1"); ?>*<?php echo $info['amount']; ?>*pin#</b><br>
                                        If you don't have a PIN *600*default pin*new pin*new pin# <span class="text-green text-italic">Default pin: 0000</span>
                                    <?php elseif ($info['network'] == 2) : ?>
                                        <h4 class="text-aqua text-center bottom-3x">
                                            Kindly transfer the sum of <?php echo USD.number_format($info['amount']); ?> to <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=2"); ?> and follow the process below to complete transaction
                                        </h4>
                                        <hr>
                                        <p class="bottom-2x">How to transfer on AIRTEL network</p>
                                        Dial <b>*432*1#</b> To <b><?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=2"); ?></b><br>
                                        If you don't have a PIN *432*1# <span class="text-green text-italic">Default pin: 1234</span>
                                    <?php elseif ($info['network'] == 3) : ?>
                                        <h4 class="text-aqua text-center bottom-3x">
                                            Kindly transfer the sum of <?php echo USD.number_format($info['amount']); ?> to <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=3"); ?> and follow the process below to complete transaction
                                        </h4>
                                        <hr>
                                        <p class="bottom-2x">How to transfer on 9MOBILE network</p>
                                        Dial <b>*223*pin*<?php echo $info['amount']; ?>*<?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=3"); ?>#</b><br>
                                        If you don't have a PIN *247*default pin*new pin# <span class="text-green text-italic">Default pin: 0000</span>
                                    <?php elseif ($info['network'] == 4) : ?>
                                        <h4 class="text-aqua text-center bottom-3x">
                                            Kindly transfer the sum of <?php echo USD.number_format($info['amount']); ?> to <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=4"); ?> and follow the process below to complete transaction
                                        </h4>
                                        <hr>
                                        <p class="bottom-2x">How to transfer on GLO network</p>
                                        Dial <b>*132*<?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=4"); ?>*amount*pin#</b><br>
                                        If you don't have a PIN *132*default pin*new pin*new pin# <span class="text-green text-italic">Default pin: 0000</span>
                                    <?php else : ?>
                                        <p class="bottom-2x">Invalid mobile network</p>
                                        Please check the network you selected while filling the form.
                                    <?php endif; ?>
                                    <button class="btn btn-primary btn-block top-2x" type="button">AIRTIME SENT</button>
                                    <p class="text-bold">
                                        NOTE: Ensure you have paid <?php echo USD.number_format($info['amount']); ?>
                                        into the number above before clicking on airtime sent. Also you must send exactly
                                        <?php echo USD.number_format($info['amount']); ?> airtime within 30 minutes or
                                        this transaction will be cancelled.
                                    </p>
                                    <p>
                                        NOTE: Confirmation is instant and payment is automated usually within 5-30 mins.<br><br>
                                        Also note that to send to us, you need to send from the number provided above. Thanks.
                                    </p>
                                </div>
                                <div class="box-footer">
                                    <a href="<?php echo base_url(); ?>airtime-to-cash/cancel-transaction/<?php echo $info['reference']; ?>" class="btn btn-danger">Cancel Transaction</a>
                                    <a href="<?php echo base_url(); ?>airtime-to-cash" class="btn btn-default pull-right">Close</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else : ?>
                    <div class="box-body">
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-heading">
                                <h3>Important Notice</h3>
                            </li>
                            <li class="list-group-item">
                                <p>1. Fill the form below correctly for airtime to cash.</p>
                            </li>
                            <li class="list-group-item">
                                <p>2. The minimum amount is N500 and maximum for GLO is N5,000 and other networks is N100,000.
                            </li>
                            <li class="list-group-item">
                                <p>3. If it's the airtime pin you have to, <b>load/recharge it in your sim first and then transfer to us.</b>
                            </li>
                            <li class="list-group-item">
                                <p>4. You must not send any amount different from the amount you filled.
                            </li>
                            <li class="list-group-item">
                                <p>5. We accept airtime transfer only. Any VTU sent to us will not be credited to your wallet.
                            </li>
                            <li class="list-group-item">
                                <p>6. Below are the phone numbers which the transfer should be made into and the codes for transfer.
                            </li>
                        </ul>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-pad-3x bottom-pad-3x bottom-3x td_underline">
                            <?php echo form_open(base_url()."airtime_to_cash"); ?>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                <div class="form-group">
                                    <label>Network <span class="required">*</span></label>
                                    <select class="form-control" name="network" id="network">
                                        <option value="">Select network</option>
                                        <?php echo $this->Util_model->list_from_table("networks", "id", "network"); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                <div class="form-group">
                                    <span class="no-display" id="fee">0</span>
                                    <label>Amount <span class="required">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-addon">$</span>
                                        <input class="form-control text-bold text-center" name="amount" required="required" id="amt-fiat" placeholder="Select network first" disabled type="number" step="0.01" value="<?php echo set_value('amount'); ?>">
                                        <span class="input-group-addon text-bold">You receive $<span id="amt-coin">0</span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                <div class="form-group">
                                    <label>Phone number <span class="required">*</span></label>
                                    <input class="form-control" type="number" min="0" minlength="11" maxlength="11" name="from" id="trans-from" placeholder="Enter the number sending making the transfer" >
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                <div class="form-group">
                                    <label>Fund to wallet <span class="required">*</span></label>
                                    <select class="form-control" name="method" id="method" onchange="if ($(this).val() == 2) { $('#pay-method').show(); } else { $('#pay-method').hide(); }">
                                        <option value="1">Yes</option>
                                        <option value="2">No</option>
                                    </select>
                                    <small>select YES if you want to use it to fund your <?php echo SITE_TITLE; ?> wallet</small>
                                </div>
                            </div>
                            <div class="no-display" id="pay-method">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                    <div class="form-group">
                                        <label>Bank <span class="required">*</span></label>
                                        <select class="form-control" name="bank">
                                            <option value="">Select bank</option>
                                            <?php echo $this->Util_model->list_from_table("banks", "name", "name", "WHERE status=1"); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                    <div class="form-group">
                                        <label>Account number <span class="required">*</span></label>
                                        <input class="form-control" type="number" min="0" minlength="9" maxlength="10" name="acct_num" placeholder="Enter account number" >
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                    <div class="form-group">
                                        <label>Account name <span class="required">*</span></label>
                                        <input class="form-control" type="text" name="acct_name" placeholder="Enter account name" >
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 bottom-2x">
                                <button class="btn btn-success pull-right" type="submit" name="buyAirtime">Proceed</button>
                            </div>
                            <?php echo form_close(); ?>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-2x">
                                    <div class="alert alert-info">
                                        <p>
                                            <b><i class="fa fa-info-circle"></i> Important Notice</b> <br>
                                            Please make sure to double check the phone number before sending any airtime. We won't be held responsible for any mistake you make while sending airtime.
                                        </p>
                                    </div>
                                </div>

                                <p class="text-center bottom-2x">Transfer to any of the phone numbers below depending on your network.</p>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="box box-info text-center">
                                        <div class="box-heading">
                                            <h4 class="box-title">MTN</h4>
                                        </div>
                                        <div class="box-body">
                                            <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=1"); ?>
                                            <hr>
                                            <h5 class="text-bold">Transfer code</h5>
                                            *600*<?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=1"); ?>*amount*pin#
                                            <hr>
                                            <h5 class="text-bold">Change PIN</h5>
                                            *600*default pin*new pin*new pin#<br>
                                            <span class="text-green text-italic">Default pin: 0000</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="box box-info text-center">
                                        <div class="box-heading">
                                            <h4 class="box-title">9MOBILE</h4>
                                        </div>
                                        <div class="box-body">
                                            <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=3"); ?>
                                            <hr>
                                            <h5 class="text-bold">Transfer code</h5>
                                            *223*pin*amount*<?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=3"); ?>#
                                            <hr>
                                            <h5 class="text-bold">Change PIN</h5>
                                            *247*default pin*new pin#<br>
                                            <span class="text-green text-italic">Default pin: 0000</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="box box-info text-center">
                                        <div class="box-heading">
                                            <h4 class="box-title">GLO</h4>
                                        </div>
                                        <div class="box-body">
                                            <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=4"); ?>
                                            <hr>
                                            <h5 class="text-bold">Transfer code</h5>
                                            *132*<?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=4"); ?>*amount*pin#
                                            <hr>
                                            <h5 class="text-bold">Change PIN</h5>
                                            *132*default pin*new pin*new pin#<br>
                                            <span class="text-green text-italic">Default pin: 0000</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="box box-info text-center">
                                        <div class="box-heading">
                                            <h4 class="box-title">AIRTEL</h4>
                                        </div>
                                        <div class="box-body">
                                            <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=2"); ?>
                                            <hr>
                                            <h5 class="text-bold">Transfer code</h5>
                                            *432*1# To <?php echo $this->Util_model->get_info("airtime_to_cash_numbers", "phone", "WHERE network_id=2"); ?>
                                            <hr>
                                            <h5 class="text-bold">Change PIN</h5>
                                            *432*1#<br>
                                            <span class="text-green text-italic">Default pin: 1234</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 table-responsive">
                            <table id="dataTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center">Network</th>
                                    <th class="text-center">Amount (Receive)</th>
                                    <th class="text-center">Funding</th>
                                    <th class="text-center">Phone Number</th>
                                    <th class="text-center">Date</th>
                                    <th class="text-center">Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $s = $this->Db_model->selectGroup("*", "airtime_to_cash", "WHERE uid=".userdata(UID)." ORDER BY id DESC");
                                if ($s->num_rows() > 0) {
                                    foreach ($s->result_array() as $row) {
                                        $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network]");
                                        if ($row['status'] == 0) {
                                            $status = "
                                            <a href='".base_url()."airtime_to_cash?reference=$row[reference]' class='btn btn-primary btn-xs'>View</a>
                                            <a href='".base_url()."airtime_to_cash/cancel_transaction/$row[reference]' class='btn btn-warning btn-xs'>Cancel</a>
                                            ";
                                        } else if ($row['status'] == 1) {
                                            $status = "<span class='label bg-green'>Awaiting confirmation</span>";
                                        } else if ($row['status'] == 2) {
                                            $status = "<span class='label bg-red'>Completed</span>";
                                        } else {
                                            $status = "<span class='label bg-red'>Cancelled</span>";
                                        }

                                        echo "
                                <tr class='text-center'>
                                    <td>$network</td>
                                    <td>$$row[amount] ($$row[amount_received])</td>
                                    <td>$row[method]</td>
                                    <td>$row[phone_pin]</td>
                                    <td>$row[date]</td>
                                    <td>$status</td>
                                </tr>\n
                            ";
                                    }
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });

        var net1 = "<?php echo $this->Util_model->get_info('airtime_to_cash_fee', 'charge', 'WHERE net_id=1'); ?>";
        var net2 = "<?php echo $this->Util_model->get_info('airtime_to_cash_fee', 'charge', 'WHERE net_id=2'); ?>";
        var net3 = "<?php echo $this->Util_model->get_info('airtime_to_cash_fee', 'charge', 'WHERE net_id=3'); ?>";
        var net4 = "<?php echo $this->Util_model->get_info('airtime_to_cash_fee', 'charge', 'WHERE net_id=4'); ?>";

        $("#amt-fiat").keyup(function() {
            if ($(this).val().trim() != "" || $(this).val().trim() > 0) {
                var amt = $(this).val().trim();
                var pay = amt - (amt * ($("#fee").text() / 100));
                $('#amt-coin').text(pay.toFixed(2));
            } else {
                $('#amt-coin').text('0');
            }
        });

        $("#network").change(function() {
            switch ($(this).val()) {
                case "1":
                    $("#fee").text(net1);
                    $("#amt-fiat").attr("placeholder", "Min. N100 - N100,000 Max. daily");
                    $("#amt-fiat").removeAttr('disabled');
                    break;
                case "2":
                    $("#fee").text(net2);
                    $("#amt-fiat").attr("placeholder", "Min. N100 - N100,000 Max. daily");
                    $("#amt-fiat").removeAttr('disabled');
                    break;
                case "3":
                    $("#fee").text(net3);
                    $("#amt-fiat").attr("placeholder", "Min. N100 - N100,000 Max. daily");
                    $("#amt-fiat").removeAttr('disabled');
                    break;
                case "4":
                    $("#fee").text(net4);
                    $("#amt-fiat").attr("placeholder", "Min. N100 - N5,000 Max. daily");
                    $("#amt-fiat").removeAttr('disabled');
                    break;
                default:
                    $("#fee").text(0);
                    $("#amt-fiat").attr("Select network first");
                    $("#amt-fiat").attr('disabled', 'disabled');
                    break;
            }
            $("#amt-fiat").keyup();
        });


    });
</script>

