<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Buy <?php echo $coin_main['name']; ?>
            <small>Purchase <?php echo $coin_main['symbol']; ?> at a cheaper price</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <!-- Info boxes -->
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box box-info box-border box-default">
                    <div class="box-header with-border">
                        <h3 class="text-muted text-bold" style="text-align:right; font-size:16px"><?php echo $this->Main_model->get_balance(userdata(UID), true); ?> Available</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <center class="top-2x bottom-2x">
                            <div class="col-xs-12">
                                <img src="<?php echo base_url().$coin_main['pic_url']; ?>" width="150" height="150">
                            </div>
                            
                            <div class="col-xs-12">
                                <div class="well top-5x">
                                    <div class="form-group">
                                        <div class="input-group">
                                            <span class="input-group-addon">Network</span>
                                            <select class="form-control" id="network" name="network" onchange="if ($(this).val() == '') { _('buy-coin').attr('disabled','disabled'); _('amount').attr('disabled','disabled'); _('usd-amount').attr('disabled','disabled'); _('fee').text('0.00'); } else { processAjax('<?php echo base_url(); ?>ajax/get_coin_fee', 'coin_id=<?php echo $coin_main['id']; ?>&network='+$(this).val(), _('fee')); _('buy-coin').removeAttr('disabled'); _('amount').removeAttr('disabled'); _('usd-amount').removeAttr('disabled'); }">
                                                <option value="">Select network</option>
                                                <?php echo $this->Util_model->list_from_table("coin_network", "network", "network", "WHERE coin_id=$coin_main[id]"); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="input-group">
                                            <span class="input-group-addon">Address</span>
                                            <input class="form-control" id="address" type="text" placeholder="Enter <?php echo $coin_main['symbol']; ?> address" >
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="input-group" style="margin-bottom:5px">
                                            <span class="input-group-addon text-muted">Amount (<?php echo $coin_main['symbol']; ?>)</span>
                                            <input id="amount" type="number" autocomplete="off" disabled required class="form-control text-center text-muted" min="1" placeholder="Min. <?php echo $coin_main['min']; ?>" onkeyup="convert($(this).val())" onblur="convert($(this).val())">
                                        </div>
                                    </div>
                                    <p class="text-center">
                                        <i class="fa fa-exchange" style="-webkit-transform: rotate(-90deg); -moz-transform: rotate(-90deg); -ms-transform: rotate(-90deg); -o-transform: rotate(-90deg); filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);"></i>
                                    </p>
                                    <div class="form-group">
                                        <div class="input-group">
                                            <span class="input-group-addon text-muted">Amount (USD)</span>
                                            <input id="usd-amount" type="number" autocomplete="off" disabled required class="form-control text-center text-muted" min="1" placeholder="" onkeyup="convert($(this).val(), 1)" onblur="convert($(this).val(), 1)">
                                        </div>
                                    </div>
                                    <h2 class="text-center"><span id="total">0.00</span> <?php echo $coin_main['symbol']; ?></h2>
                                    <p class="text-center">Network Fee <span id="fee">0.00</span> <?php echo $coin_main['symbol']; ?></p>
                                    <button id="buy-coin" class="btn btn-primary btn-block top-2x" disabled type="button">Buy <?php echo $coin_main['symbol']; ?></button>
                                </div>
                            </div>                            
                        </center>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php $this->load->view("layouts/buy_sell_coin"); ?>
            </div>
        </div>
    </section>
</div>

<script>
    $(document).ready(function() {
        var rate = <?php echo $this->Util_model->get_option("dollar_rate"); ?>;
        var coin_price = <?php echo $coin_main['price']; ?>;
        var min_amt = <?php echo $coin_main['min']; ?>;
        var min = (min_amt * coin_price) * rate;
        _("usd-amount").attr("placeholder", "Min. "+numberWithCommas(min.toFixed(2)));

        $("#buy-coin").click (function () {
            if (___("address") == "" || ___("amount") == "" || ___("usd-amount") == "") {
                msg("<i class='fa fa-times-circle'></i> Required field(s) empty", "alert-danger", 1, _("msg"));
            } else if (___("amount") < min_amt) {
                msg("<i class='fa fa-times-circle'></i> <?php echo $coin_main['symbol']; ?> amount less than "+min_amt, "alert-danger", 1, _("msg"));
            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, proceed!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        buy();
                    }
                });
            }
        });
    });
    
    function convert (amt, type) {
        var rate = <?php echo $this->Util_model->get_option("dollar_rate"); ?>;
        var coin_price = <?php echo $coin_main['price']; ?>;
        if (amt > 0) {
            if (type) {
                var crypto = (amt / rate) / coin_price;
                var actual = crypto;
                _("amount").val(crypto.toFixed(4));
            } else {
                var usd = (amt * coin_price) * rate;
                var actual = amt;
                _("usd-amount").val(usd.toFixed(2));
            }
            $.post("<?php echo base_url(); ?>ajax/get_coin_fee", {"coin_id":<?php echo $coin_main['id']; ?>, "network":$("#network").val()}, function (fee) {
                actual = actual - fee;
                actual = actual.toString().match(/^-?\d+(?:\.\d{0,4})?/)[0];
                $("#total").text(actual);
            });
        } else if (amt <= 0) {
            if (type) {
                _("amount").val(0);
            } else {
                _("usd-amount").val(0);
            }
            $("#total").text("0.00");
            $("#fee").text("0.00");
        }


        /* if (actual < 25000) {
            $("#crypto-select").addClass("no-display");
        } else if (actual > 100000000) {
            $("#crypto-select").addClass("no-display");
        } else {
            $("#crypto-select").show();
        } */
    }

    function buy() {
        var base_url = "<?php echo base_url(); ?>";
        _("buy-coin").attr("disabled", "disabled");
        _("buy-coin").html("<i class='fa fa-spinner fa-spin'></i> Processing...");
        $.post(base_url+"coin/process-buy/<?php echo $coin_main['id']; ?>", {"network":___('network'), "address":___("address"), "amount":___("amount"), "ngn_amount":___("usd-amount"), "recieve_amount":____("total"), "fee":____("fee")}, function(data) {
            if (data == 1) {
                msg("<i class='fa fa-check-circle'></i> Thank you! We are processing your purchase now.", "alert-success", 1, _("msg"));
                setTimeout(function() {
                    window.location = base_url+"transactions/coin-buy";
                }, 2000);
            } else if (data == 0) {
                msg("<i class='fa fa-times-circle'></i> Sorry, an error occured. Please try again", "alert-danger", 1, _("msg"));
                _("buy-coin").removeAttr("disabled");
                _("buy-coin").html("<i class='fa fa-send'></i> Buy <?php echo $coin_main['symbol']; ?>");
            } else if (data == 2) {
                msg("<i class='fa fa-times-circle'></i> Insufficient balance. <a href='"+base_url+"deposit'>Top up balance</a> to proceed.", "alert-danger", 1, _("msg"));
                _("buy-coin").removeAttr("disabled");
                _("buy-coin").html("<i class='fa fa-send'></i> Buy <?php echo $coin_main['symbol']; ?>");
            }
        })
    }
</script>