<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Checkout
            <small>Make payment to complete your upgrade</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <!-- Info boxes -->
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 pull-right">
                                <div class="well">
                                    <h3 class="td_underline">Summary</h3>
                                    <p>Sub amount <span class="pull-right text-bold"><?php echo USD.number_format($amount,2); ?></span></p>
                                    <p>Discount amount <span class="pull-right text-bold"><?php echo USD.number_format($discount,2); ?></span></p>
                                    <h4>Total amount <span class="pull-right text-bold text-right"><?php echo USD.number_format(($amount-$discount),2); ?><br><small class="text-muted">For Nigerians <b>$<?php echo number_format(($amount-$discount)*500); ?></b></small></span></h4>
                                    <?php if ($promo_code != NULL) : ?>
                                    <hr>
                                    <h4 class="text-orange text-center">The promo code used <b><?php echo strtoupper($promo_code); ?></b></h4>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <!-- Custom Tabs -->
                                <div class="nav-tabs-custom">
                                    <ul class="nav nav-tabs">
                                        <li><a href="#usdt" data-toggle="tab">USDT</a></li>
                                        <li class="active"><a href="#transfer" data-toggle="tab">Bank Transfer</a></li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane" id="usdt">
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <center class="top-2x bottom-2x">
                                                    <img src="<?php echo base_url(); ?>assets/img/usdt_qr.jpg" width="150" height="150" style="border:1px solid #000000; box-shadow:0px 0px 5px #000000">
                                                    <h5 class="text-center text-bold top-2x" id="address">TFnjPE27wsat2BBqj64z7ZDSWdnQ4wnE88</h5>
                                                    <small class="text-center">TRC20 Network</small><br>
                                                    <button class="btn btn-default btn-sm top-1x" type="button" onclick="copyToClipboard($(this), $('#address'))"><i class="fa fa-copy"></i> Copy Address</button>
                                                </center>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 no-padding">
                                                <div class="col-xs-12 box-border">
                                                    <h4 class="td_underline">Book Payment</h4>
                                                    <?php echo form_open(base_url()."activate/book-payment/$uid"); ?>
                                                        <input type="hidden" name="code" value="<?php echo $promo_code; ?>">
                                                        <input type="hidden" name="amount" value="<?php echo ($amount-$discount); ?>">
                                                        <input type="hidden" name="channel" value="USDT">
                                                        <input type="hidden" name="package" value="<?php echo $package; ?>">
                                                        <div class="form-group">
                                                            <label>Amount Paid</label>
                                                            <input class="form-control" type="text" name="amount_paid" placeholder="Enter amount you sent">
                                                        </div>
                                                        <div class="form-group">
                                                            <label>Transaction ID</label>
                                                            <input class="form-control" type="text" name="trans_id" placeholder="Enter the transaction ID">
                                                        </div>
                                                        <div class="form-group">
                                                            <button class="btn btn-primary btn-flat btn-block" type="submit">Book Payment</button>
                                                        </div>
                                                    <?php echo form_close(); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane active" id="transfer">
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <center class="top-2x bottom-2x">
                                                    <img src="<?php echo base_url(); ?>assets/img/Access.jpg" width="150" height="100%">
                                                    <p>Access Bank</p>
                                                    <h4 class="text-center text-bold top-2x" id="acct_number">0016055384</h5>
                                                    <small class="text-center">Peaceman Charly Brown LTD</small><br>
                                                    <button class="btn btn-default btn-sm top-1x" type="button" onclick="copyToClipboard($(this), $('#acct_number'))"><i class="fa fa-copy"></i> Copy Account Number</button>
                                                    <div class="alert alert-info top-2x">Bank transaction is available for Nigerians only</div>
                                                </center>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 no-padding">
                                                <div class="col-xs-12 box-border">
                                                    <h4 class="td_underline">Book Payment</h4>
                                                    <?php echo form_open(base_url()."activate/book-payment/$uid"); ?>
                                                        <input type="hidden" name="code" value="<?php echo $promo_code; ?>">
                                                        <input type="hidden" name="amount" value="<?php echo ($amount-$discount); ?>">
                                                        <input type="hidden" name="channel" value="Transfer">
                                                        <input type="hidden" name="package" value="<?php echo $package; ?>">
                                                        <div class="form-group">
                                                            <label>Amount Paid</label>
                                                            <input class="form-control" type="text" name="amount_paid" placeholder="Enter amount you sent">
                                                        </div>
                                                        <div class="form-group">
                                                            <label>Sender's Name</label>
                                                            <input class="form-control" type="text" name="sender" placeholder="Enter the sender's name">
                                                        </div>
                                                        <div class="form-group">
                                                            <label>Sender's Bank</label>
                                                            <select name="bank" class="form-control">
                                                                <?php echo $this->Util_model->list_from_table("banks", "name", "name", "WHERE status=1"); ?>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label>Reference/Description</label>
                                                            <input class="form-control" type="text" name="desc" placeholder="Enter the reference or description">
                                                        </div>
                                                        <div class="form-group">
                                                            <button class="btn btn-primary btn-flat btn-block" type="submit">Book Payment</button>
                                                        </div>
                                                    <?php echo form_close(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <div class="box box-widget widget-user">
                    <!-- Add the bg color to the header using any of the bg-* classes -->
                    <?php
                    $uid = userdata(UID);
                    $main = $this->Util_model->get_info("user_main", "name, date", "WHERE uid=$uid");
                    $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
                    $centre = $this->Util_model->get_info("centre", "*", "WHERE cid='".$this->Util_model->get_user_info($uid, "cid", "profile")."'");
                    ?>
                    <div class="widget-user-header bg-purple-active">
                        <h3 class="widget-user-username"><?php echo $main['name']; ?></h3>
                        <h5 class="widget-user-desc">@<?php echo $pro['username']; ?></h5>
                    </div>
                    <div class="widget-user-image">
                        <img class="img-circle" src="<?php echo base_url().$this->Util_model->picture($uid); ?>" alt="<?php echo $pro['username']; ?>">
                    </div>
                    
                    <div class="box-footer no-padding">
                        <ul class="nav nav-stacked">
                            <li><a href="#">Centre ID<span class="pull-right text-bold"><?php echo $centre['cid']; ?></span></a></li>
                            <li><a href="#">Phone <span class="pull-right text-bold"><?php echo $pro['phone_code'].$pro['phone'] ?></span></a></li>
                            <li><a href="#">Email <span class="pull-right text-bold"><?php echo $pro["email"]; ?></span></a></li>
                            <li><a href="#">Referred by <span class="pull-right text-bold"><?php echo $this->Util_model->get_user_info($this->Util_model->get_user_info($uid, "refID", "referrer")); ?></span></a></li>
                            <li><a href="#">Registered on <span class="pull-right text-bold"><?php echo $main['date']; ?></span></a></li>
                        </ul>
                    </div>
                </div>
                <!-- /.widget-user -->
            </div>
        </div>
    </section>
</div>

<script>
    function selectPackage(btn, package) {
        $(".btn-package").removeClass("btn-warning");
        btn.addClass("btn-warning");
        $("#package").val(package);
        $("#promo-section").show();
        window.location = "#promo-section";
    }
</script>