
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header no-padding">
                        <div class="nav-tabs-custom tab-warning">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#buy" data-toggle="tab">Purchase</a></li>
                                <li><a href="#history" data-toggle="tab">History</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-pad-3x bottom-pad-3x bottom-3x" style="padding-right:0px; padding-left:0px;">
                            <?php 
                            $country = $this->Util_model->get_user_info(userdata(UID), "country", "profile");
                            if ($this->Util_model->row_count("networks", "WHERE country=$country") > 0) : 
                            ?>
                            <div class="tab-content">
                                <div class="tab-pane active" id="buy">
                                    <?php echo form_open(base_url()."data/process_data"); ?>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label>Network <span class="required">*</span></label>
                                            <select class="form-control" name="network" id="network" onchange="_('bundle').html('<option>Loading bundle...</option>'); processAjax('<?php echo base_url(); ?>data/list-bundles/'+$(this).val(), '', _('bundle')); _('more-details').show();">
                                                <option value="">Select network</option>
                                                <?php echo $this->Util_model->list_from_table("networks", "id", "network"); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div id="more-details" class="no-display">
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Bundle <span class="required">*</span></label>
                                                <select class="form-control" name="bundle" id="bundle">
                                                    <option value="">Select network first</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                            <label>Amount <span class="required">*</span></label>
                                            <span class="no-display" id="buy-price"><?php echo $this->Util_model->get_option("coin_price"); ?></span>
                                            <div class="input-group">
                                                <span class="input-group-addon"><?php echo $this->Util_model->get_country_info("currency_symbol"); ?></span>
                                                <input class="form-control text-bold text-center" name="amount" required="required" id="amount" placeholder="Select a bundle" disabled>
                                                <span class="input-group-addon text-bold">You Pay $<span id="amt-pay">0</span></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Recipient <span class="required">*</span></label>
                                                <input class="form-control" name="recipient" type="tel" placeholder="eg. 08120203636" required="required" value="<?php echo set_value('recipient'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Password <span class="required">*</span></label>
                                                <div class="form-group">
                                                    <span class="no-display"></span>
                                                    <input class="form-control" id="password" name="password" type="password" placeholder="Verify operation" required="required" autocomplete="off">
                                                </div>
            
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>
                                                    <input name="ported" type="checkbox" value="no"> Bypass number verification for ported numbers
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <button class="btn btn-success pull-right" type="submit" name="buyAirtime" disabled>Unavailable</button>
                                        </div>
                                        <?php echo form_close(); ?>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-2x">
                                            <div class="alert alert-info">
                                                <p>
                                                    <b><i class="fa fa-info-circle"></i> Important Notice</b> <br>
                                                    Please make sure to double check the phone number before submitting because once it is been processed, it can't be undone.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="history">
                                    <div class="col-xs-12 no-padding table-responsive">
                                        <table id="dataTable" class="table table-bordered table-striped">
                                            <thead>
                                            <tr>
                                                <th class="text-center">Network</th>
                                                <th class="text-center">Bundle</th>
                                                <th class="text-center">Recipient</th>
                                                <th class="text-center">Amount</th>
                                                <th class="text-center">Date</th>
                                                <th class="text-center">Status</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "data_purchase", "WHERE uid=".userdata(UID));
                                            if ($s->num_rows() > 0) {
                                                foreach ($s->result_array() as $row) {
                                                    $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network]");
                                                    $bundle = $this->Util_model->get_info("data_bundle", "bundle", "WHERE id=$row[bundle]");
                                                    if ($row['status'] == 0) {
                                                        $status = "<span class='label bg-aqua'>Processing <i class='fa fa-spinner fa-spin'></i> </span>";
                                                    } else if ($row['status'] == 1) {
                                                        $status = "<span class='label bg-green'>Delivered</span>";
                                                    } else {
                                                        $status = "<span class='label bg-red'>Cancelled</span>";
                                                    }
            
                                                    echo "
                                            <tr class='text-center'>
                                                <td>$network</td>
                                                <td>$bundle</td>
                                                <td>$row[recipient]</td>
                                                <td>$$row[bundle_amount]</td>
                                                <td>$row[status_date]</td>
                                                <td>$status</td>
                                            </tr>\n
                                        ";
                                                }
                                            }
                                            ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- /.tab-content --> 
                            <?php else : ?>
                                <h3>Opps! This utility is not available in you region. You will be notified via email once it is available</h3>
                                <a href="<?php echo base_url('home'); ?>" class="btn btn-warning btn-flat">Go back home Now</a>
                            <?php endif; ?>
                        </div><!-- /.col -->
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });
        
        $("#bundle").change(function() {
            $.post('<?php echo base_url(); ?>data/get-amount/'+$(this).val(), '', function (data) { 
                _('amount').val(data['amount']); 
                _('amt-pay').text(data['eqv'].toString().match(/^-?\d+(?:\.\d{0,2})?/)[0]);
            }, 'json');
        });
    });
</script>

