
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <h3 class="text-muted text-bold" style="text-align:right; font-size:16px">
                            <a href="<?php echo base_url(); ?>p2p/create-trade"><i class="fa fa-plus-square"></i> Create New Trade</a>
                        </h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body text-center">
                        <?php 
                        $s = $this->Db_model->selectGroup("*", "p2p_merchant", "WHERE uid=".userdata(UID));
                        if ($s->num_rows() == 0) {
                            echo "<div class='well text-center'>You currently don't have any p2p trade. <a href='".base_url()."p2p/create-trade'>Create new trade</a></div>";
                        } else {
                            echo '
                            <div class="table-responsive">
                                <table id="transTable" class="table table-bordered table-striped">
                                    <thead>
                                    <tr>
                                        <th class="text-center">Type</th>
                                        <th class="text-center">Method</th>
                                        <th class="text-center">Payment Details</th>
                                        <th class="text-center">Interest (%)</th>
                                        <th class="text-center">Minimum</th>
                                        <th class="text-center">Maximum</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Date</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                ';
                                foreach ($s->result_array() as $row) {
                                    $details = "";
                                    if ($row['type'] == "Buy") {
                                        if (strstr($row['details'], ",")) {
                                            foreach(explode(",", $row['details']) as $field) {
                                                $field = explode("=", $field);
                                                $details .= "<span class='label label-default'>$field[0]</span> $field[1]<br>";
                                            }
                                        } else {
                                            $field = explode("=", $row['details']);
                                            $details .= "<span class='label label-default'>$field[0]</span> $field[1]";
                                        }
                                    }
                                    
                                    if ($row['status'] == 0) {
                                        $status = "<span class='label label-warning'>Pending</span>";
                                    } else if ($row['status'] == 1) {
                                        $status = "
                                        <span class='label label-success cursor-pointer' onclick='window.location = \"".base_url()."p2p/trade-status/$row[id]/2\"'>Active</span>
                                        <br><small class='font-xs'>Click to deactivate</small>
                                        ";
                                    } else {
                                        $status = "
                                        <span class='label label-danger cursor-pointer' onclick='window.location = \"".base_url()."p2p/trade-status/$row[id]/1\"'>Inactive</span>
                                        <br><small>Click to activate</small>
                                        ";
                                    }
                                    echo "
                                    <tr>
                                        <td>".($row['type'] == "Buy" ? "<span class='badge bg-green'>Buy</span>" : "<span class='badge bg-red'>Sell</span>")."</td>
                                        <td>".$this->Util_model->get_info("payment_methods", "title", "WHERE id=$row[method]")."</td>
                                        <td>$details</td>
                                        <td>2%</td>
                                        <td>$row[min] USD</td>
                                        <td>$row[max] USD</td>
                                        <td>$status</td>
                                        <td>$row[date]</td>
                                        <td>
                                            <a class='btn btn-primary btn-xs' href='".base_url()."p2p/edit-trade/$row[id]'><i class='fa fa-edit'></i> Edit</a>
                                            <a class='btn btn-danger btn-xs' href='".base_url()."p2p/delete-trade/$row[id]'><i class='fa fa-trash'></i> Delete</a>
                                        </td>
                                    </tr>
                                    ";
                                }
                                echo '
                                    </tbody>
                                </table>
                            </div>
                            ';
                        }
                        ?>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php if ($this->Util_model->get_user_info(userdata(UID), "duration", "profile") > 0) : ?>
                    <?php $this->load->view("layouts/buy_sell_coin"); ?>
                <?php else : ?>
                    <div class="box box-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <?php
                        $uid = userdata(UID);
                        $main = $this->Util_model->get_info("user_main", "name, date", "WHERE uid=$uid");
                        $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
                        $centre = $this->Util_model->get_info("centre", "*", "WHERE cid='".$this->Util_model->get_user_info($uid, "cid", "profile")."'");
                        ?>
                        <div class="widget-user-header bg-yellow-active">
                            <h3 class="widget-user-username"><?php echo $main['name']; ?></h3>
                            <h5 class="widget-user-desc">@<?php echo $pro['username']; ?></h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle" src="<?php echo base_url().$this->Util_model->picture($uid); ?>" alt="<?php echo $pro['username']; ?>">
                        </div>
                        
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked">
                                <li><a href="#">Phone <span class="pull-right text-bold"><?php echo $pro['phone_code'].$pro['phone'] ?></span></a></li>
                                <li><a href="#">Email <span class="pull-right text-bold"><?php echo $pro["email"]; ?></span></a></li>
                                <li><a href="#">Referred by <span class="pull-right text-bold"><?php echo $this->Util_model->get_user_info($this->Util_model->get_user_info($uid, "ref1", "referrer")); ?></span></a></li>
                                <li><a href="#">Registered on <span class="pull-right text-bold"><?php echo $main['date']; ?></span></a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- /.widget-user -->
                <?php endif; ?>
            </div>
        </div>
        <!--/.row-->
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#orders').DataTable({
            "order":[7, "desc"]
        });

    });
</script>