
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-body no-padding">
                        <div class="col-sm-6 col-xs-12">
                            <h4>My Referral Link</h4>
                            <span class="text-red" id="ref-link"><?php echo base_url() . "r/" . $this->Util_model->get_user_info(userdata(UID), "username", "profile"); ?></span> 
                            <button class="btn btn-warning btn-xs btn-flat" type="button" onclick="copyToClipboard($(this), $('#ref-link'))"><i class="fa fa-copy"></i> Copy</button>
                        </div>
                        <div class="col-sm-6 col-xs-12">
                            <?php 
                            $ref = $this->Util_model->get_info("user_referrer", "ref1", "WHERE uid=".userdata(UID));
                            if ($ref) : 
                            ?>
                            <div class="info-box bg-gray box-border top-1x">
                                <img class="info-box-icon" src="<?= base_url($this->Util_model->picture($ref)); ?>">
                                <div class="info-box-content">
                                    <span>My Mentor</span>
                                    <span class="info-box-number overflow" data-toggle="tooltip" data-title="<?= $this->Util_model->get_user_info($ref); ?>"><?= $this->Util_model->get_user_info($ref); ?></span>
                                    <span class="progress-description">
                                        +<?= $phon = $this->Util_model->get_user_info($ref, "phone_code", "profile").$this->Util_model->get_user_info($ref, "phone", "profile"); ?>
                                        <a href="https://wa.me/<?= $phone; ?>" class="btn btn-warning btn-xs pull-right">Chat <i class="fa fa-send"></i></a>
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                            <!-- /.info-box -->
                            <?php endif; ?>
                        </div>
                        
                    </div>
                </div>
                <div class="box no-border">
                    <div class="box-header no-padding">
                        <div class="nav-tabs-custom tab-warning">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#active" data-toggle="tab">Active <span class="badge"><?php echo count_format($this->Main_model->get_total_network(userdata(UID))); ?></span></a></li>
                                <li><a href="#inactive" data-toggle="tab">Inactive <span class="badge"><?php echo count_format($this->Main_model->get_total_network(userdata(UID), 1, false, 0)); ?></span></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="active">
                                <?php 
                                for ($i=1; $i<=3; $i++) {
                                    $gen = ($generation == $i) ? "btn-warning" : "btn-default";
                                    echo "
                                    <a href='".base_url()."network/generation/$i' class='btn $gen btn-xs' style='margin-bottom:2px'>
                                    ".get_suffix($i)." Generation <span class='badge'>".count_format($this->Main_model->get_total_network(userdata(UID), $i))."</span>
                                    </a>
                                    "; 
                                }
                                ?>
                                <hr>
                                <h3 class="text-center"><?php echo get_suffix($generation); ?> Generation</h3>
                                <div class="col-xs-12 table-responsive td_overline" style="padding: 20px 0px;">
                                    <table id="activeTable" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Name</th>
                                            <?php if ($generation == 1) : ?>
                                            <th class="text-center">Email</th>
                                            <th class="text-center">Phone</th>
                                            <?php endif; ?>
                                            <th class="text-center">Referred By</th>
                                            <th class="text-center">Plan</th>
                                            <th class="text-center">Duration</th>
                                            <th class="text-center">Network (This Month)</th>
                                            <th class="text-center">Last Update</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $s = $this->Db_model->query("SELECT r.uid, r.ref1, m.name, p.email, p.phone_code, p.phone, p.package, p.duration, p.date FROM user_referrer r, user_profile p, user_main m WHERE r.uid = p.uid AND r.uid = m.uid AND r.ref$generation = ".userdata(UID)." AND p.duration > 0");
                                        if ($s->num_rows() > 0) {
                                            foreach ($s->result_array() as $row) {
                                                $referred_by = $this->Util_model->get_user_info($row["ref1"]);
                                                $package = $this->Util_model->get_info("packages", "name", "WHERE id=$row[package]");
                                                $network = number_format($this->Main_model->get_total_network($row["uid"]));
                                                $monthly = $this->Main_model->get_total_network($row["uid"], 0, true);
                                                echo "
                                                    <tr class='text-center'>
                                                        <td>$row[name]</td>";
                                                        if ($generation == 1) {
                                                            echo "
                                                            <td>$row[email]</td>
                                                            <td>$row[phone_code]$row[phone]</td>
                                                            ";
                                                        }
                                                    echo "
                                                        <td>$referred_by</td>
                                                        <td>$package</td>
                                                        <td>$row[duration] days</td>
                                                        <td>$network ($monthly)</td>
                                                        <td>".$this->Util_model->get_info("user_upgrade", "date", "WHERE uid=$row[uid]")."</td>
                                                    </tr>\n
                                                ";
                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                            <div class="tab-pane" id="inactive">
                                <div class="col-xs-12 table-responsive" style="padding: 20px 0px;">
                                    <table id="inactiveTable" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Name</th>
                                            <th class="text-center">Email</th>
                                            <th class="text-center">Phone number</th>
                                            <th class="text-center">Registration Date</th>
                                            <th></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $s = $this->Db_model->query("SELECT r.uid, m.name, p.email, p.phone_code, p.phone, p.date FROM user_referrer r, user_profile p, user_main m WHERE r.uid = p.uid AND r.uid = m.uid AND r.ref1 = ".userdata(UID)." AND p.duration = 0");
                                        if ($s->num_rows() > 0) {
                                            foreach ($s->result_array() as $row) {
                                                $ss = $this->Db_model->selectGroup("*", "packages", "WHERE status=1");
                                                if ($ss->num_rows() > 0) {
                                                    $buttons = "";
                                                    foreach ($ss->result_array() as $row1) {
                                                        $buttons .= "
                                                        <li><a href='".base_url()."activate/activate-user/$row[uid]/$row1[id]'>$row1[name] <span class='label bg-blue pull-right'>".USD.number_format($row1['amount'])."</span></a></li>\n
                                                        ";
                                                    }
                                                }
                                                $phone = $row["phone_code"].$row["phone"];
                                                echo "
                                                    <tr class='text-center'>
                                                        <td>$row[name]</td>
                                                        <td>$row[email]</td>
                                                        <td>$phone</td>
                                                        <td>$row[date]</td>
                                                        <td>
                                                            <div class='btn-group'>
                                                                <button type='button' class='btn btn-info btn-xs dropdown-toggle' data-toggle='dropdown'>
                                                                    Activate Member 
                                                                    <span class='caret'></span>
                                                                    <span class='sr-only'>Toggle Dropdown</span>
                                                                </button>
                                                                <ul class='dropdown-menu' role='menu'>
                                                                    <li class='text-bold text-center'>Select Package</li>
                                                                    $buttons
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>\n
                                                ";
                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.box -->
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php $this->load->view("layouts/buy_sell_coin"); ?>
            </div>
        </div>
        <!--/.row-->
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- date-picker -->
<script src="<?php echo base_url(); ?>assets/plugins/datepicker/bootstrap-datepicker.js"></script>

<script>
    $(function () {

        $('#activeTable, #inactiveTable').DataTable({
            "order":[0, "desc"]
        });

    });
</script>
