
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="col-xs-12">
                            <span class="no-display" id="trans-status"><?php echo $trans['status']; ?></span>
                        <?php
                            if ($trans['buyer_uid'] == userdata(UID)) {
                                echo "<h4 class='bottom-2x'>Depositing ".number_format($trans["amount"],2)." USD ($trans[converted_amount] $trans[currency]) via <span class='text-blue'>".$this->Util_model->get_user_info($trans['seller_uid'], 'username', 'profile')."</span></h4>";
                            } else {
                                echo "<h4 class='bottom-2x'>Withdrawing ".number_format($trans["amount"],2)." USD ($trans[converted_amount] $trans[currency]) via <span class='text-blue'>".$this->Util_model->get_user_info($trans['buyer_uid'], 'username', 'profile')."</span></h4>";
                            }
                            if ($trans['status'] == 4) {
                                echo alert_msg("<b>Oops!</b> Order cancelled", "alert-danger text-center");
                            } else if ($trans['status'] == 3) {
                                echo alert_msg("<b>Congratulations</b> Order completed", "alert-success text-center");
                            } else if ($trans['status'] == 2) {
                                echo alert_msg("<b>Order status:</b> Waiting for payment confirmation", "alert-info text-center");
                            } else if ($trans['status'] == 1) {
                                echo alert_msg("<b>Order status:</b> Waiting for payment to be made", "alert-info text-center");
                            } else {
                                echo alert_msg("<b>Order status:</b> Order appealed <a href='".base_url()."p2p/appeal/$trans[reference]'>Click here to follow up the appeal</a>", "alert-warning text-center");
                            }
                        ?>
                        </div>
                        <div class="col-xs-12">
                            <?php if ($trans['status'] == 1 || $trans['status'] == 2) : ?>
                            <div class="well text-center" id="rem-time-wrapper">
                                Order Cancel In
                                <h1 style="margin-top: 5px; margin-bottom: 5px" id="rem-time">
                                    <?php echo $this->p2p->remaining_time($trans['expiry_date']); ?>
                                </h1>
                            </div>
                            <?php endif; ?>
                            <div class="box box-default direct-chat direct-chat-warning" style="border:1px solid #ccc">
                                <div class="box-header with-border">
                                    <h3 class="box-title">Direct Message</h3>
                                    <div class="box-tools pull-right">
                                        <?php $msg_num = $this->Util_model->row_count("p2p_chat", "WHERE order_id=$order_id"); ?>
                                        <span data-toggle="tooltip" title="<?php echo $msg_num; ?> Messages" class="badge bg-yellow"><?php echo $msg_num; ?></span>
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <!-- Conversations are loaded here -->
                                    <div class="direct-chat-messages" id="chat-msg" style="max-height: 450px; overflow-y: auto">
                                        <?php echo $this->p2p->list_chat($order_id); ?>
                                    </div>
                                    <!--/.direct-chat-messages-->
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer">
                                    <span class="no-display" id="order-id"><?php echo $order_id; ?></span>
                                    <span class="no-display" id="sender"><?php echo $sender = userdata(UID); ?></span>
                                    <span class="no-display" id="receiver"><?php echo $receiver = ($trans['buyer_uid'] == userdata(UID))?$trans['seller_uid']:$trans['buyer_uid']; ?></span>
                                    <div class="no-display">
                                        <?php echo form_open_multipart(base_url()."p2p/upload_picture/$sender/$receiver/$order_id", "id='img-form'"); ?>
                                        <input type="file" name="image" id="user-img">
                                        <button type="submit" class="btn btn-warning" id="img-submit">Submit</button>
                                        <?php echo form_close(); ?>
                                    </div>
                                    <div class="input-group">
                                        <input type="text" id="msg-content" name="message" placeholder="Type Message ..." class="form-control">
                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-default btn-flat" onclick="upload_profile_picture()"><i class="fa fa-image"></i></button>
                                            <button type="button" class="btn btn-warning btn-flat" onclick="post_chat(____('sender'), ____('receiver'), ____('order-id'), _('msg-content'), 'text', $(this), _('chat-msg'));"><i class="fa fa-send"></i> Send</button>
                                        </span>
                                    </div>
                                </div>
                                <!-- /.box-footer-->
                            </div>
                            <!--/.direct-chat -->
                        </div>
                        <div class="col-xs-12">
                            <?php if ($trans['buyer_uid'] == userdata(UID)) : ?>
                            <div class="well" style="font-size: 16px;">
                                <h3>Step 1: Pay the seller</h3>
                                The reference message must be included or the seller can't identify your payment. Send a message to the seller to receive help with completing the payment.
                                <p style="background-color: white; padding:10px; margin-top:10px">
                                    <?php echo str_replace(["=", ","], [": ", "<br>"], $trans['details']); ?><br>
                                    Paying: <b><?php echo $trans['converted_amount']." ".$trans['currency']; ?></b><br>
                                    Reference/description: <?php echo $trans['reference']; ?><br>
                                    <?php $phone = $this->Util_model->get_info("user_profile", "phone_code, phone", "WHERE uid=$trans[seller_uid]"); ?>
                                    <span class="text-bold text-red">Seller's Phone: <?php echo $phone['phone_code'].$phone['phone']; ?></span>
                                </p>
                                <?php if ($trans['status'] == 1) : ?>
                                <div class="margin"></div>
                                <h3>Step 2: Confirm the payment</h3>
                                The funds are held in escrow for <?php echo $this->Util_model->get_option("p2p_pay_time"); ?> minutes, during which it is safe to pay. After paying, you need to <b>mark payment as completed</b> by clicking the <b>I have paid</b> button or the order will automatically cancel after the time.
                                <center>
                                    <a href="<?php echo base_url()."p2p/made_payment/$order_id"; ?>" class="btn btn-warning"><i class="fa fa-play"></i> I Have Paid</a>
                                </center>
                                <?php endif; ?>
                            </div>
                            <?php else : ?>
                            <div class="well" style="font-size: 16px;">
                                <h3>Step 1: Accept payment from buyer</h3>
                                Send a message to the receiver to help with completing the payment. Below is your payment details and the receiver's phone number.
                                <p style="background-color: white; padding:10px; margin-top:10px">
                                    <?php echo str_replace(["=", ","], [": ", "<br>"], $trans['details']); ?><br>
                                    Receiving: <b><?php echo $trans['converted_amount']." ".$trans['currency']; ?></b><br>
                                    Reference/message: <?php echo $trans['reference']; ?><br>
                                    <?php $phone = $this->Util_model->get_info("user_profile", "phone_code, phone", "WHERE uid=$trans[buyer_uid]"); ?>
                                    <span class="text-bold text-red">Buyers's Phone: <?php echo $phone['phone_code'].$phone['phone']; ?></span>
                                </p>
                                <?php if ($trans['status'] < 3) : ?>
                                <div class="margin"></div>
                                <h3>Step 2: Confirm payment</h3>
                                The funds are held in escrow till the end of the trade. Never click the <b>Confirm Payment</b> button without receiving funds in your wallet or bank account. You cannot undo after confirmation.
                                If an order is marked as <b>PAID</b> and you didn't <b>confirm the payment</b> before the time elapse or <b>appeal</b>, your account may be blocked and funds released to buyer.
                                <center>
                                    <a href="javascript:;" class="btn btn-warning" onclick="release()"><i class="fa fa-play"></i> Confirm Payment</a>
                                </center>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                            <?php if ($trans["buyer_uid"] == userdata(UID) && $trans['status'] <= 2) : ?>
                            <div class="panel box box-border">
                                <div class="box-header with-border">
                                    <h4 class="box-title">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#canel">
                                            <i class="fa fa-chevron-right"></i> Cancel Order
                                        </a>
                                    </h4>
                                </div>
                                <div id="canel" class="panel-collapse collapse">
                                    <div class="box-body">
                                        <b>Never cancel the order if you have already sent payment to the sender!</b><br><br>

                                        In case of any problems <b>DO NOT cancel the order</b>, rather create an appeal by clicking on the <b>Appeal order</b> button after <b>marking the payment as complete</b>.<br><br>

                                        Appeal button will appear after the order has been marked as paid.<br><br>

                                        <b>Attention!</b> If the sender offers to return your funds, <b>Cancel the order</b> instead of appealing the trade. <b>NB: DO NOT cancel the order until you see the funds in your account/wallet.</b>
                                        <center class="top-1x">
                                            <a href="<?php echo base_url()."p2p/cancel-trade/$order_id"; ?>" class="btn btn-danger"><i class="fa fa-times"></i> Cancel order</a>
                                        </center>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if ($trans['status'] == 2) : ?>
                            <div class="box box-solid top-1x">
                                <div class="box-body" style="background-color: #CCCCCC;">
                                    <div class="box-group">
                                        <!-- we are adding the .panel class so bootstrap.js collapse plugin detects it -->
                                        <div class="panel box no-border">
                                            <div class="box-header with-border">
                                                <h4 class="box-title">
                                                    <a data-toggle="collapse" data-parent="#accordion" href="#appeal">
                                                        <i class="fa fa-chevron-right"></i> Appeal Order
                                                    </a>
                                                </h4>
                                            </div>
                                            <div id="appeal" class="panel-collapse collapse">
                                                <div class="box-body">
                                                    <b>In case of any issue during trade, Appeal order</b><br><br>

                                                    Never create an appeal if you have not completed the trade requirements<br><br>

                                                    Appealing an order must be done before the order completes.<br><br>

                                                    <center class="top-1x">
                                                        <a href="<?php echo base_url()."p2p/appeal-order/$order_id"; ?>" class="btn btn-danger">Appeal order</a>
                                                    </center>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.box-body -->
                            </div>
                            <!-- /.box -->
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php if ($this->Util_model->get_user_info(userdata(UID), "duration", "profile") > 0) : ?>
                    <?php $this->load->view("layouts/buy_sell_coin"); ?>
                <?php else : ?>
                    <div class="box box-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <?php
                        $uid = userdata(UID);
                        $main = $this->Util_model->get_info("user_main", "name, date", "WHERE uid=$uid");
                        $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
                        $centre = $this->Util_model->get_info("centre", "*", "WHERE cid='".$this->Util_model->get_user_info($uid, "cid", "profile")."'");
                        ?>
                        <div class="widget-user-header bg-yellow-active">
                            <h3 class="widget-user-username"><?php echo $main['name']; ?></h3>
                            <h5 class="widget-user-desc">@<?php echo $pro['username']; ?></h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle" src="<?php echo base_url().$this->Util_model->picture($uid); ?>" alt="<?php echo $pro['username']; ?>">
                        </div>
                        
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked">
                                <li><a href="#">Phone <span class="pull-right text-bold"><?php echo $pro['phone_code'].$pro['phone'] ?></span></a></li>
                                <li><a href="#">Email <span class="pull-right text-bold"><?php echo $pro["email"]; ?></span></a></li>
                                <li><a href="#">Referred by <span class="pull-right text-bold"><?php echo $this->Util_model->get_user_info($this->Util_model->get_user_info($uid, "ref1", "referrer")); ?></span></a></li>
                                <li><a href="#">Registered on <span class="pull-right text-bold"><?php echo $main['date']; ?></span></a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- /.widget-user -->
                <?php endif; ?>
            </div>
        </div>
    </section>


<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/sweetalert/sweetalert2.js"></script>

<script>
    $(document).ready(function () {
        setInterval(function () {
            $.post("<?php echo base_url(); ?>p2p/list_chat", {"trans_id":____("order-id")}, function (data) {
                _('chat-msg').html(data);
            });
        }, 10000);

        setInterval(function () {
            $.post("<?php echo base_url(); ?>p2p/trade_time", {"trans_id":____("order-id")}, function (data) {
                if (data["status"]) {
                    _('rem-time').html(data["time"]);
                } else {
                    _('rem-time-wrapper').remove();
                    reloadPage();
                }
            }, "json");
        }, 1000);

        setInterval(function () {
            $.post("<?php echo base_url(); ?>p2p/check-status", {"trans_id":____("order-id")}, function (data) {
                if (data != ____("trans-status")) {
                    reloadPage();
                }
            });
        }, 5000);
    
        $('#orders').DataTable({
            "order":[0, "desc"]
        });

    });

    function upload_profile_picture () {
        $("#user-img").click();
        $("#user-img").change(function() {
            $("#btn-upload").html("<i class='fa fa-spinner fa-spin'></i> Uploading");
            $("#btn-upload").attr("disabled", "disabled");
            $("#img-submit").click();
        });
    }

    function post_chat (sender, receiver, trans_id, content, type, btn, ele) {
        if (content.val().trim().length > 0) {
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            $.post("<?php echo base_url(); ?>p2p/post_chat", {"sender":sender, "receiver":receiver, "trans_id":trans_id, "content":content.val(), "type":type}, function (data) {
                if (data != 0) {
                    ele.html(data);
                    content.val("");
                }
                btn.html("<i class='fa fa-send'></i> Send");
            });
        }
    }

    function release () {
        var body = "<p class='text-center'>";
        body += "<i class='fa fa-lock fa-2x'></i><br>";
        body += "<small class='text-muted'>Enter your password to confirm transaction<br></small>";
        body += "<input class='form-control text-center' id='release-pass' type='password' placeholder='Enter passowrd here'>";
        var footer = "<button class='btn btn-warning' type='button' onclick='if (___(\"release-pass\") != \"\") { $(this).val(\"Processing...\"); $(this).attr(\"disabled\", \"disabled\"); window.location = \"<?php echo base_url(); ?>p2p/release/<?php echo $order_id; ?>/\"+___(\"release-pass\"); }'>Verify</button>";
        
        alert_modal("Verify Password", body, footer, "sm");
    }
</script>